/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.sql.DataSource;
import net.hydromatic.avatica.AvaticaConnection;
import net.hydromatic.avatica.AvaticaStatement;
import net.hydromatic.avatica.Handler;
import net.hydromatic.avatica.HandlerImpl;
import net.hydromatic.avatica.Meta;
import net.hydromatic.linq4j.BaseQueryable;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.ModifiableTable;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaFactory;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableFactory;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.AbstractTable;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.TableFunctionImpl;
import net.hydromatic.optiq.impl.TableMacroImpl;
import net.hydromatic.optiq.impl.ViewTable;
import net.hydromatic.optiq.impl.clone.CloneSchema;
import net.hydromatic.optiq.impl.generate.RangeTable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.jdbc.MetaImpl;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.runtime.Hook;
import net.hydromatic.optiq.runtime.SqlFunctions;
import net.hydromatic.optiq.test.FoodmartTest;
import net.hydromatic.optiq.test.OptiqAssert;
import net.hydromatic.optiq.test.TableInRootSchemaTest;
import net.hydromatic.optiq.tools.SqlRun;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableModificationRel;
import org.eigenbase.rel.TableModificationRelBase;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.advise.SqlAdvisorGetHintsFunction;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.test.DiffTestCase;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hsqldb.jdbcDriver;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTest {
    public static final Method GENERATE_STRINGS_METHOD = Types.lookupMethod(JdbcTest.class, (String)"generateStrings", (Class[])new Class[]{Integer.class});
    public static final Method MULTIPLICATION_TABLE_METHOD = Types.lookupMethod(JdbcTest.class, (String)"multiplicationTable", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.class});
    public static final Method VIEW_METHOD = Types.lookupMethod(JdbcTest.class, (String)"view", (Class[])new Class[]{String.class});
    public static final Method STRING_UNION_METHOD = Types.lookupMethod(JdbcTest.class, (String)"stringUnion", (Class[])new Class[]{Queryable.class, Queryable.class});
    public static final Method PROCESS_CURSOR_METHOD = Types.lookupMethod(JdbcTest.class, (String)"processCursor", (Class[])new Class[]{Integer.TYPE, Enumerable.class});
    public static final Method PROCESS_CURSORS_METHOD = Types.lookupMethod(JdbcTest.class, (String)"processCursors", (Class[])new Class[]{Integer.TYPE, Enumerable.class, Enumerable.class});
    public static final String FOODMART_SCHEMA = "     {\n       type: 'jdbc',\n       name: 'foodmart',\n       jdbcDriver: '" + OptiqAssert.CONNECTION_SPEC.driver + "',\n" + "       jdbcUser: '" + OptiqAssert.CONNECTION_SPEC.username + "',\n" + "       jdbcPassword: '" + OptiqAssert.CONNECTION_SPEC.password + "',\n" + "       jdbcUrl: '" + OptiqAssert.CONNECTION_SPEC.url + "',\n" + "       jdbcCatalog: null,\n" + "       jdbcSchema: 'foodmart'\n" + "     }\n";
    public static final String FOODMART_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'foodmart',\n   schemas: [\n" + FOODMART_SCHEMA + "   ]\n" + "}";
    public static final String HR_SCHEMA = "     {\n       type: 'custom',\n       name: 'hr',\n       factory: '" + ReflectiveSchema.Factory.class.getName() + "',\n" + "       operand: {\n" + "         class: '" + HrSchema.class.getName() + "'\n" + "       }\n" + "     }\n";
    public static final String HR_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'hr',\n   schemas: [\n" + HR_SCHEMA + "   ]\n" + "}";
    public static final String START_OF_GROUP_DATA = "(values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)";
    private static final String[] QUERIES = new String[]{"select count(*) from (select 1 as \"c0\" from \"salary\" as \"salary\") as \"init\"", "EXPR$0=21252\n", "select count(*) from (select 1 as \"c0\" from \"salary\" as \"salary2\") as \"init\"", "EXPR$0=21252\n", "select count(*) from (select 1 as \"c0\" from \"department\" as \"department\") as \"init\"", "EXPR$0=12\n", "select count(*) from (select 1 as \"c0\" from \"employee\" as \"employee\") as \"init\"", "EXPR$0=1155\n", "select count(*) from (select 1 as \"c0\" from \"employee_closure\" as \"employee_closure\") as \"init\"", "EXPR$0=7179\n", "select count(*) from (select 1 as \"c0\" from \"position\" as \"position\") as \"init\"", "EXPR$0=18\n", "select count(*) from (select 1 as \"c0\" from \"promotion\" as \"promotion\") as \"init\"", "EXPR$0=1864\n", "select count(*) from (select 1 as \"c0\" from \"store\" as \"store\") as \"init\"", "EXPR$0=25\n", "select count(*) from (select 1 as \"c0\" from \"product\" as \"product\") as \"init\"", "EXPR$0=1560\n", "select count(*) from (select 1 as \"c0\" from \"product_class\" as \"product_class\") as \"init\"", "EXPR$0=110\n", "select count(*) from (select 1 as \"c0\" from \"time_by_day\" as \"time_by_day\") as \"init\"", "EXPR$0=730\n", "select count(*) from (select 1 as \"c0\" from \"customer\" as \"customer\") as \"init\"", "EXPR$0=10281\n", "select count(*) from (select 1 as \"c0\" from \"sales_fact_1997\" as \"sales_fact_1997\") as \"init\"", "EXPR$0=86837\n", "select count(*) from (select 1 as \"c0\" from \"inventory_fact_1997\" as \"inventory_fact_1997\") as \"init\"", "EXPR$0=4070\n", "select count(*) from (select 1 as \"c0\" from \"warehouse\" as \"warehouse\") as \"init\"", "EXPR$0=24\n", "select count(*) from (select 1 as \"c0\" from \"agg_c_special_sales_fact_1997\" as \"agg_c_special_sales_fact_1997\") as \"init\"", "EXPR$0=86805\n", "select count(*) from (select 1 as \"c0\" from \"agg_pl_01_sales_fact_1997\" as \"agg_pl_01_sales_fact_1997\") as \"init\"", "EXPR$0=86829\n", "select count(*) from (select 1 as \"c0\" from \"agg_l_05_sales_fact_1997\" as \"agg_l_05_sales_fact_1997\") as \"init\"", "EXPR$0=86154\n", "select count(*) from (select 1 as \"c0\" from \"agg_g_ms_pcat_sales_fact_1997\" as \"agg_g_ms_pcat_sales_fact_1997\") as \"init\"", "EXPR$0=2637\n", "select count(*) from (select 1 as \"c0\" from \"agg_c_14_sales_fact_1997\" as \"agg_c_14_sales_fact_1997\") as \"init\"", "EXPR$0=86805\n", "select \"time_by_day\".\"the_year\" as \"c0\" from \"time_by_day\" as \"time_by_day\" group by \"time_by_day\".\"the_year\" order by \"time_by_day\".\"the_year\" ASC", "c0=1997\nc0=1998\n", "select \"store\".\"store_country\" as \"c0\" from \"store\" as \"store\" where UPPER(\"store\".\"store_country\") = UPPER('USA') group by \"store\".\"store_country\" order by \"store\".\"store_country\" ASC", "c0=USA\n", "select \"store\".\"store_state\" as \"c0\" from \"store\" as \"store\" where (\"store\".\"store_country\" = 'USA') and UPPER(\"store\".\"store_state\") = UPPER('CA') group by \"store\".\"store_state\" order by \"store\".\"store_state\" ASC", "c0=CA\n", "select \"store\".\"store_city\" as \"c0\", \"store\".\"store_state\" as \"c1\" from \"store\" as \"store\" where (\"store\".\"store_state\" = 'CA' and \"store\".\"store_country\" = 'USA') and UPPER(\"store\".\"store_city\") = UPPER('Los Angeles') group by \"store\".\"store_city\", \"store\".\"store_state\" order by \"store\".\"store_city\" ASC", "c0=Los Angeles; c1=CA\n", "select \"customer\".\"country\" as \"c0\" from \"customer\" as \"customer\" where UPPER(\"customer\".\"country\") = UPPER('USA') group by \"customer\".\"country\" order by \"customer\".\"country\" ASC", "c0=USA\n", "select \"customer\".\"state_province\" as \"c0\", \"customer\".\"country\" as \"c1\" from \"customer\" as \"customer\" where (\"customer\".\"country\" = 'USA') and UPPER(\"customer\".\"state_province\") = UPPER('CA') group by \"customer\".\"state_province\", \"customer\".\"country\" order by \"customer\".\"state_province\" ASC", "c0=CA; c1=USA\n", "select \"customer\".\"city\" as \"c0\", \"customer\".\"country\" as \"c1\", \"customer\".\"state_province\" as \"c2\" from \"customer\" as \"customer\" where (\"customer\".\"country\" = 'USA' and \"customer\".\"state_province\" = 'CA' and \"customer\".\"country\" = 'USA' and \"customer\".\"state_province\" = 'CA' and \"customer\".\"country\" = 'USA') and UPPER(\"customer\".\"city\") = UPPER('Los Angeles') group by \"customer\".\"city\", \"customer\".\"country\", \"customer\".\"state_province\" order by \"customer\".\"city\" ASC", "c0=Los Angeles; c1=USA; c2=CA\n", "select \"store\".\"store_country\" as \"c0\" from \"store\" as \"store\" where UPPER(\"store\".\"store_country\") = UPPER('Gender') group by \"store\".\"store_country\" order by \"store\".\"store_country\" ASC", "", "select \"store\".\"store_type\" as \"c0\" from \"store\" as \"store\" where UPPER(\"store\".\"store_type\") = UPPER('Gender') group by \"store\".\"store_type\" order by \"store\".\"store_type\" ASC", "", "select \"product_class\".\"product_family\" as \"c0\" from \"product\" as \"product\", \"product_class\" as \"product_class\" where \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and UPPER(\"product_class\".\"product_family\") = UPPER('Gender') group by \"product_class\".\"product_family\" order by \"product_class\".\"product_family\" ASC", "", "select \"promotion\".\"media_type\" as \"c0\" from \"promotion\" as \"promotion\" where UPPER(\"promotion\".\"media_type\") = UPPER('Gender') group by \"promotion\".\"media_type\" order by \"promotion\".\"media_type\" ASC", "", "select \"promotion\".\"promotion_name\" as \"c0\" from \"promotion\" as \"promotion\" where UPPER(\"promotion\".\"promotion_name\") = UPPER('Gender') group by \"promotion\".\"promotion_name\" order by \"promotion\".\"promotion_name\" ASC", "", "select \"promotion\".\"media_type\" as \"c0\" from \"promotion\" as \"promotion\" where UPPER(\"promotion\".\"media_type\") = UPPER('No Media') group by \"promotion\".\"media_type\" order by \"promotion\".\"media_type\" ASC", "c0=No Media\n", "select \"promotion\".\"media_type\" as \"c0\" from \"promotion\" as \"promotion\" group by \"promotion\".\"media_type\" order by \"promotion\".\"media_type\" ASC", "c0=Bulk Mail\nc0=Cash Register Handout\nc0=Daily Paper\nc0=Daily Paper, Radio\nc0=Daily Paper, Radio, TV\nc0=In-Store Coupon\nc0=No Media\nc0=Product Attachment\nc0=Radio\nc0=Street Handout\nc0=Sunday Paper\nc0=Sunday Paper, Radio\nc0=Sunday Paper, Radio, TV\nc0=TV\n", "select count(distinct \"the_year\") from \"time_by_day\"", "EXPR$0=2\n", "select \"time_by_day\".\"the_year\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 group by \"time_by_day\".\"the_year\"", "c0=1997; m0=266773.0000\n", "select \"time_by_day\".\"the_year\" as \"c0\", \"promotion\".\"media_type\" as \"c1\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"promotion\" as \"promotion\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\" group by \"time_by_day\".\"the_year\", \"promotion\".\"media_type\"", "c0=1997; c1=Bulk Mail; m0=4320.0000\nc0=1997; c1=Radio; m0=2454.0000\nc0=1997; c1=Street Handout; m0=5753.0000\nc0=1997; c1=TV; m0=3607.0000\nc0=1997; c1=No Media; m0=195448.0000\nc0=1997; c1=In-Store Coupon; m0=3798.0000\nc0=1997; c1=Sunday Paper, Radio, TV; m0=2726.0000\nc0=1997; c1=Product Attachment; m0=7544.0000\nc0=1997; c1=Daily Paper; m0=7738.0000\nc0=1997; c1=Cash Register Handout; m0=6697.0000\nc0=1997; c1=Daily Paper, Radio; m0=6891.0000\nc0=1997; c1=Daily Paper, Radio, TV; m0=9513.0000\nc0=1997; c1=Sunday Paper, Radio; m0=5945.0000\nc0=1997; c1=Sunday Paper; m0=4339.0000\n", "select \"store\".\"store_country\" as \"c0\", sum(\"inventory_fact_1997\".\"supply_time\") as \"m0\" from \"store\" as \"store\", \"inventory_fact_1997\" as \"inventory_fact_1997\" where \"inventory_fact_1997\".\"store_id\" = \"store\".\"store_id\" group by \"store\".\"store_country\"", "c0=USA; m0=10425\n", "select \"sn\".\"desc\" as \"c0\" from (SELECT * FROM (VALUES (1, 'SameName')) AS \"t\" (\"id\", \"desc\")) as \"sn\" group by \"sn\".\"desc\" order by \"sn\".\"desc\" ASC NULLS LAST", "c0=SameName\n", "select \"the_year\", count(*) as c, min(\"the_month\") as m\nfrom \"foodmart2\".\"time_by_day\"\ngroup by \"the_year\"\norder by 1, 2", "the_year=1997; C=365; M=April\nthe_year=1998; C=365; M=April\n", "select\n \"store\".\"store_state\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\",\n sum(\"sales_fact_1997\".\"store_sales\") as \"m1\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"store\".\"store_state\" in ('DF', 'WA')\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"store\".\"store_state\", \"time_by_day\".\"the_year\"", "c0=WA; c1=1997; m0=124366.0000; m1=263793.2200\n", "select count(distinct \"product_id\") from \"product\"", "EXPR$0=1560\n", "select \"store\".\"store_name\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n sum(\"sales_fact_1997\".\"store_sales\") as \"m0\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"store\".\"store_name\" in ('Store 1', 'Store 10', 'Store 11', 'Store 15', 'Store 16', 'Store 24', 'Store 3', 'Store 7')\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"store\".\"store_name\",\n \"time_by_day\".\"the_year\"\n", "c0=Store 7; c1=1997; m0=54545.2800\nc0=Store 24; c1=1997; m0=54431.1400\nc0=Store 16; c1=1997; m0=49634.4600\nc0=Store 3; c1=1997; m0=52896.3000\nc0=Store 15; c1=1997; m0=52644.0700\nc0=Store 11; c1=1997; m0=55058.7900\n", "select \"customer\".\"yearly_income\" as \"c0\", \"customer\".\"education\" as \"c1\" \nfrom \"customer\" as \"customer\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\n and ((not (\"customer\".\"yearly_income\" in ('$10K - $30K', '$50K - $70K'))\n or (\"customer\".\"yearly_income\" is null)))\ngroup by \"customer\".\"yearly_income\",\n \"customer\".\"education\"\norder by \"customer\".\"yearly_income\" ASC NULLS LAST,\n \"customer\".\"education\" ASC NULLS LAST", "c0=$110K - $130K; c1=Bachelors Degree\nc0=$110K - $130K; c1=Graduate Degree\nc0=$110K - $130K; c1=High School Degree\nc0=$110K - $130K; c1=Partial College\nc0=$110K - $130K; c1=Partial High School\nc0=$130K - $150K; c1=Bachelors Degree\nc0=$130K - $150K; c1=Graduate Degree\nc0=$130K - $150K; c1=High School Degree\nc0=$130K - $150K; c1=Partial College\nc0=$130K - $150K; c1=Partial High School\nc0=$150K +; c1=Bachelors Degree\nc0=$150K +; c1=Graduate Degree\nc0=$150K +; c1=High School Degree\nc0=$150K +; c1=Partial College\nc0=$150K +; c1=Partial High School\nc0=$30K - $50K; c1=Bachelors Degree\nc0=$30K - $50K; c1=Graduate Degree\nc0=$30K - $50K; c1=High School Degree\nc0=$30K - $50K; c1=Partial College\nc0=$30K - $50K; c1=Partial High School\nc0=$70K - $90K; c1=Bachelors Degree\nc0=$70K - $90K; c1=Graduate Degree\nc0=$70K - $90K; c1=High School Degree\nc0=$70K - $90K; c1=Partial College\nc0=$70K - $90K; c1=Partial High School\nc0=$90K - $110K; c1=Bachelors Degree\nc0=$90K - $110K; c1=Graduate Degree\nc0=$90K - $110K; c1=High School Degree\nc0=$90K - $110K; c1=Partial College\nc0=$90K - $110K; c1=Partial High School\n", "ignore:select \"time_by_day\".\"the_year\" as \"c0\", \"product_class\".\"product_family\" as \"c1\", \"customer\".\"state_province\" as \"c2\", \"customer\".\"city\" as \"c3\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"product_class\" as \"product_class\", \"product\" as \"product\", \"customer\" as \"customer\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"product_class\".\"product_family\" = 'Drink' and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" and \"customer\".\"state_province\" = 'WA' and \"customer\".\"city\" in ('Anacortes', 'Ballard', 'Bellingham', 'Bremerton', 'Burien', 'Edmonds', 'Everett', 'Issaquah', 'Kirkland', 'Lynnwood', 'Marysville', 'Olympia', 'Port Orchard', 'Puyallup', 'Redmond', 'Renton', 'Seattle', 'Sedro Woolley', 'Spokane', 'Tacoma', 'Walla Walla', 'Yakima') group by \"time_by_day\".\"the_year\", \"product_class\".\"product_family\", \"customer\".\"state_province\", \"customer\".\"city\"", "c0=1997; c1=Drink; c2=WA; c3=Sedro Woolley; m0=58.0000\n", "select \"store\".\"store_country\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n sum(\"sales_fact_1997\".\"store_cost\") as \"m0\",\n count(\"sales_fact_1997\".\"product_id\") as \"m1\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m2\",\n sum((case when \"sales_fact_1997\".\"promotion_id\" = 0 then 0\n     else \"sales_fact_1997\".\"store_sales\" end)) as \"m3\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"store\".\"store_country\", \"time_by_day\".\"the_year\"", "c0=USA; c1=1997; m0=225627.2336; m1=86837; m2=5581; m3=151211.2100\n", "ignore:select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\nand \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand (((\"product\".\"brand_name\" = 'Cormorant'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable')\n or (\"product\".\"brand_name\" = 'Denny'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable')\n or (\"product\".\"brand_name\" = 'High Quality'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable')\n or (\"product\".\"brand_name\" = 'Red Wing'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable'))\n or (\"product_class\".\"product_subcategory\" = 'Pots and Pans'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable'))\ngroup by \"time_by_day\".\"the_year\"\n", "xxtodo", "ignore:select count(\"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand ((\"product\".\"brand_name\" = 'Cormorant'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers')\n or (\"product_class\".\"product_subcategory\" = 'Pots and Pans'))\n", "xxxx", "select count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand \"product\".\"brand_name\" = 'Cormorant'\n", "m0=1298", "select \"store\".\"store_country\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n \"time_by_day\".\"quarter\" as \"c2\",\n \"product_class\".\"product_family\" as \"c3\",\n count(\"sales_fact_1997\".\"product_id\") as \"m0\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m1\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"store\".\"store_country\" = 'USA'\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\nand \"time_by_day\".\"quarter\" = 'Q3'\nand \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand \"product_class\".\"product_family\" = 'Food'\ngroup by \"store\".\"store_country\",\n \"time_by_day\".\"the_year\",\n \"time_by_day\".\"quarter\",\n \"product_class\".\"product_family\"", "c0=USA; c1=1997; c2=Q3; c3=Food; m0=15449; m1=2939"};
    public static final List<Pair<String, String>> FOODMART_QUERIES = JdbcTest.querify(QUERIES);
    public static final ImmutableMultimap<Class, Integer> CONVERSIONS = JdbcTest.x();

    public static List<Pair<String, String>> getFoodmartQueries() {
        return FOODMART_QUERIES;
    }

    @Test
    public void testTableFunction() throws SQLException, ClassNotFoundException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableFunction table = TableFunctionImpl.create((Method)GENERATE_STRINGS_METHOD);
        schema.add("GenerateStrings", (Function)table);
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom table(\"s\".\"GenerateStrings\"(5)) as t(n, c)\nwhere char_length(c) > 3");
        Assert.assertThat((Object)OptiqAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"N=4; C=abcd\n"));
    }

    @Test
    public void testTableFunctionDynamicStructure() throws SQLException, ClassNotFoundException {
        Connection connection = this.getConnectionWithMultiplyFunction();
        PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"multiplication\"(4, 3, ?))\n");
        ps.setInt(1, 100);
        ResultSet resultSet = ps.executeQuery();
        Assert.assertThat((Object)OptiqAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"row_name=row 0; c1=101; c2=102; c3=103; c4=104\nrow_name=row 1; c1=102; c2=104; c3=106; c4=108\nrow_name=row 2; c1=103; c2=106; c3=109; c4=112\n"));
    }

    @Ignore(value="SQLException does not include message from nested exception")
    @Test
    public void testTableFunctionNonNullableMustBeLiterals() throws SQLException, ClassNotFoundException {
        Connection connection = this.getConnectionWithMultiplyFunction();
        try {
            PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"multiplication\"(?, 3, 100))\n");
            ps.setInt(1, 100);
            ResultSet resultSet = ps.executeQuery();
            Assert.fail((String)("Should fail, got " + resultSet));
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Wrong arguments for table function 'public static net.hydromatic.optiq.QueryableTable net.hydromatic.optiq.test.JdbcTest.multiplicationTable(int,int,java.lang.Integer)' call. Expected '[int, int, classjava.lang.Integer]', actual '[null, 3, 100]'"));
        }
    }

    private Connection getConnectionWithMultiplyFunction() throws ClassNotFoundException, SQLException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableFunction table = TableFunctionImpl.create((Method)MULTIPLICATION_TABLE_METHOD);
        schema.add("multiplication", (Function)table);
        return connection;
    }

    @Ignore(value="CannotPlanException: Node [rel#18:Subset#4.ENUMERABLE.[]] could not be implemented")
    @Test
    public void testTableFunctionCursorInputs() throws SQLException, ClassNotFoundException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableFunction table = TableFunctionImpl.create((Method)GENERATE_STRINGS_METHOD);
        schema.add("GenerateStrings", (Function)table);
        TableFunction add = TableFunctionImpl.create((Method)PROCESS_CURSOR_METHOD);
        schema.add("process", (Function)add);
        PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"process\"(2,\ncursor(select * from table(\"s\".\"GenerateStrings\"(?)))\n)) as t(u)\nwhere u > 3");
        ps.setInt(1, 5);
        ResultSet resultSet = ps.executeQuery();
        Assert.assertThat((Object)OptiqAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"u=4\nu=5\nu=6\n"));
    }

    @Ignore(value="CannotPlanException: Node [rel#24:Subset#6.ENUMERABLE.[]] could not be implemented")
    @Test
    public void testTableFunctionCursorsInputs() throws SQLException, ClassNotFoundException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = this.getConnectionWithMultiplyFunction();
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        SchemaPlus schema = rootSchema.getSubSchema("s");
        TableFunction table = TableFunctionImpl.create((Method)GENERATE_STRINGS_METHOD);
        schema.add("GenerateStrings", (Function)table);
        TableFunction add = TableFunctionImpl.create((Method)PROCESS_CURSORS_METHOD);
        schema.add("process", (Function)add);
        PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"process\"(2,\ncursor(select * from table(\"s\".\"multiplication\"(5,5,0))),\ncursor(select * from table(\"s\".\"GenerateStrings\"(?)))\n)) as t(u)\nwhere u > 3");
        ps.setInt(1, 5);
        ResultSet resultSet = ps.executeQuery();
        Assert.assertThat((Object)OptiqAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"u=4\nu=5\nu=6\nu=7\nu=8\nu=9\n"));
    }

    @Test
    public void testSqlAdvisorGetHintsFunction() throws SQLException, ClassNotFoundException {
        String res = this.adviseSql("select e.e^ from \"emps\" e");
        Assert.assertThat((Object)res, (Matcher)CoreMatchers.equalTo((Object)"id=e; names=null; type=MATCH\nid=empid; names=[empid]; type=COLUMN\n"));
    }

    @Test
    public void testSqlAdvisorSchemaNames() throws SQLException, ClassNotFoundException {
        String res = this.adviseSql("select empid from \"emps\" e, ^");
        Assert.assertThat((Object)res, (Matcher)CoreMatchers.equalTo((Object)"id=; names=null; type=MATCH\nid=(; names=[(]; type=KEYWORD\nid=LATERAL; names=[LATERAL]; type=KEYWORD\nid=TABLE; names=[TABLE]; type=KEYWORD\nid=UNNEST; names=[UNNEST]; type=KEYWORD\nid=hr; names=[hr]; type=SCHEMA\nid=metadata; names=[metadata]; type=SCHEMA\nid=s; names=[s]; type=SCHEMA\nid=hr.depts; names=[hr, depts]; type=TABLE\nid=hr.emps; names=[hr, emps]; type=TABLE\n"));
    }

    private String adviseSql(String sql) throws ClassNotFoundException, SQLException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Properties info = new Properties();
        info.put("lex", "JAVA");
        info.put("quoting", "DOUBLE_QUOTE");
        Connection connection = DriverManager.getConnection("jdbc:optiq:", info);
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        optiqConnection.setSchema("hr");
        SqlAdvisorGetHintsFunction table = new SqlAdvisorGetHintsFunction();
        schema.add("get_hints", (Function)table);
        PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"get_hints\"(?, ?)) as t(id, names, type)");
        SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
        ps.setString(1, sap.sql);
        ps.setInt(2, sap.cursor);
        return OptiqAssert.toString(ps.executeQuery());
    }

    @Test
    public void testTableMacro() throws SQLException, ClassNotFoundException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableMacro tableMacro = TableMacroImpl.create((Method)VIEW_METHOD);
        schema.add("View", (Function)tableMacro);
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom table(\"s\".\"View\"('(10), (20)')) as t(n)\nwhere n < 15");
        Assert.assertThat((Object)OptiqAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"N=1\nN=3\nN=10\n"));
    }

    @Test
    public void testTableMacroInModel() throws Exception {
        this.checkTableMacroInModel(TableMacroFunction.class);
    }

    @Test
    public void testStaticTableMacroInModel() throws Exception {
        this.checkTableMacroInModel(StaticTableMacroFunction.class);
    }

    @Test
    public void testTableFunctionInModel() throws Exception {
        this.checkTableMacroInModel(TestTableFunction.class);
    }

    @Test
    public void testStaticTableFunctionInModel() throws Exception {
        this.checkTableMacroInModel(TestStaticTableFunction.class);
    }

    private void checkTableMacroInModel(Class clazz) {
        OptiqAssert.that().withModel("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       functions: [\n         {\n           name: 'View',\n           className: '" + clazz.getName() + "'\n" + "         }\n" + "       ]\n" + "     }\n" + "   ]\n" + "}").query("select * from table(\"adhoc\".\"View\"('(30)'))").returns("c=1\nc=3\nc=30\n");
    }

    public static <T> Queryable<T> stringUnion(Queryable<T> q0, Queryable<T> q1) {
        return q0.concat(q1);
    }

    public static QueryableTable generateStrings(final Integer count) {
        return new AbstractQueryableTable((Type)((Object)IntString.class)){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.createJavaType(IntString.class);
            }

            public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                BaseQueryable<IntString> queryable = new BaseQueryable<IntString>(null, IntString.class, null){

                    public Enumerator<IntString> enumerator() {
                        return new Enumerator<IntString>(){
                            static final String Z = "abcdefghijklm";
                            int i = 0;
                            int curI;
                            String curS;

                            public IntString current() {
                                return new IntString(this.curI, this.curS);
                            }

                            public boolean moveNext() {
                                if (this.i < count) {
                                    this.curI = this.i;
                                    this.curS = Z.substring(0, this.i % Z.length());
                                    ++this.i;
                                    return true;
                                }
                                return false;
                            }

                            public void reset() {
                                this.i = 0;
                            }

                            public void close() {
                            }
                        };
                    }
                };
                return queryable;
            }
        };
    }

    public static QueryableTable multiplicationTable(final int ncol, final int nrow, Integer offset) {
        final int offs = offset == null ? 0 : offset;
        return new AbstractQueryableTable((Type)((Object)Object[].class)){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
                builder.add("row_name", typeFactory.createJavaType(String.class));
                RelDataType int_ = typeFactory.createJavaType(Integer.TYPE);
                int i = 1;
                while (i <= ncol) {
                    builder.add("c" + i, int_);
                    ++i;
                }
                return builder.build();
            }

            public Queryable<Object[]> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                AbstractList<Object[]> table = new AbstractList<Object[]>(){

                    @Override
                    public Object[] get(int index) {
                        Object[] cur = new Object[ncol + 1];
                        cur[0] = "row " + index;
                        int j = 1;
                        while (j <= ncol) {
                            cur[j] = j * (index + 1) + offs;
                            ++j;
                        }
                        return cur;
                    }

                    @Override
                    public int size() {
                        return nrow;
                    }
                };
                return Linq4j.asEnumerable((List)table).asQueryable();
            }
        };
    }

    public static QueryableTable processCursor(int offset, Enumerable<Object[]> a) {
        return new AbstractQueryableTable((Type)((Object)Object[].class), (Enumerable)a, offset){
            private final /* synthetic */ Enumerable val$a;
            private final /* synthetic */ int val$offset;
            {
                this.val$a = enumerable;
                this.val$offset = n;
                super($anonymous0);
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("result", SqlTypeName.INTEGER).build();
            }

            public Queryable<Integer> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                Enumerable enumerable = this.val$a.select((Function1)new Function1<Object[], Integer>(){

                    public Integer apply(Object[] a0) {
                        return val$offset + (Integer)a0[0];
                    }
                });
                return enumerable.asQueryable();
            }
        };
    }

    public static QueryableTable processCursors(int offset, Enumerable<Object[]> a, Enumerable<IntString> b) {
        return new AbstractQueryableTable((Type)((Object)Object[].class), (Enumerable)a, (Enumerable)b, offset){
            private final /* synthetic */ Enumerable val$a;
            private final /* synthetic */ Enumerable val$b;
            private final /* synthetic */ int val$offset;
            {
                this.val$a = enumerable;
                this.val$b = enumerable2;
                this.val$offset = n;
                super($anonymous0);
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("result", SqlTypeName.INTEGER).build();
            }

            public Queryable<Integer> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                Enumerable enumerable = this.val$a.zip(this.val$b, (Function2)new Function2<Object[], IntString, Integer>(){

                    public Integer apply(Object[] v0, IntString v1) {
                        return (Integer)v0[1] + v1.n + val$offset;
                    }
                });
                return enumerable.asQueryable();
            }
        };
    }

    @Test
    public void testOnConnectionClose() throws Exception {
        final int[] closeCount = new int[1];
        final int[] statementCloseCount = new int[1];
        HandlerDriver.HANDLERS.set(new HandlerImpl(){

            public void onConnectionClose(AvaticaConnection connection) {
                closeCount[0] = closeCount[0] + 1;
                throw new RuntimeException();
            }

            public void onStatementClose(AvaticaStatement statement) {
                statementCloseCount[0] = statementCloseCount[0] + 1;
                throw new RuntimeException();
            }
        });
        HandlerDriver driver = new HandlerDriver();
        OptiqConnection connection = (OptiqConnection)driver.connect("jdbc:optiq:", new Properties());
        SchemaPlus rootSchema = connection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
        connection.setSchema("hr");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from \"emps\"");
        Assert.assertEquals((long)0L, (long)closeCount[0]);
        Assert.assertEquals((long)0L, (long)statementCloseCount[0]);
        resultSet.close();
        Assert.assertEquals((long)0L, (long)closeCount[0]);
        Assert.assertEquals((long)0L, (long)statementCloseCount[0]);
        try {
            statement.close();
            Assert.fail((String)"expecting error");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)closeCount[0]);
        Assert.assertEquals((long)1L, (long)statementCloseCount[0]);
        try {
            connection.close();
            Assert.fail((String)"expecting error");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)closeCount[0]);
        Assert.assertEquals((long)1L, (long)statementCloseCount[0]);
        connection.close();
        Assert.assertEquals((long)1L, (long)closeCount[0]);
        Assert.assertEquals((long)1L, (long)statementCloseCount[0]);
        HandlerDriver.HANDLERS.remove();
    }

    @Test
    public void testStatementCloseOnCompletion() throws Exception {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.7") < 0) {
            return;
        }
        net.hydromatic.optiq.jdbc.Driver driver = new net.hydromatic.optiq.jdbc.Driver();
        OptiqConnection connection = (OptiqConnection)driver.connect("jdbc:optiq:", new Properties());
        SchemaPlus rootSchema = connection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
        connection.setSchema("hr");
        Statement statement = connection.createStatement();
        Assert.assertFalse((boolean)((Boolean)OptiqAssert.call(statement, "isCloseOnCompletion", new Object[0])));
        OptiqAssert.call(statement, "closeOnCompletion", new Object[0]);
        Assert.assertTrue((boolean)((Boolean)OptiqAssert.call(statement, "isCloseOnCompletion", new Object[0])));
        ResultSet resultSet = statement.executeQuery("select * from \"emps\"");
        Assert.assertFalse((boolean)resultSet.isClosed());
        Assert.assertFalse((boolean)statement.isClosed());
        Assert.assertFalse((boolean)connection.isClosed());
        resultSet.close();
        Assert.assertTrue((boolean)resultSet.isClosed());
        Assert.assertTrue((boolean)statement.isClosed());
        Assert.assertFalse((boolean)connection.isClosed());
        connection.close();
        Assert.assertTrue((boolean)resultSet.isClosed());
        Assert.assertTrue((boolean)statement.isClosed());
        Assert.assertTrue((boolean)connection.isClosed());
    }

    @Test
    public void testReadme() throws ClassNotFoundException, SQLException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
        Statement statement = optiqConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("select d.\"deptno\", min(e.\"empid\")\nfrom \"hr\".\"emps\" as e\njoin \"hr\".\"depts\" as d\n  on e.\"deptno\" = d.\"deptno\"\ngroup by d.\"deptno\"\nhaving count(*) > 1");
        String s = OptiqAssert.toString(resultSet);
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.notNullValue());
        resultSet.close();
        statement.close();
        connection.close();
    }

    @Test
    public void testConnectionProperties() throws ClassNotFoundException, SQLException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Driver driver = DriverManager.getDriver("jdbc:optiq:");
        DriverPropertyInfo[] propertyInfo = driver.getPropertyInfo("jdbc:optiq:", new Properties());
        HashSet<String> names = new HashSet<String>();
        DriverPropertyInfo[] driverPropertyInfoArray = propertyInfo;
        int n = propertyInfo.length;
        int n2 = 0;
        while (n2 < n) {
            DriverPropertyInfo info = driverPropertyInfoArray[n2];
            names.add(info.name);
            ++n2;
        }
        Assert.assertTrue((boolean)names.contains("SCHEMA"));
        Assert.assertTrue((boolean)names.contains("TIMEZONE"));
        Assert.assertTrue((boolean)names.contains("MATERIALIZATIONS_ENABLED"));
    }

    @Test
    public void testVersion() throws ClassNotFoundException, SQLException {
        String majorMinor;
        String[] split;
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        DatabaseMetaData metaData = optiqConnection.getMetaData();
        Assert.assertEquals((Object)"Optiq JDBC Driver", (Object)metaData.getDriverName());
        String driverVersion = metaData.getDriverVersion();
        int driverMajorVersion = metaData.getDriverMajorVersion();
        int driverMinorVersion = metaData.getDriverMinorVersion();
        Assert.assertEquals((long)0L, (long)driverMajorVersion);
        Assert.assertTrue((driverMinorVersion >= 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Optiq", (Object)metaData.getDatabaseProductName());
        String databaseProductVersion = metaData.getDatabaseProductVersion();
        int databaseMajorVersion = metaData.getDatabaseMajorVersion();
        Assert.assertEquals((long)driverMajorVersion, (long)databaseMajorVersion);
        int databaseMinorVersion = metaData.getDatabaseMinorVersion();
        Assert.assertEquals((long)driverMinorVersion, (long)databaseMinorVersion);
        if (!driverVersion.endsWith("-SNAPSHOT")) {
            Assert.assertTrue((boolean)driverVersion.startsWith("0."));
            split = driverVersion.split("\\.");
            Assert.assertTrue((split.length >= 2 ? 1 : 0) != 0);
            majorMinor = String.valueOf(driverMajorVersion) + "." + driverMinorVersion;
            Assert.assertTrue((driverVersion.equals(majorMinor) || driverVersion.startsWith(String.valueOf(majorMinor) + ".") ? 1 : 0) != 0);
        }
        if (!databaseProductVersion.endsWith("-SNAPSHOT")) {
            Assert.assertTrue((boolean)databaseProductVersion.startsWith("0."));
            split = databaseProductVersion.split("\\.");
            Assert.assertTrue((split.length >= 2 ? 1 : 0) != 0);
            majorMinor = String.valueOf(databaseMajorVersion) + "." + databaseMinorVersion;
            Assert.assertTrue((databaseProductVersion.equals(majorMinor) || databaseProductVersion.startsWith(String.valueOf(majorMinor) + ".") ? 1 : 0) != 0);
        }
        connection.close();
    }

    @Test
    public void testMetaDataColumns() throws ClassNotFoundException, SQLException {
        OptiqConnection connection = OptiqAssert.getConnection("hr", "foodmart");
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet resultSet = metaData.getColumns(null, null, null, null);
        Assert.assertTrue((boolean)resultSet.next());
        String name = resultSet.getString(4);
        int type = resultSet.getInt(5);
        String typeName = resultSet.getString(6);
        int columnSize = resultSet.getInt(7);
        int decimalDigits = resultSet.getInt(9);
        int numPrecRadix = resultSet.getInt(10);
        int charOctetLength = resultSet.getInt(16);
        String isNullable = resultSet.getString(18);
        resultSet.close();
        connection.close();
    }

    @Test
    public void testMetaDataPrimaryKeys() throws ClassNotFoundException, SQLException {
        OptiqConnection connection = OptiqAssert.getConnection("hr", "foodmart");
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet resultSet = metaData.getPrimaryKeys(null, null, null);
        Assert.assertFalse((boolean)resultSet.next());
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)6L, (long)resultSetMetaData.getColumnCount());
        Assert.assertEquals((Object)"TABLE_CAT", (Object)resultSetMetaData.getColumnName(1));
        Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
        Assert.assertEquals((Object)"PK_NAME", (Object)resultSetMetaData.getColumnName(6));
        resultSet.close();
        connection.close();
    }

    @Test
    public void testLikeToRegex() {
        this.checkLikeToRegex(true, "%", "abc");
        this.checkLikeToRegex(true, "abc", "abc");
        this.checkLikeToRegex(false, "abc", "abcd");
        this.checkLikeToRegex(false, "abc", "0abc");
        this.checkLikeToRegex(false, "abc", "aBc");
        this.checkLikeToRegex(true, "a[b]c", "a[b]c");
        this.checkLikeToRegex(true, "a$c", "a$c");
        this.checkLikeToRegex(false, "a$", "a");
        this.checkLikeToRegex(true, "a%c", "ac");
        this.checkLikeToRegex(true, "a%c", "abbbc");
        this.checkLikeToRegex(false, "a%c", "acccd");
        this.checkLikeToRegex(true, "a\\%c", "a%c");
        this.checkLikeToRegex(false, "a\\%c", "abc");
        this.checkLikeToRegex(false, "a\\%c", "a\\%c");
        this.checkLikeToRegex(true, "a%c%d", "abcdaaad");
        this.checkLikeToRegex(false, "a%c%d", "abcdc");
    }

    private void checkLikeToRegex(boolean b, String pattern, String abc) {
        Assert.assertTrue((b == MetaImpl.likeToRegex((Meta.Pat)Meta.Pat.of((String)pattern)).matcher(abc).matches() ? 1 : 0) != 0);
    }

    @Test
    public void testResultSetMetaData() throws ClassNotFoundException, SQLException {
        OptiqConnection connection = OptiqAssert.getConnection("hr", "foodmart");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select \"empid\", \"deptno\" as x, 1 as y\nfrom \"hr\".\"emps\"");
        ResultSetMetaData metaData = resultSet.getMetaData();
        Assert.assertEquals((long)3L, (long)metaData.getColumnCount());
        Assert.assertEquals((Object)"empid", (Object)metaData.getColumnLabel(1));
        Assert.assertEquals((Object)"empid", (Object)metaData.getColumnName(1));
        Assert.assertEquals((Object)"emps", (Object)metaData.getTableName(1));
        Assert.assertEquals((Object)"X", (Object)metaData.getColumnLabel(2));
        Assert.assertEquals((Object)"deptno", (Object)metaData.getColumnName(2));
        Assert.assertEquals((Object)"emps", (Object)metaData.getTableName(2));
        Assert.assertEquals((Object)"Y", (Object)metaData.getColumnLabel(3));
        Assert.assertEquals((Object)"Y", (Object)metaData.getColumnName(3));
        Assert.assertEquals(null, (Object)metaData.getTableName(3));
        resultSet.close();
        connection.close();
    }

    @Test
    public void testSimple() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("SELECT 1").returns("EXPR$0=1\n");
    }

    @Test
    public void testGetByName() throws Exception {
        OptiqAssert.that().doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection c) {
                try {
                    int x2;
                    Statement s = c.createStatement();
                    ResultSet rs = s.executeQuery("SELECT 1 as \"a\", 2 as \"b\", 3 as \"a\", 4 as \"B\"\nFROM (VALUES (0))");
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt("a"));
                    Assert.assertEquals((long)1L, (long)rs.getInt("A"));
                    Assert.assertEquals((long)2L, (long)rs.getInt("b"));
                    Assert.assertEquals((long)2L, (long)rs.getInt("B"));
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((long)2L, (long)rs.getInt(2));
                    Assert.assertEquals((long)3L, (long)rs.getInt(3));
                    Assert.assertEquals((long)4L, (long)rs.getInt(4));
                    try {
                        x2 = rs.getInt("z");
                        Assert.fail((String)("expected error, got " + x2));
                    }
                    catch (SQLException x2) {
                        // empty catch block
                    }
                    Assert.assertEquals((long)1L, (long)rs.findColumn("a"));
                    Assert.assertEquals((long)1L, (long)rs.findColumn("A"));
                    Assert.assertEquals((long)2L, (long)rs.findColumn("b"));
                    Assert.assertEquals((long)2L, (long)rs.findColumn("B"));
                    try {
                        x2 = rs.findColumn("z");
                        Assert.fail((String)("expected error, got " + x2));
                    }
                    catch (SQLException e) {
                        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"column 'z' not found"));
                    }
                    try {
                        int x3 = rs.getInt(0);
                        Assert.fail((String)("expected error, got " + x3));
                    }
                    catch (SQLException e) {
                        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"invalid column ordinal: 0"));
                    }
                    try {
                        int x4 = rs.getInt(5);
                        Assert.fail((String)("expected error, got " + x4));
                    }
                    catch (SQLException e) {
                        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"invalid column ordinal: 5"));
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testCloneSchema() throws ClassNotFoundException, SQLException {
        OptiqConnection connection = OptiqAssert.getConnection(false);
        SchemaPlus rootSchema = connection.getRootSchema();
        SchemaPlus foodmart = rootSchema.getSubSchema("foodmart");
        rootSchema.add("foodmart2", (Schema)new CloneSchema(foodmart));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) from \"foodmart2\".\"time_by_day\"");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((long)730L, (long)resultSet.getInt(1));
        resultSet.close();
        connection.close();
    }

    @Test
    public void testCloneGroupBy() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"the_year\", count(*) as c, min(\"the_month\") as m\nfrom \"foodmart2\".\"time_by_day\"\ngroup by \"the_year\"\norder by 1, 2").returns("the_year=1997; C=365; M=April\nthe_year=1998; C=365; M=April\n");
    }

    @Ignore
    @Test
    public void testCloneGroupBy2() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"product_class\".\"product_family\" as \"c2\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"product_class\" as \"product_class\", \"product\" as \"product\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"product_class\".\"product_family\"").returns("c0=1997; c1=Q2; c2=Drink; m0=5895.0000\nc0=1997; c1=Q1; c2=Food; m0=47809.0000\nc0=1997; c1=Q3; c2=Drink; m0=6065.0000\nc0=1997; c1=Q4; c2=Drink; m0=6661.0000\nc0=1997; c1=Q4; c2=Food; m0=51866.0000\nc0=1997; c1=Q1; c2=Drink; m0=5976.0000\nc0=1997; c1=Q3; c2=Non-Consumable; m0=12343.0000\nc0=1997; c1=Q4; c2=Non-Consumable; m0=13497.0000\nc0=1997; c1=Q2; c2=Non-Consumable; m0=11890.0000\nc0=1997; c1=Q2; c2=Food; m0=44825.0000\nc0=1997; c1=Q3; c2=Food; m0=47440.0000\nc0=1997; c1=Q1; c2=Non-Consumable; m0=12506.0000\n");
    }

    @Ignore
    @Test
    public void testCloneGroupBy2Plan() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("explain plan for select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"product_class\".\"product_family\" as \"c2\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"product_class\" as \"product_class\", \"product\" as \"product\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"product_class\".\"product_family\"").returns("PLAN=EnumerableAggregateRel(group=[{0, 1, 2}], m0=[SUM($3)])\n  EnumerableCalcRel(expr#0..37=[{inputs}], c0=[$t9], c1=[$t13], c2=[$t4], unit_sales=[$t22])\n    EnumerableJoinRel(condition=[=($23, $0)], joinType=[inner])\n      EnumerableTableAccessRel(table=[[foodmart2, product_class]])\n      EnumerableJoinRel(condition=[=($10, $19)], joinType=[inner])\n        EnumerableJoinRel(condition=[=($11, $0)], joinType=[inner])\n          EnumerableCalcRel(expr#0..9=[{inputs}], expr#10=[CAST($t4):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], proj#0..9=[{exprs}], $condition=[$t12])\n            EnumerableTableAccessRel(table=[[foodmart2, time_by_day]])\n          EnumerableTableAccessRel(table=[[foodmart2, sales_fact_1997]])\n        EnumerableTableAccessRel(table=[[foodmart2, product]])\n\n");
    }

    @Test
    public void testOrderByCase() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\" from \"time_by_day\" as \"time_by_day\" group by \"time_by_day\".\"the_year\" order by CASE WHEN \"time_by_day\".\"the_year\" IS NULL THEN 1 ELSE 0 END, \"time_by_day\".\"the_year\" ASC").returns("c0=1997\nc0=1998\n");
    }

    @Test
    public void testJanino169() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select \"time_id\" from \"foodmart\".\"time_by_day\" as \"t\"\n").returnsCount(730);
    }

    @Test
    public void testAnd3() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\" from \"hr\".\"emps\"\nwhere \"emps\".\"empid\" < 240\nand \"salary\" > 7500.0and \"emps\".\"deptno\" > 10\n").returnsUnordered("deptno=20");
    }

    @Test
    public void testJdbcDate() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select count(*) as c from (\n  select 1 from \"foodmart\".\"employee\" as e1\n  where \"position_title\" = 'VP Country Manager'\n  and \"birth_date\" < DATE '1950-01-01'\n  and \"gender\" = 'F')").returns("C=1\n");
    }

    @Test
    public void testJdbcTimestamp() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*) as c from (\n  select 1 from \"foodmart\".\"employee\" as e1\n  where \"hire_date\" < TIMESTAMP '1996-06-05 00:00:00'\n  and \"gender\" = 'F')").returns("C=287\n");
    }

    @Test
    public void testExtract() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("values extract(year from date '2008-2-23')").returns(new Function1<ResultSet, Void>(){

            public Void apply(ResultSet a0) {
                try {
                    BigDecimal bigDecimal = a0.getBigDecimal(1);
                    Assert.assertThat((Object)bigDecimal, (Matcher)CoreMatchers.equalTo((Object)BigDecimal.valueOf(2008L)));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    @Test
    public void testSelfJoin() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*) as c from (\n  select 1 from \"foodmart\".\"employee\" as e1\n  join \"foodmart\".\"employee\" as e2 using (\"position_title\"))").returns("C=247149\n");
    }

    @Test
    public void testSelfJoinDifferentColumns() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select e1.\"full_name\"\n  from \"foodmart\".\"employee\" as e1\n  join \"foodmart\".\"employee\" as e2 on e1.\"first_name\" = e2.\"last_name\"\norder by e1.\"last_name\" limit 3").returns("full_name=James Aguilar\nfull_name=Carol Amyotte\nfull_name=Terry Anderson\n");
    }

    @Ignore
    @Test
    public void testJoinJoin() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select\n   \"product_class\".\"product_family\" as \"c0\",\n   \"product_class\".\"product_department\" as \"c1\",\n   \"customer\".\"country\" as \"c2\",\n   \"customer\".\"state_province\" as \"c3\",\n   \"customer\".\"city\" as \"c4\"\nfrom\n   \"sales_fact_1997\" as \"sales_fact_1997\"\njoin (\"product\" as \"product\"\n     join \"product_class\" as \"product_class\"\n     on \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\")\non  \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\njoin \"customer\" as \"customer\"\non  \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\njoin \"promotion\" as \"promotion\"\non \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\"\nwhere (\"promotion\".\"media_type\" = 'Radio'\n or \"promotion\".\"media_type\" = 'TV'\n or \"promotion\".\"media_type\" = 'Sunday Paper'\n or \"promotion\".\"media_type\" = 'Street Handout')\n and (\"product_class\".\"product_family\" = 'Drink')\n and (\"customer\".\"country\" = 'USA' and \"customer\".\"state_province\" = 'WA' and \"customer\".\"city\" = 'Bellingham')\ngroup by \"product_class\".\"product_family\",\n   \"product_class\".\"product_department\",\n   \"customer\".\"country\",\n   \"customer\".\"state_province\",\n   \"customer\".\"city\"\norder by ISNULL(\"product_class\".\"product_family\") ASC,   \"product_class\".\"product_family\" ASC,\n   ISNULL(\"product_class\".\"product_department\") ASC,   \"product_class\".\"product_department\" ASC,\n   ISNULL(\"customer\".\"country\") ASC,   \"customer\".\"country\" ASC,\n   ISNULL(\"customer\".\"state_province\") ASC,   \"customer\".\"state_province\" ASC,\n   ISNULL(\"customer\".\"city\") ASC,   \"customer\".\"city\" ASC").returns("+-------+---------------------+-----+------+------------+\n| c0    | c1                  | c2  | c3   | c4         |\n+-------+---------------------+-----+------+------------+\n| Drink | Alcoholic Beverages | USA | WA   | Bellingham |\n| Drink | Dairy               | USA | WA   | Bellingham |\n+-------+---------------------+-----+------+------------+");
    }

    @Ignore
    @Test
    public void testJoinFiveWay() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store\".\"store_country\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n \"product_class\".\"product_family\" as \"c2\",\n count(\"sales_fact_1997\".\"product_id\") as \"m0\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"store\".\"store_country\" = 'USA'\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\nand \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\ngroup by \"store\".\"store_country\",\n \"time_by_day\".\"the_year\",\n \"product_class\".\"product_family\"").explainContains("EnumerableAggregateRel(group=[{0, 1, 2}], m0=[COUNT($3)])\n  EnumerableCalcRel(expr#0..61=[{inputs}], c0=[$t19], c1=[$t4], c2=[$t46], product_id=[$t34])\n    EnumerableJoinRel(condition=[=($35, $0)], joinType=[inner])\n      EnumerableCalcRel(expr#0..9=[{inputs}], expr#10=[CAST($t4):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], proj#0..9=[{exprs}], $condition=[$t12])\n        EnumerableTableAccessRel(table=[[foodmart2, time_by_day]])\n      EnumerableCalcRel(expr#0..51=[{inputs}], proj#0..23=[{exprs}], product_id=[$t44], time_id=[$t45], customer_id=[$t46], promotion_id=[$t47], store_id0=[$t48], store_sales=[$t49], store_cost=[$t50], unit_sales=[$t51], product_class_id=[$t24], product_subcategory=[$t25], product_category=[$t26], product_department=[$t27], product_family=[$t28], product_class_id0=[$t29], product_id0=[$t30], brand_name=[$t31], product_name=[$t32], SKU=[$t33], SRP=[$t34], gross_weight=[$t35], net_weight=[$t36], recyclable_package=[$t37], low_fat=[$t38], units_per_case=[$t39], cases_per_pallet=[$t40], shelf_width=[$t41], shelf_height=[$t42], shelf_depth=[$t43])\n        EnumerableJoinRel(condition=[=($48, $0)], joinType=[inner])\n          EnumerableCalcRel(expr#0..23=[{inputs}], expr#24=['USA'], expr#25=[=($t9, $t24)], proj#0..23=[{exprs}], $condition=[$t25])\n            EnumerableTableAccessRel(table=[[foodmart2, store]])\n          EnumerableCalcRel(expr#0..27=[{inputs}], proj#0..4=[{exprs}], product_class_id0=[$t13], product_id=[$t14], brand_name=[$t15], product_name=[$t16], SKU=[$t17], SRP=[$t18], gross_weight=[$t19], net_weight=[$t20], recyclable_package=[$t21], low_fat=[$t22], units_per_case=[$t23], cases_per_pallet=[$t24], shelf_width=[$t25], shelf_height=[$t26], shelf_depth=[$t27], product_id0=[$t5], time_id=[$t6], customer_id=[$t7], promotion_id=[$t8], store_id=[$t9], store_sales=[$t10], store_cost=[$t11], unit_sales=[$t12])\n            EnumerableJoinRel(condition=[=($13, $0)], joinType=[inner])\n              EnumerableTableAccessRel(table=[[foodmart2, product_class]])\n              EnumerableJoinRel(condition=[=($0, $9)], joinType=[inner])\n                EnumerableTableAccessRel(table=[[foodmart2, sales_fact_1997]])\n                EnumerableTableAccessRel(table=[[foodmart2, product]])\n\n]>").returns("+-------+---------------------+-----+------+------------+\n| c0    | c1                  | c2  | c3   | c4         |\n+-------+---------------------+-----+------+------------+\n| Drink | Alcoholic Beverages | USA | WA   | Bellingham |\n| Drink | Dairy               | USA | WA   | Bellingham |\n+-------+---------------------+-----+------+------------+");
    }

    @Test
    public void testJoinManyWay() {
        JdbcTest.checkJoinNWay(1);
        JdbcTest.checkJoinNWay(6);
    }

    private static void checkJoinNWay(int n) {
        assert (n > 0);
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*)");
        int i = 0;
        while (i < n) {
            buf.append(i == 0 ? "\nfrom " : ",\n ").append("\"hr\".\"depts\" as d").append(i);
            ++i;
        }
        i = 1;
        while (i < n) {
            buf.append(i == 1 ? "\nwhere" : "\nand").append(" d").append(i).append(".\"deptno\" = d").append(i - 1).append(".\"deptno\"");
            ++i;
        }
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query(buf.toString()).returns("EXPR$0=3\n");
    }

    private static List<Pair<String, String>> querify(String[] queries1) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        int i = 0;
        while (i < queries1.length) {
            String query = queries1[i];
            String expected = null;
            if (i + 1 < queries1.length && queries1[i + 1] != null && !queries1[i + 1].startsWith("select")) {
                expected = queries1[++i];
            }
            list.add((Pair<String, String>)Pair.of((Object)query, expected));
            ++i;
        }
        return list;
    }

    @Ignore
    @Test
    public void testCloneQueries() {
        OptiqAssert.AssertThat with = OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE);
        for (Ord query : Ord.zip(FOODMART_QUERIES)) {
            try {
                String sql = (String)((Pair)query.e).left;
                if (sql.startsWith("ignore:")) continue;
                String expected = (String)((Pair)query.e).right;
                OptiqAssert.AssertQuery query1 = with.query(sql);
                if (expected != null) {
                    if (sql.contains("order by")) {
                        query1.returns(expected);
                        continue;
                    }
                    query1.returnsUnordered(expected.split("\n"));
                    continue;
                }
                query1.runs();
            }
            catch (Throwable e) {
                throw new RuntimeException("while running query #" + query.i, e);
            }
        }
    }

    @Test
    public void testArray() throws Exception {
        String hsqldbMemUrl = "jdbc:hsqldb:mem:.";
        Connection baseConnection = DriverManager.getConnection(hsqldbMemUrl);
        Statement baseStmt = baseConnection.createStatement();
        baseStmt.execute("CREATE TABLE ARR_TABLE (\nID INTEGER,\nVALS INTEGER ARRAY)");
        baseStmt.execute("INSERT INTO ARR_TABLE VALUES (1, ARRAY[1,2,3])");
        baseStmt.execute("CREATE TABLE ARR_TABLE2 (\nID INTEGER,\nVALS INTEGER ARRAY,\nVALVALS VARCHAR(10) ARRAY)");
        baseStmt.execute("INSERT INTO ARR_TABLE2 VALUES (1, ARRAY[1,2,3], ARRAY['x','y'])");
        baseStmt.close();
        baseConnection.commit();
        Properties info = new Properties();
        info.put("model", "inline:{\n  version: '1.0',\n  defaultSchema: 'BASEJDBC',\n  schemas: [\n     {\n       type: 'jdbc',\n       name: 'BASEJDBC',\n       jdbcDriver: '" + jdbcDriver.class.getName() + "',\n" + "       jdbcUrl: '" + hsqldbMemUrl + "',\n" + "       jdbcCatalog: null,\n" + "       jdbcSchema: null\n" + "     }\n" + "  ]\n" + "}");
        Connection optiqConnection = DriverManager.getConnection("jdbc:optiq:", info);
        Statement optiqStatement = optiqConnection.createStatement();
        ResultSet rs = optiqStatement.executeQuery("SELECT ID, VALS FROM ARR_TABLE");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Array array = rs.getArray(2);
        Assert.assertNotNull((Object)array);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])((int[])array.getArray()));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = optiqStatement.executeQuery("SELECT ID, CARDINALITY(VALS), VALS[2] FROM ARR_TABLE");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = optiqStatement.executeQuery("SELECT * FROM ARR_TABLE2");
        ResultSetMetaData metaData = rs.getMetaData();
        Assert.assertThat((Object)metaData.getColumnTypeName(1), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
        Assert.assertThat((Object)metaData.getColumnTypeName(2), (Matcher)CoreMatchers.equalTo((Object)"INTEGER ARRAY"));
        Assert.assertThat((Object)metaData.getColumnTypeName(3), (Matcher)CoreMatchers.equalTo((Object)"VARCHAR(10) ARRAY"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertThat((Object)rs.getArray(2), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)rs.getArray(3), (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((boolean)rs.next());
        optiqConnection.close();
    }

    @Test
    public void testArray2() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\", cardinality(\"employees\") as c\nfrom \"hr\".\"depts\"").returnsUnordered("deptno=10; C=2", "deptno=30; C=0", "deptno=40; C=1");
    }

    @Test
    public void testNestedArray() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection a0) {
                try {
                    Statement statement = a0.createStatement();
                    ResultSet resultSet = statement.executeQuery("select \"empid\",\n  array[\n    array['x', 'y', 'z'],\n    array[\"name\"]] as a\nfrom \"hr\".\"emps\"");
                    Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)100));
                    Assert.assertThat((Object)resultSet.getString(2), (Matcher)CoreMatchers.equalTo((Object)"[[x, y, z], [Bill]]"));
                    Array array = resultSet.getArray(2);
                    Assert.assertThat((Object)array.getBaseType(), (Matcher)CoreMatchers.equalTo((Object)2003));
                    Object[] arrayValues = (Object[])array.getArray();
                    Assert.assertThat((Object)arrayValues.length, (Matcher)CoreMatchers.equalTo((Object)2));
                    Array subArray = (Array)arrayValues[0];
                    Assert.assertThat((Object)subArray.getBaseType(), (Matcher)CoreMatchers.equalTo((Object)12));
                    Object[] subArrayValues = (Object[])subArray.getArray();
                    Assert.assertThat((Object)subArrayValues.length, (Matcher)CoreMatchers.equalTo((Object)3));
                    Assert.assertThat((Object)subArrayValues[2], (Matcher)CoreMatchers.equalTo((Object)"z"));
                    ResultSet subResultSet = subArray.getResultSet();
                    Assert.assertThat((Object)subResultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)subResultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"x"));
                    try {
                        String string = subResultSet.getString(2);
                        Assert.fail((String)("expected error, got " + string));
                    }
                    catch (SQLException e) {
                        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"invalid column ordinal: 2"));
                    }
                    Assert.assertThat((Object)subResultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)subResultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)subResultSet.isAfterLast(), (Matcher)CoreMatchers.is((Object)false));
                    Assert.assertThat((Object)subResultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"z"));
                    Assert.assertThat((Object)subResultSet.next(), (Matcher)CoreMatchers.is((Object)false));
                    Assert.assertThat((Object)subResultSet.isAfterLast(), (Matcher)CoreMatchers.is((Object)true));
                    statement.close();
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testArrayConstructor() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select array[1,2] as a from (values (1))").returnsUnordered("A=[1, 2]");
    }

    @Test
    public void testMultisetConstructor() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select multiset[1,2] as a from (values (1))").returnsUnordered("A=[1, 2]");
    }

    @Test
    public void testMultisetQuery() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select multiset(\n  select \"deptno\", \"empid\" from \"hr\".\"emps\") as a\nfrom (values (1))").returnsUnordered("A=[[10, 100], [20, 200], [10, 150], [10, 110]]");
    }

    @Test
    public void testMultisetQueryWithSingleColumn() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select multiset(\n  select \"deptno\" from \"hr\".\"emps\") as a\nfrom (values (1))").returnsUnordered("A=[10, 20, 10, 10]");
    }

    @Ignore(value="unnest does not apply to array. should it?")
    @Test
    public void testUnnestArray() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select*from unnest(array[1,2])").returnsUnordered("xx");
    }

    @Test
    public void testUnnestMultiset() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select*from unnest(multiset[1,2]) as t(c)").returnsUnordered("C=1", "C=2");
    }

    @Test
    public void testUnnestMultiset2() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select*from unnest(\n select \"employees\" from \"hr\".\"depts\"\n where \"deptno\" = 10)").returnsUnordered("EXPR$0=Employee [empid: 100, deptno: 10, name: Bill]", "EXPR$0=Employee [empid: 150, deptno: 10, name: Sebastian]");
    }

    @Test
    public void testArrayElement() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select element(\"employees\") from \"hr\".\"depts\"\nwhere cardinality(\"employees\") < 2").returnsUnordered("EXPR$0=Employee [empid: 200, deptno: 20, name: Eric]", "EXPR$0=null");
    }

    @Test
    public void testLateral() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\",\n LATERAL (select * from \"hr\".\"depts\" where \"emps\".\"deptno\" = \"depts\".\"deptno\")").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000; deptno0=10; name0=Sales; employees=[Employee [empid: 100, deptno: 10, name: Bill], Employee [empid: 150, deptno: 10, name: Sebastian]]", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250; deptno0=10; name0=Sales; employees=[Employee [empid: 100, deptno: 10, name: Bill], Employee [empid: 150, deptno: 10, name: Sebastian]]", "empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null; deptno0=10; name0=Sales; employees=[Employee [empid: 100, deptno: 10, name: Bill], Employee [empid: 150, deptno: 10, name: Sebastian]]");
    }

    @Ignore
    @Test
    public void testUnnestArrayColumn() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select d.\"name\", e.*\nfrom \"hr\".\"depts\" as d,\n UNNEST(d.\"employees\") as e").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000; deptno0=10; name0=Sales; employees=[Employee [empid: 100, deptno: 10, name: Bill], Employee [empid: 150, deptno: 10, name: Sebastian]]", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250; deptno0=10; name0=Sales; employees=[Employee [empid: 100, deptno: 10, name: Bill], Employee [empid: 150, deptno: 10, name: Sebastian]]", "empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null; deptno0=10; name0=Sales; employees=[Employee [empid: 100, deptno: 10, name: Bill], Employee [empid: 150, deptno: 10, name: Sebastian]]");
    }

    private OptiqAssert.AssertQuery withFoodMartQuery(int id) throws IOException {
        FoodmartTest.FoodMartQuerySet set = FoodmartTest.FoodMartQuerySet.instance();
        return OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query(set.queries.get((Object)Integer.valueOf((int)id)).sql);
    }

    @Ignore
    @Test
    public void testNoCalcBetweenJoins() throws IOException {
        FoodmartTest.FoodMartQuerySet set = FoodmartTest.FoodMartQuerySet.instance();
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query(set.queries.get((Object)Integer.valueOf((int)16)).sql).explainContains("EnumerableSortRel(sort0=[$0], sort1=[$1], sort2=[$2], sort3=[$4], sort4=[$10], sort5=[$11], sort6=[$12], sort7=[$13], sort8=[$22], sort9=[$23], sort10=[$24], sort11=[$25], sort12=[$26], sort13=[$27], dir0=[Ascending-nulls-last], dir1=[Ascending-nulls-last], dir2=[Ascending-nulls-last], dir3=[Ascending-nulls-last], dir4=[Ascending-nulls-last], dir5=[Ascending-nulls-last], dir6=[Ascending-nulls-last], dir7=[Ascending-nulls-last], dir8=[Ascending-nulls-last], dir9=[Ascending-nulls-last], dir10=[Ascending-nulls-last], dir11=[Ascending-nulls-last], dir12=[Ascending-nulls-last], dir13=[Ascending-nulls-last])\n  EnumerableCalcRel(expr#0..26=[{inputs}], proj#0..4=[{exprs}], c5=[$t4], c6=[$t5], c7=[$t6], c8=[$t7], c9=[$t8], c10=[$t9], c11=[$t10], c12=[$t11], c13=[$t12], c14=[$t13], c15=[$t14], c16=[$t15], c17=[$t16], c18=[$t17], c19=[$t18], c20=[$t19], c21=[$t20], c22=[$t21], c23=[$t22], c24=[$t23], c25=[$t24], c26=[$t25], c27=[$t26])\n    EnumerableAggregateRel(group=[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26}])\n      EnumerableCalcRel(expr#0..80=[{inputs}], c0=[$t12], c1=[$t10], c2=[$t9], c3=[$t0], fullname=[$t28], c6=[$t19], c7=[$t17], c8=[$t22], c9=[$t18], c10=[$t46], c11=[$t44], c12=[$t43], c13=[$t40], c14=[$t38], c15=[$t47], c16=[$t52], c17=[$t53], c18=[$t54], c19=[$t55], c20=[$t56], c21=[$t42], c22=[$t80], c23=[$t79], c24=[$t78], c25=[$t77], c26=[$t63], c27=[$t64])\n        EnumerableJoinRel(condition=[=($61, $76)], joinType=[inner])\n          EnumerableJoinRel(condition=[=($29, $62)], joinType=[inner])\n            EnumerableJoinRel(condition=[=($33, $37)], joinType=[inner])\n              EnumerableCalcRel(expr#0..36=[{inputs}], customer_id=[$t8], account_num=[$t9], lname=[$t10], fname=[$t11], mi=[$t12], address1=[$t13], address2=[$t14], address3=[$t15], address4=[$t16], city=[$t17], state_province=[$t18], postal_code=[$t19], country=[$t20], customer_region_id=[$t21], phone1=[$t22], phone2=[$t23], birthdate=[$t24], marital_status=[$t25], yearly_income=[$t26], gender=[$t27], total_children=[$t28], num_children_at_home=[$t29], education=[$t30], date_accnt_opened=[$t31], member_card=[$t32], occupation=[$t33], houseowner=[$t34], num_cars_owned=[$t35], fullname=[$t36], product_id=[$t0], time_id=[$t1], customer_id0=[$t2], promotion_id=[$t3], store_id=[$t4], store_sales=[$t5], store_cost=[$t6], unit_sales=[$t7])\n                EnumerableJoinRel(condition=[=($2, $8)], joinType=[inner])\n                  EnumerableTableAccessRel(table=[[foodmart2, sales_fact_1997]])\n                  EnumerableTableAccessRel(table=[[foodmart2, customer]])\n              EnumerableTableAccessRel(table=[[foodmart2, store]])\n            EnumerableTableAccessRel(table=[[foodmart2, product]])\n          EnumerableTableAccessRel(table=[[foodmart2, product_class]])\n");
    }

    @Ignore
    @Test
    public void testExplainJoin() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query((String)JdbcTest.FOODMART_QUERIES.get((int)48).left).explainContains("EnumerableAggregateRel(group=[{}], m0=[COUNT($0)])\n  EnumerableAggregateRel(group=[{0}])\n    EnumerableCalcRel(expr#0..27=[{inputs}], customer_id=[$t7])\n      EnumerableJoinRel(condition=[=($13, $0)], joinType=[inner])\n        EnumerableTableAccessRel(table=[[foodmart2, product_class]])\n        EnumerableJoinRel(condition=[=($0, $9)], joinType=[inner])\n          EnumerableTableAccessRel(table=[[foodmart2, sales_fact_1997]])\n          EnumerableCalcRel(expr#0..14=[{inputs}], expr#15=['Cormorant'], expr#16=[=($t2, $t15)], proj#0..14=[{exprs}], $condition=[$t16])\n            EnumerableTableAccessRel(table=[[foodmart2, product]]");
    }

    @Ignore
    @Test
    public void testExplainJoin2() throws IOException {
        this.withFoodMartQuery(2482).explainContains("EnumerableSortRel(sort0=[$0], sort1=[$1], dir0=[Ascending-nulls-last], dir1=[Ascending-nulls-last])\n  EnumerableAggregateRel(group=[{0, 1}])\n    EnumerableCalcRel(expr#0..5=[{inputs}], c0=[$t4], c1=[$t1])\n      EnumerableJoinRel(condition=[=($3, $5)], joinType=[inner])\n        EnumerableCalcRel(expr#0..3=[{inputs}], store_id=[$t2], store_country=[$t3], store_id0=[$t0], month_of_year=[$t1])\n          EnumerableJoinRel(condition=[=($0, $2)], joinType=[inner])\n            EnumerableCalcRel(expr#0..10=[{inputs}], store_id=[$t2], month_of_year=[$t4])\n              EnumerableTableAccessRel(table=[[foodmart2, agg_c_14_sales_fact_1997]])\n            EnumerableCalcRel(expr#0..23=[{inputs}], store_id=[$t0], store_country=[$t9])\n              EnumerableTableAccessRel(table=[[foodmart2, store]])\n        EnumerableCalcRel(expr#0..9=[{inputs}], the_year=[$t4], month_of_year=[$t7])\n          EnumerableTableAccessRel(table=[[foodmart2, time_by_day]])\n").runs();
    }

    @Ignore
    @Test
    public void testExplainJoin3() throws IOException {
        this.withFoodMartQuery(8).explainContains("EnumerableSortRel(sort0=[$0], sort1=[$1], sort2=[$2], sort3=[$4], dir0=[Ascending-nulls-last], dir1=[Ascending-nulls-last], dir2=[Ascending-nulls-last], dir3=[Ascending-nulls-last])\n  EnumerableCalcRel(expr#0..8=[{inputs}], expr#9=['%Jeanne%'], expr#10=[LIKE($t4, $t9)], proj#0..4=[{exprs}], c5=[$t4], c6=[$t5], c7=[$t6], c8=[$t7], c9=[$t8], $condition=[$t10])\n    EnumerableAggregateRel(group=[{0, 1, 2, 3, 4, 5, 6, 7, 8}])\n      EnumerableCalcRel(expr#0..46=[{inputs}], c0=[$t12], c1=[$t10], c2=[$t9], c3=[$t0], fullname=[$t28], c6=[$t19], c7=[$t17], c8=[$t22], c9=[$t18])\n        EnumerableJoinRel(condition=[=($30, $37)], joinType=[inner])\n          EnumerableCalcRel(expr#0..36=[{inputs}], customer_id=[$t8], account_num=[$t9], lname=[$t10], fname=[$t11], mi=[$t12], address1=[$t13], address2=[$t14], address3=[$t15], address4=[$t16], city=[$t17], state_province=[$t18], postal_code=[$t19], country=[$t20], customer_region_id=[$t21], phone1=[$t22], phone2=[$t23], birthdate=[$t24], marital_status=[$t25], yearly_income=[$t26], gender=[$t27], total_children=[$t28], num_children_at_home=[$t29], education=[$t30], date_accnt_opened=[$t31], member_card=[$t32], occupation=[$t33], houseowner=[$t34], num_cars_owned=[$t35], fullname=[$t36], product_id=[$t0], time_id=[$t1], customer_id0=[$t2], promotion_id=[$t3], store_id=[$t4], store_sales=[$t5], store_cost=[$t6], unit_sales=[$t7])\n            EnumerableJoinRel(condition=[=($2, $8)], joinType=[inner])\n              EnumerableTableAccessRel(table=[[foodmart2, sales_fact_1997]])\n              EnumerableTableAccessRel(table=[[foodmart2, customer]])\n          EnumerableCalcRel(expr#0..9=[{inputs}], expr#10=[CAST($t4):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], proj#0..9=[{exprs}], $condition=[$t12])\n            EnumerableTableAccessRel(table=[[foodmart2, time_by_day]])").runs();
    }

    @Ignore
    @Test
    public void testExplainJoin4() throws IOException {
        this.withFoodMartQuery(5217).explainContains("EnumerableAggregateRel(group=[{0, 1, 2, 3}], m0=[COUNT($4)])\n  EnumerableCalcRel(expr#0..69=[{inputs}], c0=[$t4], c1=[$t27], c2=[$t61], c3=[$t66], $f11=[$t11])\n    EnumerableJoinRel(condition=[=($68, $69)], joinType=[inner])\n      EnumerableCalcRel(expr#0..67=[{inputs}], proj#0..67=[{exprs}], $f68=[$t66])\n        EnumerableJoinRel(condition=[=($11, $65)], joinType=[inner])\n          EnumerableJoinRel(condition=[=($46, $59)], joinType=[inner])\n            EnumerableCalcRel(expr#0..58=[{inputs}], $f0=[$t49], $f1=[$t50], $f2=[$t51], $f3=[$t52], $f4=[$t53], $f5=[$t54], $f6=[$t55], $f7=[$t56], $f8=[$t57], $f9=[$t58], $f10=[$t41], $f11=[$t42], $f12=[$t43], $f13=[$t44], $f14=[$t45], $f15=[$t46], $f16=[$t47], $f17=[$t48], $f18=[$t0], $f19=[$t1], $f20=[$t2], $f21=[$t3], $f22=[$t4], $f23=[$t5], $f24=[$t6], $f25=[$t7], $f26=[$t8], $f27=[$t9], $f28=[$t10], $f29=[$t11], $f30=[$t12], $f31=[$t13], $f32=[$t14], $f33=[$t15], $f34=[$t16], $f35=[$t17], $f36=[$t18], $f37=[$t19], $f38=[$t20], $f39=[$t21], $f40=[$t22], $f41=[$t23], $f42=[$t24], $f43=[$t25], $f44=[$t26], $f45=[$t27], $f46=[$t28], $f47=[$t29], $f48=[$t30], $f49=[$t31], $f50=[$t32], $f51=[$t33], $f52=[$t34], $f53=[$t35], $f54=[$t36], $f55=[$t37], $f56=[$t38], $f57=[$t39], $f58=[$t40])\n              EnumerableJoinRel(condition=[=($41, $50)], joinType=[inner])\n                EnumerableCalcRel(expr#0..48=[{inputs}], $f0=[$t25], $f1=[$t26], $f2=[$t27], $f3=[$t28], $f4=[$t29], $f5=[$t30], $f6=[$t31], $f7=[$t32], $f8=[$t33], $f9=[$t34], $f10=[$t35], $f11=[$t36], $f12=[$t37], $f13=[$t38], $f14=[$t39], $f15=[$t40], $f16=[$t41], $f17=[$t42], $f18=[$t43], $f19=[$t44], $f20=[$t45], $f21=[$t46], $f22=[$t47], $f23=[$t48], $f24=[$t8], $f25=[$t9], $f26=[$t10], $f27=[$t11], $f28=[$t12], $f29=[$t13], $f30=[$t14], $f31=[$t15], $f32=[$t16], $f33=[$t17], $f34=[$t18], $f35=[$t19], $f36=[$t20], $f37=[$t21], $f38=[$t22], $f39=[$t23], $f40=[$t24], $f41=[$t0], $f42=[$t1], $f43=[$t2], $f44=[$t3], $f45=[$t4], $f46=[$t5], $f47=[$t6], $f48=[$t7])\n                  EnumerableJoinRel(condition=[=($14, $25)], joinType=[inner])\n                    EnumerableJoinRel(condition=[=($1, $8)], joinType=[inner])\n                      EnumerableTableAccessRel(table=[[foodmart2, salary]])\n                      EnumerableTableAccessRel(table=[[foodmart2, employee]])\n                    EnumerableTableAccessRel(table=[[foodmart2, store]])\n                EnumerableTableAccessRel(table=[[foodmart2, time_by_day]])\n            EnumerableTableAccessRel(table=[[foodmart2, position]])\n          EnumerableTableAccessRel(table=[[foodmart2, employee_closure]])\n      EnumerableAggregateRel(group=[{0}])\n        EnumerableValuesRel(tuples=[[{ 1 }, { 2 }, { 20 }, { 21 }, { 22 }, { 23 }, { 24 }, { 25 }, { 26 }, { 27 }, { 28 }, { 29 }, { 30 }, { 31 }, { 53 }, { 54 }, { 55 }, { 56 }, { 57 }, { 58 }, { 59 }, { 60 }, { 61 }, { 62 }, { 63 }, { 64 }, { 65 }, { 66 }, { 67 }, { 68 }, { 69 }, { 70 }, { 71 }, { 72 }, { 73 }, { 74 }, { 75 }, { 76 }, { 77 }, { 78 }, { 79 }, { 80 }, { 81 }, { 82 }, { 83 }, { 84 }, { 85 }, { 86 }, { 87 }, { 88 }, { 89 }, { 90 }, { 91 }, { 92 }, { 93 }, { 94 }, { 95 }, { 96 }, { 97 }, { 98 }, { 99 }, { 100 }, { 101 }, { 102 }, { 103 }, { 104 }, { 105 }, { 106 }, { 107 }, { 108 }, { 109 }, { 110 }, { 111 }, { 112 }, { 113 }, { 114 }, { 115 }, { 116 }, { 117 }, { 118 }, { 119 }, { 120 }, { 121 }, { 122 }, { 123 }, { 124 }, { 125 }, { 126 }, { 127 }, { 128 }, { 129 }, { 130 }, { 131 }, { 132 }, { 133 }, { 134 }, { 135 }, { 136 }, { 137 }, { 138 }, { 139 }, { 140 }, { 141 }, { 142 }, { 143 }, { 144 }, { 145 }, { 146 }, { 147 }, { 148 }, { 149 }, { 150 }, { 151 }, { 152 }, { 153 }, { 154 }, { 155 }, { 156 }, { 157 }, { 158 }, { 159 }, { 160 }, { 161 }, { 162 }, { 163 }, { 164 }, { 165 }, { 166 }, { 167 }, { 168 }, { 169 }, { 170 }, { 171 }, { 172 }, { 173 }, { 174 }, { 175 }, { 176 }, { 177 }, { 178 }, { 179 }, { 180 }, { 181 }, { 182 }, { 183 }, { 184 }, { 185 }, { 186 }, { 187 }, { 188 }, { 189 }, { 190 }, { 191 }, { 192 }, { 193 }, { 194 }, { 195 }, { 196 }, { 197 }, { 198 }, { 199 }, { 200 }, { 201 }, { 202 }, { 203 }, { 204 }, { 205 }, { 206 }, { 207 }, { 208 }, { 209 }, { 210 }, { 211 }, { 212 }, { 213 }, { 214 }, { 215 }, { 216 }, { 217 }, { 218 }, { 219 }, { 220 }, { 221 }, { 222 }, { 223 }, { 224 }, { 225 }, { 226 }, { 227 }, { 228 }, { 229 }, { 230 }, { 231 }, { 232 }, { 233 }, { 234 }, { 235 }, { 236 }, { 237 }, { 238 }, { 239 }, { 240 }, { 241 }, { 242 }, { 243 }, { 244 }, { 245 }, { 246 }, { 247 }, { 248 }, { 249 }, { 250 }, { 251 }, { 252 }, { 253 }, { 254 }, { 255 }, { 256 }, { 257 }, { 258 }, { 259 }, { 260 }, { 261 }, { 262 }, { 263 }, { 264 }, { 265 }, { 266 }, { 267 }, { 268 }, { 269 }, { 270 }, { 271 }, { 272 }, { 273 }, { 274 }, { 275 }, { 276 }, { 277 }, { 278 }, { 279 }, { 280 }, { 281 }, { 282 }, { 283 }, { 284 }, { 285 }, { 286 }, { 287 }, { 288 }, { 289 }, { 290 }, { 291 }, { 292 }, { 293 }, { 294 }, { 295 }, { 296 }, { 297 }, { 298 }, { 299 }, { 300 }, { 301 }, { 302 }, { 303 }, { 304 }, { 305 }, { 306 }, { 307 }, { 308 }, { 309 }, { 310 }, { 311 }, { 312 }, { 313 }, { 314 }, { 315 }, { 316 }, { 317 }, { 318 }, { 319 }, { 320 }, { 321 }, { 322 }, { 323 }, { 324 }, { 325 }, { 326 }, { 327 }, { 328 }, { 329 }, { 330 }, { 331 }, { 332 }, { 333 }, { 334 }, { 335 }, { 336 }, { 337 }, { 338 }, { 339 }, { 340 }, { 341 }, { 342 }, { 343 }, { 344 }, { 345 }, { 346 }, { 347 }, { 348 }, { 349 }, { 350 }, { 351 }, { 352 }, { 353 }, { 354 }, { 355 }, { 356 }, { 357 }, { 358 }, { 359 }, { 360 }, { 361 }, { 362 }, { 363 }, { 364 }, { 365 }, { 366 }, { 367 }, { 368 }, { 369 }, { 370 }, { 371 }, { 372 }, { 373 }, { 374 }, { 375 }, { 376 }, { 377 }, { 378 }, { 379 }, { 380 }, { 381 }, { 382 }, { 383 }, { 384 }, { 385 }, { 386 }, { 387 }, { 388 }, { 389 }, { 390 }, { 391 }, { 392 }, { 393 }, { 394 }, { 395 }, { 396 }, { 397 }, { 398 }, { 399 }, { 400 }, { 401 }, { 402 }, { 403 }, { 404 }, { 405 }, { 406 }, { 407 }, { 408 }, { 409 }, { 410 }, { 411 }, { 412 }, { 413 }, { 414 }, { 415 }, { 416 }, { 417 }, { 418 }, { 419 }, { 420 }, { 421 }, { 422 }, { 423 }, { 424 }, { 425 }, { 430 }, { 431 }, { 432 }, { 433 }, { 434 }, { 435 }, { 436 }, { 437 }, { 442 }, { 443 }, { 444 }, { 445 }, { 446 }, { 447 }, { 448 }, { 449 }, { 450 }, { 451 }, { 457 }, { 458 }, { 459 }, { 460 }, { 461 }, { 462 }, { 463 }, { 469 }, { 470 }, { 471 }, { 472 }, { 473 }]])\n").runs();
    }

    @Ignore
    @Test
    public void testExplainJoinOrderingWithOr() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query((String)JdbcTest.FOODMART_QUERIES.get((int)47).left).explainContains("xxx");
    }

    @Test
    public void testNullableTimestamp() {
        this.checkNullableTimestamp(OptiqAssert.Config.FOODMART_CLONE);
    }

    @Test
    public void testNullableTimestamp2() {
        this.checkNullableTimestamp(OptiqAssert.Config.JDBC_FOODMART);
    }

    private void checkNullableTimestamp(OptiqAssert.Config config) {
        OptiqAssert.that().with(config).query("select \"hire_date\", \"end_date\", \"birth_date\" from \"foodmart\".\"employee\" where \"employee_id\" = 1").returns("hire_date=1994-12-01 00:00:00; end_date=null; birth_date=1961-08-26\n");
    }

    @Test
    public void testReuseExpressionWhenNullChecking() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select upper((case when \"empid\">\"deptno\"*10 then 'y' else null end)) T from \"hr\".\"emps\"").planContains("static final String $L4J$C$net_hydromatic_optiq_runtime_SqlFunctions_upper_y_ = net.hydromatic.optiq.runtime.SqlFunctions.upper(\"y\");").planContains("return current.empid <= current.deptno * 10 ? (String) null : $L4J$C$net_hydromatic_optiq_runtime_SqlFunctions_upper_y_;").returns("T=null\nT=null\nT=Y\nT=Y\n");
    }

    @Test
    public void testReuseExpressionWhenNullChecking2() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select upper((case when \"empid\">\"deptno\"*10 then \"name\" end)) T from \"hr\".\"emps\"").planContains("final String inp2_ = current.name;").planContains("return current.empid <= current.deptno * 10 || inp2_ == null ? (String) null : net.hydromatic.optiq.runtime.SqlFunctions.upper(inp2_);").returns("T=null\nT=null\nT=SEBASTIAN\nT=THEODORE\n");
    }

    @Test
    public void testReuseExpressionWhenNullChecking3() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select substring(\"name\", \"deptno\"+case when user <> 'sa' then 1 end) from \"hr\".\"emps\"").planContains("final String inp2_ = current.name;").planContains("static final boolean $L4J$C$net_hydromatic_optiq_runtime_SqlFunctions_ne_sa_sa_ = net.hydromatic.optiq.runtime.SqlFunctions.ne(\"sa\", \"sa\");").planContains("static final boolean $L4J$C$_net_hydromatic_optiq_runtime_SqlFunctions_ne_sa_sa_ = !$L4J$C$net_hydromatic_optiq_runtime_SqlFunctions_ne_sa_sa_;").planContains("return inp2_ == null || $L4J$C$_net_hydromatic_optiq_runtime_SqlFunctions_ne_sa_sa_ ? (String) null : net.hydromatic.optiq.runtime.SqlFunctions.substring(inp2_, current.deptno + 1);");
    }

    @Test
    public void testReuseExpressionWhenNullChecking4() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select substring(trim(\nsubstring(\"name\",\n  \"deptno\"*0+case when user = 'sa' then 1 end)\n), case when \"empid\">\"deptno\" then 4\n   else\n     case when \"deptno\"*8>8 then 5 end\n   end-2) T\nfrom\n\"hr\".\"emps\"").planContains("final String inp2_ = current.name;").planContains("final int inp1_ = current.deptno;").planContains("static final boolean $L4J$C$net_hydromatic_optiq_runtime_SqlFunctions_eq_sa_sa_ = net.hydromatic.optiq.runtime.SqlFunctions.eq(\"sa\", \"sa\");").planContains("static final boolean $L4J$C$_net_hydromatic_optiq_runtime_SqlFunctions_eq_sa_sa_ = !$L4J$C$net_hydromatic_optiq_runtime_SqlFunctions_eq_sa_sa_;").planContains("return inp2_ == null || $L4J$C$_net_hydromatic_optiq_runtime_SqlFunctions_eq_sa_sa_ || !v5 && inp1_ * 8 <= 8 ? (String) null : net.hydromatic.optiq.runtime.SqlFunctions.substring(net.hydromatic.optiq.runtime.SqlFunctions.trim(true, true, \" \", net.hydromatic.optiq.runtime.SqlFunctions.substring(inp2_, inp1_ * 0 + 1)), (v5 ? 4 : 5) - 2);").returns("T=ill\nT=ric\nT=ebastian\nT=heodore\n");
    }

    @Test
    public void testReuseExpressionWhenNullChecking5() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select substring(trim(\nsubstring(\"name\",\n  \"deptno\"*0+case when user = 'sa' then 1 end)\n), case when \"empid\">\"deptno\" then 5\n   else\n     case when \"deptno\"*8>8 then 5 end\n   end-2) T\nfrom\n\"hr\".\"emps\"").planContains("final String inp2_ = current.name;").planContains("final int inp1_ = current.deptno;").planContains("static final int $L4J$C$5_2 = 5 - 2;").planContains("static final boolean $L4J$C$net_hydromatic_optiq_runtime_SqlFunctions_eq_sa_sa_ = net.hydromatic.optiq.runtime.SqlFunctions.eq(\"sa\", \"sa\");").planContains("static final boolean $L4J$C$_net_hydromatic_optiq_runtime_SqlFunctions_eq_sa_sa_ = !$L4J$C$net_hydromatic_optiq_runtime_SqlFunctions_eq_sa_sa_;").planContains("return inp2_ == null || $L4J$C$_net_hydromatic_optiq_runtime_SqlFunctions_eq_sa_sa_ || current.empid <= inp1_ && inp1_ * 8 <= 8 ? (String) null : net.hydromatic.optiq.runtime.SqlFunctions.substring(net.hydromatic.optiq.runtime.SqlFunctions.trim(true, true, \" \", net.hydromatic.optiq.runtime.SqlFunctions.substring(inp2_, inp1_ * 0 + 1)), $L4J$C$5_2);").returns("T=ll\nT=ic\nT=bastian\nT=eodore\n");
    }

    @Test
    public void testValues() {
        OptiqAssert.that().query("values (1), (2)").returns("EXPR$0=1\nEXPR$0=2\n");
    }

    @Test
    public void testValuesAlias() {
        OptiqAssert.that().query("select \"desc\" from (VALUES ROW(1, 'SameName')) AS \"t\" (\"id\", \"desc\")").returns("desc=SameName\n");
    }

    @Test
    public void testValuesMinus() {
        OptiqAssert.that().query("values (-2-1)").returns("EXPR$0=-3\n");
    }

    private static ImmutableMultimap<Class, Integer> x() {
        int n;
        int n2;
        Object[] objectArray;
        int type;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        int[] allTypes = new int[]{-6, 5, 4, -5, 7, 6, 8, 3, 2, -7, 1, 12, -1, -2, -3, -4, 91, 92, 93};
        int[] numericTypes = new int[]{-6, 5, 4, -5, 7, 6, 8, 3, 2, -7};
        Class[] numericClasses = new Class[]{BigDecimal.class, Boolean.class, Integer.class, Long.class, Float.class, Double.class};
        Class[] allClasses = new Class[]{String.class, BigDecimal.class, Boolean.class, Integer.class, Long.class, Float.class, Double.class, byte[].class, Date.class, Time.class, Timestamp.class};
        int[] charTypes = new int[]{1, 12, -1};
        int[] binaryTypes = new int[]{-2, -3, -4};
        Object[] objectArray2 = allTypes;
        int n3 = allTypes.length;
        int n4 = 0;
        while (n4 < n3) {
            type = objectArray2[n4];
            builder.put(String.class, (Object)type);
            ++n4;
        }
        objectArray2 = numericClasses;
        n3 = numericClasses.length;
        n4 = 0;
        while (n4 < n3) {
            int clazz = objectArray2[n4];
            objectArray = numericTypes;
            n2 = numericTypes.length;
            n = 0;
            while (n < n2) {
                int type2 = objectArray[n];
                builder.put((Object)clazz, (Object)type2);
                ++n;
            }
            ++n4;
        }
        objectArray2 = charTypes;
        n3 = charTypes.length;
        n4 = 0;
        while (n4 < n3) {
            type = objectArray2[n4];
            objectArray = allClasses;
            n2 = allClasses.length;
            n = 0;
            while (n < n2) {
                int clazz = objectArray[n];
                builder.put((Object)clazz, (Object)type);
                ++n;
            }
            ++n4;
        }
        objectArray2 = binaryTypes;
        n3 = binaryTypes.length;
        n4 = 0;
        while (n4 < n3) {
            type = objectArray2[n4];
            builder.put(byte[].class, (Object)type);
            ++n4;
        }
        builder.put(Date.class, (Object)91);
        builder.put(Date.class, (Object)93);
        builder.put(Time.class, (Object)92);
        builder.put(Timestamp.class, (Object)91);
        builder.put(Time.class, (Object)92);
        builder.put(Timestamp.class, (Object)93);
        return builder.build();
    }

    @Test
    public void testValuesComposite() {
        OptiqAssert.that().query("values (1, 'a'), (2, 'abc')").returns("EXPR$0=1; EXPR$1=a  \nEXPR$0=2; EXPR$1=abc\n");
    }

    @Test
    public void testInnerJoinValues() {
        OptiqAssert.that().with(OptiqAssert.Config.LINGUAL).query("select empno, desc from sales.emps,\n  (SELECT * FROM (VALUES (10, 'SameName')) AS t (id, desc)) as sn\nwhere emps.deptno = sn.id and sn.desc = 'SameName' group by empno, desc").returns("EMPNO=1; DESC=SameName\n");
    }

    @Test
    public void testCartesianJoin() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\", \"hr\".\"depts\" where \"emps\".\"empid\" < 140 and \"depts\".\"deptno\" > 20").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000; deptno0=30; name0=Marketing; employees=[]", "empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000; deptno0=40; name0=HR; employees=[Employee [empid: 200, deptno: 20, name: Eric]]", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250; deptno0=30; name0=Marketing; employees=[]", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250; deptno0=40; name0=HR; employees=[Employee [empid: 200, deptno: 20, name: Eric]]");
    }

    @Test
    public void testDistinctCountSimple() {
        String s = "select count(distinct \"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"";
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select count(distinct \"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"").explainContains("EnumerableAggregateRel(group=[{}], m0=[COUNT($0)])\n  EnumerableAggregateRel(group=[{0}])\n    EnumerableCalcRel(expr#0..7=[{inputs}], unit_sales=[$t7])\n      EnumerableTableAccessRel(table=[[foodmart2, sales_fact_1997]])").returns("m0=6\n");
    }

    @Test
    public void testDistinctCount2() {
        String s = "select cast(\"unit_sales\" as integer) as \"u\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"\ngroup by \"unit_sales\"";
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select cast(\"unit_sales\" as integer) as \"u\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"\ngroup by \"unit_sales\"").explainContains("EnumerableCalcRel(expr#0..1=[{inputs}], expr#2=[CAST($t0):INTEGER NOT NULL], u=[$t2], m0=[$t1])\n  EnumerableAggregateRel(group=[{0}], m0=[COUNT($1)])\n    EnumerableAggregateRel(group=[{0, 1}])\n      EnumerableCalcRel(expr#0..7=[{inputs}], unit_sales=[$t7], customer_id=[$t2])\n        EnumerableTableAccessRel(table=[[foodmart2, sales_fact_1997]])").returnsUnordered("u=1; m0=523", "u=5; m0=1059", "u=4; m0=4459", "u=6; m0=19", "u=3; m0=4895", "u=2; m0=4735");
    }

    @Test
    public void testDistinctCount() {
        String s = "select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_year\"";
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_year\"").explainContains("EnumerableAggregateRel(group=[{0}], m0=[COUNT($1)])\n  EnumerableAggregateRel(group=[{0, 1}])\n    EnumerableCalcRel(expr#0..3=[{inputs}], c0=[$t3], unit_sales=[$t1])\n      EnumerableJoinRel(condition=[=($0, $2)], joinType=[inner])\n        EnumerableCalcRel(expr#0..7=[{inputs}], time_id=[$t1], unit_sales=[$t7])\n          EnumerableTableAccessRel(table=[[foodmart2, sales_fact_1997]])\n        EnumerableCalcRel(expr#0..9=[{inputs}], expr#10=[CAST($t4):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], time_id=[$t0], the_year=[$t4], $condition=[$t12])\n          EnumerableTableAccessRel(table=[[foodmart2, time_by_day]])").returns("c0=1997; m0=6\n");
    }

    @Test
    public void testDistinctCountComposite() {
        String s = "select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"product_id\",\n       \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_year\"";
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"product_id\",\n       \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_year\"").returns("c0=1997; m0=85452\n");
    }

    @Ignore
    @Test
    public void testIn() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\",\n \"product_class\".\"product_family\" as \"c1\",\n \"customer\".\"country\" as \"c2\",\n \"customer\".\"state_province\" as \"c3\",\n \"customer\".\"city\" as \"c4\",\n sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\", \"customer\" as \"customer\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\nand \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand \"product_class\".\"product_family\" = 'Drink'\nand \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nand \"customer\".\"country\" = 'USA'\nand \"customer\".\"state_province\" = 'WA'\nand \"customer\".\"city\" in ('Anacortes', 'Ballard', 'Bellingham', 'Bremerton', 'Burien', 'Edmonds', 'Everett', 'Issaquah', 'Kirkland', 'Lynnwood', 'Marysville', 'Olympia', 'Port Orchard', 'Puyallup', 'Redmond', 'Renton', 'Seattle', 'Sedro Woolley', 'Spokane', 'Tacoma', 'Walla Walla', 'Yakima')\ngroup by \"time_by_day\".\"the_year\",\n \"product_class\".\"product_family\",\n \"customer\".\"country\",\n \"customer\".\"state_province\",\n \"customer\".\"city\"").returns("c0=1997; c1=Drink; c2=USA; c3=WA; c4=Sedro Woolley; m0=58.0000\n");
    }

    @Test
    public void testSql92JoinParenthesized() {
    }

    @Test
    public void testOrderBy() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2").returns("store_id=1; grocery_sqft=17475\nstore_id=2; grocery_sqft=22271\nstore_id=0; grocery_sqft=null\n");
    }

    @Test
    public void testOrderByDesc() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2 desc").returns("store_id=2; grocery_sqft=22271\nstore_id=1; grocery_sqft=17475\nstore_id=0; grocery_sqft=null\n");
    }

    @Test
    public void testOrderByExpr() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"name\", \"empid\" from \"hr\".\"emps\"\norder by - \"empid\"").returns("name=Eric; empid=200\nname=Sebastian; empid=150\nname=Theodore; empid=110\nname=Bill; empid=100\n");
    }

    @Test
    public void testOrderStarByExpr() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\norder by - \"empid\"").explainContains("EnumerableCalcRel(expr#0..5=[{inputs}], proj#0..4=[{exprs}])\n  EnumerableSortRel(sort0=[$5], dir0=[ASC])\n    EnumerableCalcRel(expr#0..4=[{inputs}], expr#5=[-($t0)], proj#0..5=[{exprs}])\n      EnumerableTableAccessRel(table=[[hr, emps]])").returns("empid=200; deptno=20; name=Eric; salary=8000.0; commission=500\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\nempid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testOrderUnionStarByExpr() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\" where \"empid\" < 150\nunion all\nselect * from \"hr\".\"emps\" where \"empid\" > 150\norder by - \"empid\"").returns("empid=200; deptno=20; name=Eric; salary=8000.0; commission=500\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\nempid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testOrderByCast() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"customer_id\", \"postal_code\" from \"customer\"\nwhere \"customer_id\" < 5\norder by cast(substring(\"postal_code\" from 3) as integer) desc").returns("customer_id=3; postal_code=73980\ncustomer_id=4; postal_code=74674\ncustomer_id=2; postal_code=17172\ncustomer_id=1; postal_code=15057\n");
    }

    @Test
    public void testOrderByDescNullsFirst() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2 desc nulls first").returns("store_id=0; grocery_sqft=null\nstore_id=2; grocery_sqft=22271\nstore_id=1; grocery_sqft=17475\n");
    }

    @Test
    public void testOrderByNullsFirst() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2 nulls first").returns("store_id=0; grocery_sqft=null\nstore_id=1; grocery_sqft=17475\nstore_id=2; grocery_sqft=22271\n");
    }

    @Test
    public void testOrderByDescNullsLast() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2 desc nulls last").returns("store_id=2; grocery_sqft=22271\nstore_id=1; grocery_sqft=17475\nstore_id=0; grocery_sqft=null\n");
    }

    @Test
    public void testOrderByNullsLast() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2 nulls last").returns("store_id=1; grocery_sqft=17475\nstore_id=2; grocery_sqft=22271\nstore_id=0; grocery_sqft=null\n");
    }

    @Test
    public void testOrderByFetch() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 10\norder by 1 fetch first 5 rows only").explainContains("PLAN=EnumerableLimitRel(fetch=[5])\n  EnumerableSortRel(sort0=[$0], dir0=[ASC])\n    EnumerableCalcRel(expr#0..23=[{inputs}], expr#24=[10], expr#25=[<($t0, $t24)], store_id=[$t0], grocery_sqft=[$t16], $condition=[$t25])\n      EnumerableTableAccessRel(table=[[foodmart2, store]])\n").returns("store_id=0; grocery_sqft=null\nstore_id=1; grocery_sqft=17475\nstore_id=2; grocery_sqft=22271\nstore_id=3; grocery_sqft=24390\nstore_id=4; grocery_sqft=16844\n");
    }

    @Test
    public void testOrderByOffsetFetch() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 10\norder by 1 offset 2 rows fetch next 5 rows only").returns("store_id=2; grocery_sqft=22271\nstore_id=3; grocery_sqft=24390\nstore_id=4; grocery_sqft=16844\nstore_id=5; grocery_sqft=15012\nstore_id=6; grocery_sqft=15337\n");
    }

    @Test
    public void testFetch() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"empid\" from \"hr\".\"emps\"\nfetch first 2 rows only").returns("empid=100\nempid=200\n");
    }

    @Test
    public void testFetchStar() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nfetch first 2 rows only").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=200; deptno=20; name=Eric; salary=8000.0; commission=500\n");
    }

    @Test
    public void testLimitZero() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nlimit 0").returns("").planContains("return net.hydromatic.linq4j.Linq4j.asEnumerable(new Object[] {})");
    }

    @Test
    public void testLimitStar() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nlimit 2").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=200; deptno=20; name=Eric; salary=8000.0; commission=500\n");
    }

    @Test
    public void testLimitOnQueryableTable() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select * from \"days\"\nlimit 2").returns("day=1; week_day=Sunday\nday=2; week_day=Monday\n");
    }

    @Test
    public void testSelfJoinCount() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*) as c from \"foodmart\".\"sales_fact_1997\" as p1 join \"foodmart\".\"sales_fact_1997\" as p2 using (\"store_id\")").returns("C=749681031\n").explainContains("EnumerableAggregateRel(group=[{}], C=[COUNT()])\n  EnumerableCalcRel(expr#0..1=[{inputs}], expr#2=[0], DUMMY=[$t2])\n    EnumerableJoinRel(condition=[=($0, $1)], joinType=[inner])\n      JdbcToEnumerableConverter\n        JdbcProjectRel(store_id=[$4])\n          JdbcTableScan(table=[[foodmart, sales_fact_1997]])\n      JdbcToEnumerableConverter\n        JdbcProjectRel(store_id=[$4])\n          JdbcTableScan(table=[[foodmart, sales_fact_1997]])\n");
    }

    @Test
    public void testGroupByNull() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\", \"commission\", sum(\"salary\") s\nfrom \"hr\".\"emps\"\ngroup by \"deptno\", \"commission\"").returnsUnordered("deptno=10; commission=null; S=7000.0", "deptno=20; commission=500; S=8000.0", "deptno=10; commission=1000; S=10000.0", "deptno=10; commission=250; S=11500.0");
    }

    @Test
    public void testSelectDistinct() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select distinct \"deptno\"\nfrom \"hr\".\"emps\"\n").returnsUnordered("deptno=10", "deptno=20").planContains(".distinct(");
    }

    @Test
    public void testSelectDistinctComposite() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select distinct \"empid\" > 140 as c, \"deptno\"\nfrom \"hr\".\"emps\"\n").returnsUnordered("C=false; deptno=10", "C=true; deptno=10", "C=true; deptno=20").planContains(".distinct(");
    }

    @Test
    public void testGroupByNoAggregates() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\"\nfrom \"hr\".\"emps\"\ngroup by \"deptno\"").returnsUnordered("deptno=10", "deptno=20").planContains(".distinct(");
    }

    @Test
    public void testGroupByMax1IsNull() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from (\nselect max(1) max_id\nfrom \"hr\".\"emps\" where 1=2\n) where max_id is null").returnsUnordered("MAX_ID=null");
    }

    @Test
    public void testGroupBy1Max1() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from (\nselect max(u) max_id\nfrom (select \"empid\"+\"deptno\" u, 1 cnst\nfrom \"hr\".\"emps\" a) where 1=2\ngroup by cnst\n) where max_id is null").returnsCount(0);
    }

    @Test
    public void testCountUnionAll() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select count(*) c from (\nselect * from \"hr\".\"emps\" where 1=2\nunion all\nselect * from \"hr\".\"emps\" where 3=4\n)").returnsUnordered("C=0");
    }

    @Test
    public void testAggregateEmpty() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select\n count(*) as cs,\n count(\"deptno\") as c,\n sum(\"deptno\") as s,\n avg(\"deptno\") as a\nfrom \"hr\".\"emps\"\nwhere \"deptno\" < 0").explainContains("PLAN=EnumerableCalcRel(expr#0..2=[{inputs}], expr#3=[0], expr#4=[=($t0, $t3)], expr#5=[null], expr#6=[CASE($t4, $t5, $t1)], expr#7=[/($t2, $t0)], expr#8=[CAST($t7):JavaType(class java.lang.Integer)], CS=[$t0], C=[$t0], S=[$t6], A=[$t8])\n  EnumerableAggregateRel(group=[{}], CS=[COUNT()], agg#1=[$SUM0($0)], agg#2=[SUM($0)])\n    EnumerableCalcRel(expr#0..4=[{inputs}], expr#5=[0], expr#6=[<($t1, $t5)], deptno=[$t1], $condition=[$t6])\n      EnumerableTableAccessRel(table=[[hr, emps]])\n").returns("CS=0; C=0; S=null; A=null\n");
    }

    @Test
    public void testReduceCountNotNullable() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select\n count(\"deptno\") as cs,\n count(*) as cs2\nfrom \"hr\".\"emps\"\nwhere \"deptno\" < 0").explainContains("PLAN=EnumerableCalcRel(expr#0=[{inputs}], CS=[$t0], CS2=[$t0])\n  EnumerableAggregateRel(group=[{}], CS=[COUNT()])\n    EnumerableCalcRel(expr#0..4=[{inputs}], expr#5=[0], expr#6=[<($t1, $t5)], DUMMY=[$t5], $condition=[$t6])\n      EnumerableTableAccessRel(table=[[hr, emps]])\n").returns("CS=0; CS2=0\n");
    }

    @Test
    public void testReduceCompositeCountNotNullable() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select\n count(\"deptno\", \"commission\", \"commission\" + 1) as cs\nfrom \"hr\".\"emps\"").explainContains("EnumerableAggregateRel(group=[{}], CS=[COUNT($0, $1)])\n  EnumerableCalcRel(expr#0..4=[{inputs}], expr#5=[1], expr#6=[+($t4, $t5)], commission=[$t4], $f2=[$t6])\n    EnumerableTableAccessRel(table=[[hr, emps]])").returns("CS=3\n");
    }

    @Test
    public void testOrderByOnSortedTable() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select * from \"time_by_day\"\norder by \"time_id\"").explainContains("PLAN=EnumerableSortRel(sort0=[$0], dir0=[ASC])\n  EnumerableTableAccessRel(table=[[foodmart2, time_by_day]])\n\n");
    }

    @Ignore(value="fix output for timezone")
    @Test
    public void testOrderByOnSortedTable2() {
        OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).query("select \"time_id\", \"the_date\" from \"time_by_day\"\nwhere \"time_id\" < 370\norder by \"time_id\"").returns("time_id=367; the_date=1997-01-01 00:00:00.0\ntime_id=368; the_date=1997-01-02 00:00:00.0\ntime_id=369; the_date=1997-01-03 00:00:00.0\n").explainContains("PLAN=EnumerableSortRel(sort0=[$0], dir0=[Ascending])\n  EnumerableCalcRel(expr#0..9=[{inputs}], expr#10=[370], expr#11=[<($t0, $t10)], proj#0..1=[{exprs}], $condition=[$t11])\n    EnumerableTableAccessRel(table=[[foodmart2, time_by_day]])\n\n");
    }

    @Test
    public void testWithInsideWhereExists() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\" from \"hr\".\"emps\"\nwhere exists (\n  with dept2 as (select * from \"hr\".\"depts\" where \"depts\".\"deptno\" >= \"emps\".\"deptno\")\n  select 1 from dept2 where \"deptno\" <= \"emps\".\"deptno\")").returnsUnordered("deptno=10", "deptno=10", "deptno=10");
    }

    @Test
    public void testWithOrderBy() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("with emp2 as (select * from \"hr\".\"emps\")\nselect * from emp2\norder by \"deptno\" desc, \"empid\" desc").returns("empid=200; deptno=20; name=Eric; salary=8000.0; commission=500\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\nempid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testWinAgg() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\",\n \"empid\",\nsum(\"salary\" + \"empid\") over w as s,\n 5 as five,\n min(\"salary\") over w as m,\n count(*) over w as c\nfrom \"hr\".\"emps\"\nwindow w as (partition by \"deptno\" order by \"empid\" rows 1 preceding)").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, S REAL, FIVE INTEGER NOT NULL, M REAL, C BIGINT NOT NULL]").explainContains("EnumerableCalcRel(expr#0..7=[{inputs}], expr#8=[0], expr#9=[>($t4, $t8)], expr#10=[CAST($t5):JavaType(class java.lang.Float)], expr#11=[null], expr#12=[CASE($t9, $t10, $t11)], expr#13=[5], deptno=[$t1], empid=[$t0], S=[$t12], FIVE=[$t13], M=[$t6], C=[$t7])\n  EnumerableWindowRel(window#0=[window(partition {1} order by [0] rows between $4 PRECEDING and CURRENT ROW aggs [COUNT($3), $SUM0($3), MIN($2), COUNT()])])\n    EnumerableCalcRel(expr#0..4=[{inputs}], expr#5=[+($t3, $t0)], proj#0..1=[{exprs}], salary=[$t3], $3=[$t5])\n      EnumerableTableAccessRel(table=[[hr, emps]])\n").returnsUnordered("deptno=10; empid=100; S=10100.0; FIVE=5; M=10000.0; C=1", "deptno=10; empid=110; S=21710.0; FIVE=5; M=10000.0; C=2", "deptno=10; empid=150; S=18760.0; FIVE=5; M=7000.0; C=2", "deptno=20; empid=200; S=8200.0; FIVE=5; M=8000.0; C=1").planContains(OptiqPrepareImpl.DEBUG ? "_list.add(new Object[] {\n        row[0],\n        row[1],\n        row[2],\n        row[3],\n        COUNTa0w0,\n        $SUM0a1w0,\n        MINa2w0,\n        COUNTa3w0});" : "_list.add(new Object[] {\n        row[0],\n        row[1],\n        row[2],\n        row[3],\n        a0w0,\n        a1w0,\n        a2w0,\n        a3w0});").planContains("return new Object[] {\n                  current[1],\n                  current[0],\n                  net.hydromatic.optiq.runtime.SqlFunctions.toLong(current[4]) > 0L ? Float.valueOf(net.hydromatic.optiq.runtime.SqlFunctions.toFloat(current[5])) : (Float) null,\n                  5,\n                  current[6],\n                  current[7]};\n");
    }

    @Test
    public void testWinAgg2() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\",\n \"empid\",\nsum(\"salary\" + \"empid\") over w as s,\n 5 as five,\n min(\"salary\") over w as m,\n count(*) over w as c,\n count(*) over w2 as c2,\n count(*) over w11 as c11,\n count(*) over w11dept as c11dept\nfrom \"hr\".\"emps\"\nwindow w as (order by \"empid\" rows 1 preceding),\n w2 as (order by \"empid\" rows 2 preceding),\n w11 as (order by \"empid\" rows between 1 preceding and 1 following),\n w11dept as (partition by \"deptno\" order by \"empid\" rows between 1 preceding and 1 following)").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, S REAL, FIVE INTEGER NOT NULL, M REAL, C BIGINT NOT NULL, C2 BIGINT NOT NULL, C11 BIGINT NOT NULL, C11DEPT BIGINT NOT NULL]").planContains("tempList.size()").returnsUnordered("deptno=20; empid=200; S=15350.0; FIVE=5; M=7000.0; C=2; C2=3; C11=2; C11DEPT=1", "deptno=10; empid=100; S=10100.0; FIVE=5; M=10000.0; C=1; C2=1; C11=2; C11DEPT=2", "deptno=10; empid=110; S=21710.0; FIVE=5; M=10000.0; C=2; C2=2; C11=3; C11DEPT=3", "deptno=10; empid=150; S=18760.0; FIVE=5; M=7000.0; C=2; C2=3; C11=3; C11DEPT=2");
    }

    @Test
    public void testWinAggScalarNonNullPhysType() {
        String planLine = "a0s0w0 = net.hydromatic.optiq.runtime.SqlFunctions.lesser(a0s0w0, net.hydromatic.optiq.runtime.SqlFunctions.toFloat(_rows[j]));";
        if (OptiqPrepareImpl.DEBUG) {
            planLine = planLine.replaceAll("a0s0w0", "MINa0s0w0");
        }
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select min(\"salary\"+1) over w as m\nfrom \"hr\".\"emps\"\nwindow w as (order by \"salary\"+1 rows 1 preceding)\n").typeIs("[M REAL]").planContains(planLine).returnsUnordered("M=7001.0", "M=7001.0", "M=8001.0", "M=10001.0");
    }

    @Test
    public void testWinAggScalarNonNullPhysTypePlusOne() {
        String planLine = "a0s0w0 = net.hydromatic.optiq.runtime.SqlFunctions.lesser(a0s0w0, net.hydromatic.optiq.runtime.SqlFunctions.toFloat(_rows[j]));";
        if (OptiqPrepareImpl.DEBUG) {
            planLine = planLine.replaceAll("a0s0w0", "MINa0s0w0");
        }
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select 1+min(\"salary\"+1) over w as m\nfrom \"hr\".\"emps\"\nwindow w as (order by \"salary\"+1 rows 1 preceding)\n").typeIs("[M REAL]").planContains(planLine).returnsUnordered("M=7002.0", "M=7002.0", "M=8002.0", "M=10002.0");
    }

    @Test
    public void testWinAggRank() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select  \"deptno\",\n \"empid\",\n \"commission\",\n rank() over (partition by \"deptno\" order by \"commission\" desc nulls first) as rcnf,\n rank() over (partition by \"deptno\" order by \"commission\" desc nulls last) as rcnl,\n rank() over (partition by \"deptno\" order by \"empid\") as r,\n rank() over (partition by \"deptno\" order by \"empid\" desc) as rd\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, RCNF INTEGER NOT NULL, RCNL INTEGER NOT NULL, R INTEGER NOT NULL, RD INTEGER NOT NULL]").returnsUnordered("deptno=10; empid=100; commission=1000; RCNF=2; RCNL=1; R=1; RD=3", "deptno=10; empid=110; commission=250; RCNF=3; RCNL=2; R=2; RD=2", "deptno=10; empid=150; commission=null; RCNF=1; RCNL=3; R=3; RD=1", "deptno=20; empid=200; commission=500; RCNF=1; RCNL=1; R=1; RD=1");
    }

    @Test
    public void testWinAggRankValues() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select  \"deptno\",\n rank() over (order by \"deptno\") as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, R INTEGER NOT NULL]").returnsUnordered("deptno=10; R=1", "deptno=10; R=1", "deptno=10; R=1", "deptno=20; R=4");
    }

    @Test
    public void testWinAggRankValuesDesc() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select  \"deptno\",\n rank() over (order by \"deptno\" desc) as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, R INTEGER NOT NULL]").returnsUnordered("deptno=10; R=2", "deptno=10; R=2", "deptno=10; R=2", "deptno=20; R=1");
    }

    @Test
    public void testWinAggDenseRankValues() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select  \"deptno\",\n dense_rank() over (order by \"deptno\") as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, R INTEGER NOT NULL]").returnsUnordered("deptno=10; R=1", "deptno=10; R=1", "deptno=10; R=1", "deptno=20; R=2");
    }

    @Test
    public void testWinAggDenseRankValuesDesc() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select  \"deptno\",\n dense_rank() over (order by \"deptno\" desc) as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, R INTEGER NOT NULL]").returnsUnordered("deptno=10; R=2", "deptno=10; R=2", "deptno=10; R=2", "deptno=20; R=1");
    }

    @Ignore(value="DATE/TIMESTAMP/INTERVAL support is broken:1 year is converted to 12 months instead of milliseconds")
    @Test
    public void testWinIntervalFrame() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select  \"deptno\",\n \"empid\",\n \"hire_date\",\n count(*) over (partition by \"deptno\" order by \"hire_date\" range between interval '1' year preceding and interval '1' year following) as r\nfrom (select \"empid\", \"deptno\",\n  DATE '2014-06-12' + \"empid\"*interval '0' day \"hire_date\"\n  from \"hr\".\"emps\")").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, hire_date DATE NOT NULL, R BIGINT]").returnsUnordered("deptno=10; R=1", "deptno=10; R=1", "deptno=10; R=1", "deptno=20; R=4");
    }

    private void startOfGroupStep1(String startOfGroup) {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select t.*\n  from (\n       select  t.*,\n               case when " + startOfGroup + " then 0 else 1 end start_of_group\n" + "         from " + START_OF_GROUP_DATA + ") t\n").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, START_OF_GROUP INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; START_OF_GROUP=1", "RN=2; VAL=0; EXPECTED=1; START_OF_GROUP=0", "RN=3; VAL=1; EXPECTED=2; START_OF_GROUP=1", "RN=4; VAL=0; EXPECTED=3; START_OF_GROUP=1", "RN=5; VAL=0; EXPECTED=3; START_OF_GROUP=0", "RN=6; VAL=0; EXPECTED=3; START_OF_GROUP=0", "RN=7; VAL=1; EXPECTED=4; START_OF_GROUP=1", "RN=8; VAL=1; EXPECTED=4; START_OF_GROUP=0");
    }

    private void startOfGroupStep2(String startOfGroup) {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select t.*\n       ,sum(start_of_group) over (order by rn rows unbounded preceding) group_id\n  from (\n       select  t.*,\n               case when " + startOfGroup + " then 0 else 1 end start_of_group\n" + "         from " + START_OF_GROUP_DATA + ") t\n").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, START_OF_GROUP INTEGER NOT NULL, GROUP_ID INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; START_OF_GROUP=1; GROUP_ID=1", "RN=2; VAL=0; EXPECTED=1; START_OF_GROUP=0; GROUP_ID=1", "RN=3; VAL=1; EXPECTED=2; START_OF_GROUP=1; GROUP_ID=2", "RN=4; VAL=0; EXPECTED=3; START_OF_GROUP=1; GROUP_ID=3", "RN=5; VAL=0; EXPECTED=3; START_OF_GROUP=0; GROUP_ID=3", "RN=6; VAL=0; EXPECTED=3; START_OF_GROUP=0; GROUP_ID=3", "RN=7; VAL=1; EXPECTED=4; START_OF_GROUP=1; GROUP_ID=4", "RN=8; VAL=1; EXPECTED=4; START_OF_GROUP=0; GROUP_ID=4");
    }

    private void startOfGroupStep3(String startOfGroup) {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select group_id, min(rn) min_rn, max(rn) max_rn, count(rn) cnt_rn, avg(val) avg_val from (\nselect t.*\n       ,sum(start_of_group) over (order by rn rows unbounded preceding) group_id\n  from (\n       select  t.*,\n               case when " + startOfGroup + " then 0 else 1 end start_of_group\n" + "         from " + START_OF_GROUP_DATA + ") t\n" + ") group by group_id\n").typeIs("[GROUP_ID INTEGER NOT NULL, MIN_RN INTEGER NOT NULL, MAX_RN INTEGER NOT NULL, CNT_RN BIGINT NOT NULL, AVG_VAL INTEGER NOT NULL]").returnsUnordered("GROUP_ID=1; MIN_RN=1; MAX_RN=2; CNT_RN=2; AVG_VAL=0", "GROUP_ID=2; MIN_RN=3; MAX_RN=3; CNT_RN=1; AVG_VAL=1", "GROUP_ID=3; MIN_RN=4; MAX_RN=6; CNT_RN=3; AVG_VAL=0", "GROUP_ID=4; MIN_RN=7; MAX_RN=8; CNT_RN=2; AVG_VAL=1");
    }

    @Test
    public void testStartOfGroupLastValueStep1() {
        this.startOfGroupStep1("val = last_value(val) over (order by rn rows between 1 preceding and 1 preceding)");
    }

    @Test
    public void testStartOfGroupLastValueStep2() {
        this.startOfGroupStep2("val = last_value(val) over (order by rn rows between 1 preceding and 1 preceding)");
    }

    @Test
    public void testStartOfGroupLastValueStep3() {
        this.startOfGroupStep3("val = last_value(val) over (order by rn rows between 1 preceding and 1 preceding)");
    }

    @Test
    public void testStartOfGroupLagStep1() {
        this.startOfGroupStep1("val = lag(val) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLagValueStep2() {
        this.startOfGroupStep2("val = lag(val) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLagStep3() {
        this.startOfGroupStep3("val = lag(val) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLeadStep1() {
        this.startOfGroupStep1("val = lead(val, -1) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLeadValueStep2() {
        this.startOfGroupStep2("val = lead(val, -1) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLeadStep3() {
        this.startOfGroupStep3("val = lead(val, -1) over (order by rn)");
    }

    @Test
    public void testLagDefaultValue() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select t.*, lag(rn+expected,1,42) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; L=42", "RN=2; VAL=0; EXPECTED=1; L=2", "RN=3; VAL=1; EXPECTED=2; L=3", "RN=4; VAL=0; EXPECTED=3; L=5", "RN=5; VAL=0; EXPECTED=3; L=7", "RN=6; VAL=0; EXPECTED=3; L=8", "RN=7; VAL=1; EXPECTED=4; L=9", "RN=8; VAL=1; EXPECTED=4; L=11");
    }

    @Test
    public void testLeadDefaultValue() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select t.*, lead(rn+expected,1,42) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; L=3", "RN=2; VAL=0; EXPECTED=1; L=5", "RN=3; VAL=1; EXPECTED=2; L=7", "RN=4; VAL=0; EXPECTED=3; L=8", "RN=5; VAL=0; EXPECTED=3; L=9", "RN=6; VAL=0; EXPECTED=3; L=11", "RN=7; VAL=1; EXPECTED=4; L=12", "RN=8; VAL=1; EXPECTED=4; L=42");
    }

    @Test
    public void testLagExpressionOffset() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select t.*, lag(rn, expected, 42) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; L=42", "RN=2; VAL=0; EXPECTED=1; L=1", "RN=3; VAL=1; EXPECTED=2; L=1", "RN=4; VAL=0; EXPECTED=3; L=1", "RN=5; VAL=0; EXPECTED=3; L=2", "RN=6; VAL=0; EXPECTED=3; L=3", "RN=7; VAL=1; EXPECTED=4; L=3", "RN=8; VAL=1; EXPECTED=4; L=4");
    }

    @Test
    public void testLagInvalidOffsetArgument() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select t.*, lag(rn, DATE '2014-06-20', 42) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").throws_("Cannot apply 'LAG' to arguments of type 'LAG(<INTEGER>, <DATE>, <INTEGER>)'");
    }

    @Test
    public void testNtile1() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select rn, ntile(1) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; L=1", "RN=2; L=1", "RN=3; L=1", "RN=4; L=1", "RN=5; L=1", "RN=6; L=1", "RN=7; L=1", "RN=8; L=1");
    }

    @Test
    public void testNtile2() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select rn, ntile(2) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; L=1", "RN=2; L=1", "RN=3; L=1", "RN=4; L=1", "RN=5; L=2", "RN=6; L=2", "RN=7; L=2", "RN=8; L=2");
    }

    @Ignore(value="Have no idea how to validate that expression is constant")
    @Test
    public void testNtileConstantArgs() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select rn, ntile(1+1) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; L=1", "RN=2; L=1", "RN=3; L=1", "RN=4; L=1", "RN=5; L=2", "RN=6; L=2", "RN=7; L=2", "RN=8; L=2");
    }

    @Test
    public void testNtileNegativeArg() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select rn, ntile(-1) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").throws_("Argument to function 'NTILE' must be a positive integer literal");
    }

    @Test
    public void testNtileDecimalArg() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select rn, ntile(3.141592653) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").throws_("Cannot apply 'NTILE' to arguments of type 'NTILE(<DECIMAL(10, 9)>)'");
    }

    @Test
    public void testWinAggFirstValue() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select  \"deptno\",\n \"empid\",\n \"commission\",\n first_value(\"commission\") over (partition by \"deptno\" order by \"empid\") as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, R INTEGER]").returnsUnordered("deptno=10; empid=100; commission=1000; R=1000", "deptno=10; empid=110; commission=250; R=1000", "deptno=10; empid=150; commission=null; R=1000", "deptno=20; empid=200; commission=500; R=500");
    }

    @Test
    public void testWinAggFirstValueDesc() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select  \"deptno\",\n \"empid\",\n \"commission\",\n first_value(\"commission\") over (partition by \"deptno\" order by \"empid\" desc) as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, R INTEGER]").returnsUnordered("deptno=10; empid=100; commission=1000; R=null", "deptno=10; empid=110; commission=250; R=null", "deptno=10; empid=150; commission=null; R=null", "deptno=20; empid=200; commission=500; R=500");
    }

    @Test
    public void testWinAggFirstValueEmptyWindow() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\",\n \"empid\",\n \"commission\",\n first_value(\"commission\") over (partition by \"deptno\" order by \"empid\" desc range between 1000 preceding and 999 preceding) as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, R INTEGER]").returnsUnordered("deptno=10; empid=100; commission=1000; R=null", "deptno=10; empid=110; commission=250; R=null", "deptno=10; empid=150; commission=null; R=null", "deptno=20; empid=200; commission=500; R=null");
    }

    @Test
    public void testWinRowNumber() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\",\n \"empid\",\n \"commission\",\n row_number() over (partition by \"deptno\" order by \"commission\" desc nulls first) as rcnf,\n row_number() over (partition by \"deptno\" order by \"commission\" desc nulls last) as rcnl,\n row_number() over (partition by \"deptno\" order by \"empid\") as r,\n row_number() over (partition by \"deptno\" order by \"empid\" desc) as rd\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, RCNF INTEGER NOT NULL, RCNL INTEGER NOT NULL, R INTEGER NOT NULL, RD INTEGER NOT NULL]").returnsUnordered("deptno=10; empid=100; commission=1000; RCNF=2; RCNL=1; R=1; RD=3", "deptno=10; empid=110; commission=250; RCNF=3; RCNL=2; R=2; RD=2", "deptno=10; empid=150; commission=null; RCNF=1; RCNL=3; R=3; RD=1", "deptno=20; empid=200; commission=500; RCNF=1; RCNL=1; R=1; RD=1");
    }

    @Test
    public void testOverUnboundedPreceding() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"empid\",\n  \"commission\",\n  count(\"empid\") over (partition by 42\n    order by \"commission\" nulls first\n    rows between UNBOUNDED PRECEDING and current row) as m\nfrom \"hr\".\"emps\"").typeIs("[empid INTEGER NOT NULL, commission INTEGER, M BIGINT NOT NULL]").returnsUnordered("empid=100; commission=1000; M=4", "empid=200; commission=500; M=3", "empid=150; commission=null; M=1", "empid=110; commission=250; M=2");
    }

    @Test
    public void testSumOverUnboundedPreceding() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"empid\",\n  \"commission\",\n  sum(\"empid\") over (partition by 42\n    order by \"commission\" nulls first\n    rows between UNBOUNDED PRECEDING and current row) as m\nfrom \"hr\".\"emps\"").typeIs("[empid INTEGER NOT NULL, commission INTEGER, M INTEGER NOT NULL]").returnsUnordered("empid=100; commission=1000; M=560", "empid=110; commission=250; M=260", "empid=150; commission=null; M=150", "empid=200; commission=500; M=460");
    }

    @Test
    public void testSumOverPossiblyEmptyWindow() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"empid\",\n  \"commission\",\n  sum(\"empid\") over (partition by 42\n    order by \"commission\" nulls first\n    rows between UNBOUNDED PRECEDING and 1 preceding) as m\nfrom \"hr\".\"emps\"").typeIs("[empid INTEGER NOT NULL, commission INTEGER, M INTEGER]").returnsUnordered("empid=100; commission=1000; M=460", "empid=110; commission=250; M=150", "empid=150; commission=null; M=null", "empid=200; commission=500; M=260");
    }

    @Test
    public void testOverNoOrder() {
        this.checkOuter("select *,\n count(*) over (partition by deptno) as m1,\n count(*) over (partition by deptno order by ename) as m2,\n count(*) over () as m3\nfrom emp", "ENAME=Adam ; DEPTNO=50; GENDER=M; M1=2; M2=1; M3=9", "ENAME=Alice; DEPTNO=30; GENDER=F; M1=2; M2=1; M3=9", "ENAME=Bob  ; DEPTNO=10; GENDER=M; M1=2; M2=1; M3=9", "ENAME=Eric ; DEPTNO=20; GENDER=M; M1=1; M2=1; M3=9", "ENAME=Eve  ; DEPTNO=50; GENDER=F; M1=2; M2=2; M3=9", "ENAME=Grace; DEPTNO=60; GENDER=F; M1=1; M2=1; M3=9", "ENAME=Jane ; DEPTNO=10; GENDER=F; M1=2; M2=2; M3=9", "ENAME=Susan; DEPTNO=30; GENDER=F; M1=2; M2=2; M3=9", "ENAME=Wilma; DEPTNO=null; GENDER=F; M1=1; M2=1; M3=9");
    }

    @Test
    public void testTrimFields() throws Exception {
        try {
            Prepare.THREAD_TRIM.set(true);
            OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"name\", count(\"commission\") + 1\nfrom \"hr\".\"emps\"\ngroup by \"deptno\", \"name\"").convertContains("ProjectRel(name=[$1], EXPR$1=[+($2, 1)])\n  AggregateRel(group=[{0, 1}], agg#0=[COUNT($2)])\n    ProjectRel(deptno=[$1], name=[$2], commission=[$4])\n      EnumerableTableAccessRel(table=[[hr, emps]])\n");
        }
        finally {
            Prepare.THREAD_TRIM.set(false);
        }
    }

    @Test
    public void testTrimFieldsOver() throws Exception {
        try {
            Prepare.THREAD_TRIM.set(true);
            OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"name\", count(\"commission\") over (partition by \"deptno\") + 1\nfrom \"hr\".\"emps\"\nwhere \"empid\" > 10").convertContains("ProjectRel(name=[$2], EXPR$1=[+(COUNT($3) OVER (PARTITION BY $1 RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING), 1)])\n  FilterRel(condition=[>($0, 10)])\n    ProjectRel(empid=[$0], deptno=[$1], name=[$2], commission=[$4])\n      EnumerableTableAccessRel(table=[[hr, emps]])\n");
        }
        finally {
            Prepare.THREAD_TRIM.set(false);
        }
    }

    @Test
    public void testWinAggConstant() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select max(1) over (partition by \"deptno\"\n  order by \"empid\") as m\nfrom \"hr\".\"emps\"").returnsUnordered("M=1", "M=1", "M=1", "M=1");
    }

    @Test
    public void testWinAggConstantMultipleConstants() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\", sum(1) over (partition by \"deptno\"\n  order by \"empid\" rows between unbounded preceding and current row) as a,\n sum(-1) over (partition by \"deptno\"\n  order by \"empid\" rows between unbounded preceding and current row) as b\nfrom \"hr\".\"emps\"").returnsUnordered("deptno=10; A=1; B=-1", "deptno=10; A=2; B=-2", "deptno=10; A=3; B=-3", "deptno=20; A=1; B=-1");
    }

    @Test
    public void testWinAggPartitionByConstant() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select max(\"empid\"*0) over (partition by 42\n  order by \"empid\") as m\nfrom \"hr\".\"emps\"").returnsUnordered("M=0", "M=0", "M=0", "M=0");
    }

    @Test
    public void testWinAggOrderByConstant() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select max(\"empid\"*0) over (partition by \"deptno\"\n  order by 42) as m\nfrom \"hr\".\"emps\"").returnsUnordered("M=0", "M=0", "M=0", "M=0");
    }

    @Test
    public void testWhereNullable() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nwhere \"commission\" > 800").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testLike() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nwhere \"name\" like '%i__'").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\n");
    }

    @Test
    public void testArrayIndexing() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"deptno\", \"employees\"[1] as e from \"hr\".\"depts\"\n").returns("deptno=10; E=Employee [empid: 100, deptno: 10, name: Bill]\ndeptno=30; E=null\ndeptno=40; E=Employee [empid: 200, deptno: 20, name: Eric]\n");
    }

    @Test
    public void testVarcharEquals() {
        OptiqAssert.that().withModel(FOODMART_MODEL).query("select \"lname\" from \"customer\" where \"lname\" = 'Nowmer'").returns("lname=Nowmer\n");
        OptiqAssert.that().withModel(FOODMART_MODEL).query("select count(*) as c from \"customer\" where \"lname\" = 'this string is longer than 30 characters'").returns("C=0\n");
        OptiqAssert.that().withModel(FOODMART_MODEL).query("select count(*) as c from \"customer\" where cast(\"customer_id\" as char(20)) = 'this string is longer than 30 characters'").returns("C=0\n");
    }

    @Test
    public void testNotIn() {
        this.predicate("\"name\" not in ('a', 'b') or \"name\" is null").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=200; deptno=20; name=Eric; salary=8000.0; commission=500\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n");
        this.predicate("\"name\" in ('a', 'b') or \"name\" is null");
        this.predicate("\"name\" in ('a', 'b', null) or \"name\" is null");
        this.predicate("\"name\" in ('a', 'b') or \"name\" is not null");
        this.predicate("\"name\" in ('a', 'b', null) or \"name\" is not null");
        this.predicate("\"name\" not in ('a', 'b', null) or \"name\" is not null");
        this.predicate("\"name\" not in ('a', 'b', null) and \"name\" is not null");
    }

    @Test
    public void testNotInEmptyQuery() {
        this.checkOuter("select deptno from emp where deptno not in (\nselect deptno from dept where deptno = -1)", "DEPTNO=10", "DEPTNO=10", "DEPTNO=20", "DEPTNO=30", "DEPTNO=30", "DEPTNO=50", "DEPTNO=50", "DEPTNO=60");
    }

    @Test
    public void testNotInQuery() {
        this.checkOuter("select deptno from emp where deptno not in (\nselect deptno from dept)", "DEPTNO=50", "DEPTNO=50", "DEPTNO=60");
    }

    @Test
    public void testNotInQueryWithNull() {
        this.checkOuter("select deptno from emp where deptno not in (\nselect deptno from emp)", new String[0]);
    }

    @Test
    public void testTrim() {
        OptiqAssert.that().withModel(FOODMART_MODEL).query("select trim(\"lname\") as \"lname\" from \"customer\" where \"lname\" = 'Nowmer'").returns("lname=Nowmer\n");
        OptiqAssert.that().withModel(FOODMART_MODEL).query("select trim(leading 'N' from \"lname\") as \"lname\" from \"customer\" where \"lname\" = 'Nowmer'").returns("lname=owmer\n");
    }

    private OptiqAssert.AssertQuery predicate(String foo) {
        return OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nwhere " + foo).runs();
    }

    @Test
    public void testExistsCorrelated() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select*from \"hr\".\"emps\" where exists (\n select 1 from \"hr\".\"depts\"\n where \"emps\".\"deptno\"=\"depts\".\"deptno\")").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000", "empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250");
    }

    @Test
    public void testScalarSubQuery() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"empid\", \"deptno\",\n (select \"name\" from \"hr\".\"depts\"\n  where \"deptno\" = e.\"deptno\") as dname\nfrom \"hr\".\"emps\" as e").returnsUnordered("empid=100; deptno=10; DNAME=Sales", "empid=110; deptno=10; DNAME=Sales", "empid=150; deptno=10; DNAME=Sales", "empid=200; deptno=20; DNAME=null");
    }

    @Test
    public void testLeftJoin() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select e.\"deptno\", d.\"deptno\"\nfrom \"hr\".\"emps\" as e\n  left join \"hr\".\"depts\" as d using (\"deptno\")").returnsUnordered("deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=20; deptno=null");
    }

    @Test
    public void testFullJoin() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select e.\"deptno\", d.\"deptno\"\nfrom \"hr\".\"emps\" as e\n  full join \"hr\".\"depts\" as d using (\"deptno\")").returnsUnordered("deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=20; deptno=null", "deptno=null; deptno=30", "deptno=null; deptno=40");
    }

    @Test
    public void testRightJoin() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select e.\"deptno\", d.\"deptno\"\nfrom \"hr\".\"emps\" as e\n  right join \"hr\".\"depts\" as d using (\"deptno\")").returnsUnordered("deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=null; deptno=30", "deptno=null; deptno=40");
    }

    @Test
    public void testVariousOuter() {
        this.checkOuter("select * from emp join dept on emp.deptno = dept.deptno", "ENAME=Alice; DEPTNO=30; GENDER=F; DEPTNO0=30; DNAME=Engineering", "ENAME=Bob  ; DEPTNO=10; GENDER=M; DEPTNO0=10; DNAME=Sales      ", "ENAME=Eric ; DEPTNO=20; GENDER=M; DEPTNO0=20; DNAME=Marketing  ", "ENAME=Jane ; DEPTNO=10; GENDER=F; DEPTNO0=10; DNAME=Sales      ", "ENAME=Susan; DEPTNO=30; GENDER=F; DEPTNO0=30; DNAME=Engineering");
    }

    private void checkOuter(String sql, String ... lines) {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("with\n  emp(ename, deptno, gender) as (values\n    ('Jane', 10, 'F'),\n    ('Bob', 10, 'M'),\n    ('Eric', 20, 'M'),\n    ('Susan', 30, 'F'),\n    ('Alice', 30, 'F'),\n    ('Adam', 50, 'M'),\n    ('Eve', 50, 'F'),\n    ('Grace', 60, 'F'),\n    ('Wilma', cast(null as integer), 'F')),\n  dept(deptno, dname) as (values\n    (10, 'Sales'),\n    (20, 'Marketing'),\n    (30, 'Engineering'),\n    (40, 'Empty'))\n" + sql).returnsUnordered(lines);
    }

    @Test
    public void testRunAgg() throws Exception {
        this.checkRun("sql/agg.oq");
    }

    @Test
    public void testRunOuter() throws Exception {
        this.checkRun("sql/outer.oq");
    }

    @Test
    public void testRunWinAgg() throws Exception {
        this.checkRun("sql/winagg.oq");
    }

    @Test
    public void testRunMisc() throws Exception {
        this.checkRun("sql/misc.oq");
    }

    private void checkRun(String path) throws Exception {
        URL inUrl = JdbcTest.class.getResource("/" + path);
        String x = inUrl.getFile();
        assert (x.endsWith(path));
        x = x.substring(0, x.length() - path.length());
        assert (x.endsWith("/test-classes/"));
        x = x.substring(0, x.length() - "/test-classes/".length());
        File base = new File(x);
        File inFile = new File(base, "/test-classes/" + path);
        File outFile = new File(base, "/surefire/" + path);
        outFile.getParentFile().mkdirs();
        FileReader fileReader = new FileReader(inFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        FileWriter writer = new FileWriter(outFile);
        SqlRun sqlRun = new SqlRun(bufferedReader, (Writer)writer);
        sqlRun.execute(new SqlRun.ConnectionFactory(){

            public Connection connect(String name) throws Exception {
                if (name.equals("hr")) {
                    return OptiqAssert.that().with(OptiqAssert.Config.REGULAR).connect();
                }
                if (name.equals("foodmart")) {
                    return OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE).connect();
                }
                if (name.equals("post")) {
                    return OptiqAssert.that().with(OptiqAssert.Config.REGULAR).withSchema("POST").connect();
                }
                throw new RuntimeException("unknown connection '" + name + "'");
            }
        });
        String diff = DiffTestCase.diff(inFile, outFile);
        if (!diff.isEmpty()) {
            Assert.fail((String)("Files differ: " + outFile + " " + inFile + "\n" + diff));
        }
    }

    @Test
    public void testScalarSubQueryUncorrelated() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select \"empid\", \"deptno\",\n (select \"name\" from \"hr\".\"depts\"\n  where \"deptno\" = 30) as dname\nfrom \"hr\".\"emps\" as e").returnsUnordered("empid=100; deptno=10; DNAME=Marketing", "empid=110; deptno=10; DNAME=Marketing", "empid=150; deptno=10; DNAME=Marketing", "empid=200; deptno=20; DNAME=Marketing");
    }

    @Test
    public void testScalarSubQueryInCase() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select e.\"name\",\n (CASE e.\"deptno\"\n  WHEN (Select \"deptno\" from \"hr\".\"depts\" d\n        where d.\"deptno\" = e.\"deptno\")\n  THEN (Select d.\"name\" from \"hr\".\"depts\" d\n        where d.\"deptno\" = e.\"deptno\")\n  ELSE 'DepartmentNotFound'  END) AS DEPTNAME\nfrom \"hr\".\"emps\" e").returnsUnordered("name=Bill; DEPTNAME=Sales", "name=Eric; DEPTNAME=DepartmentNotFound", "name=Sebastian; DEPTNAME=Sales", "name=Theodore; DEPTNAME=Sales");
    }

    @Test
    public void testScalarSubQueryInCase2() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).query("select e.\"name\",\n (CASE WHEN e.\"deptno\" = (\n    Select \"deptno\" from \"hr\".\"depts\" d\n    where d.\"name\" = 'Sales')\n  THEN 'Sales'\n  ELSE 'Not Matched'  END) AS DEPTNAME\nfrom \"hr\".\"emps\" e").returnsUnordered("name=Bill; DEPTNAME=Sales      ", "name=Eric; DEPTNAME=Not Matched", "name=Sebastian; DEPTNAME=Sales      ", "name=Theodore; DEPTNAME=Sales      ");
    }

    @Test
    public void testMetaTables() {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR_PLUS_METADATA).query("select * from \"metadata\".TABLES").returns(OptiqAssert.checkResultContains("tableSchem=metadata; tableName=COLUMNS; tableType=SYSTEM_TABLE; "));
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR_PLUS_METADATA).query("select count(distinct \"tableSchem\") as c\nfrom \"metadata\".TABLES").returns("C=3\n");
    }

    @Test
    public void testSetMaxRows() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection a0) {
                try {
                    Statement statement = a0.createStatement();
                    try {
                        statement.setMaxRows(-1);
                        Assert.fail((String)"expected error");
                    }
                    catch (SQLException e) {
                        Assert.assertEquals((Object)e.getMessage(), (Object)"illegal maxRows value: -1");
                    }
                    statement.setMaxRows(2);
                    Assert.assertEquals((long)2L, (long)statement.getMaxRows());
                    ResultSet resultSet = statement.executeQuery("select * from \"hr\".\"emps\"");
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertFalse((boolean)resultSet.next());
                    resultSet.close();
                    statement.close();
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testPreparedStatement() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection connection) {
                try {
                    PreparedStatement preparedStatement = connection.prepareStatement("select \"deptno\", \"name\" from \"hr\".\"emps\"\nwhere \"deptno\" < ? and \"name\" like ?");
                    ResultSet resultSet = preparedStatement.executeQuery();
                    Assert.assertFalse((boolean)resultSet.next());
                    preparedStatement.setInt(1, 15);
                    preparedStatement.setString(2, "%");
                    resultSet = preparedStatement.executeQuery();
                    Assert.assertEquals((Object)"deptno=10; name=Bill\ndeptno=10; name=Sebastian\ndeptno=10; name=Theodore\n", (Object)OptiqAssert.toString(resultSet));
                    preparedStatement.setString(2, "%r%");
                    resultSet = preparedStatement.executeQuery();
                    Assert.assertEquals((Object)"deptno=10; name=Theodore\n", (Object)OptiqAssert.toString(resultSet));
                    resultSet.close();
                    preparedStatement.close();
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testModel() {
        OptiqAssert.that().withModel(FOODMART_MODEL).query("select count(*) as c from \"foodmart\".\"time_by_day\"").returns("C=730\n");
    }

    @Test
    public void testModelWithComment() {
        String model = FOODMART_MODEL.replace("schemas:", "/* comment */ schemas:");
        Assert.assertThat((Object)model, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)FOODMART_MODEL)));
        OptiqAssert.that().withModel(model).query("select count(*) as c from \"foodmart\".\"time_by_day\"").returns("C=730\n");
    }

    @Ignore(value="until JdbcSchema can define materialized views")
    @Test
    public void testModelWithMaterializedView() {
        OptiqAssert.that().withModel(FOODMART_MODEL).enable(false).query("select count(*) as c from \"foodmart\".\"sales_fact_1997\" join \"foodmart\".\"time_by_day\" using (\"time_id\")").returns("C=86837\n");
        OptiqAssert.that().withMaterializations(FOODMART_MODEL, "agg_c_10_sales_fact_1997", "select t.`month_of_year`, t.`quarter`, t.`the_year`, sum(s.`store_sales`) as `store_sales`, sum(s.`store_cost`), sum(s.`unit_sales`), count(distinct s.`customer_id`), count(*) as `fact_count` from `time_by_day` as t join `sales_fact_1997` as s using (`time_id`) group by t.`month_of_year`, t.`quarter`, t.`the_year`").query("select t.\"month_of_year\", t.\"quarter\", t.\"the_year\", sum(s.\"store_sales\") as \"store_sales\", sum(s.\"store_cost\"), sum(s.\"unit_sales\"), count(distinct s.\"customer_id\"), count(*) as \"fact_count\" from \"time_by_day\" as t join \"sales_fact_1997\" as s using (\"time_id\") group by t.\"month_of_year\", t.\"quarter\", t.\"the_year\"").explainContains("JdbcTableScan(table=[[foodmart, agg_c_10_sales_fact_1997]])").enableMaterializations(false).explainContains("JdbcTableScan(table=[[foodmart, sales_fact_1997]])").sameResultWithMaterializationsDisabled();
    }

    @Test
    public void testModelCustomTable() {
        OptiqAssert.that().withModel("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + EmpDeptTableFactory.class.getName() + "',\n" + "           operand: {'foo': 1, 'bar': [345, 357] }\n" + "         }\n" + "       ]\n" + "     }\n" + "   ]\n" + "}").query("select * from \"adhoc\".EMPLOYEES where \"deptno\" = 10").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n");
    }

    @Test
    public void testModelCustomTable2() {
        OptiqAssert.that().withModel("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'MATH',\n       tables: [\n         {\n           name: 'INTEGERS',\n           type: 'custom',\n           factory: '" + RangeTable.Factory.class.getName() + "',\n" + "           operand: {'column': 'N', 'start': 3, 'end': 7 }\n" + "         }\n" + "       ]\n" + "     }\n" + "   ]\n" + "}").query("select * from math.integers").returns("N=3\nN=4\nN=5\nN=6\n");
    }

    @Test
    public void testModelCustomSchema() throws Exception {
        OptiqAssert.AssertThat that = OptiqAssert.that().withModel("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [\n    {\n      name: 'empty'\n    },\n    {\n      name: 'adhoc',\n      type: 'custom',\n      factory: '" + MySchemaFactory.class.getName() + "',\n" + "      operand: {'tableName': 'ELVIS'}\n" + "    }\n" + "  ]\n" + "}");
        that.doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection connection) {
                try {
                    Assert.assertEquals((Object)"adhoc", (Object)connection.getSchema());
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        that.query("select * from \"adhoc\".ELVIS where \"deptno\" = 10").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n");
        that.query("select * from \"adhoc\".EMPLOYEES").throws_("Table 'adhoc.EMPLOYEES' not found");
    }

    @Test
    public void testModelImmutableSchemaCannotContainView() throws Exception {
        OptiqAssert.AssertThat that = OptiqAssert.that().withModel("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [\n    {\n      name: 'empty'\n    },\n    {\n      name: 'adhoc',\n      type: 'custom',\n      tables: [\n        {\n          name: 'v',\n          type: 'view',\n          sql: 'values (1)'\n        }\n      ],\n      factory: '" + MySchemaFactory.class.getName() + "',\n" + "      operand: {\n" + "           'tableName': 'ELVIS',\n" + "           'mutable': false\n" + "      }\n" + "    }\n" + "  ]\n" + "}");
        that.connectThrows("Cannot define view; parent schema 'adhoc' is not mutable");
    }

    private OptiqAssert.AssertThat modelWithView(String view) {
        Class<EmpDeptTableFactory> clazz = EmpDeptTableFactory.class;
        return OptiqAssert.that().withModel("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + clazz.getName() + "',\n" + "           operand: {'foo': true, 'bar': 345}\n" + "         },\n" + "         {\n" + "           name: 'V',\n" + "           type: 'view',\n" + "           sql: '" + view + "'\n" + "         }\n" + "       ]\n" + "     }\n" + "   ]\n" + "}");
    }

    @Test
    public void testModelView() throws Exception {
        OptiqAssert.AssertThat with = this.modelWithView("select * from \"EMPLOYEES\" where \"deptno\" = 10");
        with.query("select * from \"adhoc\".V order by \"name\" desc").returns("empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
        with.doWithConnection(new Function1<OptiqConnection, Void>(){

            public Void apply(OptiqConnection a0) {
                try {
                    DatabaseMetaData metaData = a0.getMetaData();
                    Assert.assertEquals((Object)"TABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=EMPLOYEES; TABLE_TYPE=TABLE; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; TABLE_TYPE=VIEW; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\n", (Object)OptiqAssert.toString(metaData.getTables(null, "adhoc", null, null)));
                    Assert.assertEquals((Object)"TABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; TABLE_TYPE=VIEW; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\n", (Object)OptiqAssert.toString(metaData.getTables(null, "adhoc", null, new String[]{Schema.TableType.VIEW.name()})));
                    Assert.assertEquals((Object)"TABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=empid; DATA_TYPE=4; TYPE_NAME=JavaType(int) NOT NULL; COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=0; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=1; IS_NULLABLE=NO; SCOPE_CATALOG=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=null; IS_GENERATEDCOLUMN=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=deptno; DATA_TYPE=4; TYPE_NAME=JavaType(int) NOT NULL; COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=0; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=2; IS_NULLABLE=NO; SCOPE_CATALOG=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=null; IS_GENERATEDCOLUMN=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=name; DATA_TYPE=12; TYPE_NAME=JavaType(class java.lang.String); COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=1; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=3; IS_NULLABLE=YES; SCOPE_CATALOG=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=null; IS_GENERATEDCOLUMN=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=salary; DATA_TYPE=7; TYPE_NAME=JavaType(float) NOT NULL; COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=0; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=4; IS_NULLABLE=NO; SCOPE_CATALOG=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=null; IS_GENERATEDCOLUMN=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=commission; DATA_TYPE=4; TYPE_NAME=JavaType(class java.lang.Integer); COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=1; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=5; IS_NULLABLE=YES; SCOPE_CATALOG=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=null; IS_GENERATEDCOLUMN=null\n", (Object)OptiqAssert.toString(metaData.getColumns(null, "adhoc", "V", null)));
                    Assert.assertEquals((Object)"TABLE_CATALOG=null\n", (Object)OptiqAssert.toString(metaData.getCatalogs()));
                    Assert.assertEquals((Object)"TABLE_SCHEM=adhoc; TABLE_CATALOG=null\nTABLE_SCHEM=metadata; TABLE_CATALOG=null\n", (Object)OptiqAssert.toString(metaData.getSchemas()));
                    Assert.assertEquals((Object)"TABLE_SCHEM=adhoc; TABLE_CATALOG=null\n", (Object)OptiqAssert.toString(metaData.getSchemas(null, "adhoc")));
                    Assert.assertEquals((Object)"TABLE_TYPE=TABLE\nTABLE_TYPE=VIEW\n", (Object)OptiqAssert.toString(metaData.getTableTypes()));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testOrderByView() throws Exception {
        OptiqAssert.AssertThat with = this.modelWithView("select * from \"EMPLOYEES\" where \"deptno\" = 10 order by \"empid\" limit 2");
        with.query("select \"name\" from \"adhoc\".V order by \"name\"").returns("name=Bill\nname=Theodore\n");
        with.query("select \"name\" from (\nselect * from \"adhoc\".\"EMPLOYEES\" where \"deptno\" = 10\norder by \"empid\" limit 2)\norder by \"name\"").returns("name=Bill\nname=Theodore\n");
    }

    @Test
    public void testAutomaticTemporaryTable() throws Exception {
        final ArrayList objects = new ArrayList();
        OptiqAssert.that().with(new OptiqAssert.ConnectionFactory(){

            public OptiqConnection createConnection() throws Exception {
                OptiqConnection connection = (OptiqConnection)new AutoTempDriver(objects).connect("jdbc:optiq:", new Properties());
                SchemaPlus rootSchema = connection.getRootSchema();
                rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
                connection.setSchema("hr");
                return connection;
            }
        }).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection a0) {
                try {
                    a0.createStatement().executeQuery("select * from \"hr\".\"emps\" where \"deptno\" = 10");
                    Assert.assertEquals((long)1L, (long)objects.size());
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private OptiqAssert.AssertThat withUdf() {
        return OptiqAssert.that().withModel("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + EmpDeptTableFactory.class.getName() + "',\n" + "           operand: {'foo': true, 'bar': 345}\n" + "         }\n" + "       ],\n" + "       functions: [\n" + "         {\n" + "           name: 'MY_PLUS',\n" + "           className: '" + MyPlusFunction.class.getName() + "'\n" + "         },\n" + "         {\n" + "           name: 'MY_STR',\n" + "           className: '" + MyToStringFunction.class.getName() + "'\n" + "         },\n" + "         {\n" + "           name: 'MY_DOUBLE',\n" + "           className: '" + MyDoubleFunction.class.getName() + "'\n" + "         },\n" + "         {\n" + "           name: 'COUNT_ARGS',\n" + "           className: '" + CountArgs0Function.class.getName() + "'\n" + "         },\n" + "         {\n" + "           name: 'COUNT_ARGS',\n" + "           className: '" + CountArgs1Function.class.getName() + "'\n" + "         },\n" + "         {\n" + "           name: 'COUNT_ARGS',\n" + "           className: '" + CountArgs2Function.class.getName() + "'\n" + "         }\n" + "       ]\n" + "     }\n" + "   ]\n" + "}");
    }

    @Test
    public void testUserDefinedFunction() throws Exception {
        OptiqAssert.AssertThat with = this.withUdf();
        with.query("select \"adhoc\".my_plus(\"deptno\", 100) as p from \"adhoc\".EMPLOYEES").returns("P=110\nP=120\nP=110\nP=110\n");
        with.query("select \"adhoc\".my_double(\"deptno\") as p from \"adhoc\".EMPLOYEES").returns("P=20\nP=40\nP=20\nP=20\n");
    }

    @Test
    public void testNotNullImplementor() {
        OptiqAssert.AssertThat with = this.withUdf();
        with.query("select upper(\"adhoc\".my_str(\"name\")) as p from \"adhoc\".EMPLOYEES").returns("P=<BILL>\nP=<ERIC>\nP=<SEBASTIAN>\nP=<THEODORE>\n");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(\"name\") is not null").returns("P=Bill\nP=Eric\nP=Sebastian\nP=Theodore\n");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(upper(\"name\")) is not null").returns("P=Bill\nP=Eric\nP=Sebastian\nP=Theodore\n");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere upper(\"adhoc\".my_str(\"name\")) is not null").returns("P=Bill\nP=Eric\nP=Sebastian\nP=Theodore\n");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(\"name\") is null").returns("");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(upper(\"adhoc\".my_str(\"name\"))) ='8'").returns("");
    }

    @Test
    public void testUdfDerivedReturnType() {
        OptiqAssert.AssertThat with = this.withUdf();
        with.query("select max(\"adhoc\".my_double(\"deptno\")) as p from \"adhoc\".EMPLOYEES").returns("P=40\n");
        with.query("select max(\"adhoc\".my_str(\"name\")) as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(\"name\") is null").returns("P=null\n");
    }

    @Test
    public void testUdfOverloaded() {
        OptiqAssert.AssertThat with = this.withUdf();
        with.query("values (\"adhoc\".count_args(),\n \"adhoc\".count_args(0),\n \"adhoc\".count_args(0, 0))").returns("EXPR$0=0; EXPR$1=1; EXPR$2=2\n");
        with.query("select max(\"adhoc\".count_args()) as p0,\n min(\"adhoc\".count_args(0)) as p1,\n max(\"adhoc\".count_args(0, 0)) as p2\nfrom \"adhoc\".EMPLOYEES limit 1").returns("P0=0; P1=1; P2=2\n");
    }

    @Test
    public void testUserDefinedFunction2() throws Exception {
        JdbcTest.withBadUdf(AwkwardFunction.class).connectThrows("Declaring class 'net.hydromatic.optiq.test.JdbcTest$AwkwardFunction' of non-static user-defined function must have a public constructor with zero parameters");
    }

    @Test
    public void testUserDefinedAggregateFunction() throws Exception {
        String empDept = EmpDeptTableFactory.class.getName();
        String sum = MyStaticSumFunction.class.getName();
        String sum2 = MySumFunction.class.getName();
        OptiqAssert.AssertThat with = OptiqAssert.that().withModel("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + empDept + "',\n" + "           operand: {'foo': true, 'bar': 345}\n" + "         }\n" + "       ],\n" + "       functions: [\n" + "         {\n" + "           name: 'MY_SUM',\n" + "           className: '" + sum + "'\n" + "         },\n" + "         {\n" + "           name: 'MY_SUM2',\n" + "           className: '" + sum2 + "'\n" + "         }\n" + "       ]\n" + "     }\n" + "   ]\n" + "}").withSchema("adhoc");
        with.withSchema(null).query("select \"adhoc\".my_sum(\"deptno\") as p from \"adhoc\".EMPLOYEES\n").returns("P=50\n");
        with.query("select my_sum(\"empid\"), \"deptno\" as p from EMPLOYEES\n").throws_("Expression 'deptno' is not being grouped");
        with.query("select my_sum(\"deptno\") as p from EMPLOYEES\n").returns("P=50\n");
        with.query("select my_sum(\"name\") as p from EMPLOYEES\n").throws_("Cannot apply 'MY_SUM' to arguments of type 'MY_SUM(<JAVATYPE(CLASS JAVA.LANG.STRING)>)'. Supported form(s): 'MY_SUM(<NUMERIC>)");
        with.query("select my_sum(\"deptno\", 1) as p from EMPLOYEES\n").throws_("No match found for function signature MY_SUM(<NUMERIC>, <NUMERIC>)");
        with.query("select my_sum() as p from EMPLOYEES\n").throws_("No match found for function signature MY_SUM()");
        with.query("select \"deptno\", my_sum(\"deptno\") as p from EMPLOYEES\ngroup by \"deptno\"").returnsUnordered("deptno=20; P=20", "deptno=10; P=30");
        with.query("select \"deptno\", my_sum2(\"deptno\") as p from EMPLOYEES\ngroup by \"deptno\"").returnsUnordered("deptno=20; P=20", "deptno=10; P=30");
    }

    @Test
    public void testUserDefinedAggregateFunction3() throws Exception {
        JdbcTest.withBadUdf(SumFunctionBadIAdd.class).connectThrows("Caused by: java.lang.RuntimeException: In user-defined aggregate class 'net.hydromatic.optiq.test.JdbcTest$SumFunctionBadIAdd', first parameter to 'add' method must be the accumulator (the return type of the 'init' method)");
    }

    private static OptiqAssert.AssertThat withBadUdf(Class clazz) {
        String empDept = EmpDeptTableFactory.class.getName();
        String className = clazz.getName();
        return OptiqAssert.that().withModel("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + empDept + "',\n" + "           operand: {'foo': true, 'bar': 345}\n" + "         }\n" + "       ],\n" + "       functions: [\n" + "         {\n" + "           name: 'AWKWARD',\n" + "           className: '" + className + "'\n" + "         }\n" + "       ]\n" + "     }\n" + "   ]\n" + "}").withSchema("adhoc");
    }

    @Test
    public void testPath() throws Exception {
        String name = MyPlusFunction.class.getName();
        OptiqAssert.AssertThat with = OptiqAssert.that().withModel("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       functions: [\n         {\n           name: 'MY_PLUS',\n           className: '" + name + "'\n" + "         }\n" + "       ]\n" + "     },\n" + "     {\n" + "       name: 'adhoc2',\n" + "       functions: [\n" + "         {\n" + "           name: 'MY_PLUS2',\n" + "           className: '" + name + "'\n" + "         }\n" + "       ]\n" + "     },\n" + "     {\n" + "       name: 'adhoc3',\n" + "       path: ['adhoc2','adhoc3'],\n" + "       functions: [\n" + "         {\n" + "           name: 'MY_PLUS3',\n" + "           className: '" + name + "'\n" + "         }\n" + "       ]\n" + "     }\n" + "   ]\n" + "}");
        String err = "No match found for function signature";
        String res = "EXPR$0=2\n";
        OptiqAssert.AssertThat adhoc = with.withSchema("adhoc");
        adhoc.query("values MY_PLUS(1, 1)").returns("EXPR$0=2\n");
        adhoc.query("values MY_PLUS2(1, 1)").throws_("No match found for function signature");
        adhoc.query("values \"adhoc2\".MY_PLUS(1, 1)").throws_("No match found for function signature");
        adhoc.query("values \"adhoc2\".MY_PLUS2(1, 1)").returns("EXPR$0=2\n");
        OptiqAssert.AssertThat adhoc2 = with.withSchema("adhoc2");
        adhoc2.query("values MY_PLUS2(1, 1)").returns("EXPR$0=2\n");
        adhoc2.query("values MY_PLUS(1, 1)").throws_("No match found for function signature");
        adhoc2.query("values \"adhoc\".MY_PLUS(1, 1)").returns("EXPR$0=2\n");
        OptiqAssert.AssertThat adhoc3 = with.withSchema("adhoc3");
        adhoc3.query("values MY_PLUS2(1, 1)").returns("EXPR$0=2\n");
        adhoc3.query("values MY_PLUS(1, 1)").throws_("No match found for function signature");
        adhoc3.query("values \"adhoc\".MY_PLUS(1, 1)").returns("EXPR$0=2\n");
    }

    @Test
    public void testExplain() {
        OptiqAssert.AssertThat with = OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE);
        with.query("explain plan for values (1, 'ab')").returns("PLAN=EnumerableValuesRel(tuples=[[{ 1, 'ab' }]])\n\n");
        with.query("explain plan with implementation for values (1, 'ab')").returns("PLAN=EnumerableValuesRel(tuples=[[{ 1, 'ab' }]])\n\n");
        with.query("explain plan without implementation for values (1, 'ab')").returns("PLAN=ValuesRel(tuples=[[{ 1, 'ab' }]])\n\n");
        with.query("explain plan with type for values (1, 'ab')").returns("PLAN=EXPR$0 INTEGER NOT NULL,\nEXPR$1 CHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL\n");
    }

    @Test
    public void testDifferentTypesSameFields() throws Exception {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        rootSchema.add("TEST", (Schema)new ReflectiveSchema((Object)new MySchema()));
        Statement statement = optiqConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT \"myvalue\" from TEST.\"mytable2\"");
        Assert.assertEquals((Object)"myvalue=2\n", (Object)OptiqAssert.toString(resultSet));
        resultSet.close();
        statement.close();
        connection.close();
    }

    @Test
    public void testCurrentTimestamp() throws Exception {
        OptiqAssert.that().with((Map<String, String>)ImmutableMap.of((Object)"timezone", (Object)"GMT+1:00")).doWithConnection(new Function1<OptiqConnection, Void>(){

            public Void apply(OptiqConnection connection) {
                try {
                    PreparedStatement statement = connection.prepareStatement("VALUES CURRENT_TIMESTAMP");
                    ResultSet resultSet = statement.executeQuery();
                    Assert.assertTrue((boolean)resultSet.next());
                    String s0 = resultSet.getString(1);
                    Assert.assertFalse((boolean)resultSet.next());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    resultSet = statement.executeQuery();
                    Assert.assertTrue((boolean)resultSet.next());
                    String s1 = resultSet.getString(1);
                    Assert.assertFalse((boolean)resultSet.next());
                    Assert.assertTrue((String)("\ns0=" + s0 + "\n" + "s1=" + s1 + "\n"), (s0.compareTo(s1) < 0 ? 1 : 0) != 0);
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testGetTimestamp() throws Exception {
        OptiqAssert.that().with((Map<String, String>)ImmutableMap.of((Object)"timezone", (Object)"GMT+1:00")).doWithConnection(new Function1<OptiqConnection, Void>(){

            public Void apply(OptiqConnection connection) {
                try {
                    JdbcTest.this.checkGetTimestamp((Connection)connection);
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void checkGetTimestamp(Connection con) throws SQLException {
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery("SELECT * FROM (VALUES(\n TIMESTAMP '1970-01-01 00:00:00',\n /* TIMESTAMP '2005-01-01 15:00:00 +0300', */\n TIMESTAMP '2005-01-01 15:00:00',\n TIME '15:00:00',\n /* TIME '15:00:00 +0300', */\n DATE '2005-01-01'\n)) AS t(ts0, /* tstz, */ ts, t, /* tz, */ d)");
        Assert.assertTrue((boolean)rs.next());
        TimeZone tzUtc = TimeZone.getTimeZone("UTC");
        TimeZone tzGmt03 = TimeZone.getTimeZone("GMT+03");
        TimeZone tzGmt05 = TimeZone.getTimeZone("GMT-05");
        TimeZone tzGmt13 = TimeZone.getTimeZone("GMT+13");
        Calendar cUtc = Calendar.getInstance(tzUtc);
        Calendar cGmt03 = Calendar.getInstance(tzGmt03);
        Calendar cGmt05 = Calendar.getInstance(tzGmt05);
        Calendar cGmt13 = Calendar.getInstance(tzGmt13);
        int c = 1;
        Timestamp ts = rs.getTimestamp(c);
        Assert.assertEquals((long)-3600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cUtc);
        Assert.assertEquals((long)0L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt03);
        Assert.assertEquals((long)-10800000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt05);
        Assert.assertEquals((long)18000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt13);
        Assert.assertEquals((long)-46800000L, (long)ts.getTime());
        String s = rs.getString(c);
        Assert.assertEquals((Object)"1970-01-01 00:00:00", (Object)s);
        ts = rs.getTimestamp(++c);
        Assert.assertEquals((long)1104588000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cUtc);
        Assert.assertEquals((long)1104591600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt03);
        Assert.assertEquals((long)1104580800000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt05);
        Assert.assertEquals((long)1104609600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt13);
        Assert.assertEquals((long)1104544800000L, (long)ts.getTime());
        s = rs.getString(c);
        Assert.assertEquals((Object)"2005-01-01 15:00:00", (Object)s);
        ts = rs.getTimestamp(++c);
        Assert.assertEquals((long)50400000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cUtc);
        Assert.assertEquals((long)54000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt03);
        Assert.assertEquals((long)43200000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt05);
        Assert.assertEquals((long)72000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt13);
        Assert.assertEquals((long)0x6DDD00L, (long)ts.getTime());
        s = rs.getString(c);
        Assert.assertEquals((Object)"15:00:00", (Object)s);
        ts = rs.getTimestamp(++c);
        Assert.assertEquals((long)1104534000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cUtc);
        Assert.assertEquals((long)1104537600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt03);
        Assert.assertEquals((long)1104526800000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt05);
        Assert.assertEquals((long)1104555600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt13);
        Assert.assertEquals((long)1104490800000L, (long)ts.getTime());
        s = rs.getString(c);
        Assert.assertEquals((Object)"2005-01-01", (Object)s);
        ++c;
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    @Test
    public void testGetDate() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection conn) {
                try {
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("select min(\"date\") mindate from \"foodmart\".\"currency\"");
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)Date.valueOf("1997-01-01"), (Object)rs.getDate(1));
                    Assert.assertFalse((boolean)rs.next());
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testGetDateAsString() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select min(\"date\") mindate from \"foodmart\".\"currency\"").returns("MINDATE=1997-01-01\n");
    }

    @Test
    public void testGetTimestampObject() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection conn) {
                try {
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("select \"hire_date\" from \"foodmart\".\"employee\" where \"employee_id\" = 1");
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)Timestamp.valueOf("1994-12-01 00:00:00"), (Object)rs.getTimestamp(1));
                    Assert.assertFalse((boolean)rs.next());
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testUnicode() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with(OptiqAssert.Config.FOODMART_CLONE);
        with.query("values _UTF16'\u82f1\u56fd'").returns("EXPR$0=\u82f1\u56fd\n");
        with.query("values U&'\\82F1\\56FD'").returns("EXPR$0=\u82f1\u56fd\n");
        with.query("values u&'\\82f1\\56fd'").returns("EXPR$0=\u82f1\u56fd\n");
        with.query("values '\u82f1\u56fd'").throws_("Failed to encode '\u82f1\u56fd' in character set 'ISO-8859-1'");
        with.query("select * from \"employee\" where \"full_name\" = '\u82f1\u56fd'").throws_("Failed to encode '\u82f1\u56fd' in character set 'ISO-8859-1'");
        with.query("select * from \"employee\" where \"full_name\" = _UTF16'\u82f1\u56fd'").throws_("Cannot apply = to the two different charsets ISO-8859-1 and UTF-16LE");
        with.query("select * from \"employee\"\nwhere convert(\"full_name\" using UTF16) = _UTF16'\u82f1\u56fd'").throws_("Column 'UTF16' not found in any table");
    }

    @Test
    public void testLexMySQL() throws Exception {
        OptiqAssert.that().with((Map<String, String>)ImmutableMap.of((Object)"lex", (Object)"MYSQL")).doWithConnection(new Function1<OptiqConnection, Void>(){

            public Void apply(OptiqConnection connection) {
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"`"));
                    Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testLexSqlServer() throws Exception {
        OptiqAssert.that().with((Map<String, String>)ImmutableMap.of((Object)"lex", (Object)"SQL_SERVER")).doWithConnection(new Function1<OptiqConnection, Void>(){

            public Void apply(OptiqConnection connection) {
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"["));
                    Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testLexOracle() throws Exception {
        OptiqAssert.that().with((Map<String, String>)ImmutableMap.of((Object)"lex", (Object)"ORACLE")).doWithConnection(new Function1<OptiqConnection, Void>(){

            public Void apply(OptiqConnection connection) {
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"\""));
                    Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesUpperCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testLexJava() throws Exception {
        OptiqAssert.that().with((Map<String, String>)ImmutableMap.of((Object)"lex", (Object)"JAVA")).doWithConnection(new Function1<OptiqConnection, Void>(){

            public Void apply(OptiqConnection connection) {
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"`"));
                    Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesUpperCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testLexOracleAsJava() throws Exception {
        OptiqAssert.that().with((Map<String, String>)ImmutableMap.builder().put((Object)"lex", (Object)"ORACLE").put((Object)"quoting", (Object)"BACK_TICK").put((Object)"unquotedCasing", (Object)"UNCHANGED").put((Object)"quotedCasing", (Object)"UNCHANGED").put((Object)"caseSensitive", (Object)"TRUE").build()).doWithConnection(new Function1<OptiqConnection, Void>(){

            public Void apply(OptiqConnection connection) {
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"`"));
                    Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                    Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesUpperCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testLexCaseInsensitive() {
        OptiqAssert.AssertThat with = OptiqAssert.that().with((Map<String, String>)ImmutableMap.of((Object)"lex", (Object)"MYSQL"));
        with.query("select COUNT(*) as c from metaData.tAbles").returns("c=2\n");
        with.query("select COUNT(*) as c from `metaData`.`tAbles`").returns("c=2\n");
        OptiqAssert.AssertThat with2 = OptiqAssert.that().with((Map<String, String>)ImmutableMap.of((Object)"lex", (Object)"JAVA"));
        with2.query("select COUNT(*) as c from `metaData`.`tAbles`").throws_("Table 'metaData.tAbles' not found");
    }

    @Test
    public void testHook() {
        final int[] callCount = new int[1];
        Hook.Closeable hook = Hook.PARSE_TREE.addThread((Function1)new Function1<Object, Object>(){

            public Object apply(Object a0) {
                Object[] args = (Object[])a0;
                Assert.assertThat((Object)args.length, (Matcher)CoreMatchers.equalTo((Object)2));
                Assert.assertThat((Object)args[0], (Matcher)CoreMatchers.instanceOf(String.class));
                Assert.assertThat((Object)((String)args[0]), (Matcher)CoreMatchers.equalTo((Object)"select \"deptno\", \"commission\", sum(\"salary\") s\nfrom \"hr\".\"emps\"\ngroup by \"deptno\", \"commission\""));
                Assert.assertThat((Object)args[1], (Matcher)CoreMatchers.instanceOf(SqlSelect.class));
                callCount[0] = callCount[0] + 1;
                return null;
            }
        });
        try {
            this.testSimple();
            Assert.assertThat((Object)callCount[0], (Matcher)CoreMatchers.equalTo((Object)0));
            this.testGroupByNull();
            Assert.assertThat((Object)callCount[0], (Matcher)CoreMatchers.equalTo((Object)1));
        }
        finally {
            hook.close();
        }
    }

    @Test
    public void testDialect() {
        final String[] sqls = new String[1];
        Hook.Closeable hook = Hook.QUERY_PLAN.addThread((Function1)new Function1<Object, Object>(){

            public Object apply(Object a0) {
                String sql;
                sqls[0] = sql = (String)a0;
                return null;
            }
        });
        try {
            OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select count(*) as c from \"foodmart\".\"employee\" as e1\n  where \"first_name\" = 'abcde'\n  and \"gender\" = 'F'").returns("C=0\n");
            switch (OptiqAssert.CONNECTION_SPEC) {
                case HSQLDB: {
                    Assert.assertThat((Object)Util.toLinux((String)sqls[0]), (Matcher)CoreMatchers.equalTo((Object)"SELECT COUNT(*) AS \"C\"\nFROM (SELECT 0 AS \"DUMMY\"\nFROM \"foodmart\".\"employee\"\nWHERE \"first_name\" = 'abcde' AND \"gender\" = 'F') AS \"t0\""));
                }
            }
        }
        finally {
            hook.close();
        }
    }

    @Test
    public void testSchemaCaching() throws Exception {
        OptiqConnection connection = OptiqAssert.getConnection(false);
        SchemaPlus rootSchema = connection.getRootSchema();
        final HashMap<String, AbstractSchema> aSubSchemaMap = new HashMap<String, AbstractSchema>();
        SchemaPlus aSchema = rootSchema.add("a", (Schema)new AbstractSchema(){

            protected Map<String, Schema> getSubSchemaMap() {
                return aSubSchemaMap;
            }
        });
        aSchema.setCacheEnabled(true);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)aSchema.contentsHaveChangedSince(-1L, 1L), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)aSchema.contentsHaveChangedSince(1L, 1L), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        aSubSchemaMap.put("b1", new AbstractSchema());
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)aSchema.getSubSchema("b1"), (Matcher)CoreMatchers.nullValue());
        aSchema.setCacheEnabled(false);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)aSchema.getSubSchema("b1"), (Matcher)CoreMatchers.notNullValue());
        aSubSchemaMap.put("b2", new AbstractSchema());
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)2));
        aSchema.setCacheEnabled(true);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)2));
        aSchema.add("b3", (Schema)new AbstractSchema());
        aSubSchemaMap.put("b4", new AbstractSchema());
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)3));
        aSchema.setCacheEnabled(false);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)4));
        for (String name : aSchema.getSubSchemaNames()) {
            Assert.assertThat((Object)aSchema.getSubSchema(name), (Matcher)CoreMatchers.notNullValue());
        }
        final HashMap<String, AbstractSchema> a2SubSchemaMap = new HashMap<String, AbstractSchema>();
        final boolean[] changed = new boolean[1];
        SchemaPlus a2Schema = rootSchema.add("a", (Schema)new AbstractSchema(){

            protected Map<String, Schema> getSubSchemaMap() {
                return a2SubSchemaMap;
            }

            public boolean contentsHaveChangedSince(long lastCheck, long now) {
                return changed[0];
            }
        });
        a2Schema.setCacheEnabled(true);
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        a2SubSchemaMap.put("b3", new AbstractSchema());
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        Thread.sleep(1L);
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        changed[0] = true;
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)1));
        changed[0] = false;
        a2SubSchemaMap.put("b4", new AbstractSchema());
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)1));
        a2Schema.setCacheEnabled(false);
        a2Schema.setCacheEnabled(true);
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)2));
        for (String name : aSchema.getSubSchemaNames()) {
            Assert.assertThat((Object)aSchema.getSubSchema(name), (Matcher)CoreMatchers.notNullValue());
        }
        TableInRootSchemaTest.SimpleTable table = new TableInRootSchemaTest.SimpleTable();
        a2Schema.add("table1", (Table)table);
        a2Schema.add("TABLE1", (Table)table);
        a2Schema.add("tabLe1", (Table)table);
        a2Schema.add("tabLe2", (Table)table);
        Assert.assertThat((Object)a2Schema.getTableNames().size(), (Matcher)CoreMatchers.equalTo((Object)4));
        OptiqSchema a2OptiqSchema = OptiqSchema.from((SchemaPlus)a2Schema);
        Assert.assertThat((Object)a2OptiqSchema.getTable("table1", true), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)a2OptiqSchema.getTable("table1", false), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)a2OptiqSchema.getTable("taBle1", true), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)a2OptiqSchema.getTable("taBle1", false), (Matcher)CoreMatchers.notNullValue());
        ViewTable.ViewTableMacro function = ViewTable.viewMacro((SchemaPlus)a2Schema, (String)"values 1", null);
        connection.close();
    }

    public static TranslatableTable view(String s) {
        return new ViewTable(Object.class, new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("c", SqlTypeName.INTEGER).build();
            }
        }, "values (1), (3), " + s, (List)ImmutableList.of());
    }

    private static QueryableTable oneThreePlus(String s) {
        Integer latest = Integer.parseInt(s.substring(1, s.length() - 1));
        List<Object> items = Arrays.asList(1, 3, latest);
        final Enumerable enumerable = Linq4j.asEnumerable(items);
        return new AbstractQueryableTable((Type)((Object)Object[].class)){

            public Queryable<Object> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                return enumerable.asQueryable();
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("c", SqlTypeName.INTEGER).build();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractModifiableTable
    extends AbstractTable
    implements ModifiableTable {
        protected AbstractModifiableTable(String tableName) {
        }

        public TableModificationRelBase toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModificationRelBase.Operation operation, List<String> updateColumnList, boolean flattened) {
            return new TableModificationRel(cluster, table, catalogReader, child, operation, updateColumnList, flattened);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutoTempDriver
    extends net.hydromatic.optiq.jdbc.Driver {
        private final List<Object> results;

        AutoTempDriver(List<Object> results) {
            this.results = results;
        }

        protected Handler createHandler() {
            return new HandlerImpl(){

                public void onStatementExecute(AvaticaStatement statement, Handler.ResultSink resultSink) {
                    super.onStatementExecute(statement, resultSink);
                    AutoTempDriver.this.results.add(resultSink);
                }
            };
        }
    }

    public static abstract class AwkwardFunction {
        private AwkwardFunction() {
        }

        public int eval(int x) {
            return 0;
        }
    }

    public static abstract class CountArgs0Function {
        private CountArgs0Function() {
        }

        public static int eval() {
            return 0;
        }
    }

    public static abstract class CountArgs1Function {
        private CountArgs1Function() {
        }

        public static int eval(int x) {
            return 1;
        }
    }

    public static abstract class CountArgs2Function {
        private CountArgs2Function() {
        }

        public static int eval(int x, int y) {
            return 2;
        }
    }

    public static class Customer {
        public final int customer_id;

        public Customer(int customer_id) {
            this.customer_id = customer_id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Department {
        public final int deptno;
        public final String name;
        public final List<Employee> employees;

        public Department(int deptno, String name, List<Employee> employees) {
            this.deptno = deptno;
            this.name = name;
            this.employees = employees;
        }

        public String toString() {
            return "Department [deptno: " + this.deptno + ", name: " + this.name + ", employees: " + this.employees + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmpDeptTableFactory
    implements TableFactory<Table> {
        public Table create(SchemaPlus schema, String name, Map<String, Object> operand, RelDataType rowType) {
            Object[] array;
            Class clazz;
            if (name.equals("EMPLOYEES")) {
                clazz = Employee.class;
                array = new HrSchema().emps;
            } else {
                clazz = Department.class;
                array = new HrSchema().depts;
            }
            return new AbstractQueryableTable((Type)((Object)clazz)){

                public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                    return ((JavaTypeFactory)typeFactory).createType((Type)clazz);
                }

                public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                    return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                        public Enumerator<T> enumerator() {
                            List<Object> list = Arrays.asList(array);
                            return Linq4j.enumerator(list);
                        }
                    };
                }
            };
        }
    }

    public static class Employee {
        public final int empid;
        public final int deptno;
        public final String name;
        public final float salary;
        public final Integer commission;

        public Employee(int empid, int deptno, String name, float salary, Integer commission) {
            this.empid = empid;
            this.deptno = deptno;
            this.name = name;
            this.salary = salary;
            this.commission = commission;
        }

        public String toString() {
            return "Employee [empid: " + this.empid + ", deptno: " + this.deptno + ", name: " + this.name + "]";
        }
    }

    public static class FoodmartJdbcSchema
    extends JdbcSchema {
        public final Table customer = this.getTable("customer");

        public FoodmartJdbcSchema(DataSource dataSource, SqlDialect dialect, JdbcConvention convention, String catalog, String schema) {
            super(dataSource, dialect, convention, catalog, schema);
        }
    }

    public static class FoodmartSchema {
        public final SalesFact[] sales_fact_1997 = new SalesFact[]{new SalesFact(100, 10), new SalesFact(150, 20)};
    }

    public static class HandlerDriver
    extends net.hydromatic.optiq.jdbc.Driver {
        private static final ThreadLocal<Handler> HANDLERS = new ThreadLocal();

        protected Handler createHandler() {
            return HANDLERS.get();
        }
    }

    public static class HrSchema {
        public final Employee[] emps = new Employee[]{new Employee(100, 10, "Bill", 10000.0f, 1000), new Employee(200, 20, "Eric", 8000.0f, 500), new Employee(150, 10, "Sebastian", 7000.0f, null), new Employee(110, 10, "Theodore", 11500.0f, 250)};
        public final Department[] depts = new Department[]{new Department(10, "Sales", Arrays.asList(this.emps[0], this.emps[2])), new Department(30, "Marketing", Collections.<Employee>emptyList()), new Department(40, "HR", Collections.singletonList(this.emps[1]))};

        public String toString() {
            return "HrSchema";
        }

        public QueryableTable foo(int count) {
            return JdbcTest.generateStrings(count);
        }

        public TranslatableTable view(String s) {
            return JdbcTest.view(s);
        }
    }

    public static class IntString {
        public final int n;
        public final String s;

        public IntString(int n, String s) {
            this.n = n;
            this.s = s;
        }

        public String toString() {
            return "{n=" + this.n + ", s=" + this.s + "}";
        }
    }

    public static class LingualEmp {
        public final int EMPNO;
        public final int DEPTNO;

        public LingualEmp(int EMPNO, int DEPTNO) {
            this.EMPNO = EMPNO;
            this.DEPTNO = DEPTNO;
        }
    }

    public static class LingualSchema {
        public final LingualEmp[] EMPS = new LingualEmp[]{new LingualEmp(1, 10), new LingualEmp(2, 30)};
    }

    public static abstract class MyDoubleFunction {
        private MyDoubleFunction() {
        }

        public static int eval(int x) {
            return x * 2;
        }
    }

    public static class MyPlusFunction {
        public int eval(int x, int y) {
            return x + y;
        }
    }

    public static class MySchema {
        public MyTable[] mytable = new MyTable[]{new MyTable()};
        public MyTable2[] mytable2 = new MyTable2[]{new MyTable2()};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MySchemaFactory
    implements SchemaFactory {
        public Schema create(SchemaPlus parentSchema, String name, final Map<String, Object> operand) {
            final boolean mutable = SqlFunctions.isNotFalse((Boolean)((Boolean)operand.get("mutable")));
            return new ReflectiveSchema(new HrSchema()){

                protected Map<String, Table> getTableMap() {
                    Map tableMap = super.getTableMap();
                    Table table = (Table)tableMap.get("emps");
                    String tableName = (String)operand.get("tableName");
                    return ImmutableMap.builder().putAll(tableMap).put((Object)tableName, (Object)table).build();
                }

                public boolean isMutable() {
                    return mutable;
                }
            };
        }
    }

    public static class MyStaticSumFunction {
        public static long init() {
            return 0L;
        }

        public static long add(long accumulator, int v) {
            return accumulator + (long)v;
        }

        public static long merge(long accumulator0, long accumulator1) {
            return accumulator0 + accumulator1;
        }

        public static long result(long accumulator) {
            return accumulator;
        }
    }

    public static class MySumFunction {
        public long init() {
            return 0L;
        }

        public long add(long accumulator, int v) {
            return accumulator + (long)v;
        }

        public long merge(long accumulator0, long accumulator1) {
            return accumulator0 + accumulator1;
        }

        public long result(long accumulator) {
            return accumulator;
        }
    }

    public static class MyTable {
        public String mykey = "foo";
        public Integer myvalue = 1;
    }

    public static class MyTable2 {
        public String mykey = "foo";
        public Integer myvalue = 2;
    }

    public static class MyToStringFunction {
        public static String eval(Object o) {
            if (o == null) {
                return "<null>";
            }
            return "<" + o.toString() + ">";
        }
    }

    public static class SalesFact {
        public final int cust_id;
        public final int prod_id;

        public SalesFact(int cust_id, int prod_id) {
            this.cust_id = cust_id;
            this.prod_id = prod_id;
        }
    }

    public static class StaticTableMacroFunction {
        public static TranslatableTable eval(String s) {
            return JdbcTest.view(s);
        }
    }

    public static class SumFunctionBadIAdd {
        public long init() {
            return 0L;
        }

        public long add(short accumulator, int v) {
            return accumulator + v;
        }
    }

    public static class TableMacroFunction {
        public TranslatableTable eval(String s) {
            return JdbcTest.view(s);
        }
    }

    public static class TestStaticTableFunction {
        public static QueryableTable eval(String s) {
            return JdbcTest.oneThreePlus(s);
        }
    }

    public static class TestTableFunction {
        public QueryableTable eval(String s) {
            return JdbcTest.oneThreePlus(s);
        }
    }
}

