/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.test.OptiqAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JdbcFrontJdbcBackTest {
    @Test
    public void testWhere2() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).query("select * from \"foodmart\".\"days\" where \"day\" < 3").returns("day=1; week_day=Sunday\nday=2; week_day=Monday\n");
    }

    @Ignore
    @Test
    public void testTables() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection a0) {
                try {
                    ResultSet rset = a0.getMetaData().getTables(null, null, null, null);
                    StringBuilder buf = new StringBuilder();
                    while (rset.next()) {
                        buf.append(rset.getString(3)).append(';');
                    }
                    Assert.assertEquals((Object)"account;agg_c_10_sales_fact_1997;agg_c_14_sales_fact_1997;agg_c_special_sales_fact_1997;agg_g_ms_pcat_sales_fact_1997;agg_l_03_sales_fact_1997;agg_l_04_sales_fact_1997;agg_l_05_sales_fact_1997;agg_lc_06_sales_fact_1997;agg_lc_100_sales_fact_1997;agg_ll_01_sales_fact_1997;agg_pl_01_sales_fact_1997;category;currency;customer;days;department;employee;employee_closure;expense_fact;inventory_fact_1997;inventory_fact_1998;position;product;product_class;products;promotion;region;reserve_employee;salary;sales_fact_1997;sales_fact_1998;sales_fact_dec_1998;store;store_ragged;time_by_day;warehouse;warehouse_class;COLUMNS;TABLES;", (Object)buf.toString());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    @Test
    public void testTablesByType() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.REGULAR_PLUS_METADATA).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection a0) {
                try {
                    ResultSet rset = a0.getMetaData().getTables(null, null, null, new String[]{"SYSTEM_TABLE"});
                    StringBuilder buf = new StringBuilder();
                    while (rset.next()) {
                        buf.append(rset.getString(3)).append(';');
                    }
                    Assert.assertEquals((Object)"COLUMNS;TABLES;", (Object)buf.toString());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    @Test
    public void testColumns() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection a0) {
                try {
                    ResultSet rset = a0.getMetaData().getColumns(null, null, "sales_fact_1997", null);
                    StringBuilder buf = new StringBuilder();
                    while (rset.next()) {
                        buf.append(rset.getString(4)).append(';');
                    }
                    Assert.assertEquals((Object)"product_id;time_id;customer_id;promotion_id;store_id;store_sales;store_cost;unit_sales;", (Object)buf.toString());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    @Test
    public void testEmpty() throws Exception {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).doWithConnection(new Function1<OptiqConnection, Object>(){

            public Object apply(OptiqConnection a0) {
                try {
                    ResultSet rset = a0.getMetaData().getPrimaryKeys(null, null, "sales_fact_1997");
                    Assert.assertFalse((boolean)rset.next());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    @Test
    public void testCase() {
        OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).withSchema("foodmart").query("select case when \"sales_fact_1997\".\"promotion_id\" = 1 then 0\n                        else \"sales_fact_1997\".\"store_sales\" end as \"c0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"where \"product_id\" = 1\nand \"time_id\" < 400").returns("c0=11.4000\nc0=8.5500\n");
    }
}

