/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.Calendar;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAbstractDateTimeLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;

public class SqlDateLiteral
extends SqlAbstractDateTimeLiteral {
    SqlDateLiteral(Calendar d, SqlParserPos pos) {
        super(d, false, SqlTypeName.DATE, 0, "yyyy-MM-dd", pos);
    }

    SqlDateLiteral(Calendar d, String format, SqlParserPos pos) {
        super(d, false, SqlTypeName.DATE, 0, format, pos);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new SqlDateLiteral((Calendar)this.value, pos);
    }

    public String toString() {
        return "DATE '" + this.toFormattedString() + "'";
    }

    public String toFormattedString() {
        return this.getDate().toString(this.formatString);
    }

    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        return typeFactory.createSqlType(this.getTypeName());
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        switch (writer.getDialect().getDatabaseProduct()) {
            case MSSQL: {
                writer.literal("'" + this.toFormattedString() + "'");
                break;
            }
            default: {
                writer.literal(this.toString());
            }
        }
    }
}

