/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.rex.RexWindow;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.util.ControlFlowException;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexOver
extends RexCall {
    private static final Finder FINDER = new Finder();
    private final RexWindow window;

    RexOver(RelDataType type, SqlAggFunction op, List<RexNode> operands, RexWindow window) {
        super(type, op, operands);
        assert (op.isAggregator()) : "precondition: op.isAggregator()";
        assert (window != null) : "precondition: window != null";
        this.window = window;
        this.digest = this.computeDigest(true);
    }

    public SqlAggFunction getAggOperator() {
        return (SqlAggFunction)this.getOperator();
    }

    public RexWindow getWindow() {
        return this.window;
    }

    @Override
    protected String computeDigest(boolean withType) {
        return super.computeDigest(withType) + " OVER (" + this.window + ")";
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitOver(this);
    }

    public static boolean containsOver(RexNode expr) {
        try {
            expr.accept(FINDER);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(RexProgram program) {
        try {
            RexProgram.apply(FINDER, program.getExprList(), null);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(List<RexNode> exprs, RexNode condition) {
        try {
            RexProgram.apply(FINDER, exprs, condition);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    @Override
    public RexCall clone(RelDataType type, List<RexNode> operands) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Finder
    extends RexVisitorImpl<Void> {
        public Finder() {
            super(true);
        }

        @Override
        public Void visitOver(RexOver over) {
            throw OverFound.INSTANCE;
        }
    }

    private static class OverFound
    extends ControlFlowException {
        public static final OverFound INSTANCE = new OverFound();

        private OverFound() {
        }
    }
}

