/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.IndexExpression;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.MethodDeclaration;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.JavaTypeFactoryImpl;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexExecutable;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgramBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexExecutorImpl
implements RelOptPlanner.Executor {
    private final DataContext dataContext;

    public RexExecutorImpl(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    private String compile(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter) {
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelDataType emptyRowType = typeFactory.builder().build();
        return this.compile(rexBuilder, constExps, getter, emptyRowType);
    }

    private String compile(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter, RelDataType rowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(rowType, rexBuilder);
        for (RexNode node : constExps) {
            programBuilder.addProject(node, "c" + programBuilder.getProjectList().size());
        }
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl();
        BlockBuilder blockBuilder = new BlockBuilder();
        ParameterExpression root0_ = Expressions.parameter(Object.class, (String)"root0");
        ParameterExpression root_ = DataContext.ROOT;
        blockBuilder.add((Statement)Expressions.declare((int)16, (ParameterExpression)root_, (Expression)Expressions.convert_((Expression)root0_, DataContext.class)));
        List<Expression> expressions = RexToLixTranslator.translateProjects(programBuilder.getProgram(), javaTypeFactory, blockBuilder, getter);
        blockBuilder.add((Statement)Expressions.return_(null, (Expression)Expressions.newArrayInit(Object[].class, expressions)));
        MethodDeclaration methodDecl = Expressions.methodDecl((int)1, Object[].class, (String)BuiltinMethod.FUNCTION1_APPLY.method.getName(), (Iterable)ImmutableList.of((Object)root0_), (BlockStatement)blockBuilder.toBlock());
        String code = Expressions.toString((Node)methodDecl);
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println(code);
        }
        return code;
    }

    public RexExecutable getExecutable(RexBuilder rexBuilder, List<RexNode> exps, RelDataType rowType) {
        DataContextInputGetter getter = new DataContextInputGetter(rowType, rexBuilder.getTypeFactory());
        String code = this.compile(rexBuilder, exps, getter, rowType);
        return new RexExecutable(code, "generated Rex code");
    }

    @Override
    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        String code = this.compile(rexBuilder, constExps, new RexToLixTranslator.InputGetter(){

            public Expression field(BlockBuilder list, int index) {
                throw new UnsupportedOperationException();
            }
        });
        RexExecutable executable = new RexExecutable(code, constExps);
        executable.setDataContext(this.dataContext);
        executable.reduce(rexBuilder, constExps, reducedValues);
    }

    private static class DataContextInputGetter
    implements RexToLixTranslator.InputGetter {
        private final RelDataTypeFactory typeFactory;
        private final RelDataType rowType;

        public DataContextInputGetter(RelDataType rowType, RelDataTypeFactory typeFactory) {
            this.rowType = rowType;
            this.typeFactory = typeFactory;
        }

        public Expression field(BlockBuilder list, int index) {
            MethodCallExpression recFromCtx = Expressions.call((Expression)DataContext.ROOT, (Method)BuiltinMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)"inputRecord")});
            Expression recFromCtxCasted = RexToLixTranslator.convert((Expression)recFromCtx, Object[].class);
            IndexExpression recordAccess = Expressions.arrayIndex((Expression)recFromCtxCasted, (Expression)Expressions.constant((Object)index));
            RelDataType fieldType = this.rowType.getFieldList().get(index).getType();
            Type type = ((JavaTypeFactory)this.typeFactory).getJavaClass(fieldType);
            return RexToLixTranslator.convert((Expression)recordAccess, type);
        }
    }
}

