/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PushFilterPastJoinRule
extends RelOptRule {
    public static final PushFilterPastJoinRule FILTER_ON_JOIN = new PushFilterPastJoinRule(PushFilterPastJoinRule.operand(FilterRel.class, PushFilterPastJoinRule.operand(JoinRelBase.class, PushFilterPastJoinRule.any()), new RelOptRuleOperand[0]), "PushFilterPastJoinRule:filter"){

        public void onMatch(RelOptRuleCall call) {
            FilterRel filter = (FilterRel)call.rel(0);
            JoinRelBase join = (JoinRelBase)call.rel(1);
            this.perform(call, filter, join);
        }
    };
    public static final PushFilterPastJoinRule JOIN = new PushFilterPastJoinRule(PushFilterPastJoinRule.operand(JoinRelBase.class, PushFilterPastJoinRule.any()), "PushFilterPastJoinRule:no-filter"){

        public void onMatch(RelOptRuleCall call) {
            JoinRelBase join = (JoinRelBase)call.rel(0);
            this.perform(call, null, join);
        }
    };

    private PushFilterPastJoinRule(RelOptRuleOperand operand, String id) {
        super(operand, "PushFilterRule: " + id);
    }

    protected void perform(RelOptRuleCall call, FilterRel filter, JoinRelBase join) {
        RexNode joinFilter;
        List<RexNode> joinFilters = RelOptUtil.conjunctions(join.getCondition());
        if (filter == null) {
            boolean onlyTrueFilter = true;
            for (RexNode joinFilter2 : joinFilters) {
                if (joinFilter2.isAlwaysTrue()) continue;
                onlyTrueFilter = false;
                break;
            }
            if (onlyTrueFilter) {
                return;
            }
        }
        ImmutableList aboveFilters = filter != null ? RelOptUtil.conjunctions(filter.getCondition()) : ImmutableList.of();
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        boolean filterPushed = false;
        if (RelOptUtil.classifyFilters(join, (List<RexNode>)aboveFilters, join.getJoinType() == JoinRelType.INNER, !join.getJoinType().generatesNullsOnLeft(), !join.getJoinType().generatesNullsOnRight(), joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        if (RelOptUtil.classifyFilters(join, joinFilters, false, !join.getJoinType().generatesNullsOnRight(), !join.getJoinType().generatesNullsOnLeft(), joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        if (!filterPushed) {
            return;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelNode leftRel = this.createFilterOnRel(rexBuilder, join.getLeft(), leftFilters);
        RelNode rightRel = this.createFilterOnRel(rexBuilder, join.getRight(), rightFilters);
        if (joinFilters.size() == 0) {
            if (leftFilters.size() == 0 && rightFilters.size() == 0) {
                return;
            }
            joinFilter = rexBuilder.makeLiteral(true);
        } else {
            joinFilter = RexUtil.composeConjunction(rexBuilder, joinFilters, true);
        }
        RelNode newJoinRel = join.copy(join.getCluster().traitSetOf(Convention.NONE), joinFilter, leftRel, rightRel, join.getJoinType());
        call.getPlanner().onCopy(join, newJoinRel);
        if (newJoinRel instanceof JoinRel) {
            newJoinRel = RelOptUtil.pushExpInEqualJoinCondIntoProj(join.getCluster(), newJoinRel.getCondition(), newJoinRel.getJoinType(), leftRel, rightRel);
        }
        RelNode newRel = this.createFilterOnRel(rexBuilder, newJoinRel, (List<RexNode>)aboveFilters);
        call.transformTo(newRel);
    }

    private RelNode createFilterOnRel(RexBuilder rexBuilder, RelNode rel, List<RexNode> filters) {
        RexNode andFilters = RexUtil.composeConjunction(rexBuilder, filters, false);
        if (andFilters.isAlwaysTrue()) {
            return rel;
        }
        return CalcRel.createFilter(rel, andFilters);
    }
}

