/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.Collections;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;

public class AddRedundantSemiJoinRule
extends RelOptRule {
    public static final AddRedundantSemiJoinRule INSTANCE = new AddRedundantSemiJoinRule();

    private AddRedundantSemiJoinRule() {
        super(AddRedundantSemiJoinRule.operand(JoinRel.class, AddRedundantSemiJoinRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        JoinRel origJoinRel = (JoinRel)call.rel(0);
        if (origJoinRel.isSemiJoinDone()) {
            return;
        }
        if (origJoinRel.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(origJoinRel.getLeft(), origJoinRel.getRight(), origJoinRel.getCondition(), leftKeys, rightKeys);
        if (leftKeys.size() == 0) {
            return;
        }
        SemiJoinRel semiJoin = new SemiJoinRel(origJoinRel.getCluster(), origJoinRel.getLeft(), origJoinRel.getRight(), origJoinRel.getCondition(), leftKeys, rightKeys);
        JoinRel newJoinRel = new JoinRel(origJoinRel.getCluster(), semiJoin, origJoinRel.getRight(), origJoinRel.getCondition(), JoinRelType.INNER, Collections.<String>emptySet(), true, origJoinRel.getSystemFieldList());
        call.transformTo(newJoinRel);
    }
}

