/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelJson;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelJsonReader {
    private static final TypeReference<LinkedHashMap<String, Object>> TYPE_REF = new TypeReference<LinkedHashMap<String, Object>>(){};
    private final RelOptCluster cluster;
    private final RelOptSchema relOptSchema;
    private final Schema schema;
    private final RelJson relJson = new RelJson(null);
    private final Map<String, RelNode> relMap = new LinkedHashMap<String, RelNode>();
    private RelNode lastRel;

    public RelJsonReader(RelOptCluster cluster, RelOptSchema relOptSchema, Schema schema) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        this.schema = schema;
    }

    public RelNode read(String s) throws IOException {
        this.lastRel = null;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        Map o = (Map)mapper.readValue(s, TYPE_REF);
        this.readRels((List)o.get("rels"));
        System.out.println(this.lastRel);
        return this.lastRel;
    }

    private void readRels(List<Map<String, Object>> jsonRels) {
        for (Map<String, Object> jsonRel : jsonRels) {
            this.readRel(jsonRel);
        }
    }

    private void readRel(final Map<String, Object> jsonRel) {
        String id = (String)jsonRel.get("id");
        String type = (String)jsonRel.get("relOp");
        Constructor constructor = this.relJson.getConstructor(type);
        RelInput input = new RelInput(){

            @Override
            public RelOptCluster getCluster() {
                return RelJsonReader.this.cluster;
            }

            @Override
            public RelTraitSet getTraitSet() {
                return RelJsonReader.this.cluster.traitSetOf(Convention.NONE);
            }

            @Override
            public RelOptTable getTable(String table) {
                List list = (List)jsonRel.get(table);
                return RelJsonReader.this.relOptSchema.getTableForMember(list);
            }

            @Override
            public RelNode getInput() {
                List<RelNode> inputs = this.getInputs();
                assert (inputs.size() == 1);
                return inputs.get(0);
            }

            @Override
            public List<RelNode> getInputs() {
                List jsonInputs = (List)jsonRel.get("inputs");
                if (jsonInputs == null) {
                    return ImmutableList.of((Object)RelJsonReader.this.lastRel);
                }
                ArrayList<RelNode> inputs = new ArrayList<RelNode>();
                for (String jsonInput : jsonInputs) {
                    inputs.add(RelJsonReader.this.lookupInput(jsonInput));
                }
                return inputs;
            }

            @Override
            public RexNode getExpression(String tag) {
                return RelJsonReader.this.relJson.toRex(this, jsonRel.get(tag));
            }

            @Override
            public BitSet getBitSet(String tag) {
                return BitSets.of(this.getIntegerList(tag));
            }

            public List<Integer> getIntegerList(String tag) {
                return (List)jsonRel.get(tag);
            }

            @Override
            public List<AggregateCall> getAggregateCalls(String tag) {
                List jsonAggs = (List)jsonRel.get(tag);
                ArrayList<AggregateCall> inputs = new ArrayList<AggregateCall>();
                for (Map jsonAggCall : jsonAggs) {
                    inputs.add(RelJsonReader.this.toAggCall(jsonAggCall));
                }
                return inputs;
            }

            @Override
            public Object get(String tag) {
                return jsonRel.get(tag);
            }

            @Override
            public String getString(String tag) {
                return (String)jsonRel.get(tag);
            }

            @Override
            public float getFloat(String tag) {
                return ((Number)jsonRel.get(tag)).floatValue();
            }

            @Override
            public boolean getBoolean(String tag) {
                return (Boolean)jsonRel.get(tag);
            }

            @Override
            public <E extends Enum<E>> E getEnum(String tag, Class<E> enumClass) {
                return Util.enumVal(enumClass, this.getString(tag).toUpperCase());
            }

            @Override
            public List<RexNode> getExpressionList(String tag) {
                List jsonNodes = (List)jsonRel.get(tag);
                ArrayList<RexNode> nodes = new ArrayList<RexNode>();
                for (Object jsonNode : jsonNodes) {
                    nodes.add(RelJsonReader.this.relJson.toRex(this, jsonNode));
                }
                return nodes;
            }

            @Override
            public RelDataType getRowType(String tag) {
                Object o = jsonRel.get(tag);
                return RelJsonReader.this.relJson.toType(RelJsonReader.this.cluster.getTypeFactory(), o);
            }

            @Override
            public RelDataType getRowType(String expressionsTag, String fieldsTag) {
                final List<RexNode> expressionList = this.getExpressionList(expressionsTag);
                final List names = (List)this.get(fieldsTag);
                return RelJsonReader.this.cluster.getTypeFactory().createStructType((List<? extends Map.Entry<String, RelDataType>>)new AbstractList<Map.Entry<String, RelDataType>>(){

                    @Override
                    public Map.Entry<String, RelDataType> get(int index) {
                        return Pair.of(names.get(index), ((RexNode)expressionList.get(index)).getType());
                    }

                    @Override
                    public int size() {
                        return names.size();
                    }
                });
            }

            @Override
            public RelCollation getCollation() {
                return RelJsonReader.this.relJson.toCollation((List)this.get("collation"));
            }

            @Override
            public List<List<RexLiteral>> getTuples(String tag) {
                List jsonTuples = (List)this.get(tag);
                ArrayList<List<RexLiteral>> list = new ArrayList<List<RexLiteral>>();
                for (List jsonTuple : jsonTuples) {
                    list.add(this.getTuple(jsonTuple));
                }
                return list;
            }

            public List<RexLiteral> getTuple(List jsonTuple) {
                ArrayList<RexLiteral> list = new ArrayList<RexLiteral>();
                for (Object jsonValue : jsonTuple) {
                    list.add((RexLiteral)RelJsonReader.this.relJson.toRex(this, jsonValue));
                }
                return list;
            }
        };
        try {
            RelNode rel = (RelNode)constructor.newInstance(input);
            this.relMap.put(id, rel);
            this.lastRel = rel;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2);
        }
    }

    private AggregateCall toAggCall(Map<String, Object> jsonAggCall) {
        String aggName = (String)jsonAggCall.get("agg");
        Aggregation aggregation = this.relJson.toAggregation(aggName, jsonAggCall);
        Boolean distinct = (Boolean)jsonAggCall.get("distinct");
        List operands = (List)jsonAggCall.get("operands");
        RelDataType type = this.relJson.toType(this.cluster.getTypeFactory(), jsonAggCall.get("type"));
        return new AggregateCall(aggregation, distinct, operands, type, null);
    }

    private RelNode lookupInput(String jsonInput) {
        RelNode node = this.relMap.get(jsonInput);
        if (node == null) {
            throw new RuntimeException("unknown id " + jsonInput + " for relational expression");
        }
        return node;
    }
}

