/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.PlannerImpl;
import net.hydromatic.optiq.server.OptiqServerStatement;
import net.hydromatic.optiq.tools.FrameworkConfig;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.StdFrameworkConfig;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frameworks {
    private Frameworks() {
    }

    public static Planner getPlanner(FrameworkConfig config) {
        return new PlannerImpl(config);
    }

    public static <R> R withPlanner(final PlannerAction<R> action, FrameworkConfig config) {
        return Frameworks.withPrepare(new PrepareAction<R>(config){

            @Override
            public R apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, OptiqServerStatement statement) {
                return action.apply(cluster, relOptSchema, rootSchema);
            }
        });
    }

    public static <R> R withPlanner(PlannerAction<R> action) {
        StdFrameworkConfig config = StdFrameworkConfig.newBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        return Frameworks.withPlanner(action, config);
    }

    public static <R> R withPrepare(PrepareAction<R> action) {
        try {
            Class.forName("net.hydromatic.optiq.jdbc.Driver");
            Connection connection = DriverManager.getConnection("jdbc:optiq:");
            OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
            OptiqServerStatement statement = optiqConnection.createStatement().unwrap(OptiqServerStatement.class);
            return new OptiqPrepareImpl().perform(statement, action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SchemaPlus createRootSchema(boolean addMetadataSchema) {
        return OptiqSchema.createRootSchema(addMetadataSchema).plus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PrepareAction<R> {
        private final FrameworkConfig config;

        public PrepareAction() {
            this.config = StdFrameworkConfig.newBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        }

        public PrepareAction(FrameworkConfig config) {
            this.config = config;
        }

        public FrameworkConfig getConfig() {
            return this.config;
        }

        public abstract R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3, OptiqServerStatement var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PlannerAction<R> {
        public R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3);
    }
}

