/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.impl.ScalarFunctionImpl;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMacroImpl
implements TableMacro {
    private final List<FunctionParameter> parameters;
    private final Method method;

    private TableMacroImpl(List<FunctionParameter> parameters, Method method) {
        this.parameters = parameters;
        this.method = method;
    }

    public static TableMacro create(Class<?> clazz) {
        Method method = ScalarFunctionImpl.findMethod(clazz, "eval");
        if (method == null) {
            return null;
        }
        if ((method.getModifiers() & 8) == 0 && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz)) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        Class<?> returnType = method.getReturnType();
        if (!Table.class.isAssignableFrom(returnType)) {
            return null;
        }
        return TableMacroImpl.create(method);
    }

    public static TableMacro create(Method method) {
        final ArrayList<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
        for (final Class<?> parameterType : method.getParameterTypes()) {
            parameters.add(new FunctionParameter(){
                final int ordinal;
                {
                    this.ordinal = parameters.size();
                }

                public int getOrdinal() {
                    return this.ordinal;
                }

                public String getName() {
                    return "a" + this.ordinal;
                }

                public RelDataType getType(RelDataTypeFactory typeFactory) {
                    return ((JavaTypeFactory)typeFactory).createType(parameterType);
                }
            });
        }
        return new TableMacroImpl(parameters, method);
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Table apply(List<Object> arguments) {
        try {
            Object o = null;
            if (!Modifier.isStatic(this.method.getModifiers())) {
                o = this.method.getDeclaringClass().newInstance();
            }
            return (Table)this.method.invoke(o, arguments.toArray());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Expected " + Arrays.asList(this.method.getParameterTypes()) + " actual " + arguments, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        Class<?> returnType = this.method.getReturnType();
        return ((JavaTypeFactory)typeFactory).createType(returnType);
    }
}

