/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.io.StringWriter;
import org.eigenbase.util.OptionsList;
import org.eigenbase.util.Util;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class OptionsListTest {
    @Test
    public void testBooleanArg() {
        this.checkIt("flag=true\n", new OptionsList.Option[]{new OptionsList.BooleanOption("flag", null, "xxx", false, false, false)}, new String[]{"-flag"});
    }

    @Test
    public void testBooleanArgMissing() {
        this.checkIt("flag=false (default)\n", new OptionsList.Option[]{new OptionsList.BooleanOption("flag", null, "xxx", false, false, false)}, new String[0]);
    }

    @Ignore
    @Test
    public void testUnknownArg() {
        this.checkIt("?", new OptionsList.Option[]{new OptionsList.BooleanOption("flag", null, "xxx", false, false, false)}, new String[]{"-unknown"});
    }

    @Ignore
    @Test
    public void testUnknownArgWithEqualsSyntax() {
        this.checkIt("?", new OptionsList.Option[]{new OptionsList.BooleanOption("flag", null, "xxx", false, false, false)}, new String[]{"unknown=foo"});
    }

    @Ignore
    @Test
    public void testStringArgSameAsDefault() {
        this.checkIt("foo=default", new OptionsList.Option[]{new OptionsList.StringOption("foo", "foo", "xxx", false, false, "default")}, new String[]{"foo=default"});
    }

    @Ignore
    @Test
    public void testStringArgUsesDefaultValue() {
        this.checkIt("foo=default (default)", new OptionsList.Option[]{new OptionsList.StringOption("foo", "foo", "xxx", false, false, "default")}, new String[]{""});
    }

    @Ignore
    @Test
    public void testEnumeratedArgShort() {
        this.checkIt("color=GREEN", new OptionsList.Option[]{new OptionsList.EnumeratedOption("c", "color", "", false, false, (Enum)Color.RED, Color.class)}, new String[]{"-c GREEN"});
    }

    @Ignore
    @Test
    public void testEnumeratedArgLong() {
        this.checkIt("color=BLUE", new OptionsList.Option[]{new OptionsList.EnumeratedOption("c", "color", "", false, false, (Enum)Color.RED, Color.class)}, new String[]{"color=BLUE"});
    }

    @Ignore
    @Test
    public void testEnumeratedArgWrong() {
        this.checkIt("PURPLE is not a valid value", new OptionsList.Option[]{new OptionsList.EnumeratedOption("c", "color", "", false, false, (Enum)Color.RED, Color.class)}, new String[]{"-c PURPLE"});
    }

    @Ignore
    @Test
    public void testEnumeratedArgDefault() {
        this.checkIt("color=RED (default)", new OptionsList.Option[]{new OptionsList.EnumeratedOption("c", "color", "", false, false, (Enum)Color.RED, Color.class), new OptionsList.NumberOption("x", "x", "", false, false, null)}, new String[]{"-c PURPLE"});
    }

    @Ignore
    @Test
    public void testMissingMandatory() {
        this.checkIt("missing x", new OptionsList.Option[]{new OptionsList.NumberOption("x", "x", "", true, false, null)}, new String[0]);
    }

    @Ignore
    @Test
    public void testGroupOptionsMustBeOptional() {
        OptionsList.NumberOption optionX = new OptionsList.NumberOption("x", "x", "", false, false, null);
        OptionsList.NumberOption optionY = new OptionsList.NumberOption("y", "y", "", true, false, null);
        OptionsList optionsList = new OptionsList(new OptionsList.Option[]{optionX, optionY});
        try {
            optionsList.constrain(new OptionsList.Option[]{optionX, optionY}, 0, 1);
            Assert.assertTrue((String)"Expected an error", (boolean)false);
        }
        catch (Exception e) {
            this.assertContains("fewer than 1...", e.toString());
        }
    }

    @Ignore
    @Test
    public void testGroupMissing() {
        StringBufferOptionsHandler handler = new StringBufferOptionsHandler();
        OptionsList.NumberOption optionX = new OptionsList.NumberOption("x", "x", "", false, false, null);
        OptionsList.NumberOption optionY = new OptionsList.NumberOption("y", "y", "", false, false, null);
        OptionsList.NumberOption optionZ = new OptionsList.NumberOption("z", "z", "", false, false, null);
        OptionsList optionsList = new OptionsList(new OptionsList.Option[]{optionX, optionY, optionZ});
        optionsList.constrain(new OptionsList.Option[]{optionX, optionY}, 0, 1);
        String[] args = new String[]{"-z"};
        optionsList.parse(args);
        Assert.assertEquals((Object)"foo", (Object)handler.toString());
    }

    @Ignore
    @Test
    public void testAnonymousOption() {
        this.checkIt("verbose=true\nfile=file.txt", new OptionsList.Option[]{new OptionsList.BooleanOption("flag", "flag", "", false, false, false), new OptionsList.StringOption("file", "file", "", false, true, "foo.txt")}, new String[]{"-v", "bar.txt"});
    }

    @Ignore
    @Test
    public void testRepeatingOption() {
        this.checkIt("verbose=truefile=foo.txtfile=bar.txt", new OptionsList.Option[]{new OptionsList.BooleanOption("flag", "flag", "", false, false, false), new OptionsList.StringOption("file", "file", "", false, true, "foo.txt")}, new String[]{"-v", "-f", "foo.txt", "-f", "bar.txt"});
    }

    private void assertContains(String expected, String actual) {
        if (actual.indexOf(expected) < 0) {
            Assert.fail((String)("Expected '" + actual + "' to contain '" + expected + "'"));
        }
    }

    private void checkIt(String expected, OptionsList.Option[] options, String[] args) {
        StringBufferOptionsHandler handler = new StringBufferOptionsHandler();
        OptionsList optionsList = new OptionsList();
        for (OptionsList.Option option : options) {
            option.setHandler((OptionsList.OptionHandler)handler);
            optionsList.add(option);
        }
        optionsList.parse(args);
        Assert.assertEquals((Object)expected, (Object)Util.toLinux((String)handler.toString()));
    }

    public static class StringBufferOptionsHandler
    implements OptionsList.OptionHandler {
        private StringWriter buf = new StringWriter();

        public void set(OptionsList.Option option, Object value, boolean isExplicit) {
            this.buf.write(option.getName() + "=" + value + (isExplicit ? "" : " (default)") + "\n");
        }

        public void invalidValue(OptionsList.Option option, String value) {
            this.buf.write(value + " is not valid for " + option.getName() + "\n");
        }

        public String toString() {
            return this.buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Color {
        RED,
        GREEN,
        BLUE;

    }
}

