/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.rules.CoerceInputsRule;
import org.eigenbase.rel.rules.FilterToCalcRule;
import org.eigenbase.rel.rules.MergeCalcRule;
import org.eigenbase.rel.rules.ProjectToCalcRule;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.rel.rules.UnionToDistinctRule;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.hep.HepMatchOrder;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepProgramBuilder;
import org.eigenbase.test.DiffRepository;
import org.eigenbase.test.RelOptTestBase;
import org.junit.Test;

public class HepPlannerTest
extends RelOptTestBase {
    private static final String UNION_TREE = "(select name from dept union select ename from emp) union (select ename from bonus)";

    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(HepPlannerTest.class);
    }

    @Test
    public void testRuleClass() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleClass(CoerceInputsRule.class);
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.addRule((RelOptRule)new CoerceInputsRule(UnionRel.class, false));
        planner.addRule((RelOptRule)new CoerceInputsRule(IntersectRel.class, false));
        this.checkPlanning((RelOptPlanner)planner, "(select name from dept union select ename from emp) intersect (select fname from customer.contact)");
    }

    @Test
    public void testRuleDescription() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleByDescription("FilterToCalcRule");
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.addRule((RelOptRule)FilterToCalcRule.INSTANCE);
        this.checkPlanning((RelOptPlanner)planner, "select name from sales.dept where deptno=12");
    }

    @Test
    public void testMatchLimitOneTopDown() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        programBuilder.addMatchLimit(1);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testMatchLimitOneBottomUp() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchLimit(1);
        programBuilder.addMatchOrder(HepMatchOrder.BOTTOM_UP);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testMatchUntilFixpoint() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchLimit(Integer.MAX_VALUE);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testReplaceCommonSubexpression() throws Exception {
        this.checkPlanning((RelOptRule)RemoveTrivialProjectRule.INSTANCE, "select d1.deptno from (select * from dept) d1, (select * from dept) d2");
    }

    @Test
    public void testSubprogram() throws Exception {
        HepProgramBuilder subprogramBuilder = HepProgram.builder();
        subprogramBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        subprogramBuilder.addMatchLimit(1);
        subprogramBuilder.addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE);
        subprogramBuilder.addRuleInstance((RelOptRule)MergeCalcRule.INSTANCE);
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addSubprogram(subprogramBuilder.build());
        this.checkPlanning(programBuilder.build(), "select upper(ename) from (select lower(ename) as ename from emp)");
    }

    @Test
    public void testGroup() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addGroupBegin();
        programBuilder.addRuleInstance((RelOptRule)MergeCalcRule.INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE);
        programBuilder.addGroupEnd();
        this.checkPlanning(programBuilder.build(), "select upper(name) from dept where deptno=20");
    }
}

