/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.test;

import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.Quoting;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.runtime.Utilities;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlIntervalLiteral;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.sql.test.DelegatingSqlTestFactory;
import org.eigenbase.sql.test.SqlTestFactory;
import org.eigenbase.sql.test.SqlTester;
import org.eigenbase.sql.test.SqlTests;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.util.SqlShuttle;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.test.SqlValidatorTestCase;
import org.eigenbase.util.Pair;
import org.eigenbase.util.TestUtil;
import org.eigenbase.util.Util;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTesterImpl
implements SqlTester {
    private final SqlTestFactory factory;

    public SqlTesterImpl(SqlTestFactory factory) {
        this.factory = factory;
    }

    @Override
    public final SqlTestFactory getFactory() {
        return this.factory;
    }

    @Override
    public void close() {
    }

    @Override
    public final SqlConformance getConformance() {
        return (SqlConformance)this.factory.get("conformance");
    }

    @Override
    public final SqlValidator getValidator() {
        return this.factory.getValidator(this.factory);
    }

    @Override
    public void assertExceptionIsThrown(String sql, String expectedMsgPattern) {
        SqlValidator validator;
        SqlNode sqlNode;
        SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
        try {
            sqlNode = this.parseQuery(sap.sql);
            validator = this.getValidator();
        }
        catch (SqlParseException e) {
            String errMessage = e.getMessage();
            if (expectedMsgPattern == null) {
                e.printStackTrace();
                throw new AssertionError((Object)("Error while parsing query [" + sap.sql + "]"));
            }
            if (null == errMessage || !errMessage.matches(expectedMsgPattern)) {
                e.printStackTrace();
                throw new AssertionError((Object)("Error did not match expected [" + expectedMsgPattern + "] while parsing query [" + sap.sql + "]"));
            }
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new AssertionError((Object)("Error while parsing query [" + sap.sql + "]"));
        }
        Throwable thrown = null;
        try {
            validator.validate(sqlNode);
        }
        catch (Throwable ex) {
            thrown = ex;
        }
        SqlValidatorTestCase.checkEx(thrown, expectedMsgPattern, sap);
    }

    @Override
    public RelDataType getColumnType(String sql) {
        RelDataType rowType = this.getResultType(sql);
        List fields = rowType.getFieldList();
        Assert.assertEquals((String)"expected query to return 1 field", (long)1L, (long)fields.size());
        return ((RelDataTypeField)fields.get(0)).getType();
    }

    @Override
    public RelDataType getResultType(String sql) {
        SqlValidator validator = this.getValidator();
        SqlNode n = this.parseAndValidate(validator, sql);
        return validator.getValidatedNodeType(n);
    }

    @Override
    public SqlNode parseAndValidate(SqlValidator validator, String sql) {
        SqlNode sqlNode;
        if (validator == null) {
            validator = this.getValidator();
        }
        try {
            sqlNode = this.parseQuery(sql);
        }
        catch (SqlParseException e) {
            throw new RuntimeException("Error while parsing query [" + sql + "]", e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new AssertionError((Object)("Error while parsing query [" + sql + "]"));
        }
        return validator.validate(sqlNode);
    }

    @Override
    public SqlNode parseQuery(String sql) throws SqlParseException {
        SqlParser parser = this.factory.createParser(this.factory, sql);
        return parser.parseQuery();
    }

    @Override
    public void checkColumnType(String sql, String expected) {
        RelDataType actualType = this.getColumnType(sql);
        String actual = SqlTests.getTypeString(actualType);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    public void checkFieldOrigin(String sql, String fieldOriginList) {
        SqlValidator validator = this.getValidator();
        SqlNode n = this.parseAndValidate(validator, sql);
        List list = validator.getFieldOrigins(n);
        StringBuilder buf = new StringBuilder("{");
        int i = 0;
        for (List strings : list) {
            if (i++ > 0) {
                buf.append(", ");
            }
            if (strings == null) {
                buf.append("null");
                continue;
            }
            int j = 0;
            for (String s : strings) {
                if (j++ > 0) {
                    buf.append('.');
                }
                buf.append(s);
            }
        }
        buf.append("}");
        Assert.assertEquals((Object)fieldOriginList, (Object)buf.toString());
    }

    @Override
    public void checkResultType(String sql, String expected) {
        RelDataType actualType = this.getResultType(sql);
        String actual = SqlTests.getTypeString(actualType);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    public void checkIntervalConv(String sql, String expected) {
        SqlValidator validator = this.getValidator();
        SqlCall n = (SqlCall)this.parseAndValidate(validator, sql);
        SqlNode node = null;
        for (int i = 0; i < n.operandCount(); ++i) {
            node = n.operand(i);
            if (!(node instanceof SqlCall)) continue;
            if (node.getKind() == SqlKind.AS) {
                node = ((SqlCall)node).operand(0);
            }
            node = ((SqlCall)node).operand(0);
            break;
        }
        Assert.assertNotNull(node);
        SqlIntervalLiteral intervalLiteral = (SqlIntervalLiteral)node;
        SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)intervalLiteral.getValue();
        long l = interval.getIntervalQualifier().isYearMonth() ? SqlParserUtil.intervalToMonths((SqlIntervalLiteral.IntervalValue)interval) : SqlParserUtil.intervalToMillis((SqlIntervalLiteral.IntervalValue)interval);
        String actual = l + "";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    public void checkType(String expression, String type) {
        for (String sql : this.buildQueries(expression)) {
            this.checkColumnType(sql, type);
        }
    }

    @Override
    public void checkCollation(String expression, String expectedCollationName, SqlCollation.Coercibility expectedCoercibility) {
        for (String sql : this.buildQueries(expression)) {
            RelDataType actualType = this.getColumnType(sql);
            SqlCollation collation = actualType.getCollation();
            Assert.assertEquals((Object)expectedCollationName, (Object)collation.getCollationName());
            Assert.assertEquals((Object)expectedCoercibility, (Object)collation.getCoercibility());
        }
    }

    @Override
    public void checkCharset(String expression, Charset expectedCharset) {
        for (String sql : this.buildQueries(expression)) {
            RelDataType actualType = this.getColumnType(sql);
            Charset actualCharset = actualType.getCharset();
            if (expectedCharset.equals(actualCharset)) continue;
            Assert.fail((String)("\nExpected=" + expectedCharset.name() + "\n" + "  actual=" + actualCharset.name()));
        }
    }

    @Override
    public SqlTesterImpl withQuoting(Quoting quoting) {
        return this.with("quoting", quoting);
    }

    @Override
    public SqlTester withQuotedCasing(Casing casing) {
        return this.with("quotedCasing", casing);
    }

    @Override
    public SqlTester withUnquotedCasing(Casing casing) {
        return this.with("unquotedCasing", casing);
    }

    @Override
    public SqlTester withCaseSensitive(boolean sensitive) {
        return this.with("caseSensitive", sensitive);
    }

    @Override
    public SqlTester withLex(Lex lex) {
        return this.withQuoting(lex.quoting).withCaseSensitive(lex.caseSensitive).withQuotedCasing(lex.quotedCasing).withUnquotedCasing(lex.unquotedCasing);
    }

    @Override
    public SqlTesterImpl withConformance(SqlConformance conformance) {
        if (conformance == null) {
            conformance = SqlConformance.DEFAULT;
        }
        return this.with("conformance", conformance);
    }

    private SqlTesterImpl with(final String name2, final Object value) {
        return new SqlTesterImpl(new DelegatingSqlTestFactory(this.factory){

            public Object get(String name) {
                if (name.equals(name2)) {
                    return value;
                }
                return super.get(name);
            }
        });
    }

    @Override
    public void setFor(SqlOperator operator, SqlTester.VmName ... unimplementedVmNames) {
    }

    @Override
    public void checkAgg(String expr, String[] inputValues, Object result, double delta) {
        String query = SqlTests.generateAggQuery(expr, inputValues);
        this.check(query, SqlTests.ANY_TYPE_CHECKER, result, delta);
    }

    @Override
    public void checkWinAgg(String expr, String[] inputValues, String windowSpec, String type, Object result, double delta) {
        String query = SqlTests.generateWinAggQuery(expr, windowSpec, inputValues);
        this.check(query, SqlTests.ANY_TYPE_CHECKER, result, delta);
    }

    @Override
    public void checkScalar(String expression, Object result, String resultType) {
        this.checkType(expression, resultType);
        for (String sql : this.buildQueries(expression)) {
            this.check(sql, SqlTests.ANY_TYPE_CHECKER, result, 0.0);
        }
    }

    @Override
    public void checkScalarExact(String expression, String result) {
        for (String sql : this.buildQueries(expression)) {
            this.check(sql, SqlTests.INTEGER_TYPE_CHECKER, result, 0.0);
        }
    }

    @Override
    public void checkScalarExact(String expression, String expectedType, String result) {
        for (String sql : this.buildQueries(expression)) {
            SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
            this.check(sql, typeChecker, result, 0.0);
        }
    }

    @Override
    public void checkScalarApprox(String expression, String expectedType, double expectedResult, double delta) {
        for (String sql : this.buildQueries(expression)) {
            SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
            this.check(sql, typeChecker, new Double(expectedResult), delta);
        }
    }

    @Override
    public void checkBoolean(String expression, Boolean result) {
        for (String sql : this.buildQueries(expression)) {
            if (null == result) {
                this.checkNull(expression);
                continue;
            }
            this.check(sql, SqlTests.BOOLEAN_TYPE_CHECKER, result.toString(), 0.0);
        }
    }

    @Override
    public void checkString(String expression, String result, String expectedType) {
        for (String sql : this.buildQueries(expression)) {
            SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
            this.check(sql, typeChecker, result, 0.0);
        }
    }

    @Override
    public void checkNull(String expression) {
        for (String sql : this.buildQueries(expression)) {
            this.check(sql, SqlTests.ANY_TYPE_CHECKER, null, 0.0);
        }
    }

    @Override
    public final void check(String query, SqlTester.TypeChecker typeChecker, Object result, double delta) {
        this.check(query, typeChecker, SqlTests.createChecker(result, delta));
    }

    @Override
    public void check(String query, SqlTester.TypeChecker typeChecker, SqlTester.ResultChecker resultChecker) {
        RelDataType actualType = this.getColumnType(query);
        typeChecker.checkType(actualType);
    }

    @Override
    public void checkRewrite(SqlValidator validator, String query, String expectedRewrite) {
        SqlNode rewrittenNode = this.parseAndValidate(validator, query);
        String actualRewrite = rewrittenNode.toSqlString(SqlDialect.DUMMY, false).getSql();
        TestUtil.assertEqualsVerbose(expectedRewrite, Util.toLinux((String)actualRewrite));
    }

    @Override
    public void checkFails(String expression, String expectedError, boolean runtime) {
        if (runtime) {
            SqlValidator validator = this.getValidator();
            String sql = SqlTesterImpl.buildQuery(expression);
            SqlNode n = this.parseAndValidate(validator, sql);
            Assert.assertNotNull((Object)n);
        } else {
            this.checkQueryFails(SqlTesterImpl.buildQuery(expression), expectedError);
        }
    }

    @Override
    public void checkQueryFails(String sql, String expectedError) {
        this.assertExceptionIsThrown(sql, expectedError);
    }

    @Override
    public void checkQuery(String sql) {
        this.assertExceptionIsThrown(sql, null);
    }

    @Override
    public SqlMonotonicity getMonotonicity(String sql) {
        SqlValidator validator = this.getValidator();
        SqlNode node = this.parseAndValidate(validator, sql);
        SqlSelect select = (SqlSelect)node;
        SqlNode selectItem0 = select.getSelectList().get(0);
        SqlValidatorScope scope = validator.getSelectScope(select);
        return selectItem0.getMonotonicity(scope);
    }

    public static String buildQuery(String expression) {
        return "values (" + expression + ")";
    }

    public static String buildQueryAgg(String expression) {
        return "select " + expression + " from (values (1)) as t(x) group by x";
    }

    private String buildQuery2(String expression) {
        SqlNode x;
        String sql = "values (" + expression + ")";
        try {
            x = this.parseQuery(sql);
        }
        catch (SqlParseException e) {
            throw new RuntimeException(e);
        }
        final LinkedHashSet literalSet = new LinkedHashSet();
        x.accept((SqlVisitor)new SqlShuttle(){
            private final List<SqlOperator> ops = ImmutableList.of((Object)SqlStdOperatorTable.LITERAL_CHAIN, (Object)SqlStdOperatorTable.LOCALTIME, (Object)SqlStdOperatorTable.LOCALTIMESTAMP, (Object)SqlStdOperatorTable.CURRENT_TIME, (Object)SqlStdOperatorTable.CURRENT_TIMESTAMP);

            public SqlNode visit(SqlLiteral literal) {
                if (!this.isNull((SqlNode)literal) && literal.getTypeName() != SqlTypeName.SYMBOL) {
                    literalSet.add(literal);
                }
                return literal;
            }

            public SqlNode visit(SqlCall call) {
                SqlOperator operator = call.getOperator();
                if (operator == SqlStdOperatorTable.CAST && this.isNull(call.operand(0))) {
                    literalSet.add(call);
                    return call;
                }
                if (this.ops.contains(operator)) {
                    return call;
                }
                return super.visit(call);
            }

            private boolean isNull(SqlNode sqlNode) {
                return sqlNode instanceof SqlLiteral && ((SqlLiteral)sqlNode).getTypeName() == SqlTypeName.NULL;
            }
        });
        ArrayList nodes = new ArrayList(literalSet);
        Collections.sort(nodes, new Comparator<SqlNode>(){

            @Override
            public int compare(SqlNode o1, SqlNode o2) {
                SqlParserPos pos0 = o1.getParserPosition();
                SqlParserPos pos1 = o2.getParserPosition();
                int c = -Utilities.compare((int)pos0.getLineNum(), (int)pos1.getLineNum());
                if (c != 0) {
                    return c;
                }
                return -Utilities.compare((int)pos0.getColumnNum(), (int)pos1.getColumnNum());
            }
        });
        String sql2 = sql;
        ArrayList<Pair> values = new ArrayList<Pair>();
        int p = 0;
        for (SqlNode literal : nodes) {
            SqlParserPos pos = literal.getParserPosition();
            int start = SqlParserUtil.lineColToIndex((String)sql, (int)pos.getLineNum(), (int)pos.getColumnNum());
            int end = SqlParserUtil.lineColToIndex((String)sql, (int)pos.getEndLineNum(), (int)pos.getEndColumnNum()) + 1;
            String param = "p" + p++;
            values.add(Pair.of((Object)sql2.substring(start, end), (Object)param));
            sql2 = sql2.substring(0, start) + param + sql2.substring(end);
        }
        if (values.isEmpty()) {
            values.add(Pair.of((Object)"1", (Object)"p0"));
        }
        return "select " + sql2.substring("values (".length(), sql2.length() - 1) + " from (values (" + Util.commaList((List)Pair.left(values)) + ")) as t(" + Util.commaList((List)Pair.right(values)) + ")";
    }

    private Iterable<String> buildQueries(final String expression) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int i = 0;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public String next() {
                        switch (this.i++) {
                            case 0: {
                                return SqlTesterImpl.buildQuery(expression);
                            }
                            case 1: {
                                return SqlTesterImpl.this.buildQuery2(expression);
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < 2;
                    }
                };
            }
        };
    }

    @Override
    public boolean isVm(SqlTester.VmName vmName) {
        return false;
    }
}

