/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.type.SqlTypeFactoryImpl;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.TestUtil;
import org.eigenbase.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class RelOptUtilTest {
    @Test
    public void testTypeDump() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl();
        RelDataType t1 = typeFactory.builder().add("f0", SqlTypeName.DECIMAL, 5, 2).add("f1", SqlTypeName.VARCHAR, 10).build();
        TestUtil.assertEqualsVerbose(TestUtil.fold("f0 DECIMAL(5, 2) NOT NULL,", "f1 VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL"), Util.toLinux((String)(RelOptUtil.dumpType((RelDataType)t1) + "\n")));
        RelDataType t2 = typeFactory.builder().add("f0", t1).add("f1", typeFactory.createMultisetType(t1, -1L)).build();
        TestUtil.assertEqualsVerbose(TestUtil.fold("f0 RECORD (", "  f0 DECIMAL(5, 2) NOT NULL,", "  f1 VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL) NOT NULL,", "f1 RECORD (", "  f0 DECIMAL(5, 2) NOT NULL,", "  f1 VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL) NOT NULL MULTISET NOT NULL"), Util.toLinux((String)(RelOptUtil.dumpType((RelDataType)t2) + "\n")));
    }

    @Test
    public void testRuleGuessDescription() {
        Assert.assertEquals((Object)"Bar", (Object)RelOptRule.guessDescription((String)"com.foo.Bar"));
        Assert.assertEquals((Object)"Baz", (Object)RelOptRule.guessDescription((String)"com.flatten.Bar$Baz"));
        try {
            Util.discard((Object)RelOptRule.guessDescription((String)"com.foo.Bar$1"));
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Derived description of rule class com.foo.Bar$1 is an integer, not valid. Supply a description manually.", (Object)e.getMessage());
        }
    }
}

