/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import com.google.common.collect.ImmutableMultiset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.JavaRules;
import net.hydromatic.optiq.test.OptiqAssert;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.util.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TableInRootSchemaTest {
    @Test
    public void testAddingTableInRootSchema() throws Exception {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        optiqConnection.getRootSchema().add("SAMPLE", (Table)new SimpleTable());
        Statement statement = optiqConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("select A, SUM(B) from SAMPLE group by A");
        Assert.assertThat((Object)ImmutableMultiset.of((Object)"A=foo; EXPR$1=8", (Object)"A=bar; EXPR$1=4"), (Matcher)CoreMatchers.equalTo(OptiqAssert.toSet(resultSet)));
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertThat((Object)resultSetMetaData.getColumnName(1), (Matcher)CoreMatchers.equalTo((Object)"A"));
        Assert.assertThat((Object)resultSetMetaData.getTableName(1), (Matcher)CoreMatchers.equalTo((Object)"SAMPLE"));
        Assert.assertThat((Object)resultSetMetaData.getSchemaName(1), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSetMetaData.getColumnName(2), (Matcher)CoreMatchers.equalTo((Object)"EXPR$1"));
        Assert.assertThat((Object)resultSetMetaData.getTableName(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSetMetaData.getSchemaName(2), (Matcher)CoreMatchers.nullValue());
        resultSet.close();
        statement.close();
        connection.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleTable
    extends AbstractQueryableTable
    implements TranslatableTable {
        private String[] columnNames = new String[]{"A", "B"};
        private Class[] columnTypes = new Class[]{String.class, Integer.class};
        private Object[][] rows = new Object[3][];

        SimpleTable() {
            super(Object[].class);
            this.rows[0] = new Object[]{"foo", 5};
            this.rows[1] = new Object[]{"bar", 4};
            this.rows[2] = new Object[]{"foo", 3};
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            int columnCount = this.columnNames.length;
            ArrayList<Pair> columnDesc = new ArrayList<Pair>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                RelDataType colType = typeFactory.createJavaType(this.columnTypes[i]);
                columnDesc.add(Pair.of((Object)this.columnNames[i], (Object)colType));
            }
            return typeFactory.createStructType(columnDesc);
        }

        public Iterator<Object[]> iterator() {
            return Linq4j.enumeratorIterator(this.enumerator());
        }

        public Enumerator<Object[]> enumerator() {
            return this.enumeratorImpl(null);
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<T> enumerator() {
                    return SimpleTable.this.enumeratorImpl(null);
                }
            };
        }

        private Enumerator<Object[]> enumeratorImpl(final int[] fields) {
            return new Enumerator<Object[]>(){
                private Object[] current;
                private Iterator<Object[]> iterator;
                {
                    this.iterator = Arrays.asList(SimpleTable.this.rows).iterator();
                }

                public Object[] current() {
                    return this.current;
                }

                public boolean moveNext() {
                    if (this.iterator.hasNext()) {
                        Object[] full = this.iterator.next();
                        this.current = fields != null ? this.convertRow(full) : full;
                        return true;
                    }
                    this.current = null;
                    return false;
                }

                public void reset() {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                }

                private Object[] convertRow(Object[] full) {
                    Object[] objects = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        objects[i] = full[fields[i]];
                    }
                    return objects;
                }
            };
        }

        public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
            return new JavaRules.EnumerableTableAccessRel(context.getCluster(), context.getCluster().traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE}), relOptTable, (Class)this.getElementType());
        }
    }
}

