/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import net.hydromatic.optiq.model.JsonColumn;
import net.hydromatic.optiq.model.JsonCustomSchema;
import net.hydromatic.optiq.model.JsonJdbcSchema;
import net.hydromatic.optiq.model.JsonMapSchema;
import net.hydromatic.optiq.model.JsonRoot;
import net.hydromatic.optiq.model.JsonTable;
import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.test.OptiqAssert;
import org.junit.Assert;
import org.junit.Test;

public class ModelTest {
    private ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return mapper;
    }

    @Test
    public void testRead() throws IOException {
        ObjectMapper mapper = this.mapper();
        JsonRoot root = (JsonRoot)mapper.readValue("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'FoodMart',\n       tables: [\n         {\n           name: 'time_by_day',\n           columns: [\n             {\n               name: 'time_id'\n             }\n           ]\n         },\n         {\n           name: 'sales_fact_1997',\n           columns: [\n             {\n               name: 'time_id'\n             }\n           ]\n         }\n       ]\n     }\n   ]\n}", JsonRoot.class);
        Assert.assertEquals((Object)"1.0", (Object)root.version);
        Assert.assertEquals((long)1L, (long)root.schemas.size());
        JsonMapSchema schema = (JsonMapSchema)root.schemas.get(0);
        Assert.assertEquals((Object)"FoodMart", (Object)schema.name);
        Assert.assertEquals((long)2L, (long)schema.tables.size());
        JsonTable table0 = (JsonTable)schema.tables.get(0);
        Assert.assertEquals((Object)"time_by_day", (Object)table0.name);
        JsonTable table1 = (JsonTable)schema.tables.get(1);
        Assert.assertEquals((Object)"sales_fact_1997", (Object)table1.name);
        Assert.assertEquals((long)1L, (long)table0.columns.size());
        JsonColumn column = (JsonColumn)table0.columns.get(0);
        Assert.assertEquals((Object)"time_id", (Object)column.name);
    }

    @Test
    public void testSubtype() throws IOException {
        ObjectMapper mapper = this.mapper();
        JsonRoot root = (JsonRoot)mapper.readValue("{\n  version: '1.0',\n   schemas: [\n     {\n       type: 'jdbc',\n       name: 'FoodMart',\n       jdbcUser: 'u_baz',\n       jdbcPassword: 'p_baz',\n       jdbcUrl: 'jdbc:baz',\n       jdbcCatalog: 'cat_baz',\n       jdbcSchema: ''\n     }\n   ]\n}", JsonRoot.class);
        Assert.assertEquals((Object)"1.0", (Object)root.version);
        Assert.assertEquals((long)1L, (long)root.schemas.size());
        JsonJdbcSchema schema = (JsonJdbcSchema)root.schemas.get(0);
        Assert.assertEquals((Object)"FoodMart", (Object)schema.name);
    }

    @Test
    public void testCustomSchema() throws IOException {
        ObjectMapper mapper = this.mapper();
        JsonRoot root = (JsonRoot)mapper.readValue("{\n  version: '1.0',\n   schemas: [\n     {\n       type: 'custom',\n       name: 'My Custom Schema',\n       factory: 'com.acme.MySchemaFactory',\n       operand: {a: 'foo', b: [1, 3.5] }\n     }\n   ]\n}", JsonRoot.class);
        Assert.assertEquals((Object)"1.0", (Object)root.version);
        Assert.assertEquals((long)1L, (long)root.schemas.size());
        JsonCustomSchema schema = (JsonCustomSchema)root.schemas.get(0);
        Assert.assertEquals((Object)"My Custom Schema", (Object)schema.name);
        Assert.assertEquals((Object)"com.acme.MySchemaFactory", (Object)schema.factory);
        Assert.assertEquals((Object)"foo", schema.operand.get("a"));
        Assert.assertNull(schema.operand.get("c"));
        Assert.assertTrue((boolean)(schema.operand.get("b") instanceof List));
        List list = (List)schema.operand.get("b");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)1, list.get(0));
        Assert.assertEquals((Object)3.5, list.get(1));
    }

    @Test
    public void testModelImmutableSchemaCannotContainMaterialization() throws Exception {
        OptiqAssert.AssertThat that = OptiqAssert.that().withModel("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [\n    {\n      name: 'empty'\n    },\n    {\n      name: 'adhoc',\n      type: 'custom',\n      factory: '" + JdbcTest.MySchemaFactory.class.getName() + "',\n" + "      operand: {\n" + "           'tableName': 'ELVIS',\n" + "           'mutable': false\n" + "      },\n" + "      materializations: [\n" + "        {\n" + "          table: 'v',\n" + "          sql: 'values (1)'\n" + "        }\n" + "      ]\n" + "    }\n" + "  ]\n" + "}");
        that.connectThrows("Cannot define materialization; parent schema 'adhoc' is not a SemiMutableSchema");
    }
}

