/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.test.OptiqAssert;
import org.junit.Test;

public class JdbcAdapterTest {
    @Test
    public void testUnionPlan() {
        OptiqAssert.that().withModel(JdbcTest.FOODMART_MODEL).query("select * from \"sales_fact_1997\"\nunion all\nselect * from \"sales_fact_1998\"").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcUnionRel(all=[true])\n    JdbcTableScan(table=[[foodmart, sales_fact_1997]])\n    JdbcTableScan(table=[[foodmart, sales_fact_1998]])").runs().enable(OptiqAssert.CONNECTION_SPEC.url.startsWith("jdbc:hsqldb:")).planHasSql("SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nUNION ALL\nSELECT *\nFROM \"foodmart\".\"sales_fact_1998\"");
    }

    @Test
    public void testFilterUnionPlan() {
        OptiqAssert.that().withModel(JdbcTest.FOODMART_MODEL).query("select * from (\n  select * from \"sales_fact_1997\"\n  union all\n  select * from \"sales_fact_1998\")\nwhere \"product_id\" = 1").runs().enable(OptiqAssert.CONNECTION_SPEC.url.startsWith("jdbc:hsqldb:")).planHasSql("SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nWHERE \"product_id\" = 1\nUNION ALL\nSELECT *\nFROM \"foodmart\".\"sales_fact_1998\"\nWHERE \"product_id\" = 1");
    }

    @Test
    public void testInPlan() {
        OptiqAssert.that().withModel(JdbcTest.FOODMART_MODEL).query("select \"store_id\", \"store_name\" from \"store\"\nwhere \"store_name\" in ('Store 1', 'Store 10', 'Store 11', 'Store 15', 'Store 16', 'Store 24', 'Store 3', 'Store 7')").runs().enable(OptiqAssert.CONNECTION_SPEC.url.startsWith("jdbc:hsqldb:")).planHasSql("SELECT \"store_id\", \"store_name\"\nFROM \"foodmart\".\"store\"\nWHERE \"store_name\" = 'Store 1' OR \"store_name\" = 'Store 10' OR \"store_name\" = 'Store 11' OR \"store_name\" = 'Store 15' OR \"store_name\" = 'Store 16' OR \"store_name\" = 'Store 24' OR \"store_name\" = 'Store 3' OR \"store_name\" = 'Store 7'").returns("store_id=1; store_name=Store 1\nstore_id=3; store_name=Store 3\nstore_id=7; store_name=Store 7\nstore_id=10; store_name=Store 10\nstore_id=11; store_name=Store 11\nstore_id=15; store_name=Store 15\nstore_id=16; store_name=Store 16\nstore_id=24; store_name=Store 24\n");
    }
}

