/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import java.util.AbstractList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

public class SetopOperandTypeChecker
implements SqlOperandTypeChecker {
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int i;
        assert (callBinding.getOperandCount() == 2) : "setops are binary (for now)";
        final RelDataType[] argTypes = new RelDataType[callBinding.getOperandCount()];
        int colCount = -1;
        SqlValidator validator = callBinding.getValidator();
        for (i = 0; i < argTypes.length; ++i) {
            RelDataType argType = argTypes[i] = callBinding.getOperandType(i);
            Util.permAssert(argType.isStruct(), "setop arg must be a struct");
            List<RelDataTypeField> fields = argType.getFieldList();
            if (i == 0) {
                colCount = fields.size();
                continue;
            }
            if (fields.size() == colCount) continue;
            if (throwOnFailure) {
                Object node = callBinding.getCall().operand(i);
                if (node instanceof SqlSelect) {
                    node = ((SqlSelect)node).getSelectList();
                }
                throw validator.newValidationError((SqlNode)node, Static.RESOURCE.columnCountMismatchInSetop(callBinding.getOperator().getName()));
            }
            return false;
        }
        i = 0;
        while (i < colCount) {
            final int i2 = i++;
            RelDataType type = callBinding.getTypeFactory().leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return argTypes[index].getFieldList().get(i2).getType();
                }

                @Override
                public int size() {
                    return argTypes.length;
                }
            });
            if (type != null) continue;
            if (throwOnFailure) {
                SqlNode field = SqlUtil.getSelectListItem(callBinding.getCall().operand(0), i);
                throw validator.newValidationError(field, Static.RESOURCE.columnTypeMismatchInSetop(i + 1, callBinding.getOperator().getName()));
            }
            return false;
        }
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "{0} " + opName + " {1}";
    }
}

