/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypePrecedenceList;
import org.eigenbase.resource.Resources;
import org.eigenbase.sql.SqlAbstractStringLiteral;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlBasicCall;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlJoin;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSetOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.BarfingInvocationHandler;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;
import org.eigenbase.util14.ConversionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlUtil {
    static SqlNode andExpressions(SqlNode node1, SqlNode node2) {
        if (node1 == null) {
            return node2;
        }
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        if (node1.getKind() == SqlKind.AND) {
            list.addAll(((SqlCall)node1).getOperandList());
        } else {
            list.add(node1);
        }
        if (node2.getKind() == SqlKind.AND) {
            list.addAll(((SqlCall)node2).getOperandList());
        } else {
            list.add(node2);
        }
        return SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, list);
    }

    static ArrayList<SqlNode> flatten(SqlNode node) {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        SqlUtil.flatten(node, list);
        return list;
    }

    public static SqlNode getFromNode(SqlSelect query, int ordinal) {
        ArrayList<SqlNode> list = SqlUtil.flatten(query.getFrom());
        return list.get(ordinal);
    }

    private static void flatten(SqlNode node, ArrayList<SqlNode> list) {
        switch (node.getKind()) {
            case JOIN: {
                SqlJoin join = (SqlJoin)node;
                SqlUtil.flatten(join.getLeft(), list);
                SqlUtil.flatten(join.getRight(), list);
                return;
            }
            case AS: {
                SqlCall call = (SqlCall)node;
                SqlUtil.flatten(call.operand(0), list);
                return;
            }
        }
        list.add(node);
    }

    public static SqlNodeList toNodeList(SqlNode[] operands) {
        SqlNodeList ret = new SqlNodeList(SqlParserPos.ZERO);
        for (SqlNode node : operands) {
            ret.add(node);
        }
        return ret;
    }

    public static boolean isNullLiteral(SqlNode node, boolean allowCast) {
        SqlCall call;
        if (node instanceof SqlLiteral) {
            SqlLiteral literal = (SqlLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (null == literal.getValue());
                return true;
            }
            return false;
        }
        return allowCast && node.getKind() == SqlKind.CAST && SqlUtil.isNullLiteral((call = (SqlCall)node).operand(0), false);
    }

    public static boolean isNull(SqlNode node) {
        return SqlUtil.isNullLiteral(node, false) || node.getKind() == SqlKind.CAST && SqlUtil.isNull(((SqlCall)node).operand(0));
    }

    public static boolean isLiteral(SqlNode node) {
        assert (node != null);
        return node instanceof SqlLiteral;
    }

    public static boolean isLiteralChain(SqlNode node) {
        assert (node != null);
        if (node instanceof SqlCall) {
            SqlCall call = (SqlCall)node;
            return call.getKind() == SqlKind.LITERAL_CHAIN;
        }
        return false;
    }

    public static void unparseFunctionSyntax(SqlOperator operator, SqlWriter writer, SqlCall call, boolean emptyParens, SqlLiteral quantifier) {
        if (operator instanceof SqlFunction) {
            SqlIdentifier id;
            SqlFunction function = (SqlFunction)operator;
            if (function.getFunctionType() == SqlFunctionCategory.USER_DEFINED_SPECIFIC_FUNCTION) {
                writer.keyword("SPECIFIC");
            }
            if ((id = function.getSqlIdentifier()) == null) {
                writer.keyword(operator.getName());
            } else {
                id.unparse(writer, 0, 0);
            }
        } else {
            writer.print(operator.getName());
        }
        if (call.operandCount() == 0 && !emptyParens) {
            return;
        }
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
        if (null != quantifier) {
            quantifier.unparse(writer, 0, 0);
        }
        if (call.operandCount() == 0 && operator instanceof SqlAggFunction) {
            writer.sep("*");
        }
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    public static void unparseBinarySyntax(SqlOperator operator, SqlCall call, SqlWriter writer, int leftPrec, int rightPrec) {
        SqlBinaryOperator binop = (SqlBinaryOperator)operator;
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startList(binop instanceof SqlSetOperator ? SqlWriter.FrameTypeEnum.SETOP : SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, binop.getLeftPrec());
        boolean needsSpace = binop.needsSpace();
        writer.setNeedWhitespace(needsSpace);
        writer.sep(binop.getName());
        writer.setNeedWhitespace(needsSpace);
        ((SqlNode)call.operand(1)).unparse(writer, binop.getRightPrec(), rightPrec);
        writer.endList(frame);
    }

    public static SqlLiteral concatenateLiterals(List<SqlLiteral> lits) {
        if (lits.size() == 1) {
            return lits.get(0);
        }
        return ((SqlAbstractStringLiteral)lits.get(0)).concat1(lits);
    }

    public static SqlFunction lookupRoutine(SqlOperatorTable opTab, SqlIdentifier funcName, List<RelDataType> argTypes, SqlFunctionCategory category) {
        List<SqlFunction> list = SqlUtil.lookupSubjectRoutines(opTab, funcName, argTypes, category);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static List<SqlFunction> lookupSubjectRoutines(SqlOperatorTable opTab, SqlIdentifier funcName, List<RelDataType> argTypes, SqlFunctionCategory category) {
        List<SqlFunction> routines = SqlUtil.lookupSubjectRoutinesByName(opTab, funcName, category);
        SqlUtil.filterRoutinesByParameterCount(routines, argTypes);
        if (category == SqlFunctionCategory.USER_DEFINED_PROCEDURE) {
            return routines;
        }
        SqlUtil.filterRoutinesByParameterType(routines, argTypes);
        if (routines.size() < 2) {
            return routines;
        }
        SqlUtil.filterRoutinesByTypePrecedence(routines, argTypes);
        return routines;
    }

    public static boolean matchRoutinesByParameterCount(SqlOperatorTable opTab, SqlIdentifier funcName, List<RelDataType> argTypes, SqlFunctionCategory category) {
        List<SqlFunction> routines = SqlUtil.lookupSubjectRoutinesByName(opTab, funcName, category);
        SqlUtil.filterRoutinesByParameterCount(routines, argTypes);
        return routines.size() > 0;
    }

    private static List<SqlFunction> lookupSubjectRoutinesByName(SqlOperatorTable opTab, SqlIdentifier funcName, SqlFunctionCategory category) {
        ArrayList operators = Lists.newArrayList();
        opTab.lookupOperatorOverloads(funcName, category, SqlSyntax.FUNCTION, operators);
        ArrayList<SqlFunction> routines = new ArrayList<SqlFunction>();
        for (SqlOperator operator : operators) {
            if (!(operator instanceof SqlFunction)) continue;
            routines.add((SqlFunction)operator);
        }
        return routines;
    }

    private static void filterRoutinesByParameterCount(List<SqlFunction> routines, List<RelDataType> argTypes) {
        Iterator<SqlFunction> iter = routines.iterator();
        while (iter.hasNext()) {
            SqlFunction function = iter.next();
            SqlOperandCountRange od = function.getOperandCountRange();
            if (od.isValidCount(argTypes.size())) continue;
            iter.remove();
        }
    }

    private static void filterRoutinesByParameterType(List<SqlFunction> routines, List<RelDataType> argTypes) {
        Iterator<SqlFunction> iter = routines.iterator();
        while (iter.hasNext()) {
            SqlFunction function = iter.next();
            List<RelDataType> paramTypes = function.getParamTypes();
            if (paramTypes == null) continue;
            assert (paramTypes.size() == argTypes.size());
            boolean keep = true;
            for (Pair<RelDataType, RelDataType> p : Pair.zip(paramTypes, argTypes)) {
                RelDataType argType = (RelDataType)p.right;
                RelDataType paramType = (RelDataType)p.left;
                RelDataTypePrecedenceList precList = argType.getPrecedenceList();
                if (precList.containsType(paramType)) continue;
                keep = false;
                break;
            }
            if (keep) continue;
            iter.remove();
        }
    }

    private static void filterRoutinesByTypePrecedence(List<SqlFunction> routines, List<RelDataType> argTypes) {
        for (int i = 0; i < argTypes.size(); ++i) {
            List<RelDataType> paramTypes;
            RelDataTypePrecedenceList precList = argTypes.get(i).getPrecedenceList();
            RelDataType bestMatch = null;
            for (SqlFunction function : routines) {
                paramTypes = function.getParamTypes();
                if (paramTypes == null) continue;
                RelDataType paramType = paramTypes.get(i);
                if (bestMatch == null) {
                    bestMatch = paramType;
                    continue;
                }
                int c = precList.compareTypePrecedence(bestMatch, paramType);
                if (c >= 0) continue;
                bestMatch = paramType;
            }
            if (bestMatch == null) continue;
            Iterator<SqlFunction> iter = routines.iterator();
            while (iter.hasNext()) {
                SqlFunction function;
                function = iter.next();
                paramTypes = function.getParamTypes();
                int c = paramTypes == null ? -1 : precList.compareTypePrecedence(paramTypes.get(i), bestMatch);
                if (c >= 0) continue;
                iter.remove();
            }
        }
    }

    public static SqlNode getSelectListItem(SqlNode query, int i) {
        switch (query.getKind()) {
            case SELECT: {
                SqlSelect select = (SqlSelect)query;
                SqlNode from = select.getFrom();
                if (from.getKind() == SqlKind.AS) {
                    SqlCall as = (SqlCall)from;
                    from = as.operand(0);
                }
                if (from.getKind() == SqlKind.VALUES) {
                    return SqlUtil.getSelectListItem(from, i);
                }
                SqlNodeList fields = select.getSelectList();
                if (i >= fields.size()) {
                    i = 0;
                }
                return fields.get(i);
            }
            case VALUES: {
                SqlCall call = (SqlCall)query;
                assert (call.operandCount() > 0) : "VALUES must have at least one operand";
                SqlCall row = (SqlCall)call.operand(0);
                assert (row.operandCount() > i) : "VALUES has too few columns";
                return row.operand(i);
            }
        }
        throw Util.needToImplement(query);
    }

    public static SqlCall makeCall(SqlOperatorTable opTab, SqlIdentifier id) {
        if (id.names.size() == 1) {
            ArrayList list = Lists.newArrayList();
            opTab.lookupOperatorOverloads(id, null, SqlSyntax.FUNCTION, list);
            for (SqlOperator operator : list) {
                if (operator.getSyntax() != SqlSyntax.FUNCTION_ID) continue;
                return new SqlBasicCall(operator, SqlNode.EMPTY_ARRAY, id.getParserPosition(), true, null);
            }
        }
        return null;
    }

    public static String deriveAliasFromOrdinal(int ordinal) {
        return "EXPR$" + ordinal;
    }

    public static String getOperatorSignature(SqlOperator op, List<?> typeList) {
        return SqlUtil.getAliasedSignature(op, op.getName(), typeList);
    }

    public static String getAliasedSignature(SqlOperator op, String opName, List<?> typeList) {
        StringBuilder ret = new StringBuilder();
        String template = op.getSignatureTemplate(typeList.size());
        if (null == template) {
            ret.append("'");
            ret.append(opName);
            ret.append("(");
            for (int i = 0; i < typeList.size(); ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append("<").append(typeList.get(i).toString().toUpperCase()).append(">");
            }
            ret.append(")'");
        } else {
            Object[] values = new Object[typeList.size() + 1];
            values[0] = opName;
            ret.append("'");
            for (int i = 0; i < typeList.size(); ++i) {
                values[i + 1] = "<" + typeList.get(i).toString().toUpperCase() + ">";
            }
            ret.append(MessageFormat.format(template, values));
            ret.append("'");
            assert (typeList.size() + 1 == values.length);
        }
        return ret.toString();
    }

    public static EigenbaseException newContextException(SqlParserPos pos, Resources.ExInst<?> e, String inputText) {
        EigenbaseContextException ex = SqlUtil.newContextException(pos, e);
        ex.setOriginalStatement(inputText);
        return ex;
    }

    public static EigenbaseContextException newContextException(SqlParserPos pos, Resources.ExInst<?> e) {
        int line = pos.getLineNum();
        int col = pos.getColumnNum();
        int endLine = pos.getEndLineNum();
        int endCol = pos.getEndColumnNum();
        return SqlUtil.newContextException(line, col, endLine, endCol, e);
    }

    public static EigenbaseContextException newContextException(int line, int col, int endLine, int endCol, Resources.ExInst<?> e) {
        EigenbaseContextException contextExcn = (line == endLine && col == endCol ? Static.RESOURCE.validatorContextPoint(line, col) : Static.RESOURCE.validatorContext(line, col, endLine, endCol)).ex((Throwable)e.ex());
        contextExcn.setPosition(line, col, endLine, endCol);
        return contextExcn;
    }

    public static boolean isCallTo(SqlNode node, SqlOperator operator) {
        return node instanceof SqlCall && ((SqlCall)node).getOperator() == operator;
    }

    public static RelDataType createNlsStringType(RelDataTypeFactory typeFactory, NlsString str) {
        SqlCollation collation;
        Charset charset = str.getCharset();
        if (null == charset) {
            charset = typeFactory.getDefaultCharset();
        }
        if (null == (collation = str.getCollation())) {
            collation = SqlCollation.COERCIBLE;
        }
        RelDataType type = typeFactory.createSqlType(SqlTypeName.CHAR, str.getValue().length());
        type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        return type;
    }

    public static String translateCharacterSetName(String name) {
        if (name.equals("LATIN1")) {
            return "ISO-8859-1";
        }
        if (name.equals("UTF16")) {
            return ConversionUtil.NATIVE_UTF16_CHARSET_NAME;
        }
        if (name.equals(ConversionUtil.NATIVE_UTF16_CHARSET_NAME)) {
            return name;
        }
        if (name.equals("ISO-8859-1")) {
            return name;
        }
        return null;
    }

    public static class DatabaseMetaDataInvocationHandler
    extends BarfingInvocationHandler {
        private final String databaseProductName;
        private final String identifierQuoteString;

        public DatabaseMetaDataInvocationHandler(String databaseProductName, String identifierQuoteString) {
            this.databaseProductName = databaseProductName;
            this.identifierQuoteString = identifierQuoteString;
        }

        public String getDatabaseProductName() throws SQLException {
            return this.databaseProductName;
        }

        public String getIdentifierQuoteString() throws SQLException {
            return this.identifierQuoteString;
        }
    }
}

