/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sarg;

import java.util.Set;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sarg.SargBoundType;
import org.eigenbase.sarg.SargExpr;
import org.eigenbase.sarg.SargFactory;
import org.eigenbase.sarg.SargInterval;
import org.eigenbase.sarg.SargIntervalBase;
import org.eigenbase.sarg.SargIntervalSequence;
import org.eigenbase.sarg.SargStrictness;
import org.eigenbase.sql.SqlNullSemantics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SargIntervalExpr
extends SargIntervalBase
implements SargExpr {
    private SqlNullSemantics nullSemantics;

    SargIntervalExpr(SargFactory factory, RelDataType dataType, SqlNullSemantics nullSemantics) {
        super(factory, dataType);
        this.nullSemantics = nullSemantics;
    }

    public SqlNullSemantics getNullSemantics() {
        return this.nullSemantics;
    }

    @Override
    public void setPoint(RexNode coordinate) {
        super.setPoint(coordinate);
        if (RexLiteral.isNullLiteral(coordinate) && this.nullSemantics == SqlNullSemantics.NULL_MATCHES_NOTHING) {
            this.nullSemantics = SqlNullSemantics.NULL_MATCHES_NULL;
        }
    }

    @Override
    public void setNull() {
        super.setNull();
    }

    @Override
    public void setLower(RexNode coordinate, SargStrictness strictness) {
        super.setLower(coordinate, strictness);
    }

    @Override
    public void setUpper(RexNode coordinate, SargStrictness strictness) {
        super.setUpper(coordinate, strictness);
    }

    @Override
    public void unsetLower() {
        super.unsetLower();
    }

    @Override
    public void unsetUpper() {
        super.unsetUpper();
    }

    @Override
    public void setUnconstrained() {
        super.setUnconstrained();
    }

    @Override
    public void setEmpty() {
        super.setEmpty();
    }

    @Override
    public String toString() {
        String s = super.toString();
        if (this.nullSemantics == SqlNullSemantics.NULL_MATCHES_NOTHING) {
            return s;
        }
        return s + " " + (Object)((Object)this.nullSemantics);
    }

    @Override
    public SargIntervalSequence evaluate() {
        SargIntervalSequence seq = new SargIntervalSequence();
        if (this.lowerBound.getBoundType() != SargBoundType.LOWER || this.upperBound.getBoundType() != SargBoundType.UPPER) {
            return seq;
        }
        if (this.nullSemantics == SqlNullSemantics.NULL_MATCHES_NOTHING && (this.lowerBound.isNull() || this.upperBound.isNull())) {
            return seq;
        }
        SargInterval interval = new SargInterval(this.factory, this.getDataType());
        interval.copyFrom(this);
        if (this.nullSemantics == SqlNullSemantics.NULL_MATCHES_NOTHING && this.getDataType().isNullable() && (this.lowerBound.isFinite() || this.upperBound.isFinite()) && (!this.lowerBound.isFinite() || this.lowerBound.isNull())) {
            interval.setLower(this.factory.newNullLiteral(), SargStrictness.OPEN);
        } else if (this.nullSemantics == SqlNullSemantics.NULL_MATCHES_ANYTHING && (!this.lowerBound.isFinite() || this.lowerBound.isNull() || this.upperBound.isNull())) {
            interval.setUnconstrained();
        }
        seq.addInterval(interval);
        return seq;
    }

    @Override
    public void collectDynamicParams(Set<RexDynamicParam> dynamicParams) {
        if (this.lowerBound.getCoordinate() instanceof RexDynamicParam) {
            dynamicParams.add((RexDynamicParam)this.lowerBound.getCoordinate());
        }
        if (this.upperBound.getCoordinate() instanceof RexDynamicParam) {
            dynamicParams.add((RexDynamicParam)this.upperBound.getCoordinate());
        }
    }

    @Override
    public SargIntervalSequence evaluateComplemented() {
        SargIntervalSequence originalSeq = this.evaluate();
        SargIntervalSequence seq = new SargIntervalSequence();
        if (originalSeq.getList().isEmpty()) {
            seq.addInterval(new SargInterval(this.factory, this.getDataType()));
            return seq;
        }
        assert (originalSeq.getList().size() == 1);
        SargInterval originalInterval = originalSeq.getList().get(0);
        if (originalInterval.isUnconstrained()) {
            return seq;
        }
        SargInterval interval = new SargInterval(this.factory, this.getDataType());
        interval.setLower(this.factory.newNullLiteral(), SargStrictness.OPEN);
        if (originalInterval.getUpperBound().isFinite() && originalInterval.getLowerBound().isFinite()) {
            interval.setUpper(originalInterval.getLowerBound().getCoordinate(), originalInterval.getLowerBound().getStrictnessComplement());
            if (!originalInterval.getLowerBound().isNull()) {
                seq.addInterval(interval);
            }
            interval = new SargInterval(this.factory, this.getDataType());
            interval.setLower(originalInterval.getUpperBound().getCoordinate(), originalInterval.getUpperBound().getStrictnessComplement());
            seq.addInterval(interval);
        } else if (originalInterval.getLowerBound().isFinite()) {
            interval.setUpper(originalInterval.getLowerBound().getCoordinate(), originalInterval.getLowerBound().getStrictnessComplement());
            if (!originalInterval.getLowerBound().isNull()) {
                seq.addInterval(interval);
            }
        } else {
            assert (originalInterval.getUpperBound().isFinite());
            interval.setLower(originalInterval.getUpperBound().getCoordinate(), originalInterval.getUpperBound().getStrictnessComplement());
            seq.addInterval(interval);
        }
        return seq;
    }
}

