/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.fun.SqlStdOperatorTable;

public class RelMdColumnUniqueness {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.COLUMN_UNIQUENESS.method, new RelMdColumnUniqueness());

    private RelMdColumnUniqueness() {
    }

    public Boolean areColumnsUnique(FilterRelBase rel, BitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getChild(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(SortRel rel, BitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getChild(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(CorrelatorRel rel, BitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getLeft(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(ProjectRelBase rel, BitSet columns, boolean ignoreNulls) {
        List<RexNode> projExprs = rel.getProjects();
        BitSet childColumns = new BitSet();
        for (int bit : BitSets.toIter(columns)) {
            RelDataType origType;
            RelDataTypeFactory typeFactory;
            RelDataType castType;
            RexNode castOperand;
            RexCall call;
            RexNode projExpr = projExprs.get(bit);
            if (projExpr instanceof RexInputRef) {
                childColumns.set(((RexInputRef)projExpr).getIndex());
                continue;
            }
            if (!(projExpr instanceof RexCall) || !ignoreNulls || (call = (RexCall)projExpr).getOperator() != SqlStdOperatorTable.CAST || !((castOperand = call.getOperands().get(0)) instanceof RexInputRef) || !(castType = (typeFactory = rel.getCluster().getTypeFactory()).createTypeWithNullability(projExpr.getType(), true)).equals(origType = typeFactory.createTypeWithNullability(castOperand.getType(), true))) continue;
            childColumns.set(((RexInputRef)castOperand).getIndex());
        }
        if (childColumns.cardinality() == 0) {
            return null;
        }
        return RelMetadataQuery.areColumnsUnique(rel.getChild(), childColumns, ignoreNulls);
    }

    public Boolean areColumnsUnique(JoinRelBase rel, BitSet columns, boolean ignoreNulls) {
        if (columns.cardinality() == 0) {
            return false;
        }
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        BitSet leftColumns = new BitSet();
        BitSet rightColumns = new BitSet();
        int nLeftColumns = left.getRowType().getFieldCount();
        for (int bit : BitSets.toIter(columns)) {
            if (bit < nLeftColumns) {
                leftColumns.set(bit);
                continue;
            }
            rightColumns.set(bit - nLeftColumns);
        }
        Boolean leftUnique = RelMetadataQuery.areColumnsUnique(left, leftColumns, ignoreNulls);
        Boolean rightUnique = RelMetadataQuery.areColumnsUnique(right, rightColumns, ignoreNulls);
        if (leftColumns.cardinality() > 0 && rightColumns.cardinality() > 0) {
            if (leftUnique == null || rightUnique == null) {
                return null;
            }
            return leftUnique != false && rightUnique != false;
        }
        BitSet leftJoinCols = new BitSet();
        BitSet rightJoinCols = new BitSet();
        RelMdUtil.findEquiJoinCols(left, right, rel.getCondition(), leftJoinCols, rightJoinCols);
        if (leftColumns.cardinality() > 0) {
            if (rel.getJoinType().generatesNullsOnLeft()) {
                return false;
            }
            Boolean rightJoinColsUnique = RelMetadataQuery.areColumnsUnique(right, rightJoinCols, ignoreNulls);
            if (rightJoinColsUnique == null || leftUnique == null) {
                return null;
            }
            return rightJoinColsUnique != false && leftUnique != false;
        }
        if (rightColumns.cardinality() > 0) {
            if (rel.getJoinType().generatesNullsOnRight()) {
                return false;
            }
            Boolean leftJoinColsUnique = RelMetadataQuery.areColumnsUnique(left, leftJoinCols, ignoreNulls);
            if (leftJoinColsUnique == null || rightUnique == null) {
                return null;
            }
            return leftJoinColsUnique != false && rightUnique != false;
        }
        throw new AssertionError();
    }

    public Boolean areColumnsUnique(SemiJoinRel rel, BitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getLeft(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(AggregateRelBase rel, BitSet columns, boolean ignoreNulls) {
        if (rel.getGroupCount() > 0) {
            BitSet groupKey = new BitSet();
            for (int i = 0; i < rel.getGroupCount(); ++i) {
                groupKey.set(i);
            }
            return BitSets.contains(columns, groupKey);
        }
        return columns.isEmpty();
    }

    public Boolean areColumnsUnique(RelNode rel, BitSet columns, boolean ignoreNulls) {
        return null;
    }
}

