/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eigenbase.util.UnmodifiableArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableNullableList<E>
extends AbstractList<E> {
    private static final List SINGLETON_NULL = Collections.singletonList(null);
    private final E[] elements;

    private ImmutableNullableList(E[] elements) {
        this.elements = elements;
    }

    public static <E> List<E> copyOf(Collection<? extends E> elements) {
        if (elements instanceof ImmutableNullableList || elements instanceof ImmutableList) {
            return (List)elements;
        }
        for (E object : elements) {
            if (object != null) continue;
            Object[] objects = elements.toArray();
            return new ImmutableNullableList<Object>(objects);
        }
        return ImmutableList.copyOf(elements);
    }

    public static <E> List<E> copyOf(E[] elements) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E object = EArray[n2];
            if (object == null) {
                return new ImmutableNullableList<Object>((Object[])elements.clone());
            }
            ++n2;
        }
        return ImmutableList.copyOf((Object[])elements);
    }

    public static <E> List<E> of(E e1) {
        return e1 == null ? SINGLETON_NULL : ImmutableList.of(e1);
    }

    public static <E> List<E> of(E e1, E e2) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2});
    }

    public static <E> List<E> of(E e1, E e2, E e3) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3, e4});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3, e4, e5});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3, e4, e5, e6});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3, e4, e5, e6, e7});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E ... others) {
        Object[] array = new Object[8 + others.length];
        array[0] = e1;
        array[1] = e2;
        array[2] = e3;
        array[3] = e4;
        array[4] = e5;
        array[5] = e6;
        array[6] = e7;
        array[7] = e8;
        System.arraycopy(others, 0, array, 8, others.length);
        return new ImmutableNullableList<Object>(array);
    }

    @Override
    public E get(int index) {
        return this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }
}

