/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlBasicCall;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlDataTypeSpec;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlIntervalLiteral;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlJdbcFunctionCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlNumericLiteral;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.fun.SqlArrayValueConstructor;
import org.eigenbase.sql.fun.SqlAvgAggFunction;
import org.eigenbase.sql.fun.SqlBetweenOperator;
import org.eigenbase.sql.fun.SqlCase;
import org.eigenbase.sql.fun.SqlDatetimeSubtractionOperator;
import org.eigenbase.sql.fun.SqlExtractFunction;
import org.eigenbase.sql.fun.SqlLiteralChainOperator;
import org.eigenbase.sql.fun.SqlMapValueConstructor;
import org.eigenbase.sql.fun.SqlMultisetQueryConstructor;
import org.eigenbase.sql.fun.SqlMultisetValueConstructor;
import org.eigenbase.sql.fun.SqlOverlapsOperator;
import org.eigenbase.sql.fun.SqlRowOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql2rel.ReflectiveConvertletTable;
import org.eigenbase.sql2rel.SqlRexContext;
import org.eigenbase.sql2rel.SqlRexConvertlet;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardConvertletTable
extends ReflectiveConvertletTable {
    public static final StandardConvertletTable INSTANCE = new StandardConvertletTable();

    private StandardConvertletTable() {
        this.addAlias(SqlStdOperatorTable.CHARACTER_LENGTH, SqlStdOperatorTable.CHAR_LENGTH);
        this.addAlias(SqlStdOperatorTable.IS_UNKNOWN, SqlStdOperatorTable.IS_NULL);
        this.addAlias(SqlStdOperatorTable.IS_NOT_UNKNOWN, SqlStdOperatorTable.IS_NOT_NULL);
        this.registerOp(SqlStdOperatorTable.CAST, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertCast(cx, call);
            }
        });
        this.registerOp(SqlStdOperatorTable.IS_DISTINCT_FROM, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertIsDistinctFrom(cx, call, false);
            }
        });
        this.registerOp(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertIsDistinctFrom(cx, call, true);
            }
        });
        this.registerOp(SqlStdOperatorTable.NOT_LIKE, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.LIKE.createCall(SqlParserPos.ZERO, call.getOperandList()));
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.NOT_SIMILAR_TO, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.SIMILAR_TO.createCall(SqlParserPos.ZERO, call.getOperandList()));
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.UNARY_PLUS, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                Object expanded = call.operand(0);
                return cx.convertExpression((SqlNode)expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.AS, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                Object expanded = call.operand(0);
                return cx.convertExpression((SqlNode)expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.SQRT, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.POWER.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), SqlLiteral.createExactNumeric("0.5", SqlParserPos.ZERO)});
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.AVG, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.AVG));
        this.registerOp(SqlStdOperatorTable.STDDEV_POP, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.STDDEV_POP));
        this.registerOp(SqlStdOperatorTable.STDDEV_SAMP, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.STDDEV_SAMP));
        this.registerOp(SqlStdOperatorTable.VAR_POP, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.VAR_POP));
        this.registerOp(SqlStdOperatorTable.VAR_SAMP, new AvgVarianceConvertlet(SqlAvgAggFunction.Subtype.VAR_SAMP));
        this.registerOp(SqlStdOperatorTable.FLOOR, new FloorCeilConvertlet(true));
        this.registerOp(SqlStdOperatorTable.CEIL, new FloorCeilConvertlet(false));
    }

    public RexNode convertCase(SqlRexContext cx, SqlCase call) {
        SqlNodeList whenList = call.getWhenOperands();
        SqlNodeList thenList = call.getThenOperands();
        assert (whenList.size() == thenList.size());
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        for (int i = 0; i < whenList.size(); ++i) {
            exprList.add(cx.convertExpression(whenList.get(i)));
            exprList.add(cx.convertExpression(thenList.get(i)));
        }
        exprList.add(cx.convertExpression(call.getElseOperand()));
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataType type = rexBuilder.deriveReturnType(call.getOperator(), cx.getTypeFactory(), exprList);
        for (int i : this.elseArgs(exprList.size())) {
            exprList.set(i, rexBuilder.ensureType(type, (RexNode)exprList.get(i), false));
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, exprList);
    }

    public RexNode convertMultiset(SqlRexContext cx, SqlMultisetValueConstructor op, SqlCall call) {
        RelDataType originalType = cx.getValidator().getValidatedNodeType(call);
        RexRangeRef rr = cx.getSubqueryExpr(call);
        assert (rr != null);
        RelDataType msType = rr.getType().getFieldList().get(0).getType();
        RexNode expr = cx.getRexBuilder().makeInputRef(msType, rr.getOffset());
        assert (msType.getComponentType().isStruct());
        if (!originalType.getComponentType().isStruct()) {
            expr = cx.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SLICE, expr);
        }
        return expr;
    }

    public RexNode convertArray(SqlRexContext cx, SqlArrayValueConstructor op, SqlCall call) {
        return this.convertCall(cx, call);
    }

    public RexNode convertMap(SqlRexContext cx, SqlMapValueConstructor op, SqlCall call) {
        return this.convertCall(cx, call);
    }

    public RexNode convertMultisetQuery(SqlRexContext cx, SqlMultisetQueryConstructor op, SqlCall call) {
        RelDataType originalType = cx.getValidator().getValidatedNodeType(call);
        RexRangeRef rr = cx.getSubqueryExpr(call);
        assert (rr != null);
        RelDataType msType = rr.getType().getFieldList().get(0).getType();
        RexNode expr = cx.getRexBuilder().makeInputRef(msType, rr.getOffset());
        assert (msType.getComponentType().isStruct());
        if (!originalType.getComponentType().isStruct()) {
            expr = cx.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SLICE, expr);
        }
        return expr;
    }

    public RexNode convertJdbc(SqlRexContext cx, SqlJdbcFunctionCall op, SqlCall call) {
        SqlCall convertedCall = op.getLookupCall();
        return cx.convertExpression(convertedCall);
    }

    protected RexNode convertCast(SqlRexContext cx, SqlCall call) {
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        assert (call.getKind() == SqlKind.CAST);
        Object left = call.operand(0);
        Object right = call.operand(1);
        if (right instanceof SqlIntervalQualifier) {
            SqlIntervalQualifier intervalQualifier = (SqlIntervalQualifier)right;
            if (left instanceof SqlIntervalLiteral || left instanceof SqlNumericLiteral) {
                RexLiteral sourceInterval = (RexLiteral)cx.convertExpression((SqlNode)left);
                BigDecimal sourceValue = (BigDecimal)sourceInterval.getValue();
                RexLiteral castedInterval = cx.getRexBuilder().makeIntervalLiteral(sourceValue.multiply(BigDecimal.valueOf(intervalQualifier.getStartUnit().multiplier), MathContext.UNLIMITED), intervalQualifier);
                return this.castToValidatedType(cx, call, castedInterval);
            }
            return this.castToValidatedType(cx, call, cx.convertExpression((SqlNode)left));
        }
        SqlDataTypeSpec dataType = (SqlDataTypeSpec)right;
        if (SqlUtil.isNullLiteral(left, false)) {
            return cx.convertExpression((SqlNode)left);
        }
        RexNode arg = cx.convertExpression((SqlNode)left);
        RelDataType type = dataType.deriveType(typeFactory);
        if (arg.getType().isNullable()) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        if (null != dataType.getCollectionsTypeName()) {
            RelDataType argComponentType = arg.getType().getComponentType();
            RelDataType componentType = type.getComponentType();
            if (argComponentType.isStruct() && !componentType.isStruct()) {
                RelDataType tt = typeFactory.builder().add(argComponentType.getFieldList().get(0).getName(), componentType).build();
                tt = typeFactory.createTypeWithNullability(tt, componentType.isNullable());
                boolean isn = type.isNullable();
                type = typeFactory.createMultisetType(tt, -1L);
                type = typeFactory.createTypeWithNullability(type, isn);
            }
        }
        return cx.getRexBuilder().makeCast(type, arg);
    }

    protected RexNode convertFloorCeil(SqlRexContext cx, SqlCall call, boolean floor) {
        if (call.operandCount() == 1 && call.operand(0) instanceof SqlIntervalLiteral) {
            RexNode mult;
            SqlIntervalLiteral literal = (SqlIntervalLiteral)call.operand(0);
            SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
            long val = interval.getIntervalQualifier().getStartUnit().multiplier;
            RexNode rexInterval = cx.convertExpression(literal);
            RexBuilder rexBuilder = cx.getRexBuilder();
            RexLiteral zero = rexBuilder.makeExactLiteral(BigDecimal.valueOf(0L));
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, rexInterval, zero);
            RexLiteral pad = rexBuilder.makeExactLiteral(BigDecimal.valueOf(val - 1L));
            RexNode cast = rexBuilder.makeReinterpretCast(rexInterval.getType(), pad, rexBuilder.makeLiteral(false));
            SqlBinaryOperator op = floor ? SqlStdOperatorTable.MINUS : SqlStdOperatorTable.PLUS;
            RexNode sum = rexBuilder.makeCall((SqlOperator)op, rexInterval, cast);
            RexNode kase = floor ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, cond, rexInterval, sum) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, cond, sum, rexInterval);
            RexLiteral factor = rexBuilder.makeExactLiteral(BigDecimal.valueOf(val));
            RexNode div = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, kase, factor);
            RexNode res = mult = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, div, factor);
            return res;
        }
        return this.convertFunction(cx, (SqlFunction)call.getOperator(), call);
    }

    public RexNode convertExtract(SqlRexContext cx, SqlExtractFunction op, SqlCall call) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands);
        RelDataType resType = cx.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        resType = cx.getTypeFactory().createTypeWithNullability(resType, exprs.get(1).getType().isNullable());
        RexNode res = rexBuilder.makeReinterpretCast(resType, exprs.get(1), rexBuilder.makeLiteral(false));
        SqlIntervalQualifier.TimeUnit unit = ((SqlIntervalQualifier)operands.get(0)).getStartUnit();
        SqlTypeName sqlTypeName = exprs.get(1).getType().getSqlTypeName();
        block0 : switch (unit) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                switch (sqlTypeName) {
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_DAY_TIME: {
                        break block0;
                    }
                    case TIMESTAMP: {
                        res = this.divide(rexBuilder, res, 86400000L);
                    }
                    case DATE: {
                        return rexBuilder.makeCall(resType, SqlStdOperatorTable.EXTRACT_DATE, (List<RexNode>)ImmutableList.of((Object)exprs.get(0), (Object)res));
                    }
                }
                throw new AssertionError((Object)("unexpected " + (Object)((Object)sqlTypeName)));
            }
        }
        res = this.mod(rexBuilder, resType, res, StandardConvertletTable.getFactor(unit));
        res = this.divide(rexBuilder, res, unit.multiplier);
        return res;
    }

    private static long getFactor(SqlIntervalQualifier.TimeUnit unit) {
        switch (unit) {
            case DAY: {
                return 1L;
            }
            case HOUR: {
                return SqlIntervalQualifier.TimeUnit.DAY.multiplier;
            }
            case MINUTE: {
                return SqlIntervalQualifier.TimeUnit.HOUR.multiplier;
            }
            case SECOND: {
                return SqlIntervalQualifier.TimeUnit.MINUTE.multiplier;
            }
            case YEAR: {
                return 1L;
            }
            case MONTH: {
                return SqlIntervalQualifier.TimeUnit.YEAR.multiplier;
            }
        }
        throw Util.unexpected(unit);
    }

    private RexNode mod(RexBuilder rexBuilder, RelDataType resType, RexNode res, long val) {
        if (val == 1L) {
            return res;
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MOD, res, rexBuilder.makeExactLiteral(BigDecimal.valueOf(val), resType));
    }

    private RexNode divide(RexBuilder rexBuilder, RexNode res, long val) {
        if (val == 1L) {
            return res;
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, res, rexBuilder.makeExactLiteral(BigDecimal.valueOf(val)));
    }

    public RexNode convertDatetimeMinus(SqlRexContext cx, SqlDatetimeSubtractionOperator op, SqlCall call) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands);
        for (RexNode expr : exprs) {
            if (SqlTypeName.INTERVAL_YEAR_MONTH != expr.getType().getSqlTypeName()) continue;
            Util.needToImplement("Datetime subtraction of year month interval");
        }
        RelDataType int8Type = cx.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        RexNode[] casts = new RexNode[]{rexBuilder.makeCast(cx.getTypeFactory().createTypeWithNullability(int8Type, exprs.get(0).getType().isNullable()), exprs.get(0)), rexBuilder.makeCast(cx.getTypeFactory().createTypeWithNullability(int8Type, exprs.get(1).getType().isNullable()), exprs.get(1))};
        RexNode minus = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, casts);
        RelDataType resType = cx.getValidator().getValidatedNodeType(call);
        RexNode res = rexBuilder.makeReinterpretCast(resType, minus, rexBuilder.makeLiteral(false));
        return res;
    }

    public RexNode convertFunction(SqlRexContext cx, SqlFunction fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands);
        if (fun.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
            return StandardConvertletTable.makeConstructorCall(cx, fun, exprs);
        }
        return cx.getRexBuilder().makeCall((SqlOperator)fun, exprs);
    }

    public RexNode convertAggregateFunction(SqlRexContext cx, SqlAggFunction fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        Object exprs = call.isCountStar() ? ImmutableList.of() : StandardConvertletTable.convertExpressionList(cx, operands);
        return cx.getRexBuilder().makeCall((SqlOperator)fun, (List<? extends RexNode>)exprs);
    }

    private static RexNode makeConstructorCall(SqlRexContext cx, SqlFunction constructor, List<RexNode> exprs) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        RelDataType type = rexBuilder.deriveReturnType(constructor, typeFactory, exprs);
        int n = type.getFieldCount();
        ImmutableList.Builder initializationExprs = ImmutableList.builder();
        for (int i = 0; i < n; ++i) {
            initializationExprs.add((Object)cx.getDefaultValueFactory().newAttributeInitializer(type, constructor, i, exprs));
        }
        List<RexNode> defaultCasts = RexUtil.generateCastExpressions(rexBuilder, type, (List<RexNode>)initializationExprs.build());
        return rexBuilder.makeNewInvocation(type, defaultCasts);
    }

    public RexNode convertCall(SqlRexContext cx, SqlCall call) {
        SqlOperator op = call.getOperator();
        List<SqlNode> operands = call.getOperandList();
        RexBuilder rexBuilder = cx.getRexBuilder();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands);
        if (op.getOperandTypeChecker() == OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED) {
            this.ensureSameType(cx, exprs);
        }
        return rexBuilder.makeFlatCall(op, exprs);
    }

    private List<Integer> elseArgs(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = count % 2;
        do {
            list.add(i);
        } while ((i += 2) < count);
        list.add(i - 1);
        return list;
    }

    private void ensureSameType(SqlRexContext cx, final List<RexNode> exprs) {
        RelDataType type = cx.getTypeFactory().leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return ((RexNode)exprs.get(index)).getType();
            }

            @Override
            public int size() {
                return exprs.size();
            }
        });
        for (int i = 0; i < exprs.size(); ++i) {
            exprs.set(i, cx.getRexBuilder().ensureType(type, exprs.get(i), true));
        }
    }

    private static List<RexNode> convertExpressionList(SqlRexContext cx, List<SqlNode> nodes) {
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        for (SqlNode node : nodes) {
            exprs.add(cx.convertExpression(node));
        }
        return exprs;
    }

    private RexNode convertIsDistinctFrom(SqlRexContext cx, SqlCall call, boolean neg) {
        RexNode op0 = cx.convertExpression((SqlNode)call.operand(0));
        RexNode op1 = cx.convertExpression((SqlNode)call.operand(1));
        return RelOptUtil.isDistinctFrom(cx.getRexBuilder(), op0, op1, neg);
    }

    public RexNode convertBetween(SqlRexContext cx, SqlBetweenOperator op, SqlCall call) {
        RexNode res;
        Object value = call.operand(0);
        RexNode x = cx.convertExpression((SqlNode)value);
        SqlBetweenOperator.Flag symmetric = op.flag;
        Object lower = call.operand(1);
        RexNode y = cx.convertExpression((SqlNode)lower);
        Object upper = call.operand(2);
        RexNode z = cx.convertExpression((SqlNode)upper);
        RexBuilder rexBuilder = cx.getRexBuilder();
        RexNode ge1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, x, y);
        RexNode le1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, x, z);
        RexNode and1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ge1, le1);
        switch (symmetric) {
            case ASYMMETRIC: {
                res = and1;
                break;
            }
            case SYMMETRIC: {
                RexNode ge2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, x, z);
                RexNode le2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, x, y);
                RexNode and2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ge2, le2);
                res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, and1, and2);
                break;
            }
            default: {
                throw Util.unexpected(symmetric);
            }
        }
        SqlBetweenOperator betweenOp = (SqlBetweenOperator)call.getOperator();
        if (betweenOp.isNegated()) {
            res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, res);
        }
        return res;
    }

    public RexNode convertLiteralChain(SqlRexContext cx, SqlLiteralChainOperator op, SqlCall call) {
        Util.discard(cx);
        SqlLiteral sum = SqlLiteralChainOperator.concatenateOperands(call);
        return cx.convertLiteral(sum);
    }

    public RexNode convertRow(SqlRexContext cx, SqlRowOperator op, SqlCall call) {
        if (cx.getValidator().getValidatedNodeType(call).getSqlTypeName() != SqlTypeName.COLUMN_LIST) {
            return this.convertCall(cx, call);
        }
        RexBuilder rexBuilder = cx.getRexBuilder();
        ArrayList<RexLiteral> columns = new ArrayList<RexLiteral>();
        for (SqlNode operand : call.getOperandList()) {
            columns.add(rexBuilder.makeLiteral(((SqlIdentifier)operand).getSimple()));
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.COLUMN_LIST, columns);
    }

    public RexNode convertOverlaps(SqlRexContext cx, SqlOverlapsOperator op, SqlCall call) {
        SqlBinaryOperator op1;
        SqlNode[] operands = ((SqlBasicCall)call).getOperands();
        assert (operands.length == 4);
        if (operands[1] instanceof SqlIntervalLiteral) {
            op1 = SqlStdOperatorTable.PLUS;
            SqlNode[] second = new SqlNode[]{operands[0], operands[1]};
            operands[1] = op1.createCall(call.getParserPosition(), second);
        }
        if (operands[3] instanceof SqlIntervalLiteral) {
            op1 = SqlStdOperatorTable.PLUS;
            SqlNode[] four = new SqlNode[]{operands[2], operands[3]};
            operands[3] = op1.createCall(call.getParserPosition(), four);
        }
        op1 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        SqlNode[] left = new SqlNode[]{operands[1], operands[2]};
        SqlCall call1 = op1.createCall(call.getParserPosition(), left);
        SqlBinaryOperator op2 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        SqlNode[] right = new SqlNode[]{operands[3], operands[0]};
        SqlCall call2 = op2.createCall(call.getParserPosition(), right);
        SqlBinaryOperator and = SqlStdOperatorTable.AND;
        SqlNode[] overlaps = new SqlNode[]{call1, call2};
        SqlCall call3 = and.createCall(call.getParserPosition(), overlaps);
        return cx.convertExpression(call3);
    }

    public RexNode castToValidatedType(SqlRexContext cx, SqlCall call, RexNode value) {
        RelDataType resType = cx.getValidator().getValidatedNodeType(call);
        if (value.getType() == resType) {
            return value;
        }
        return cx.getRexBuilder().makeCast(resType, value);
    }

    private class FloorCeilConvertlet
    implements SqlRexConvertlet {
        private final boolean floor;

        public FloorCeilConvertlet(boolean floor) {
            this.floor = floor;
        }

        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            return StandardConvertletTable.this.convertFloorCeil(cx, call, this.floor);
        }
    }

    private static class AvgVarianceConvertlet
    implements SqlRexConvertlet {
        private final SqlAvgAggFunction.Subtype subtype;

        public AvgVarianceConvertlet(SqlAvgAggFunction.Subtype subtype) {
            this.subtype = subtype;
        }

        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlNode expr;
            assert (call.operandCount() == 1);
            Object arg = call.operand(0);
            switch (this.subtype) {
                case AVG: {
                    expr = this.expandAvg((SqlNode)arg);
                    break;
                }
                case STDDEV_POP: {
                    expr = this.expandVariance((SqlNode)arg, true, true);
                    break;
                }
                case STDDEV_SAMP: {
                    expr = this.expandVariance((SqlNode)arg, false, true);
                    break;
                }
                case VAR_POP: {
                    expr = this.expandVariance((SqlNode)arg, true, false);
                    break;
                }
                case VAR_SAMP: {
                    expr = this.expandVariance((SqlNode)arg, false, false);
                    break;
                }
                default: {
                    throw Util.unexpected(this.subtype);
                }
            }
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            RexNode rex = cx.convertExpression(expr);
            return cx.getRexBuilder().ensureType(type, rex, true);
        }

        private SqlNode expandAvg(SqlNode arg) {
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
            SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
            return SqlStdOperatorTable.DIVIDE.createCall(pos, sum, count);
        }

        private SqlNode expandVariance(SqlNode arg, boolean biased, boolean sqrt) {
            SqlCall div;
            SqlCall denominator;
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlCall argSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, arg, arg);
            SqlCall sumArgSquared = SqlStdOperatorTable.SUM.createCall(pos, argSquared);
            SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
            SqlCall sumSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, sum, sum);
            SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
            SqlCall avgSumSquared = SqlStdOperatorTable.DIVIDE.createCall(pos, sumSquared, count);
            SqlCall diff = SqlStdOperatorTable.MINUS.createCall(pos, sumArgSquared, avgSumSquared);
            if (biased) {
                denominator = count;
            } else {
                SqlNumericLiteral one = SqlLiteral.createExactNumeric("1", pos);
                denominator = SqlStdOperatorTable.MINUS.createCall(pos, count, one);
            }
            SqlCall result = div = SqlStdOperatorTable.DIVIDE.createCall(pos, diff, denominator);
            if (sqrt) {
                SqlNumericLiteral half = SqlLiteral.createExactNumeric("0.5", pos);
                result = SqlStdOperatorTable.POWER.createCall(pos, div, half);
            }
            return result;
        }
    }
}

