/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql2rel.SqlRexContext;
import org.eigenbase.sql2rel.SqlRexConvertlet;
import org.eigenbase.sql2rel.SqlRexConvertletTable;
import org.eigenbase.util.Util;

public class ReflectiveConvertletTable
implements SqlRexConvertletTable {
    private final Map<Object, Object> map = new HashMap<Object, Object>();

    public ReflectiveConvertletTable() {
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            this.registerNodeTypeMethod(method);
            this.registerOpTypeMethod(method);
            ++n2;
        }
    }

    private void registerNodeTypeMethod(final Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return;
        }
        if (!method.getName().startsWith("convert")) {
            return;
        }
        if (!RexNode.class.isAssignableFrom(method.getReturnType())) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 2) {
            return;
        }
        if (parameterTypes[0] != SqlRexContext.class) {
            return;
        }
        Class<?> parameterType = parameterTypes[1];
        if (!SqlNode.class.isAssignableFrom(parameterType)) {
            return;
        }
        this.map.put(parameterType, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                try {
                    return (RexNode)method.invoke((Object)ReflectiveConvertletTable.this, cx, call);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "while converting " + call);
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "while converting " + call);
                }
            }
        });
    }

    private void registerOpTypeMethod(final Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return;
        }
        if (!method.getName().startsWith("convert")) {
            return;
        }
        if (!RexNode.class.isAssignableFrom(method.getReturnType())) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 3) {
            return;
        }
        if (parameterTypes[0] != SqlRexContext.class) {
            return;
        }
        Class<?> opClass = parameterTypes[1];
        if (!SqlOperator.class.isAssignableFrom(opClass)) {
            return;
        }
        Class<?> parameterType = parameterTypes[2];
        if (!SqlCall.class.isAssignableFrom(parameterType)) {
            return;
        }
        this.map.put(opClass, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                try {
                    return (RexNode)method.invoke((Object)ReflectiveConvertletTable.this, cx, call.getOperator(), call);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "while converting " + call);
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "while converting " + call);
                }
            }
        });
    }

    public SqlRexConvertlet get(SqlCall call) {
        SqlOperator op = call.getOperator();
        SqlRexConvertlet convertlet = (SqlRexConvertlet)this.map.get(op);
        if (convertlet != null) {
            return convertlet;
        }
        Class<?> clazz = op.getClass();
        while (clazz != null) {
            convertlet = (SqlRexConvertlet)this.map.get(clazz);
            if (convertlet != null) {
                return convertlet;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = call.getClass();
        while (clazz != null) {
            convertlet = (SqlRexConvertlet)this.map.get(clazz);
            if (convertlet != null) {
                return convertlet;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    protected void registerOp(SqlOperator op, SqlRexConvertlet convertlet) {
        this.map.put(op, convertlet);
    }

    protected void addAlias(final SqlOperator alias, final SqlOperator target) {
        this.map.put(alias, new SqlRexConvertlet(){

            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                Util.permAssert(call.getOperator() == alias, "call to wrong operator");
                SqlCall newCall = target.createCall(SqlParserPos.ZERO, call.getOperandList());
                return cx.convertExpression(newCall);
            }
        });
    }
}

