/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.util14.EigenbaseParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlParseException
extends Exception
implements EigenbaseParserException {
    private final SqlParserPos pos;
    private final int[][] expectedTokenSequences;
    private final String[] tokenImages;
    private final transient Throwable parserException;

    public SqlParseException(String message, SqlParserPos pos, int[][] expectedTokenSequences, String[] tokenImages, Throwable parserException) {
        super(message, null);
        this.pos = pos;
        this.expectedTokenSequences = expectedTokenSequences;
        this.tokenImages = tokenImages;
        this.parserException = parserException;
    }

    public SqlParserPos getPos() {
        return this.pos;
    }

    public Collection<String> getExpectedTokenNames() {
        if (this.expectedTokenSequences == null) {
            return Collections.emptyList();
        }
        int maxLength = 0;
        int[][] nArray = this.expectedTokenSequences;
        int n = this.expectedTokenSequences.length;
        int n2 = 0;
        while (n2 < n) {
            int[] expectedTokenSequence = nArray[n2];
            maxLength = Math.max(expectedTokenSequence.length, maxLength);
            ++n2;
        }
        TreeSet<String> set = new TreeSet<String>();
        int[][] nArray2 = this.expectedTokenSequences;
        int n3 = this.expectedTokenSequences.length;
        n = 0;
        while (n < n3) {
            int[] expectedTokenSequence = nArray2[n];
            if (expectedTokenSequence.length == maxLength) {
                set.add(this.tokenImages[expectedTokenSequence[expectedTokenSequence.length - 1]]);
            }
            ++n;
        }
        return set;
    }

    public String[] getTokenImages() {
        return this.tokenImages;
    }

    public int[][] getExpectedTokenSequences() {
        return this.expectedTokenSequences;
    }

    @Override
    public Throwable getCause() {
        return this.parserException;
    }

    private Object writeReplace() {
        return new RuntimeException(String.valueOf(this.getClass().getName()) + ": " + this.getMessage());
    }
}

