/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.advise;

import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.ImplementableFunction;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.impl.ReflectiveFunctionBase;
import net.hydromatic.optiq.rules.java.CallImplementor;
import net.hydromatic.optiq.rules.java.NotNullImplementor;
import net.hydromatic.optiq.rules.java.NullPolicy;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexCall;
import org.eigenbase.sql.advise.SqlAdvisor;
import org.eigenbase.sql.advise.SqlAdvisorHint;
import org.eigenbase.sql.validate.SqlMoniker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAdvisorGetHintsFunction
implements TableFunction,
ImplementableFunction {
    private static final Expression ADVISOR = Expressions.convert_((Expression)Expressions.call((Expression)DataContext.ROOT, (Method)BuiltinMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)DataContext.Variable.SQL_ADVISOR.camelName)}), SqlAdvisor.class);
    private static final Method GET_COMPLETION_HINTS = Types.lookupMethod(SqlAdvisorGetHintsFunction.class, (String)"getCompletionHints", (Class[])new Class[]{SqlAdvisor.class, String.class, Integer.TYPE});
    private static final CallImplementor IMPLEMENTOR = RexImpTable.createImplementor((NotNullImplementor)new NotNullImplementor(){

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> operands) {
            return Expressions.call((Method)GET_COMPLETION_HINTS, (Iterable)Iterables.concat(Collections.singleton(ADVISOR), operands));
        }
    }, (NullPolicy)NullPolicy.ANY, (boolean)false);
    private static final List<FunctionParameter> PARAMETERS = ReflectiveFunctionBase.toFunctionParameters(String.class, Integer.TYPE);

    @Override
    public CallImplementor getImplementor() {
        return IMPLEMENTOR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        return typeFactory.createJavaType(SqlAdvisorHint.class);
    }

    @Override
    public Type getElementType(List<Object> arguments) {
        return SqlAdvisorHint.class;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return PARAMETERS;
    }

    public static Enumerable<SqlAdvisorHint> getCompletionHints(SqlAdvisor advisor, String sql, int pos) {
        String[] replaced = new String[1];
        List<SqlMoniker> hints = advisor.getCompletionHints(sql, pos, replaced);
        ArrayList<SqlAdvisorHint> res = new ArrayList<SqlAdvisorHint>(hints.size() + 1);
        res.add(new SqlAdvisorHint(replaced[0], null, "MATCH"));
        for (SqlMoniker hint : hints) {
            res.add(new SqlAdvisorHint(hint));
        }
        return Linq4j.asEnumerable(res).asQueryable();
    }
}

