/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.List;
import java.util.Set;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.pretty.SqlPrettyWriter;
import org.eigenbase.sql.util.SqlString;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlNode
implements Cloneable {
    public static final SqlNode[] EMPTY_ARRAY = new SqlNode[0];
    private final SqlParserPos pos;

    SqlNode(SqlParserPos pos) {
        Util.pre(pos != null, "pos != null");
        this.pos = pos;
    }

    public Object clone() {
        return this.clone(this.getParserPosition());
    }

    public SqlNode clone(SqlParserPos pos) {
        try {
            return (SqlNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Util.newInternal(e, "error while cloning " + this);
        }
    }

    public SqlKind getKind() {
        return SqlKind.OTHER;
    }

    public final boolean isA(Set<SqlKind> category) {
        return this.getKind().belongsTo(category);
    }

    public static SqlNode[] cloneArray(SqlNode[] nodes) {
        SqlNode[] clones = (SqlNode[])nodes.clone();
        int i = 0;
        while (i < clones.length) {
            SqlNode node = clones[i];
            if (node != null) {
                clones[i] = (SqlNode)node.clone();
            }
            ++i;
        }
        return clones;
    }

    public String toString() {
        return this.toSqlString(null).getSql();
    }

    public SqlString toSqlString(SqlDialect dialect, boolean forceParens) {
        if (dialect == null) {
            dialect = SqlDialect.DUMMY;
        }
        SqlPrettyWriter writer = new SqlPrettyWriter(dialect);
        writer.setAlwaysUseParentheses(forceParens);
        writer.setSelectListItemsOnSeparateLines(false);
        writer.setIndentation(0);
        this.unparse(writer, 0, 0);
        String sql = writer.toString();
        return new SqlString(dialect, sql);
    }

    public SqlString toSqlString(SqlDialect dialect) {
        return this.toSqlString(dialect, false);
    }

    public abstract void unparse(SqlWriter var1, int var2, int var3);

    public SqlParserPos getParserPosition() {
        return this.pos;
    }

    public abstract void validate(SqlValidator var1, SqlValidatorScope var2);

    public void findValidOptions(SqlValidator validator, SqlValidatorScope scope, SqlParserPos pos, List<SqlMoniker> hintList) {
    }

    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        this.validate(validator, scope);
        Util.discard(validator.deriveType(scope, this));
    }

    public abstract <R> R accept(SqlVisitor<R> var1);

    public abstract boolean equalsDeep(SqlNode var1, boolean var2);

    public static boolean equalDeep(SqlNode node1, SqlNode node2, boolean fail) {
        if (node1 == null) {
            return node2 == null;
        }
        if (node2 == null) {
            return false;
        }
        return node1.equalsDeep(node2, fail);
    }

    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    public static boolean equalDeep(List<SqlNode> operands0, List<SqlNode> operands1, boolean fail) {
        if (operands0.size() != operands1.size()) {
            assert (!fail);
            return false;
        }
        int i = 0;
        while (i < operands0.size()) {
            if (!SqlNode.equalDeep(operands0.get(i), operands1.get(i), fail)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

