/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.reltype;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.expressions.Primitive;
import org.eigenbase.reltype.RelCrossType;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFamily;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.reltype.RelRecordType;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.type.JavaToSqlTypeConversionRules;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelDataTypeFactoryImpl
implements RelDataTypeFactory {
    private static final LoadingCache<Object, RelDataType> CACHE = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<Object, RelDataType>(){

        public RelDataType load(Object key) {
            if (key instanceof RelDataType) {
                return (RelDataType)key;
            }
            Pair pair = (Pair)key;
            ImmutableList.Builder list = ImmutableList.builder();
            int i = 0;
            while (i < ((List)pair.left).size()) {
                list.add((Object)new RelDataTypeFieldImpl((String)((List)pair.left).get(i), i, (RelDataType)((List)pair.right).get(i)));
                ++i;
            }
            return new RelRecordType((List<RelDataTypeField>)list.build());
        }
    });
    private static final Map<Class, RelDataTypeFamily> CLASS_FAMILIES = ImmutableMap.builder().put(String.class, (Object)SqlTypeFamily.CHARACTER).put(byte[].class, (Object)SqlTypeFamily.BINARY).put(Boolean.TYPE, (Object)SqlTypeFamily.BOOLEAN).put(Boolean.class, (Object)SqlTypeFamily.BOOLEAN).put(Character.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Character.class, (Object)SqlTypeFamily.NUMERIC).put(Short.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Short.class, (Object)SqlTypeFamily.NUMERIC).put(Integer.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Integer.class, (Object)SqlTypeFamily.NUMERIC).put(Long.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Long.class, (Object)SqlTypeFamily.NUMERIC).put(Float.TYPE, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Float.class, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Double.TYPE, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Double.class, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Date.class, (Object)SqlTypeFamily.DATE).put(Time.class, (Object)SqlTypeFamily.TIME).put(Timestamp.class, (Object)SqlTypeFamily.TIMESTAMP).build();

    protected RelDataTypeFactoryImpl() {
    }

    @Override
    public RelDataType createJavaType(Class clazz) {
        JavaType javaType = clazz == String.class ? new JavaType(clazz, true, this.getDefaultCharset(), SqlCollation.IMPLICIT) : new JavaType(clazz);
        return this.canonize(javaType);
    }

    @Override
    public RelDataType createJoinType(RelDataType ... types) {
        assert (types != null);
        assert (types.length >= 1);
        List<RelDataType> flattenedTypes = RelDataTypeFactoryImpl.getTypeArray((List<RelDataType>)ImmutableList.copyOf((Object[])types));
        return this.canonize(new RelCrossType(flattenedTypes, RelDataTypeFactoryImpl.getFieldArray(flattenedTypes)));
    }

    @Override
    public RelDataType createStructType(RelDataType[] types, String[] fieldNames) {
        return this.canonize(Arrays.asList(fieldNames), Arrays.asList(types));
    }

    @Override
    public RelDataType createStructType(List<RelDataType> typeList, List<String> fieldNameList) {
        assert (typeList.size() == fieldNameList.size());
        return this.canonize(fieldNameList, typeList);
    }

    @Override
    public RelDataType createStructType(final RelDataTypeFactory.FieldInfo fieldInfo) {
        return this.canonize((List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return fieldInfo.getFieldName(index);
            }

            @Override
            public int size() {
                return fieldInfo.getFieldCount();
            }
        }, (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return fieldInfo.getFieldType(index);
            }

            @Override
            public int size() {
                return fieldInfo.getFieldCount();
            }
        });
    }

    @Override
    public final RelDataType createStructType(final List<? extends Map.Entry<String, RelDataType>> fieldList) {
        return this.createStructType(new RelDataTypeFactory.FieldInfo(){

            public int getFieldCount() {
                return fieldList.size();
            }

            public String getFieldName(int index) {
                return (String)((Map.Entry)fieldList.get(index)).getKey();
            }

            public RelDataType getFieldType(int index) {
                return (RelDataType)((Map.Entry)fieldList.get(index)).getValue();
            }
        });
    }

    @Override
    public RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (types.size() >= 1);
        RelDataType type0 = types.get(0);
        if (type0.isStruct()) {
            return this.leastRestrictiveStructuredType(types);
        }
        return null;
    }

    protected RelDataType leastRestrictiveStructuredType(final List<RelDataType> types) {
        RelDataType type0 = types.get(0);
        int fieldCount = type0.getFieldCount();
        for (RelDataType type : types) {
            if (!type.isStruct()) {
                return null;
            }
            if (type.getFieldList().size() == fieldCount) continue;
            return null;
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.builder();
        int j = 0;
        while (j < fieldCount) {
            final int k = j;
            builder.add(type0.getFieldList().get(j).getName(), this.leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return ((RelDataType)types.get(index)).getFieldList().get(k).getType();
                }

                @Override
                public int size() {
                    return types.size();
                }
            }));
            ++j;
        }
        return builder.build();
    }

    private RelDataType copySimpleType(RelDataType type, boolean nullable) {
        if (type instanceof JavaType) {
            JavaType javaType = (JavaType)type;
            if (SqlTypeUtil.inCharFamily(javaType)) {
                return new JavaType(javaType.clazz, nullable, javaType.charset, javaType.collation);
            }
            return new JavaType(nullable ? Primitive.box((Class)javaType.clazz) : Primitive.unbox((Class)javaType.clazz), nullable);
        }
        return type;
    }

    private RelDataType copyRecordType(final RelRecordType type, final boolean ignoreNullable, final boolean nullable) {
        return this.createStructType(new RelDataTypeFactory.FieldInfo(){

            public int getFieldCount() {
                return type.getFieldList().size();
            }

            public String getFieldName(int index) {
                return type.getFieldList().get(index).getName();
            }

            public RelDataType getFieldType(int index) {
                RelDataType fieldType = type.getFieldList().get(index).getType();
                if (ignoreNullable) {
                    return RelDataTypeFactoryImpl.this.copyType(fieldType);
                }
                return RelDataTypeFactoryImpl.this.createTypeWithNullability(fieldType, nullable);
            }
        });
    }

    @Override
    public RelDataType copyType(RelDataType type) {
        if (type instanceof RelRecordType) {
            return this.copyRecordType((RelRecordType)type, true, false);
        }
        return this.createTypeWithNullability(type, type.isNullable());
    }

    @Override
    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        Preconditions.checkNotNull((Object)type);
        RelDataType newType = type instanceof RelRecordType ? (nullable ? this.copyRecordType((RelRecordType)type, false, true) : this.copyRecordType((RelRecordType)type, true, false)) : this.copySimpleType(type, nullable);
        return this.canonize(newType);
    }

    protected RelDataType canonize(RelDataType type) {
        return (RelDataType)CACHE.getUnchecked((Object)type);
    }

    protected RelDataType canonize(List<String> names, List<RelDataType> types) {
        RelDataType type = (RelDataType)CACHE.getIfPresent(Pair.of(names, types));
        if (type != null) {
            return type;
        }
        ImmutableList names2 = ImmutableList.copyOf(names);
        ImmutableList types2 = ImmutableList.copyOf(types);
        return (RelDataType)CACHE.getUnchecked(Pair.of(names2, types2));
    }

    private static List<RelDataTypeField> getFieldArray(List<RelDataType> types) {
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>();
        for (RelDataType type : types) {
            RelDataTypeFactoryImpl.addFields(type, fieldList);
        }
        return fieldList;
    }

    private static List<RelDataType> getTypeArray(List<RelDataType> types) {
        ArrayList<RelDataType> flatTypes = new ArrayList<RelDataType>();
        RelDataTypeFactoryImpl.getTypeArray(types, flatTypes);
        return flatTypes;
    }

    private static void getTypeArray(List<RelDataType> inTypes, List<RelDataType> flatTypes) {
        for (RelDataType inType : inTypes) {
            if (inType instanceof RelCrossType) {
                RelDataTypeFactoryImpl.getTypeArray(((RelCrossType)inType).types, flatTypes);
                continue;
            }
            flatTypes.add(inType);
        }
    }

    private static void addFields(RelDataType type, ArrayList<RelDataTypeField> fieldList) {
        if (type instanceof RelCrossType) {
            RelCrossType crossType = (RelCrossType)type;
            for (RelDataType type1 : crossType.types) {
                RelDataTypeFactoryImpl.addFields(type1, fieldList);
            }
        } else {
            List<RelDataTypeField> fields = type.getFieldList();
            for (RelDataTypeField field : fields) {
                fieldList.add(field);
            }
        }
    }

    public static boolean isJavaType(RelDataType t) {
        return t instanceof JavaType;
    }

    private List<RelDataTypeFieldImpl> fieldsOf(Class clazz) {
        ArrayList<RelDataTypeFieldImpl> list = new ArrayList<RelDataTypeFieldImpl>();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers())) {
                list.add(new RelDataTypeFieldImpl(field.getName(), list.size(), this.createJavaType(field.getType())));
            }
            ++n2;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public RelDataType createDecimalProduct(RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            int scale = s1 + s2;
            scale = Math.min(scale, 19);
            int precision = p1 + p2;
            precision = Math.min(precision, 19);
            RelDataType ret = this.createSqlType(SqlTypeName.DECIMAL, precision, scale);
            return ret;
        }
        return null;
    }

    @Override
    public boolean useDoubleMultiplication(RelDataType type1, RelDataType type2) {
        assert (this.createDecimalProduct(type1, type2) != null);
        return false;
    }

    @Override
    public RelDataType createDecimalQuotient(RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            int dout = Math.min(p1 - s1 + s2, 19);
            int scale = Math.max(6, s1 + p2 + 1);
            scale = Math.min(scale, 19 - dout);
            scale = Math.min(scale, 19);
            int precision = dout + scale;
            assert (precision <= 19);
            assert (precision > 0);
            RelDataType ret = this.createSqlType(SqlTypeName.DECIMAL, precision, scale);
            return ret;
        }
        return null;
    }

    @Override
    public Charset getDefaultCharset() {
        return Util.getDefaultCharset();
    }

    @Override
    public RelDataTypeFactory.FieldInfoBuilder builder() {
        return new RelDataTypeFactory.FieldInfoBuilder(this);
    }

    public class JavaType
    extends RelDataTypeImpl {
        private final Class clazz;
        private final boolean nullable;
        private SqlCollation collation;
        private Charset charset;

        public JavaType(Class clazz) {
            this(clazz, !clazz.isPrimitive());
        }

        public JavaType(Class clazz, boolean nullable) {
            this(clazz, nullable, null, null);
        }

        public JavaType(Class clazz, boolean nullable, Charset charset, SqlCollation collation) {
            super(RelDataTypeFactoryImpl.this.fieldsOf(clazz));
            this.clazz = clazz;
            this.nullable = nullable;
            assert (charset != null == SqlTypeUtil.inCharFamily(this)) : "Need to be a chartype";
            this.charset = charset;
            this.collation = collation;
            this.computeDigest();
        }

        public Class getJavaClass() {
            return this.clazz;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public RelDataTypeFamily getFamily() {
            RelDataTypeFamily family = (RelDataTypeFamily)CLASS_FAMILIES.get(this.clazz);
            return family != null ? family : this;
        }

        protected void generateTypeString(StringBuilder sb, boolean withDetail) {
            sb.append("JavaType(");
            sb.append(this.clazz);
            sb.append(")");
        }

        public RelDataType getComponentType() {
            Class<?> componentType = this.clazz.getComponentType();
            if (componentType == null) {
                return null;
            }
            return RelDataTypeFactoryImpl.this.createJavaType(componentType);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public SqlCollation getCollation() {
            return this.collation;
        }

        public SqlTypeName getSqlTypeName() {
            SqlTypeName typeName = JavaToSqlTypeConversionRules.instance().lookup(this.clazz);
            if (typeName == null) {
                return SqlTypeName.OTHER;
            }
            return typeName;
        }
    }
}

