/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttle;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.Permutation;
import org.eigenbase.util.mapping.Mapping;
import org.eigenbase.util.mapping.MappingType;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectRel
extends ProjectRelBase {
    public ProjectRel(RelOptCluster cluster, RelNode child, List<RexNode> exps, List<String> fieldNames, int flags) {
        this(cluster, cluster.traitSetOf(RelCollationImpl.EMPTY), child, exps, RexUtil.createStructType(cluster.getTypeFactory(), exps, fieldNames), flags);
    }

    public ProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType, int flags) {
        super(cluster, traitSet, child, exps, rowType, flags);
        assert (traitSet.containsIfApplicable(Convention.NONE));
    }

    public ProjectRel(RelInput input) {
        super(input);
    }

    @Override
    public ProjectRel copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
        return new ProjectRel(this.getCluster(), traitSet, input, exps, rowType, this.flags);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    public Permutation getPermutation() {
        int fieldCount = this.rowType.getFieldList().size();
        if (fieldCount != this.getChild().getRowType().getFieldList().size()) {
            return null;
        }
        Permutation permutation = new Permutation(fieldCount);
        int i = 0;
        while (i < fieldCount) {
            RexNode exp = (RexNode)this.exps.get(i);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            permutation.set(i, ((RexInputRef)exp).getIndex());
            ++i;
        }
        return permutation;
    }

    public boolean isMapping() {
        for (RexNode exp : this.exps) {
            if (exp instanceof RexInputRef) continue;
            return false;
        }
        return true;
    }

    public Mappings.TargetMapping getMapping() {
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, this.getChild().getRowType().getFieldCount(), this.exps.size());
        for (Ord exp : Ord.zip((List)this.exps)) {
            if (!(exp.e instanceof RexInputRef)) {
                return null;
            }
            mapping.set(((RexInputRef)exp.e).getIndex(), exp.i);
        }
        return mapping;
    }
}

