/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.FunctionParameter;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveFunctionBase
implements Function {
    public final Method method;
    public final List<FunctionParameter> parameters;

    public ReflectiveFunctionBase(Method method) {
        this.method = method;
        this.parameters = ReflectiveFunctionBase.toFunctionParameters(method.getParameterTypes());
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    public static ImmutableList<FunctionParameter> toFunctionParameters(Class ... types) {
        return ReflectiveFunctionBase.toFunctionParameters(Arrays.asList(types));
    }

    public static ImmutableList<FunctionParameter> toFunctionParameters(Iterable<? extends Class> types) {
        ImmutableList.Builder res = ImmutableList.builder();
        int i = 0;
        for (final Class clazz : types) {
            final int ordinal = i++;
            res.add((Object)new FunctionParameter(){

                public int getOrdinal() {
                    return ordinal;
                }

                public String getName() {
                    return "arg" + ordinal;
                }

                public RelDataType getType(RelDataTypeFactory typeFactory) {
                    return typeFactory.createJavaType(clazz);
                }
            });
        }
        return res.build();
    }

    static boolean classHasPublicZeroArgsConstructor(Class<?> clazz) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (constructor.getParameterTypes().length == 0 && (constructor.getModifiers() & 1) != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static Method findMethod(Class<?> clazz, String name) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(name)) {
                return method;
            }
            ++n2;
        }
        return null;
    }
}

