/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.MemoryType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.runtime.FlatLists;
import net.hydromatic.optiq.runtime.Spaces;
import net.hydromatic.optiq.util.BitSets;
import net.hydromatic.optiq.util.CompositeMap;
import org.eigenbase.resource.Resources;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.util.SqlBuilder;
import org.eigenbase.sql.util.SqlString;
import org.eigenbase.test.DiffTestCase;
import org.eigenbase.util.Benchmark;
import org.eigenbase.util.BitString;
import org.eigenbase.util.CompositeList;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.IntList;
import org.eigenbase.util.IntegerIntervalSet;
import org.eigenbase.util.JsonBuilder;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Static;
import org.eigenbase.util.StringChunker;
import org.eigenbase.util.Template;
import org.eigenbase.util.TestUtil;
import org.eigenbase.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilTest {
    @BeforeClass
    public static void setUSLocale() {
        Locale.setDefault(Locale.US);
    }

    @Test
    public void testPrintEquals() {
        this.assertPrintEquals("\"x\"", "x", true);
    }

    @Test
    public void testPrintEquals2() {
        this.assertPrintEquals("\"x\"", "x", false);
    }

    @Test
    public void testPrintEquals3() {
        this.assertPrintEquals("null", null, true);
    }

    @Test
    public void testPrintEquals4() {
        this.assertPrintEquals("", null, false);
    }

    @Test
    public void testPrintEquals5() {
        this.assertPrintEquals("\"\\\\\\\"\\r\\n\"", "\\\"\r\n", true);
    }

    @Test
    public void testScientificNotation() {
        BigDecimal bd = new BigDecimal("0.001234");
        TestUtil.assertEqualsVerbose("1.234E-3", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("0.001");
        TestUtil.assertEqualsVerbose("1E-3", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("-0.001");
        TestUtil.assertEqualsVerbose("-1E-3", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("1");
        TestUtil.assertEqualsVerbose("1E0", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("-1");
        TestUtil.assertEqualsVerbose("-1E0", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("1.0");
        TestUtil.assertEqualsVerbose("1.0E0", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("12345");
        TestUtil.assertEqualsVerbose("1.2345E4", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("12345.00");
        TestUtil.assertEqualsVerbose("1.234500E4", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("12345.001");
        TestUtil.assertEqualsVerbose("1.2345001E4", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("1.23456789012345678901");
        TestUtil.assertEqualsVerbose("1.2345678901234567890E0", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("-1.23456789012345678901");
        TestUtil.assertEqualsVerbose("-1.2345678901234567890E0", Util.toScientificNotation((BigDecimal)bd));
    }

    @Test
    public void testToJavaId() throws UnsupportedEncodingException {
        Assert.assertEquals((Object)"ID$0$foo", (Object)Util.toJavaId((String)"foo", (int)0));
        Assert.assertEquals((Object)"ID$0$foo_20_bar", (Object)Util.toJavaId((String)"foo bar", (int)0));
        Assert.assertEquals((Object)"ID$0$foo__bar", (Object)Util.toJavaId((String)"foo_bar", (int)0));
        Assert.assertEquals((Object)"ID$100$_30_bar", (Object)Util.toJavaId((String)"0bar", (int)100));
        Assert.assertEquals((Object)"ID$0$foo0bar", (Object)Util.toJavaId((String)"foo0bar", (int)0));
        Assert.assertEquals((Object)"ID$0$it_27_s_20_a_20_bird_2c__20_it_27_s_20_a_20_plane_21_", (Object)Util.toJavaId((String)"it's a bird, it's a plane!", (int)0));
        Assert.assertEquals((Object)"ID$0$_f6__cb__c4__ca__ae__c1__f9__cb_", (Object)Util.toJavaId((String)"\u00f6\u00cb\u00c4\u00ca\u00ae\u00c1\u00f9\u00cb", (int)0));
        Assert.assertEquals((Object)"ID$0$_f6cb__c4ca__aec1__f9cb_", (Object)Util.toJavaId((String)"\uf6cb\uc4ca\uaec1\uf9cb", (int)0));
        byte[] bytes1 = new byte[]{3, 12, 54, 23, 33, 23, 45, 21, 127, -34, -92, -113};
        Assert.assertEquals((Object)"ID$0$_3__c_6_17__21__17__2d__15__7f__6cd9__fffd_", (Object)Util.toJavaId((String)new String(bytes1, "EUC-JP"), (int)0));
        byte[] bytes2 = new byte[]{64, 32, 43, -45, -23, 0, 43, 54, 119, -32, -56, -34};
        Assert.assertEquals((Object)"ID$0$_30c__3617__2117__2d15__7fde__a48f_", (Object)Util.toJavaId((String)new String(bytes1, "UTF-16"), (int)0));
    }

    private void assertPrintEquals(String expect, String in, boolean nullMeansNull) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Util.printJavaString((PrintWriter)pw, (String)in, (boolean)nullMeansNull);
        pw.flush();
        String out = sw.toString();
        Assert.assertEquals((Object)expect, (Object)out);
    }

    @Test
    public void testBitString() {
        BitString b0 = new BitString("", 0);
        BitString b1 = new BitString("1", 1);
        BitString b2 = new BitString("10", 2);
        BitString b4 = new BitString("100", 3);
        BitString b8 = new BitString("1000", 4);
        BitString b16 = new BitString("10000", 5);
        BitString b32 = new BitString("100000", 6);
        BitString b64 = new BitString("1000000", 7);
        BitString b128 = new BitString("10000000", 8);
        BitString b256 = new BitString("100000000", 9);
        BitString b0x1 = new BitString("", 1);
        BitString b0x12 = new BitString("", 12);
        Assert.assertEquals((Object)"", (Object)b0.toHexString());
        Assert.assertEquals((Object)"1", (Object)b1.toHexString());
        Assert.assertEquals((Object)"2", (Object)b2.toHexString());
        Assert.assertEquals((Object)"4", (Object)b4.toHexString());
        Assert.assertEquals((Object)"8", (Object)b8.toHexString());
        Assert.assertEquals((Object)"10", (Object)b16.toHexString());
        Assert.assertEquals((Object)"20", (Object)b32.toHexString());
        Assert.assertEquals((Object)"40", (Object)b64.toHexString());
        Assert.assertEquals((Object)"80", (Object)b128.toHexString());
        Assert.assertEquals((Object)"100", (Object)b256.toHexString());
        Assert.assertEquals((Object)"0", (Object)b0x1.toHexString());
        Assert.assertEquals((Object)"000", (Object)b0x12.toHexString());
        this.assertByteArray("01", "1", 1);
        this.assertByteArray("01", "1", 5);
        this.assertByteArray("01", "1", 8);
        this.assertByteArray("00, 01", "1", 9);
        this.assertByteArray("", "", 0);
        this.assertByteArray("00", "0", 1);
        this.assertByteArray("00", "0000", 2);
        this.assertByteArray("00", "000", 5);
        this.assertByteArray("00", "0", 8);
        this.assertByteArray("00, 00", "00", 9);
        UtilTest.assertReversible("");
        UtilTest.assertReversible("1");
        UtilTest.assertReversible("10");
        UtilTest.assertReversible("100");
        UtilTest.assertReversible("1000");
        UtilTest.assertReversible("10000");
        UtilTest.assertReversible("100000");
        UtilTest.assertReversible("1000000");
        UtilTest.assertReversible("10000000");
        UtilTest.assertReversible("100000000");
        UtilTest.assertReversible("01");
        UtilTest.assertReversible("001010");
        UtilTest.assertReversible("000000000100");
    }

    private static void assertReversible(String s) {
        Assert.assertEquals((String)s, (Object)BitString.createFromBitString((String)s).toBitString(), (Object)s);
        Assert.assertEquals((Object)s, (Object)BitString.createFromHexString((String)s).toHexString());
    }

    private void assertByteArray(String expected, String bits, int bitCount) {
        byte[] bytes = BitString.toByteArrayFromBitString((String)bits, (int)bitCount);
        String s = this.toString(bytes);
        Assert.assertEquals((Object)expected, (Object)s);
    }

    private String toString(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (i > 0) {
                buf.append(", ");
            }
            String s = Integer.toString(b, 16);
            buf.append(b < 16 ? "0" + s : s);
        }
        return buf.toString();
    }

    @Test
    public void testCastingList() {
        ArrayList<Number> numberList = new ArrayList<Number>();
        numberList.add(new Integer(1));
        numberList.add(null);
        numberList.add(new Integer(2));
        List integerList = Util.cast(numberList, Integer.class);
        Assert.assertEquals((long)3L, (long)integerList.size());
        Assert.assertEquals((Object)new Integer(2), integerList.get(2));
        Assert.assertNull(integerList.get(1));
        integerList.set(1, 345);
        Assert.assertEquals((Object)new Integer(345), integerList.get(1));
        integerList.set(1, null);
        Assert.assertNull(integerList.get(1));
        numberList.add(new Double(3.1415));
        Assert.assertEquals((long)4L, (long)integerList.size());
        try {
            integerList.get(3);
            Assert.fail((String)"expected exception");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testIterableProperties() {
        Properties properties = new Properties();
        properties.put("foo", "george");
        properties.put("bar", "ringo");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : Util.toMap((Properties)properties).entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            sb.append(";");
        }
        Assert.assertEquals((Object)"bar=ringo;foo=george;", (Object)sb.toString());
        Assert.assertEquals((long)2L, (long)Util.toMap((Properties)properties).entrySet().size());
        properties.put("nonString", (Object)34);
        try {
            for (Map.Entry entry : Util.toMap((Properties)properties).entrySet()) {
                String s = (String)entry.getValue();
                Util.discard((Object)s);
            }
            Assert.fail((String)"expected exception");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testDiffLines() {
        String[] before = new String[]{"Get a dose of her in jackboots and kilt", "She's killer-diller when she's dressed to the hilt", "She's the kind of a girl that makes The News of The World", "Yes you could say she was attractively built.", "Yeah yeah yeah."};
        String[] after = new String[]{"Get a dose of her in jackboots and kilt", "(they call her \"Polythene Pam\")", "She's killer-diller when she's dressed to the hilt", "She's the kind of a girl that makes The Sunday Times", "seem more interesting.", "Yes you could say she was attractively built."};
        String diff = DiffTestCase.diffLines(Arrays.asList(before), Arrays.asList(after));
        Assert.assertThat((Object)Util.toLinux((String)diff), (Matcher)CoreMatchers.equalTo((Object)"1a2\n> (they call her \"Polythene Pam\")\n3c4,5\n< She's the kind of a girl that makes The News of The World\n---\n> She's the kind of a girl that makes The Sunday Times\n> seem more interesting.\n5d6\n< Yeah yeah yeah.\n"));
    }

    @Test
    public void testPosixTimeZone() {
        Assert.assertEquals((Object)"JST9", (Object)Util.toPosix((TimeZone)TimeZone.getTimeZone("Asia/Tokyo"), (boolean)true));
        String posixTime = Util.toPosix((TimeZone)TimeZone.getTimeZone("Australia/Sydney"), (boolean)true);
        if (posixTime.equals("EST10EST1,M10.5.0/2,M3.5.0/3")) {
            Assert.assertEquals((Object)"EST10EST1,M10.5.0/2,M3.5.0/3", (Object)posixTime);
        } else {
            Assert.assertEquals((Object)"EST10EST1,M10.1.0/2,M4.1.0/3", (Object)posixTime);
        }
        Assert.assertEquals((Object)"CET1CEST1,M3.5.0/2,M10.5.0/3", (Object)Util.toPosix((TimeZone)TimeZone.getTimeZone("Europe/Paris"), (boolean)true));
        Assert.assertEquals((Object)"UTC0", (Object)Util.toPosix((TimeZone)TimeZone.getTimeZone("UTC"), (boolean)true));
    }

    @Test
    public void testEnumConstants() {
        Map memoryTypeMap = Util.enumConstants(MemoryType.class);
        Assert.assertEquals((long)2L, (long)memoryTypeMap.size());
        Assert.assertEquals((Object)((Object)MemoryType.HEAP), memoryTypeMap.get("HEAP"));
        Assert.assertEquals((Object)((Object)MemoryType.NON_HEAP), memoryTypeMap.get("NON_HEAP"));
        try {
            memoryTypeMap.put("FOO", null);
            Assert.fail((String)"expected exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"HEAP", (Object)((MemoryType)Util.enumVal(MemoryType.class, (String)"HEAP")).name());
        Assert.assertNull((Object)Util.enumVal(MemoryType.class, (String)"heap"));
        Assert.assertNull((Object)Util.enumVal(MemoryType.class, (String)"nonexistent"));
    }

    @Test
    public void testToIterBitSet() {
        BitSet bitSet = new BitSet();
        this.assertToIterBitSet("", bitSet);
        bitSet.set(0);
        this.assertToIterBitSet("0", bitSet);
        bitSet.set(1);
        this.assertToIterBitSet("0, 1", bitSet);
        bitSet.clear();
        bitSet.set(10);
        this.assertToIterBitSet("10", bitSet);
    }

    private void assertToIterBitSet(String expected, BitSet bitSet) {
        StringBuilder buf = new StringBuilder();
        Iterator i$ = BitSets.toIter((BitSet)bitSet).iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(i));
        }
        Assert.assertEquals((Object)expected, (Object)buf.toString());
    }

    @Test
    public void testToListBitSet() {
        BitSet bitSet = new BitSet(10);
        Assert.assertEquals((Object)BitSets.toList((BitSet)bitSet), Collections.emptyList());
        bitSet.set(5);
        Assert.assertEquals((Object)BitSets.toList((BitSet)bitSet), Arrays.asList(5));
        bitSet.set(3);
        Assert.assertEquals((Object)BitSets.toList((BitSet)bitSet), Arrays.asList(3, 5));
    }

    @Test
    public void testBitSetOf() {
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.of((int[])new int[]{0, 4, 2})), Arrays.asList(0, 2, 4));
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.of((int[])new int[0])), Collections.emptyList());
    }

    @Test
    public void testBitSetBetween() {
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.range((int)0, (int)4)), Arrays.asList(0, 1, 2, 3));
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.range((int)1, (int)4)), Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.range((int)2, (int)2)), Collections.emptyList());
    }

    @Test
    public void testSqlBuilder() {
        SqlBuilder buf = new SqlBuilder(SqlDialect.EIGENBASE);
        Assert.assertEquals((long)0L, (long)buf.length());
        buf.append("select ");
        Assert.assertEquals((Object)"select ", (Object)buf.getSql());
        buf.identifier("x");
        Assert.assertEquals((Object)"select \"x\"", (Object)buf.getSql());
        buf.append(", ");
        buf.identifier(new String[]{"y", "a b"});
        Assert.assertEquals((Object)"select \"x\", \"y\".\"a b\"", (Object)buf.getSql());
        SqlString sqlString = buf.toSqlString();
        Assert.assertEquals((Object)SqlDialect.EIGENBASE, (Object)sqlString.getDialect());
        Assert.assertEquals((Object)buf.getSql(), (Object)sqlString.getSql());
        Assert.assertTrue((buf.getSql().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)buf.getSqlAndClear(), (Object)sqlString.getSql());
        Assert.assertEquals((long)0L, (long)buf.length());
        buf.clear();
        Assert.assertEquals((long)0L, (long)buf.length());
        buf.literal("can't get no satisfaction");
        Assert.assertEquals((Object)"'can''t get no satisfaction'", (Object)buf.getSqlAndClear());
        buf.literal(new Timestamp(0L));
        Assert.assertEquals((Object)"TIMESTAMP '1970-01-01 00:00:00'", (Object)buf.getSqlAndClear());
        buf.clear();
        Assert.assertEquals((long)0L, (long)buf.length());
        buf.append("hello world");
        Assert.assertEquals((long)2L, (long)buf.indexOf("l"));
        Assert.assertEquals((long)-1L, (long)buf.indexOf("z"));
        Assert.assertEquals((long)9L, (long)buf.indexOf("l", 5));
    }

    @Test
    public void testCompositeList() {
        String s;
        CompositeList list = CompositeList.of((List[])new List[0]);
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertTrue((boolean)list.isEmpty());
        try {
            String s2 = (String)list.get(0);
            Assert.fail((String)("expected error, got " + s2));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)list.listIterator().hasNext());
        List listEmpty = Collections.emptyList();
        List<String> listAbc = Arrays.asList("a", "b", "c");
        ArrayList<String> listEmpty2 = new ArrayList<String>();
        list = CompositeList.of(listEmpty, listAbc, listEmpty2);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((Object)"a", list.get(0));
        Assert.assertEquals((Object)"c", list.get(2));
        try {
            s = (String)list.get(3);
            Assert.fail((String)("expected error, got " + s));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            s = list.set(0, "z");
            Assert.fail((String)("expected error, got " + s));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        Iterator iterator = list.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"a", iterator.next());
        Assert.assertEquals((Object)"b", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.remove();
            Assert.fail((String)"expected error");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)"c", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        listEmpty2.add("zz");
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"zz", list.get(3));
        String ss = "";
        for (String s3 : CompositeList.of((List)list, (List)list)) {
            ss = ss + s3;
        }
        Assert.assertEquals((Object)"abczzabczz", (Object)ss);
    }

    @Test
    public void testTemplate() {
        Assert.assertEquals((Object)"Hello, world, what a nice day.", (Object)MessageFormat.format("Hello, {0}, what a nice {1}.", "world", "day"));
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("person", "world");
        map.put("time", "day");
        Assert.assertEquals((Object)"Hello, world, what a nice day.", (Object)Template.formatByName((String)"Hello, {person}, what a nice {time}.", map));
        Template template = Template.of((String)"Happy {age,number,#.00}th birthday, {person}!");
        map.clear();
        map.put("person", "Ringo");
        map.put("age", 64.5);
        Assert.assertEquals((Object)"Happy 64.50th birthday, Ringo!", (Object)template.format(map));
        map.remove("person");
        Assert.assertEquals((Object)"Happy 64.50th birthday, null!", (Object)template.format(map));
        map.clear();
        map.put(1, "Ringo");
        map.put("0", 64.5);
        Assert.assertEquals((Object)"Happy 64.50th birthday, Ringo!", (Object)template.format(map));
        map.put("lastName", "Starr");
        map.put("homeTown", "Liverpool");
        Assert.assertEquals((Object)"Happy 64.50th birthday, Ringo!", (Object)template.format(map));
        Assert.assertEquals(Arrays.asList("age", "person"), (Object)template.getParameterNames());
        Template template2 = Template.of((String)"Don''t expand 'this {brace}'.");
        Assert.assertEquals(Collections.emptyList(), (Object)template2.getParameterNames());
        Assert.assertEquals((Object)"Don't expand this {brace}.", (Object)template2.format(Collections.emptyMap()));
        Assert.assertEquals((Object)"", (Object)Template.formatByName((String)"", map));
    }

    @Test
    public void testParseLocale() {
        String[] localeNames;
        Locale[] locales;
        for (Locale locale : locales = new Locale[]{Locale.CANADA, Locale.CANADA_FRENCH, Locale.getDefault(), Locale.US, Locale.TRADITIONAL_CHINESE}) {
            Assert.assertEquals((Object)locale, (Object)Util.parseLocale((String)locale.toString()));
        }
        for (String localeName : localeNames = new String[]{"en", "de_DE", "_GB", "en_US_WIN", "de__POSIX", "fr__MAC"}) {
            Assert.assertEquals((Object)localeName, (Object)Util.parseLocale((String)localeName).toString());
        }
    }

    @Test
    public void testStringChunker() {
        int chunkCount;
        String source = "0123456789AB";
        Object[] ref = new String[]{"0123456789AB"};
        int chunkSize = 0;
        try {
            chunkCount = StringChunker.countChunks((int)source.length(), (int)chunkSize);
            Assert.fail((String)"Expected division by zero error");
        }
        catch (ArithmeticException ae) {
            // empty catch block
        }
        chunkSize = Short.MAX_VALUE;
        chunkCount = StringChunker.countChunks((int)source.length(), (int)chunkSize);
        Assert.assertEquals((long)1L, (long)chunkCount);
        Object[] chunks = StringChunker.slice((String)source, (int)chunkSize);
        Assert.assertTrue((boolean)Arrays.equals(ref, chunks));
        chunkSize = 12;
        chunkCount = StringChunker.countChunks((int)source.length(), (int)chunkSize);
        Assert.assertEquals((long)1L, (long)chunkCount);
        chunks = StringChunker.slice((String)source, (int)chunkSize);
        Assert.assertTrue((boolean)Arrays.equals(ref, chunks));
        chunkSize = 6;
        chunkCount = StringChunker.countChunks((int)source.length(), (int)chunkSize);
        Assert.assertEquals((long)2L, (long)chunkCount);
        ref = new String[]{"012345", "6789AB"};
        chunks = StringChunker.slice((String)source, (int)chunkSize);
        Assert.assertTrue((boolean)Arrays.equals(ref, chunks));
        chunkSize = 5;
        chunkCount = StringChunker.countChunks((int)source.length(), (int)chunkSize);
        Assert.assertEquals((long)3L, (long)chunkCount);
        ref = new String[]{"01234", "56789", "AB"};
        chunks = StringChunker.slice((String)source, (int)chunkSize);
        Assert.assertTrue((boolean)Arrays.equals(ref, chunks));
        chunkSize = 1;
        chunkCount = StringChunker.countChunks((int)source.length(), (int)chunkSize);
        Assert.assertEquals((long)12L, (long)chunkCount);
        ref = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B"};
        chunks = StringChunker.slice((String)source, (int)chunkSize);
        Assert.assertTrue((boolean)Arrays.equals(ref, chunks));
        source = "";
        chunkCount = StringChunker.countChunks((int)source.length(), (int)chunkSize);
        Assert.assertEquals((long)1L, (long)chunkCount);
        ref = new String[]{""};
        chunks = StringChunker.slice((String)source, (int)chunkSize);
        Assert.assertTrue((boolean)Arrays.equals(ref, chunks));
        source = null;
        try {
            chunks = StringChunker.slice((String)source, (int)chunkSize);
            Assert.fail((String)"Expected null pointer");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    @Test
    public void testSpaces() {
        Assert.assertEquals((Object)"", (Object)Spaces.of((int)0));
        Assert.assertEquals((Object)" ", (Object)Spaces.of((int)1));
        Assert.assertEquals((Object)" ", (Object)Spaces.of((int)1));
        Assert.assertEquals((Object)"         ", (Object)Spaces.of((int)9));
        Assert.assertEquals((Object)"     ", (Object)Spaces.of((int)5));
        Assert.assertEquals((long)1000L, (long)Spaces.of((int)1000).length());
    }

    @Test
    public void testSpaceString() {
        Assert.assertThat((Object)Spaces.sequence((int)0).toString(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)Spaces.sequence((int)1).toString(), (Matcher)CoreMatchers.equalTo((Object)" "));
        Assert.assertThat((Object)Spaces.sequence((int)9).toString(), (Matcher)CoreMatchers.equalTo((Object)"         "));
        Assert.assertThat((Object)Spaces.sequence((int)5).toString(), (Matcher)CoreMatchers.equalTo((Object)"     "));
        String s = new StringBuilder().append("xx").append(Spaces.MAX, 0, 100).toString();
        Assert.assertThat((Object)s.length(), (Matcher)CoreMatchers.equalTo((Object)102));
        Assert.assertThat((Object)Spaces.sequence((int)1000000000).length(), (Matcher)CoreMatchers.equalTo((Object)1000000000));
        StringWriter sw = new StringWriter();
        Spaces.append((StringWriter)sw, (int)4);
        Assert.assertThat((Object)sw.toString(), (Matcher)CoreMatchers.equalTo((Object)"    "));
        StringBuilder buf = new StringBuilder();
        Spaces.append((StringBuilder)buf, (int)4);
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"    "));
        Assert.assertThat((Object)Spaces.padLeft((String)"xy", (int)5), (Matcher)CoreMatchers.equalTo((Object)"   xy"));
        Assert.assertThat((Object)Spaces.padLeft((String)"abcde", (int)5), (Matcher)CoreMatchers.equalTo((Object)"abcde"));
        Assert.assertThat((Object)Spaces.padLeft((String)"abcdef", (int)5), (Matcher)CoreMatchers.equalTo((Object)"abcdef"));
        Assert.assertThat((Object)Spaces.padRight((String)"xy", (int)5), (Matcher)CoreMatchers.equalTo((Object)"xy   "));
        Assert.assertThat((Object)Spaces.padRight((String)"abcde", (int)5), (Matcher)CoreMatchers.equalTo((Object)"abcde"));
        Assert.assertThat((Object)Spaces.padRight((String)"abcdef", (int)5), (Matcher)CoreMatchers.equalTo((Object)"abcdef"));
    }

    @Test
    public void testPairZip() {
        List<String> strings = Arrays.asList("paul", "george", "john", "ringo");
        List<Integer> integers = Arrays.asList(1942, 1943, 1940);
        List zip = Pair.zip(strings, integers);
        Assert.assertEquals((long)3L, (long)zip.size());
        Assert.assertEquals((Object)"paul:1942", (Object)((String)((Pair)zip.get((int)0)).left + ":" + ((Pair)zip.get((int)0)).right));
        Assert.assertEquals((Object)"john", (Object)((Pair)zip.get((int)2)).left);
        int x = 0;
        for (Pair pair : zip) {
            x += ((Integer)pair.right).intValue();
        }
        Assert.assertEquals((long)5825L, (long)x);
    }

    @Test
    public void testPairAdjacents() {
        List<String> strings = Arrays.asList("a", "b", "c");
        ArrayList<String> result = new ArrayList<String>();
        for (Pair pair : Pair.adjacents(strings)) {
            result.add(pair.toString());
        }
        Assert.assertThat((Object)((Object)result).toString(), (Matcher)CoreMatchers.equalTo((Object)"[<a, b>, <b, c>]"));
        Assert.assertThat((Object)Pair.adjacents((Iterable)ImmutableList.of()).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Pair.adjacents((Iterable)ImmutableList.of((Object)"a")).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Iterables.size((Iterable)Pair.adjacents(Collections.nCopies(100, null))), (Matcher)CoreMatchers.equalTo((Object)99));
    }

    @Test
    public void testPairFirstAnd() {
        List<String> strings = Arrays.asList("a", "b", "c");
        ArrayList<String> result = new ArrayList<String>();
        for (Pair pair : Pair.firstAnd(strings)) {
            result.add(pair.toString());
        }
        Assert.assertThat((Object)((Object)result).toString(), (Matcher)CoreMatchers.equalTo((Object)"[<a, b>, <a, c>]"));
        Assert.assertThat((Object)Pair.firstAnd((Iterable)ImmutableList.of()).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Pair.firstAnd((Iterable)ImmutableList.of((Object)"a")).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Iterables.size((Iterable)Pair.firstAnd(Collections.nCopies(100, null))), (Matcher)CoreMatchers.equalTo((Object)99));
    }

    @Test
    public void testQuotientList() {
        List listBad;
        List<String> beatles = Arrays.asList("john", "paul", "george", "ringo");
        List list0 = Util.quotientList(beatles, (int)3, (int)0);
        Assert.assertEquals((long)2L, (long)list0.size());
        Assert.assertEquals((Object)"john", list0.get(0));
        Assert.assertEquals((Object)"ringo", list0.get(1));
        List list1 = Util.quotientList(beatles, (int)3, (int)1);
        Assert.assertEquals((long)1L, (long)list1.size());
        Assert.assertEquals((Object)"paul", list1.get(0));
        List list2 = Util.quotientList(beatles, (int)3, (int)2);
        Assert.assertEquals((long)1L, (long)list2.size());
        Assert.assertEquals((Object)"george", list2.get(0));
        try {
            listBad = Util.quotientList(beatles, (int)3, (int)4);
            Assert.fail((String)("Expected error, got " + listBad));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            listBad = Util.quotientList(beatles, (int)3, (int)3);
            Assert.fail((String)("Expected error, got " + listBad));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            listBad = Util.quotientList(beatles, (int)0, (int)0);
            Assert.fail((String)("Expected error, got " + listBad));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        List empty = Collections.emptyList();
        List list3 = Util.quotientList(empty, (int)7, (int)2);
        Assert.assertEquals((long)0L, (long)list3.size());
        List list4 = Util.quotientList(beatles, (int)10, (int)0);
        Assert.assertEquals((long)1L, (long)list4.size());
        Assert.assertEquals((Object)"john", list4.get(0));
        List list5 = Util.quotientList(beatles, (int)10, (int)5);
        Assert.assertEquals((long)0L, (long)list5.size());
    }

    @Test
    public void testImmutableIntList() {
        ImmutableIntList list = ImmutableIntList.of();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)list, Collections.emptyList());
        list = ImmutableIntList.of((int[])new int[]{1, 3, 5});
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"[1, 3, 5]", (Object)list.toString());
        Assert.assertEquals((long)list.hashCode(), (long)Arrays.asList(1, 3, 5).hashCode());
        Integer[] integers = (Integer[])list.toArray((Object[])new Integer[3]);
        Assert.assertEquals((long)1L, (long)integers[0].intValue());
        Assert.assertEquals((long)3L, (long)integers[1].intValue());
        Assert.assertEquals((long)5L, (long)integers[2].intValue());
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)BitSets.contains((BitSet)BitSets.range((int)0, (int)5), (BitSet)BitSets.range((int)2, (int)4)));
        Assert.assertTrue((boolean)BitSets.contains((BitSet)BitSets.range((int)0, (int)5), (BitSet)BitSets.of((int[])new int[]{4})));
        Assert.assertFalse((boolean)BitSets.contains((BitSet)BitSets.range((int)0, (int)5), (BitSet)BitSets.of((int[])new int[]{14})));
        Assert.assertFalse((boolean)BitSets.contains((BitSet)BitSets.range((int)20, (int)25), (BitSet)BitSets.of((int[])new int[]{14})));
        BitSet empty = BitSets.of((int[])new int[0]);
        Assert.assertTrue((boolean)BitSets.contains((BitSet)BitSets.range((int)20, (int)25), (BitSet)empty));
        Assert.assertTrue((boolean)BitSets.contains((BitSet)empty, (BitSet)empty));
        Assert.assertTrue((boolean)BitSets.contains((BitSet)BitSets.of((int[])new int[]{1, 4, 7}), (BitSet)BitSets.of((int[])new int[]{1, 4, 7})));
    }

    @Test
    public void testIntegerIntervalSet() {
        this.checkIntegerIntervalSet("1,5", 1, 5);
        this.checkIntegerIntervalSet("", new int[0]);
        this.checkIntegerIntervalSet("2,4,-1-5", new int[0]);
        this.checkIntegerIntervalSet("1-6,-3-5,4,9", 1, 2, 4, 6, 9);
        this.checkIntegerIntervalSet("1,3,1,2-4,-2,-4", 1, 3);
    }

    private List<Integer> checkIntegerIntervalSet(String s, int ... ints) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set set = IntegerIntervalSet.of((String)s);
        Assert.assertEquals((long)set.size(), (long)ints.length);
        for (Integer integer : set) {
            list.add(integer);
        }
        Assert.assertEquals(new HashSet(IntList.asList((int[])ints)), (Object)set);
        return list;
    }

    @Test
    public void testFlatList() {
        List emp = FlatLists.of((Object[])new Object[0]);
        List emp0 = Collections.emptyList();
        Assert.assertEquals((Object)emp, emp0);
        Assert.assertEquals((long)emp.hashCode(), (long)emp0.hashCode());
        List ab = FlatLists.of((Object)"A", (Object)"B");
        List<String> ab0 = Arrays.asList("A", "B");
        Assert.assertEquals((Object)ab, ab0);
        Assert.assertEquals((long)ab.hashCode(), (long)ab0.hashCode());
        List an = FlatLists.of((Object)"A", null);
        List<String> an0 = Arrays.asList("A", null);
        Assert.assertEquals((Object)an, an0);
        Assert.assertEquals((long)an.hashCode(), (long)an0.hashCode());
        List anb = FlatLists.of((Object)"A", null, (Object)"B");
        List<String> anb0 = Arrays.asList("A", null, "B");
        Assert.assertEquals((Object)anb, anb0);
        Assert.assertEquals((long)anb.hashCode(), (long)anb0.hashCode());
    }

    @Test
    public void testToCamelCase() {
        Assert.assertEquals((Object)"myJdbcDriver", (Object)Util.toCamelCase((String)"MY_JDBC_DRIVER"));
        Assert.assertEquals((Object)"myJdbcDriver", (Object)Util.toCamelCase((String)"MY_JDBC__DRIVER"));
        Assert.assertEquals((Object)"myJdbcDriver", (Object)Util.toCamelCase((String)"my_jdbc_driver"));
        Assert.assertEquals((Object)"abCdefGHij", (Object)Util.toCamelCase((String)"ab_cdEf_g_Hij"));
        Assert.assertEquals((Object)"JdbcDriver", (Object)Util.toCamelCase((String)"_JDBC_DRIVER"));
        Assert.assertEquals((Object)"", (Object)Util.toCamelCase((String)"_"));
        Assert.assertEquals((Object)"", (Object)Util.toCamelCase((String)""));
    }

    @Test
    public void testCamelToUpper() {
        Assert.assertEquals((Object)"MY_JDBC_DRIVER", (Object)Util.camelToUpper((String)"myJdbcDriver"));
        Assert.assertEquals((Object)"MY_J_D_B_C_DRIVER", (Object)Util.camelToUpper((String)"myJDBCDriver"));
        Assert.assertEquals((Object)"AB_CDEF_G_HIJ", (Object)Util.camelToUpper((String)"abCdefGHij"));
        Assert.assertEquals((Object)"_JDBC_DRIVER", (Object)Util.camelToUpper((String)"JdbcDriver"));
        Assert.assertEquals((Object)"", (Object)Util.camelToUpper((String)""));
    }

    @Test
    public void testDistinct() {
        Assert.assertTrue((boolean)Util.isDistinct(Collections.emptyList()));
        Assert.assertTrue((boolean)Util.isDistinct(Arrays.asList("a")));
        Assert.assertTrue((boolean)Util.isDistinct(Arrays.asList("a", "b", "c")));
        Assert.assertFalse((boolean)Util.isDistinct(Arrays.asList("a", "b", "a")));
        Assert.assertTrue((boolean)Util.isDistinct(Arrays.asList("a", "b", null)));
        Assert.assertFalse((boolean)Util.isDistinct(Arrays.asList("a", null, "b", null)));
    }

    @Test
    public void testJsonBuilder() {
        JsonBuilder builder = new JsonBuilder();
        Map map = builder.map();
        map.put("foo", 1);
        map.put("baz", true);
        map.put("bar", "can't");
        List list = builder.list();
        map.put("list", list);
        list.add(2);
        list.add(3);
        list.add(builder.list());
        list.add(builder.map());
        list.add(null);
        map.put("nullValue", null);
        Assert.assertEquals((Object)"{\n  foo: 1,\n  baz: true,\n  bar: \"can't\",\n  list: [\n    2,\n    3,\n    [],\n    {},\n    null\n  ],\n  nullValue: null\n}", (Object)builder.toJsonString((Object)map));
    }

    @Test
    public void testCompositeMap() {
        String[] beatles = new String[]{"john", "paul", "george", "ringo"};
        LinkedHashMap<String, Integer> beatleMap = new LinkedHashMap<String, Integer>();
        for (String beatle : beatles) {
            beatleMap.put(beatle, beatle.length());
        }
        CompositeMap map = CompositeMap.of(beatleMap, (Map[])new Map[0]);
        this.checkCompositeMap(beatles, (Map<String, Integer>)map);
        map = CompositeMap.of(beatleMap, (Map[])new Map[]{Collections.emptyMap()});
        this.checkCompositeMap(beatles, (Map<String, Integer>)map);
        map = CompositeMap.of(Collections.emptyMap(), (Map[])new Map[]{beatleMap});
        this.checkCompositeMap(beatles, (Map<String, Integer>)map);
        map = CompositeMap.of(beatleMap, (Map[])new Map[]{beatleMap});
        this.checkCompositeMap(beatles, (Map<String, Integer>)map);
        LinkedHashMap<String, Integer> founderMap = new LinkedHashMap<String, Integer>();
        founderMap.put("ben", 1706);
        founderMap.put("george", 1732);
        founderMap.put("thomas", 1743);
        map = CompositeMap.of(beatleMap, (Map[])new Map[]{founderMap});
        Assert.assertThat((Object)map.isEmpty(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.keySet().size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.entrySet().size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.values().size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.containsKey((Object)"john"), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsKey((Object)"george"), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsKey((Object)"ben"), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsKey((Object)"andrew"), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)map.get((Object)"ben"), (Matcher)CoreMatchers.equalTo((Object)1706));
        Assert.assertThat((Object)map.get((Object)"george"), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.values().contains(1743), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)map.values().contains(1732), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)map.values().contains(1999), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    private void checkCompositeMap(String[] beatles, Map<String, Integer> map) {
        Assert.assertThat((Object)4, (Matcher)CoreMatchers.equalTo((Object)map.size()));
        Assert.assertThat((Object)false, (Matcher)CoreMatchers.equalTo((Object)map.isEmpty()));
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.equalTo(new HashSet<String>(Arrays.asList(beatles))));
        Assert.assertThat((Object)ImmutableMultiset.copyOf(map.values()), (Matcher)CoreMatchers.equalTo((Object)ImmutableMultiset.copyOf(Arrays.asList(4, 4, 6, 5))));
    }

    @Test
    public void testCommaList() {
        try {
            String s = Util.commaList(null);
            Assert.fail((String)("expected NPE, got " + s));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertThat((Object)Util.commaList((List)ImmutableList.of()), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)Util.commaList((List)ImmutableList.of((Object)1)), (Matcher)CoreMatchers.equalTo((Object)"1"));
        Assert.assertThat((Object)Util.commaList((List)ImmutableList.of((Object)2, (Object)3)), (Matcher)CoreMatchers.equalTo((Object)"2, 3"));
        Assert.assertThat((Object)Util.commaList(Arrays.asList(2, null, 3)), (Matcher)CoreMatchers.equalTo((Object)"2, null, 3"));
    }

    @Test
    public void testFirstDuplicate() {
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of()), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5)), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5, (Object)6)), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5, (Object)6, (Object)5)), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5, (Object)5, (Object)6)), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5, (Object)5, (Object)6, (Object)5)), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object[])new Integer[]{12, 13, 14, 15, 16, 17, 3, 19, 3, 21})), (Matcher)CoreMatchers.equalTo((Object)18));
    }

    @Test
    public void testIsDistinctBenchmark() {
        final int limit = Benchmark.enabled() ? 1000000 : 10;
        int zMax = 100;
        for (int i = 0; i < 30; ++i) {
            final int size = i;
            new Benchmark("isDistinct " + i + " (set)", (Function1)new Function1<Benchmark.Statistician, Void>(){

                public Void apply(Benchmark.Statistician statistician) {
                    Random random = new Random(0L);
                    ArrayList lists = new ArrayList();
                    for (int z = 0; z < 100; ++z) {
                        ArrayList<Integer> list = new ArrayList<Integer>();
                        for (int k = 0; k < size; ++k) {
                            list.add(random.nextInt(size * size));
                        }
                        lists.add(list);
                    }
                    long nanos = System.nanoTime();
                    int n = 0;
                    for (int j = 0; j < limit; ++j) {
                        n += Util.firstDuplicate((List)((List)lists.get(j % 100)));
                    }
                    statistician.record(nanos);
                    Util.discard((int)n);
                    return null;
                }
            }, 5).run();
        }
    }

    @Test
    public void testHash() {
        this.checkHash(0.0);
        this.checkHash(1.0);
        this.checkHash(-2.5);
        this.checkHash(3.3333333333333335);
        this.checkHash(Double.NEGATIVE_INFINITY);
        this.checkHash(Double.POSITIVE_INFINITY);
        this.checkHash(Double.MAX_VALUE);
        this.checkHash(Double.MIN_VALUE);
    }

    public void checkHash(double v) {
        Assert.assertThat((Object)new Double(v).hashCode(), (Matcher)CoreMatchers.equalTo((Object)Util.hashCode((double)v)));
    }

    @Test
    public void testStartsWithList() {
        Assert.assertThat((Object)Util.startsWith(this.list("x"), this.list(new String[0])), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.startsWith(this.list("x"), this.list("x")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.startsWith(this.list("x"), this.list("y")), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Util.startsWith(this.list("x"), this.list("x", "y")), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Util.startsWith(this.list("x", "y"), this.list("x")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.startsWith(this.list(new String[0]), this.list(new String[0])), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.startsWith(this.list(new String[0]), this.list("x")), (Matcher)CoreMatchers.is((Object)false));
    }

    public List<String> list(String ... xs) {
        return Arrays.asList(xs);
    }

    @Test
    public void testResources() {
        Resources.validate((Object)Static.RESOURCE);
    }
}

