/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import org.eigenbase.util.Permutation;
import org.junit.Assert;
import org.junit.Test;

public class PermutationTestCase {
    @Test
    public void testOne() {
        Permutation perm = new Permutation(4);
        Assert.assertEquals((Object)"[0, 1, 2, 3]", (Object)perm.toString());
        Assert.assertEquals((long)4L, (long)perm.size());
        perm.set(0, 2);
        Assert.assertEquals((Object)"[2, 1, 0, 3]", (Object)perm.toString());
        perm.set(1, 0);
        Assert.assertEquals((Object)"[2, 0, 1, 3]", (Object)perm.toString());
        Permutation invPerm = perm.inverse();
        Assert.assertEquals((Object)"[1, 2, 0, 3]", (Object)invPerm.toString());
        perm.set(0, 0);
        Assert.assertEquals((Object)"[0, 2, 1, 3]", (Object)perm.toString());
        Assert.assertEquals((Object)"[1, 2, 0, 3]", (Object)invPerm.toString());
    }

    @Test
    public void testTwo() {
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[3] = 1;
        Permutation perm = new Permutation(nArray);
        Assert.assertFalse((boolean)perm.isIdentity());
        Assert.assertEquals((Object)"[3, 2, 0, 1]", (Object)perm.toString());
        Permutation perm2 = (Permutation)perm.clone();
        Assert.assertEquals((Object)"[3, 2, 0, 1]", (Object)perm2.toString());
        Assert.assertTrue((boolean)perm.equals((Object)perm2));
        Assert.assertTrue((boolean)perm2.equals((Object)perm));
        perm.set(2, 1);
        Assert.assertEquals((Object)"[3, 2, 1, 0]", (Object)perm.toString());
        Assert.assertFalse((boolean)perm.equals((Object)perm2));
        Assert.assertEquals((Object)"[3, 2, 0, 1]", (Object)perm2.toString());
        perm2.set(2, 3);
        Assert.assertEquals((Object)"[0, 2, 3, 1]", (Object)perm2.toString());
    }

    @Test
    public void testInsert() {
        int[] nArray = new int[5];
        nArray[0] = 3;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 1;
        Permutation perm = new Permutation(nArray);
        perm.insertTarget(2);
        Assert.assertEquals((Object)"[4, 0, 5, 3, 1, 2]", (Object)perm.toString());
        int[] nArray2 = new int[5];
        nArray2[0] = 3;
        nArray2[2] = 4;
        nArray2[3] = 2;
        nArray2[4] = 1;
        perm = new Permutation(nArray2);
        perm.insertTarget(0);
        Assert.assertEquals((Object)"[4, 1, 5, 3, 2, 0]", (Object)perm.toString());
        int[] nArray3 = new int[5];
        nArray3[0] = 3;
        nArray3[2] = 4;
        nArray3[3] = 2;
        nArray3[4] = 1;
        perm = new Permutation(nArray3);
        perm.insertTarget(5);
        Assert.assertEquals((Object)"[3, 0, 4, 2, 1, 5]", (Object)perm.toString());
        perm = new Permutation(new int[0]);
        perm.insertTarget(0);
        Assert.assertEquals((Object)"[0]", (Object)perm.toString());
    }

    @Test
    public void testEmpty() {
        Permutation perm = new Permutation(0);
        Assert.assertTrue((boolean)perm.isIdentity());
        Assert.assertEquals((Object)"[]", (Object)perm.toString());
        Assert.assertTrue((boolean)perm.equals((Object)perm));
        Assert.assertTrue((boolean)perm.equals((Object)perm.inverse()));
        try {
            perm.set(1, 0);
            Assert.fail((String)"expected exception");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            perm.set(-1, 2);
            Assert.fail((String)"expected exception");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

