/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.sql.test.DefaultSqlTestFactory;
import org.eigenbase.sql.test.SqlTester;
import org.eigenbase.sql.test.SqlTesterImpl;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.TestUtil;
import org.eigenbase.util.Util;
import org.junit.Assert;

public class SqlValidatorTestCase {
    private static final Pattern LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
    private static final Pattern LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");
    protected final SqlTester tester = this.getTester();

    public SqlTester getTester() {
        return new SqlTesterImpl(DefaultSqlTestFactory.INSTANCE);
    }

    public void check(String sql) {
        this.tester.assertExceptionIsThrown(sql, null);
    }

    public void checkExp(String sql) {
        this.tester.assertExceptionIsThrown(SqlTesterImpl.buildQuery(sql), null);
    }

    public final void checkFails(String sql, String expected) {
        this.tester.assertExceptionIsThrown(sql, expected);
    }

    public final void checkExpFails(String sql, String expected) {
        this.tester.assertExceptionIsThrown(SqlTesterImpl.buildQuery(sql), expected);
    }

    public final void checkWholeExpFails(String sql, String expected) {
        assert (sql.indexOf(94) < 0);
        this.checkExpFails("^" + sql + "^", expected);
    }

    public final void checkExpType(String sql, String expected) {
        this.checkColumnType(SqlTesterImpl.buildQuery(sql), expected);
    }

    public final void checkColumnType(String sql, String expected) {
        this.tester.checkColumnType(sql, expected);
    }

    public final void checkResultType(String sql, String expected) {
        this.tester.checkResultType(sql, expected);
    }

    public final void checkIntervalConv(String sql, String expected) {
        this.tester.checkIntervalConv(SqlTesterImpl.buildQuery(sql), expected);
    }

    protected final void assertExceptionIsThrown(String sql, String expectedMsgPattern) {
        assert (expectedMsgPattern != null);
        this.tester.assertExceptionIsThrown(sql, expectedMsgPattern);
    }

    public void checkCharset(String sql, Charset expectedCharset) {
        this.tester.checkCharset(sql, expectedCharset);
    }

    public void checkCollation(String sql, String expectedCollationName, SqlCollation.Coercibility expectedCoercibility) {
        this.tester.checkCollation(sql, expectedCollationName, expectedCoercibility);
    }

    public static void checkEx(Throwable ex, String expectedMsgPattern, SqlParserUtil.StringAndPos sap) {
        if (null == ex) {
            if (expectedMsgPattern == null) {
                return;
            }
            throw new AssertionError((Object)("Expected query to throw exception, but it did not; query [" + sap.sql + "]; expected [" + expectedMsgPattern + "]"));
        }
        Throwable actualException = ex;
        String actualMessage = actualException.getMessage();
        int actualLine = -1;
        int actualColumn = -1;
        int actualEndLine = 100;
        int actualEndColumn = 99;
        EigenbaseContextException ece = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof EigenbaseContextException) {
                ece = (EigenbaseContextException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        SqlParseException spe = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof SqlParseException && ((SqlParseException)x).getPos() != null) {
                spe = (SqlParseException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        if (ece != null) {
            actualLine = ece.getPosLine();
            actualColumn = ece.getPosColumn();
            actualEndLine = ece.getEndPosLine();
            actualEndColumn = ece.getEndPosColumn();
            if (ece.getCause() != null) {
                actualException = ece.getCause();
                actualMessage = actualException.getMessage();
            }
        } else if (spe != null) {
            actualLine = spe.getPos().getLineNum();
            actualColumn = spe.getPos().getColumnNum();
            actualEndLine = spe.getPos().getEndLineNum();
            actualEndColumn = spe.getPos().getEndColumnNum();
            if (spe.getCause() != null) {
                actualException = spe.getCause();
                actualMessage = actualException.getMessage();
            }
        } else {
            String message = ex.getMessage();
            if (message != null) {
                Matcher matcher = LINE_COL_TWICE_PATTERN.matcher(message);
                if (matcher.matches()) {
                    actualLine = Integer.parseInt(matcher.group(1));
                    actualColumn = Integer.parseInt(matcher.group(2));
                    actualEndLine = Integer.parseInt(matcher.group(3));
                    actualEndColumn = Integer.parseInt(matcher.group(4));
                    actualMessage = matcher.group(5);
                } else {
                    matcher = LINE_COL_PATTERN.matcher(message);
                    if (matcher.matches()) {
                        actualLine = Integer.parseInt(matcher.group(1));
                        actualColumn = Integer.parseInt(matcher.group(2));
                    }
                }
            }
        }
        if (null == expectedMsgPattern) {
            if (null != actualException) {
                actualException.printStackTrace();
                Assert.fail((String)("Validator threw unexpected exception; query [" + sap.sql + "]; exception [" + actualMessage + "]; pos [line " + actualLine + " col " + actualColumn + " thru line " + actualLine + " col " + actualColumn + "]"));
            }
        } else if (null == actualException) {
            Assert.fail((String)("Expected validator to throw exception, but it did not; query [" + sap.sql + "]; expected [" + expectedMsgPattern + "]"));
        } else {
            String sqlWithCarets;
            if (actualColumn <= 0 || actualLine <= 0 || actualEndColumn <= 0 || actualEndLine <= 0) {
                if (sap.pos != null) {
                    throw new AssertionError((Object)("Expected error to have position, but actual error did not:  actual pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]"));
                }
                sqlWithCarets = sap.sql;
            } else {
                sqlWithCarets = SqlParserUtil.addCarets((String)sap.sql, (int)actualLine, (int)actualColumn, (int)actualEndLine, (int)(actualEndColumn + 1));
                if (sap.pos == null) {
                    throw new AssertionError((Object)("Actual error had a position, but expected error did not. Add error position carets to sql:\n" + sqlWithCarets));
                }
            }
            if (actualMessage != null) {
                actualMessage = Util.toLinux((String)actualMessage);
            }
            if (actualMessage == null || !actualMessage.matches(expectedMsgPattern)) {
                actualException.printStackTrace();
                String actualJavaRegexp = actualMessage == null ? "null" : TestUtil.quoteForJava(TestUtil.quotePattern(actualMessage));
                Assert.fail((String)("Validator threw different exception than expected; query [" + sap.sql + "];\n" + " expected pattern [" + expectedMsgPattern + "];\n" + " actual [" + actualMessage + "];\n" + " actual as java regexp [" + actualJavaRegexp + "]; pos [" + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]; sql [" + sqlWithCarets + "]"));
            } else if (sap.pos != null && (actualLine != sap.pos.getLineNum() || actualColumn != sap.pos.getColumnNum() || actualEndLine != sap.pos.getEndLineNum() || actualEndColumn != sap.pos.getEndColumnNum())) {
                Assert.fail((String)("Validator threw expected exception [" + actualMessage + "];\nbut at pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "];\nsql [" + sqlWithCarets + "]"));
            }
        }
    }

    public static interface Tester {
        public SqlNode parseQuery(String var1) throws SqlParseException;

        public SqlNode parseAndValidate(SqlValidator var1, String var2);

        public SqlValidator getValidator();

        public void assertExceptionIsThrown(String var1, String var2);

        public RelDataType getColumnType(String var1);

        public RelDataType getResultType(String var1);

        public void checkCollation(String var1, String var2, SqlCollation.Coercibility var3);

        public void checkCharset(String var1, Charset var2);

        public void checkColumnType(String var1, String var2);

        public void checkFieldOrigin(String var1, String var2);

        public void checkRewrite(SqlValidator var1, String var2, String var3);

        public void checkResultType(String var1, String var2);

        public void checkIntervalConv(String var1, String var2);

        public SqlMonotonicity getMonotonicity(String var1);

        public SqlConformance getConformance();
    }
}

