/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import net.hydromatic.optiq.jdbc.JavaTypeFactoryImpl;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexTransformer;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RexTransformerTest {
    RexBuilder rexBuilder = null;
    RexNode x;
    RexNode y;
    RexNode z;
    RexNode trueRex;
    RexNode falseRex;
    RelDataType boolRelDataType;
    RelDataTypeFactory typeFactory;

    @Before
    public void setUp() {
        this.typeFactory = new JavaTypeFactoryImpl();
        this.rexBuilder = new RexBuilder(this.typeFactory);
        this.boolRelDataType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        this.x = new RexInputRef(0, this.typeFactory.createTypeWithNullability(this.boolRelDataType, true));
        this.y = new RexInputRef(1, this.typeFactory.createTypeWithNullability(this.boolRelDataType, true));
        this.z = new RexInputRef(2, this.typeFactory.createTypeWithNullability(this.boolRelDataType, true));
        this.trueRex = this.rexBuilder.makeLiteral(true);
        this.falseRex = this.rexBuilder.makeLiteral(false);
    }

    void check(Boolean encapsulateType, RexNode node, String expected) {
        RexNode root = encapsulateType == null ? node : (encapsulateType.equals(Boolean.TRUE) ? this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, new RexNode[]{node}) : this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_FALSE, new RexNode[]{node}));
        RexTransformer transformer = new RexTransformer(root, this.rexBuilder);
        RexNode result = transformer.transformNullSemantics();
        String actual = result.toString();
        if (!actual.equals(expected)) {
            String msg = "\nExpected=<" + expected + ">\n  Actual=<" + actual + ">";
            Assert.fail((String)msg);
        }
    }

    @Test
    public void testPreTests() {
        RexInputRef node = new RexInputRef(0, this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), true));
        Assert.assertTrue((boolean)node.getType().isNullable());
        node = new RexInputRef(0, this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), false));
        Assert.assertFalse((boolean)node.getType().isNullable());
    }

    @Test
    public void testNonBooleans() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{this.x, this.y});
        String expected = node.toString();
        this.check(Boolean.TRUE, node, expected);
        this.check(Boolean.FALSE, node, expected);
        this.check(null, node, expected);
    }

    @Test
    public void testOrUnchanged() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.x, this.y});
        String expected = node.toString();
        this.check(Boolean.TRUE, node, expected);
        this.check(Boolean.FALSE, node, expected);
        this.check(null, node, expected);
    }

    @Test
    public void testSimpleAnd() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.x, this.y});
        this.check(Boolean.FALSE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), AND($0, $1))");
    }

    @Test
    public void testSimpleEquals() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.x, this.y});
        this.check(Boolean.TRUE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), =($0, $1))");
    }

    @Test
    public void testSimpleNotEquals() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{this.x, this.y});
        this.check(Boolean.FALSE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), <>($0, $1))");
    }

    @Test
    public void testSimpleGreaterThan() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.x, this.y});
        this.check(Boolean.TRUE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), >($0, $1))");
    }

    @Test
    public void testSimpleGreaterEquals() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{this.x, this.y});
        this.check(Boolean.FALSE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), >=($0, $1))");
    }

    @Test
    public void testSimpleLessThan() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.x, this.y});
        this.check(Boolean.TRUE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), <($0, $1))");
    }

    @Test
    public void testSimpleLessEqual() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.x, this.y});
        this.check(Boolean.FALSE, node, "AND(AND(IS NOT NULL($0), IS NOT NULL($1)), <=($0, $1))");
    }

    @Test
    public void testOptimizeNonNullLiterals() {
        RexNode node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.x, this.trueRex});
        this.check(Boolean.TRUE, node, "AND(IS NOT NULL($0), <=($0, true))");
        node = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.trueRex, this.x});
        this.check(Boolean.FALSE, node, "AND(IS NOT NULL($0), <=(true, $0))");
    }

    @Test
    public void testSimpleIdentifier() {
        RexInputRef node = this.rexBuilder.makeInputRef(this.boolRelDataType, 0);
        this.check(Boolean.TRUE, (RexNode)node, "=(IS TRUE($0), true)");
    }

    @Test
    public void testMixed1() {
        RexNode op1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.x, this.trueRex});
        RexNode and = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{op1, this.y});
        this.check(Boolean.FALSE, and, "AND(IS NOT NULL($1), AND(AND(IS NOT NULL($0), =($0, true)), $1))");
    }

    @Test
    public void testMixed2() {
        RexNode op1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{this.x, this.trueRex});
        RexNode op2 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.y, this.z});
        RexNode and = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{op1, op2});
        this.check(Boolean.FALSE, and, "AND(AND(IS NOT NULL($0), <>($0, true)), AND(AND(IS NOT NULL($1), IS NOT NULL($2)), >($1, $2)))");
    }

    @Test
    public void testMixed3() {
        RexNode op1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.x, this.y});
        RexNode op2 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.falseRex, this.z});
        RexNode and = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{op1, op2});
        this.check(Boolean.TRUE, and, "AND(AND(AND(IS NOT NULL($0), IS NOT NULL($1)), =($0, $1)), AND(IS NOT NULL($2), >(false, $2)))");
    }
}

