/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import net.hydromatic.optiq.impl.jdbc.JdbcRules;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelJson;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelOptPlanReaderTest {
    @Test
    public void testTypeToClass() {
        Class clazz;
        RelJson relJson = new RelJson(null);
        Assert.assertThat((Object)relJson.classToTypeName(ProjectRel.class), (Matcher)CoreMatchers.is((Object)"ProjectRel"));
        Assert.assertThat((Object)relJson.typeNameToClass("ProjectRel"), (Matcher)CoreMatchers.sameInstance(ProjectRel.class));
        Assert.assertThat((Object)relJson.classToTypeName(JdbcRules.JdbcProjectRel.class), (Matcher)CoreMatchers.is((Object)"JdbcProjectRel"));
        Assert.assertThat((Object)relJson.typeNameToClass("JdbcProjectRel"), (Matcher)CoreMatchers.equalTo(JdbcRules.JdbcProjectRel.class));
        try {
            clazz = relJson.typeNameToClass("NonExistentRel");
            Assert.fail((String)("expected exception, got " + clazz));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"unknown type NonExistentRel"));
        }
        try {
            clazz = relJson.typeNameToClass("org.eigenbase.rel.NonExistentRel");
            Assert.fail((String)("expected exception, got " + clazz));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"unknown type org.eigenbase.rel.NonExistentRel"));
        }
        Assert.assertThat((Object)relJson.classToTypeName(MyRel.class), (Matcher)CoreMatchers.is((Object)"org.eigenbase.relopt.RelOptPlanReaderTest$MyRel"));
        Assert.assertThat((Object)relJson.typeNameToClass(MyRel.class.getName()), (Matcher)CoreMatchers.equalTo(MyRel.class));
        try {
            clazz = relJson.typeNameToClass(MyRel.class.getCanonicalName());
            Assert.fail((String)("expected exception, got " + clazz));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"unknown type org.eigenbase.relopt.RelOptPlanReaderTest.MyRel"));
        }
    }

    public static class MyRel
    extends AbstractRelNode {
        public MyRel(RelOptCluster cluster, RelTraitSet traitSet) {
            super(cluster, traitSet);
        }
    }
}

