/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExceptionMessageTest {
    private Connection conn;

    @Before
    public void setUp() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        rootSchema.add("test", (Schema)new ReflectiveSchema((Object)new TestSchema()));
        optiqConnection.setSchema("test");
        this.conn = optiqConnection;
    }

    private void runQuery(String sql) throws SQLException {
        Statement stmt = this.conn.createStatement();
        try {
            stmt.executeQuery(sql);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                Assert.fail((String)"Error on close");
            }
        }
    }

    @Test
    public void testValidQuery() throws SQLException {
        this.runQuery("select * from \"entries\"");
    }

    @Test
    public void testNonSqlException() throws SQLException {
        try {
            this.runQuery("select * from \"badEntries\"");
            Assert.fail((String)"Query badEntries should result in an exception");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"exception while executing query: Can't iterate over badEntries"));
        }
    }

    @Test
    public void testSyntaxError() {
        try {
            this.runQuery("invalid sql");
            Assert.fail((String)"Query should fail");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"error while executing SQL \"invalid sql\": parse failed: Non-query expression encountered in illegal context"));
        }
    }

    @Test
    public void testSemanticError() {
        try {
            this.runQuery("select \"name\" - \"id\" from \"entries\"");
            Assert.fail((String)"Query with semantic error should fail");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot apply '-' to arguments"));
        }
    }

    @Test
    public void testNonexistentTable() {
        try {
            this.runQuery("select name from \"nonexistentTable\"");
            Assert.fail((String)"Query should fail");
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Table 'nonexistentTable' not found"));
        }
    }

    public static class Entry {
        public int id;
        public String name;

        public Entry(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class TestSchema {
        public Entry[] entries = new Entry[]{new Entry(1, "name1"), new Entry(2, "name2")};
        public Iterable<Entry> badEntries = new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                throw new IllegalStateException("Can't iterate over badEntries");
            }
        };
    }
}

