/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.examples.foodmart.java;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.jdbc.OptiqConnection;

public class JdbcExample {
    public static void main(String[] args) throws Exception {
        new JdbcExample().run();
    }

    public void run() throws ClassNotFoundException, SQLException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new Hr()));
        rootSchema.add("foodmart", (Schema)new ReflectiveSchema((Object)new Foodmart()));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select *\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"hr\".\"emps\" as e\non e.\"empid\" = s.\"cust_id\"");
        StringBuilder buf = new StringBuilder();
        while (resultSet.next()) {
            int n = resultSet.getMetaData().getColumnCount();
            int i = 1;
            while (i <= n) {
                buf.append(i > 1 ? "; " : "").append(resultSet.getMetaData().getColumnLabel(i)).append("=").append(resultSet.getObject(i));
                ++i;
            }
            System.out.println(buf.toString());
            buf.setLength(0);
        }
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static class Employee {
        public final int empid;
        public final String name;

        public Employee(int empid, String name) {
            this.empid = empid;
            this.name = name;
        }
    }

    public static class Foodmart {
        public final SalesFact[] sales_fact_1997 = new SalesFact[]{new SalesFact(100, 10), new SalesFact(150, 20)};
    }

    public static class Hr {
        public final Employee[] emps = new Employee[]{new Employee(100, "Bill"), new Employee(200, "Eric"), new Employee(150, "Sebastian")};
    }

    public static class SalesFact {
        public final int cust_id;
        public final int prod_id;

        public SalesFact(int cust_id, int prod_id) {
            this.cust_id = cust_id;
            this.prod_id = prod_id;
        }
    }
}

