/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import org.eigenbase.rel.TableModificationRel;
import org.eigenbase.rel.rules.AddRedundantSemiJoinRule;
import org.eigenbase.rel.rules.CoerceInputsRule;
import org.eigenbase.rel.rules.ConvertMultiJoinRule;
import org.eigenbase.rel.rules.ExtractJoinFilterRule;
import org.eigenbase.rel.rules.FilterToCalcRule;
import org.eigenbase.rel.rules.MergeCalcRule;
import org.eigenbase.rel.rules.MergeProjectRule;
import org.eigenbase.rel.rules.ProjectToCalcRule;
import org.eigenbase.rel.rules.PushAggregateThroughUnionRule;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.rel.rules.PushFilterPastProjectRule;
import org.eigenbase.rel.rules.PushFilterPastSetOpRule;
import org.eigenbase.rel.rules.PushJoinThroughUnionRule;
import org.eigenbase.rel.rules.PushProjectPastFilterRule;
import org.eigenbase.rel.rules.PushProjectPastJoinRule;
import org.eigenbase.rel.rules.PushProjectPastSetOpRule;
import org.eigenbase.rel.rules.PushSemiJoinPastFilterRule;
import org.eigenbase.rel.rules.PushSemiJoinPastJoinRule;
import org.eigenbase.rel.rules.PushSemiJoinPastProjectRule;
import org.eigenbase.rel.rules.ReduceAggregatesRule;
import org.eigenbase.rel.rules.ReduceExpressionsRule;
import org.eigenbase.rel.rules.ReduceValuesRule;
import org.eigenbase.rel.rules.RemoveEmptyRules;
import org.eigenbase.rel.rules.RemoveSemiJoinRule;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.rel.rules.TableAccessRule;
import org.eigenbase.rel.rules.UnionToDistinctRule;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.hep.HepMatchOrder;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepProgramBuilder;
import org.eigenbase.test.DiffRepository;
import org.eigenbase.test.RelOptTestBase;
import org.junit.Ignore;
import org.junit.Test;

public class RelOptRulesTest
extends RelOptTestBase {
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(RelOptRulesTest.class);
    }

    @Test
    public void testUnionToDistinctRule() {
        this.checkPlanning((RelOptRule)UnionToDistinctRule.INSTANCE, "select * from dept union select * from dept");
    }

    @Test
    public void testExtractJoinFilterRule() {
        this.checkPlanning((RelOptRule)ExtractJoinFilterRule.INSTANCE, "select 1 from emp inner join dept on emp.deptno=dept.deptno");
    }

    @Test
    public void testAddRedundantSemiJoinRule() {
        this.checkPlanning((RelOptRule)AddRedundantSemiJoinRule.INSTANCE, "select 1 from emp inner join dept on emp.deptno = dept.deptno");
    }

    @Test
    public void testPushFilterThroughOuterJoin() {
        this.checkPlanning((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN, "select 1 from sales.dept d left outer join sales.emp e on d.deptno = e.deptno where d.name = 'Charlie'");
    }

    @Test
    public void testReduceAverage() {
        this.checkPlanning((RelOptRule)ReduceAggregatesRule.INSTANCE, "select name, max(name), avg(deptno), min(name) from sales.dept group by name");
    }

    @Test
    public void testPushProjectPastFilter() {
        this.checkPlanning((RelOptRule)PushProjectPastFilterRule.INSTANCE, "select empno + deptno from emp where sal = 10 * comm and upper(ename) = 'FOO'");
    }

    @Test
    public void testPushProjectPastJoin() {
        this.checkPlanning((RelOptRule)PushProjectPastJoinRule.INSTANCE, "select e.sal + b.comm from emp e inner join bonus b on e.ename = b.ename and e.deptno = 10");
    }

    @Test
    public void testPushProjectPastSetOp() {
        this.checkPlanning((RelOptRule)PushProjectPastSetOpRule.INSTANCE, "select sal from (select * from emp e1 union all select * from emp e2)");
    }

    @Test
    public void testPushJoinThroughUnionOnLeft() {
        this.checkPlanning((RelOptRule)PushJoinThroughUnionRule.LEFT_UNION, "select r1.sal from (select * from emp e1 union all select * from emp e2) r1, emp r2");
    }

    @Test
    public void testPushJoinThroughUnionOnRight() {
        this.checkPlanning((RelOptRule)PushJoinThroughUnionRule.RIGHT_UNION, "select r1.sal from emp r1, (select * from emp e1 union all select * from emp e2) r2");
    }

    @Ignore
    @Test
    public void testMergeFilterWithJoinCondition() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)TableAccessRule.INSTANCE).addRuleInstance((RelOptRule)ExtractJoinFilterRule.INSTANCE).addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE).addRuleInstance((RelOptRule)MergeCalcRule.INSTANCE).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).build();
        this.checkPlanning(program, "select d.name as dname,e.name as ename from sales.emps e inner join sales.depts d on e.deptno=d.deptno where d.name='Propane'");
    }

    @Ignore
    @Test
    public void testHeterogeneousConversion() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)TableAccessRule.INSTANCE).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).addMatchLimit(1).addMatchLimit(Integer.MAX_VALUE).build();
        this.checkPlanning(program, "select upper(name) from sales.emps union all select lower(name) from sales.emps");
    }

    @Ignore
    @Test
    public void testPushSemiJoinPastJoinRuleLeft() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)AddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)PushSemiJoinPastJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.name from sales.emps e1, sales.depts d, sales.emps e2 where e1.deptno = d.deptno and e1.empno = e2.empno");
    }

    @Ignore
    @Test
    public void testPushSemiJoinPastJoinRuleRight() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)AddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)PushSemiJoinPastJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.name from sales.emps e1, sales.depts d, sales.emps e2 where e1.deptno = d.deptno and d.deptno = e2.deptno");
    }

    @Ignore
    @Test
    public void testPushSemiJoinPastFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)AddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)PushSemiJoinPastFilterRule.INSTANCE).build();
        this.checkPlanning(program, "select e.name from sales.emps e, sales.depts d where e.deptno = d.deptno and e.name = 'foo'");
    }

    @Ignore
    @Test
    public void testConvertMultiJoinRule() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance((RelOptRule)ConvertMultiJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.name from sales.emps e1, sales.depts d, sales.emps e2 where e1.deptno = d.deptno and d.deptno = e2.deptno");
    }

    @Test
    public void testReduceConstants() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select 1+2, d.deptno+(3+4), (5+6)+d.deptno, cast(null as integer), coalesce(2,null), row(7+8) from dept d inner join emp e on d.deptno = e.deptno + (5-5) where d.deptno=(7+8) and d.deptno=coalesce(2,null)");
    }

    @Test
    public void testReduceConstants2() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select p1 is not distinct from p0 from (values (2, cast(null as integer))) as t(p0, p1)");
    }

    @Test
    public void testReduceConstantsEliminatesFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select * from (values (1,2)) where 1 + 2 > 3 + CAST(NULL AS INTEGER)");
    }

    @Test
    public void testAlreadyFalseEliminatesFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select * from (values (1,2)) where false");
    }

    @Test
    public void testReduceConstantsCalc() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastProjectRule.INSTANCE).addRuleInstance((RelOptRule)PushFilterPastSetOpRule.INSTANCE).addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).addRuleInstance((RelOptRule)MergeCalcRule.INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE).addRuleInstance(RemoveEmptyRules.UNION_INSTANCE).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).addRuleInstance((RelOptRule)MergeCalcRule.INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE).build();
        this.checkPlanning(program, "select * from (\n  select upper(substring(x FROM 1 FOR 2) || substring(x FROM 3)) as u,\n      substring(x FROM 1 FOR 1) as s\n  from (\n    select 'table' as x from (values (true))\n    union\n    select 'view' from (values (true))\n    union\n    select 'foreign table' from (values (true))\n  )\n) where u = 'TABLE'");
    }

    @Ignore
    @Test
    public void testRemoveSemiJoin() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)AddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)RemoveSemiJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select e.name from sales.emps e, sales.depts d where e.deptno = d.deptno");
    }

    @Ignore
    @Test
    public void testRemoveSemiJoinWithFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)AddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)PushSemiJoinPastFilterRule.INSTANCE).addRuleInstance((RelOptRule)RemoveSemiJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select e.name from sales.emps e, sales.depts d where e.deptno = d.deptno and e.name = 'foo'");
    }

    @Ignore
    @Test
    public void testRemoveSemiJoinRight() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)AddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)PushSemiJoinPastJoinRule.INSTANCE).addRuleInstance((RelOptRule)RemoveSemiJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.name from sales.emps e1, sales.depts d, sales.emps e2 where e1.deptno = d.deptno and d.deptno = e2.deptno");
    }

    @Ignore
    @Test
    public void testRemoveSemiJoinRightWithFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)AddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)PushSemiJoinPastJoinRule.INSTANCE).addRuleInstance((RelOptRule)PushSemiJoinPastFilterRule.INSTANCE).addRuleInstance((RelOptRule)RemoveSemiJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.name from sales.emps e1, sales.depts d, sales.emps e2 where e1.deptno = d.deptno and d.deptno = e2.deptno and d.name = 'foo'");
    }

    @Ignore
    @Test
    public void testConvertMultiJoinRuleOuterJoins() throws Exception {
        HepProgram program = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance((RelOptRule)RemoveTrivialProjectRule.INSTANCE).addRuleInstance((RelOptRule)ConvertMultiJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select * from     (select * from         (select * from             (select * from A right outer join B on a = b)             left outer join             (select * from C full outer join D on c = d)            on a = c and b = d)         right outer join         (select * from             (select * from E full outer join F on e = f)             right outer join             (select * from G left outer join H on g = h)             on e = g and f = h)         on a = e and b = f and c = g and d = h)     inner join     (select * from I inner join J on i = j)     on a = i and h = j");
    }

    @Ignore
    @Test
    public void testPushSemiJoinPastProject() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)AddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)PushSemiJoinPastProjectRule.INSTANCE).build();
        this.checkPlanning(program, "select e.* from (select name, trim(city), age * 2, deptno from sales.emps) e, sales.depts d where e.deptno = d.deptno");
    }

    @Test
    public void testReduceValuesUnderFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastProjectRule.INSTANCE).addRuleInstance((RelOptRule)ReduceValuesRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select a, b from (values (10, 'x'), (20, 'y')) as t(a, b) where a < 15");
    }

    @Test
    public void testReduceValuesUnderProject() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)MergeProjectRule.INSTANCE).addRuleInstance((RelOptRule)ReduceValuesRule.PROJECT_INSTANCE).build();
        this.checkPlanning(program, "select a + b from (values (10, 1), (20, 3)) as t(a, b)");
    }

    @Test
    public void testReduceValuesUnderProjectFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastProjectRule.INSTANCE).addRuleInstance((RelOptRule)MergeProjectRule.INSTANCE).addRuleInstance((RelOptRule)ReduceValuesRule.PROJECT_FILTER_INSTANCE).build();
        this.checkPlanning(program, "select a + b as x, b, a from (values (10, 1), (30, 7), (20, 3)) as t(a, b) where a - b < 21");
    }

    @Ignore
    @Test
    public void testReduceValuesNull() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceValuesRule.PROJECT_INSTANCE).build();
        this.checkPlanning(program, "insert into sales.depts(deptno,name) values (NULL, 'null')");
    }

    @Test
    public void testReduceValuesToEmpty() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastProjectRule.INSTANCE).addRuleInstance((RelOptRule)MergeProjectRule.INSTANCE).addRuleInstance((RelOptRule)ReduceValuesRule.PROJECT_FILTER_INSTANCE).build();
        this.checkPlanning(program, "select a + b as x, b, a from (values (10, 1), (30, 7)) as t(a, b) where a - b < 0");
    }

    @Test
    public void testEmptyFilterProjectUnion() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushFilterPastSetOpRule.INSTANCE).addRuleInstance((RelOptRule)PushFilterPastProjectRule.INSTANCE).addRuleInstance((RelOptRule)MergeProjectRule.INSTANCE).addRuleInstance((RelOptRule)ReduceValuesRule.PROJECT_FILTER_INSTANCE).addRuleInstance(RemoveEmptyRules.PROJECT_INSTANCE).addRuleInstance(RemoveEmptyRules.UNION_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from (values (10, 1), (30, 3)) as t (x, y)\nunion all\nselect * from (values (20, 2))\n)\nwhere x + y > 30");
    }

    @Test
    public void testEmptyJoin() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(RemoveEmptyRules.PROJECT_INSTANCE).addRuleInstance(RemoveEmptyRules.JOIN_LEFT_INSTANCE).addRuleInstance(RemoveEmptyRules.JOIN_RIGHT_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from emp where false)\njoin dept using (deptno)");
    }

    @Test
    public void testEmptyJoinLeft() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(RemoveEmptyRules.PROJECT_INSTANCE).addRuleInstance(RemoveEmptyRules.JOIN_LEFT_INSTANCE).addRuleInstance(RemoveEmptyRules.JOIN_RIGHT_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from emp where false)\nleft join dept using (deptno)");
    }

    @Test
    public void testEmptyJoinRight() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(RemoveEmptyRules.PROJECT_INSTANCE).addRuleInstance(RemoveEmptyRules.JOIN_LEFT_INSTANCE).addRuleInstance(RemoveEmptyRules.JOIN_RIGHT_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from emp where false)\nright join dept using (deptno)");
    }

    @Test
    public void testEmptySort() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(RemoveEmptyRules.SORT_INSTANCE).build();
        this.checkPlanning(program, "select * from emp where false order by deptno");
    }

    @Test
    public void testEmptySortLimitZero() {
        HepProgram program = new HepProgramBuilder().addRuleInstance(RemoveEmptyRules.SORT_FETCH_ZERO_INSTANCE).build();
        this.checkPlanning(program, "select * from emp order by deptno limit 0");
    }

    @Test
    public void testReduceCasts() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select cast(d.name as varchar(128)), cast(e.empno as integer) from dept as d inner join emp as e on cast(d.deptno as integer) = cast(e.deptno as integer) where cast(e.job as varchar(1)) = 'Manager'");
    }

    @Test
    public void testReduceCastAndConsts() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select * from emp where cast((empno + (10/2)) as int) = 13");
    }

    @Ignore
    @Test
    public void testReduceCastsNullable() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)new CoerceInputsRule(TableModificationRel.class, false)).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).addRuleInstance((RelOptRule)MergeCalcRule.INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE).build();
        this.checkPlanning(program, "insert into sales.depts(name) select cast(gender as varchar(128)) from sales.emps");
    }

    @Ignore
    @Test
    public void testPushAggThroughUnion() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)PushProjectPastSetOpRule.INSTANCE).addRuleInstance((RelOptRule)PushAggregateThroughUnionRule.INSTANCE).build();
        this.checkPlanning(program, "select ename,sum(empno),count(*) from (select * from emp as e1 union all select * from emp as e2) group by ename");
    }
}

