/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util14;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeUtil {
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    public static final String TIME_FORMAT_STRING = "HH:mm:ss";
    public static final String TIMESTAMP_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final TimeZone DEFAULT_ZONE = TimeZone.getDefault();
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final Calendar ZERO_CALENDAR = Calendar.getInstance(GMT_ZONE);
    private static final Calendar LOCAL_CALENDAR;

    static {
        ZERO_CALENDAR.setTimeInMillis(0L);
        LOCAL_CALENDAR = Calendar.getInstance();
    }

    private DateTimeUtil() {
    }

    private static Calendar parseDateFormat(String s, String pattern, TimeZone tz, ParsePosition pp) {
        assert (pattern != null);
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        if (tz == null) {
            tz = DEFAULT_ZONE;
        }
        Calendar ret = Calendar.getInstance(tz);
        df.setCalendar(ret);
        df.setLenient(false);
        Date d = df.parse(s, pp);
        if (d == null) {
            return null;
        }
        ret.setTime(d);
        ret.setTimeZone(GMT_ZONE);
        return ret;
    }

    public static Calendar parseDateFormat(String s, String pattern, TimeZone tz) {
        assert (pattern != null);
        ParsePosition pp = new ParsePosition(0);
        Calendar ret = DateTimeUtil.parseDateFormat(s, pattern, tz, pp);
        if (pp.getIndex() != s.length()) {
            return null;
        }
        return ret;
    }

    public static PrecisionTime parsePrecisionDateTimeLiteral(String s, String pattern, TimeZone tz) {
        assert (pattern != null);
        ParsePosition pp = new ParsePosition(0);
        Calendar cal = DateTimeUtil.parseDateFormat(s, pattern, tz, pp);
        if (cal == null) {
            return null;
        }
        int p = 0;
        if (pp.getIndex() < s.length()) {
            if (s.charAt(pp.getIndex()) != '.') {
                return null;
            }
            pp.setIndex(pp.getIndex() + 1);
            if (pp.getIndex() < s.length()) {
                String secFraction = s.substring(pp.getIndex());
                if (!secFraction.matches("\\d+")) {
                    return null;
                }
                NumberFormat nf = NumberFormat.getIntegerInstance();
                Number num = nf.parse(s, pp);
                if (num == null || pp.getIndex() != s.length()) {
                    return null;
                }
                p = Math.min(3, secFraction.length());
                int ms = (int)Math.round((double)num.longValue() * Math.pow(10.0, 3 - secFraction.length()));
                cal.add(14, ms);
            }
        }
        assert (pp.getIndex() == s.length());
        PrecisionTime ret = new PrecisionTime(cal, p);
        return ret;
    }

    public static TimeZone getTimeZone(Calendar cal) {
        if (cal == null) {
            return DEFAULT_ZONE;
        }
        return cal.getTimeZone();
    }

    public static void checkDateFormat(String pattern) {
        new SimpleDateFormat(pattern);
    }

    public static SimpleDateFormat newDateFormat(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        return sdf;
    }

    public static class PrecisionTime {
        private final Calendar cal;
        private final int precision;

        public PrecisionTime(Calendar cal, int precision) {
            this.cal = cal;
            this.precision = precision;
        }

        public Calendar getCalendar() {
            return this.cal;
        }

        public int getPrecision() {
            return this.precision;
        }
    }
}

