/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
extends MessageFormat {
    private final List<String> parameterNames;

    public static Template of(String pattern) {
        return Template.of(pattern, Locale.getDefault());
    }

    public static Template of(String pattern, Locale locale) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        String processedPattern = Template.process(pattern, parameterNames);
        return new Template(processedPattern, parameterNames, locale);
    }

    private Template(String pattern, List<String> parameterNames, Locale locale) {
        super(pattern, locale);
        this.parameterNames = ImmutableList.copyOf(parameterNames);
    }

    private static String process(String pattern, List<String> parameterNames) {
        StringBuffer[] segments = new StringBuffer[4];
        int i = 0;
        while (i < segments.length) {
            segments[i] = new StringBuffer();
            ++i;
        }
        int part = 0;
        boolean inQuote = false;
        int braceStack = 0;
        int i2 = 0;
        while (i2 < pattern.length()) {
            char ch = pattern.charAt(i2);
            if (part == 0) {
                if (ch == '\'') {
                    segments[part].append(ch);
                    if (i2 + 1 < pattern.length() && pattern.charAt(i2 + 1) == '\'') {
                        segments[part].append(ch);
                        ++i2;
                    } else {
                        inQuote = !inQuote;
                    }
                } else if (ch == '{' && !inQuote) {
                    part = 1;
                } else {
                    segments[part].append(ch);
                }
            } else if (inQuote) {
                segments[part].append(ch);
                if (ch == '\'') {
                    inQuote = false;
                }
            } else {
                switch (ch) {
                    case ',': {
                        if (part < 3) {
                            ++part;
                            break;
                        }
                        segments[part].append(ch);
                        break;
                    }
                    case '{': {
                        ++braceStack;
                        segments[part].append(ch);
                        break;
                    }
                    case '}': {
                        if (braceStack == 0) {
                            part = 0;
                            Template.makeFormat(segments, parameterNames);
                            break;
                        }
                        --braceStack;
                        segments[part].append(ch);
                        break;
                    }
                    case '\'': {
                        inQuote = true;
                    }
                    default: {
                        segments[part].append(ch);
                    }
                }
            }
            ++i2;
        }
        if (braceStack == 0 && part != 0) {
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        return segments[0].toString();
    }

    private static void makeFormat(StringBuffer[] segments, List<String> parameterNames) {
        String three;
        String parameterName = segments[1].toString();
        int parameterOrdinal = parameterNames.size();
        parameterNames.add(parameterName);
        segments[0].append("{");
        segments[0].append(parameterOrdinal);
        String two = segments[2].toString();
        if (two.length() > 0) {
            segments[0].append(",").append(two);
        }
        if ((three = segments[3].toString()).length() > 0) {
            segments[0].append(",").append(three);
        }
        segments[0].append("}");
        segments[1].setLength(0);
        segments[2].setLength(0);
        segments[3].setLength(0);
    }

    public String format(Map<Object, Object> argMap) {
        Object[] args = new Object[this.parameterNames.size()];
        int i = 0;
        while (i < this.parameterNames.size()) {
            args[i] = this.getArg(argMap, i);
            ++i;
        }
        return this.format(args);
    }

    private Object getArg(Map<Object, Object> argMap, int ordinal) {
        String parameterName = this.parameterNames.get(ordinal);
        Object arg = argMap.get(parameterName);
        if (arg != null) {
            return arg;
        }
        arg = argMap.get(ordinal);
        if (arg != null) {
            return arg;
        }
        return argMap.get(String.valueOf(ordinal));
    }

    public static String formatByName(String pattern, Map<Object, Object> argMap) {
        return Template.of(pattern).format(argMap);
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }
}

