/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlParserPos
implements Serializable {
    public static final SqlParserPos ZERO = new SqlParserPos(0, 0);
    private static final long serialVersionUID = 1L;
    private final int lineNumber;
    private final int columnNumber;
    private final int endLineNumber;
    private final int endColumnNumber;

    public SqlParserPos(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.endLineNumber = lineNumber;
        this.endColumnNumber = columnNumber;
    }

    public SqlParserPos(int startLineNumber, int startColumnNumber, int endLineNumber, int endColumnNumber) {
        this.lineNumber = startLineNumber;
        this.columnNumber = startColumnNumber;
        this.endLineNumber = endLineNumber;
        this.endColumnNumber = endColumnNumber;
    }

    public int hashCode() {
        return this.lineNumber ^ this.columnNumber << 2 ^ this.endLineNumber << 5 ^ this.endColumnNumber << 7;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SqlParserPos) {
            SqlParserPos that = (SqlParserPos)obj;
            return that.lineNumber == this.lineNumber && that.columnNumber == this.columnNumber && that.endLineNumber == this.endLineNumber && that.endColumnNumber == this.endColumnNumber;
        }
        return false;
    }

    public int getLineNum() {
        return this.lineNumber;
    }

    public int getColumnNum() {
        return this.columnNumber;
    }

    public int getEndLineNum() {
        return this.endLineNumber;
    }

    public int getEndColumnNum() {
        return this.endColumnNumber;
    }

    public String toString() {
        return Static.RESOURCE.parserContext(this.lineNumber, this.columnNumber).str();
    }

    public SqlParserPos plus(SqlParserPos pos) {
        return new SqlParserPos(this.getLineNum(), this.getColumnNum(), pos.getEndLineNum(), pos.getEndColumnNum());
    }

    public SqlParserPos plusAll(SqlNode[] nodes) {
        int line = this.getLineNum();
        int column = this.getColumnNum();
        int endLine = this.getEndLineNum();
        int endColumn = this.getEndColumnNum();
        return SqlParserPos.sum(nodes, line, column, endLine, endColumn);
    }

    public SqlParserPos plusAll(Collection<SqlNode> nodeList) {
        SqlNode[] nodes = nodeList.toArray(new SqlNode[nodeList.size()]);
        return this.plusAll(nodes);
    }

    public static SqlParserPos sum(SqlNode[] nodes) {
        return SqlParserPos.sum(nodes, Integer.MAX_VALUE, Integer.MAX_VALUE, -1, -1);
    }

    public static SqlParserPos sum(List<? extends SqlNode> nodes) {
        return SqlParserPos.sum(nodes.toArray(new SqlNode[nodes.size()]));
    }

    private static SqlParserPos sum(SqlNode[] nodes, int line, int column, int endLine, int endColumn) {
        SqlNode[] sqlNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            SqlParserPos pos;
            SqlNode node = sqlNodeArray[n2];
            if (node != null && !(pos = node.getParserPosition()).equals(ZERO)) {
                int testLine = pos.getLineNum();
                int testColumn = pos.getColumnNum();
                if (testLine < line || testLine == line && testColumn < column) {
                    line = testLine;
                    column = testColumn;
                }
                testLine = pos.getEndLineNum();
                testColumn = pos.getEndColumnNum();
                if (testLine > endLine || testLine == endLine && testColumn > endColumn) {
                    endLine = testLine;
                    endColumn = testColumn;
                }
            }
            ++n2;
        }
        return new SqlParserPos(line, column, endLine, endColumn);
    }

    public static SqlParserPos sum(SqlParserPos[] poses) {
        return SqlParserPos.sum(poses, Integer.MAX_VALUE, Integer.MAX_VALUE, -1, -1);
    }

    private static SqlParserPos sum(SqlParserPos[] poses, int line, int column, int endLine, int endColumn) {
        SqlParserPos[] sqlParserPosArray = poses;
        int n = poses.length;
        int n2 = 0;
        while (n2 < n) {
            SqlParserPos pos = sqlParserPosArray[n2];
            if (pos != null) {
                int testLine = pos.getLineNum();
                int testColumn = pos.getColumnNum();
                if (testLine < line || testLine == line && testColumn < column) {
                    line = testLine;
                    column = testColumn;
                }
                testLine = pos.getEndLineNum();
                testColumn = pos.getEndColumnNum();
                if (testLine > endLine || testLine == endLine && testColumn > endColumn) {
                    endLine = testLine;
                    endColumn = testColumn;
                }
            }
            ++n2;
        }
        return new SqlParserPos(line, column, endLine, endColumn);
    }
}

