/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMultisetQueryConstructor
extends SqlSpecialOperator {
    public SqlMultisetQueryConstructor() {
        this("MULTISET", SqlKind.MULTISET_QUERY_CONSTRUCTOR);
    }

    protected SqlMultisetQueryConstructor(String name, SqlKind kind) {
        super(name, kind, 200, false, ReturnTypes.ARG0, null, OperandTypes.VARIADIC);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type = this.getComponentType(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        if (type == null) {
            return null;
        }
        return SqlTypeUtil.createMultisetType(opBinding.getTypeFactory(), type, false);
    }

    private RelDataType getComponentType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return typeFactory.leastRestrictive(argTypes);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveAndCollectTypes(callBinding.getValidator(), callBinding.getScope(), callBinding.getCall().getOperandList());
        RelDataType componentType = this.getComponentType(callBinding.getTypeFactory(), argTypes);
        if (componentType == null) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        SqlSelect subSelect = (SqlSelect)call.operand(0);
        subSelect.validateExpr(validator, scope);
        SqlValidatorNamespace ns = validator.getNamespace(subSelect);
        assert (ns.getRowType() != null);
        return SqlTypeUtil.createMultisetType(validator.getTypeFactory(), ns.getRowType(), false);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword("MULTISET");
        SqlWriter.Frame frame = writer.startList("(", ")");
        assert (call.operandCount() == 1);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

