/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.advise;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSimpleParser {
    private final String hintToken;

    public SqlSimpleParser(String hintToken) {
        this.hintToken = hintToken;
    }

    public String simplifySql(String sql, int cursor) {
        if (cursor >= sql.length()) {
            sql = String.valueOf(sql) + " " + this.hintToken + " ";
        } else {
            String left = sql.substring(0, cursor);
            String right = sql.substring(cursor);
            sql = String.valueOf(left) + " " + this.hintToken + " " + right;
        }
        return this.simplifySql(sql);
    }

    public String simplifySql(String sql) {
        Token token;
        Tokenizer tokenizer = new Tokenizer(sql, this.hintToken);
        ArrayList<Token> list = new ArrayList<Token>();
        while ((token = tokenizer.nextToken()) != null) {
            list.add(token);
        }
        ArrayList<Token> outList = new ArrayList<Token>();
        this.consumeQuery(list.listIterator(), outList);
        Query.simplifyList(outList, this.hintToken);
        StringBuilder buf = new StringBuilder();
        int k = -1;
        for (Token token2 : outList) {
            if (++k > 0) {
                buf.append(' ');
            }
            token2.unparse(buf);
        }
        return buf.toString();
    }

    private void consumeQuery(ListIterator<Token> iter, List<Token> outList) {
        block4: while (iter.hasNext()) {
            this.consumeSelect(iter, outList);
            if (!iter.hasNext()) continue;
            Token token = iter.next();
            switch (token.type) {
                case UNION: 
                case INTERSECT: 
                case EXCEPT: {
                    outList.add(token);
                    if (!iter.hasNext()) continue block4;
                    token = iter.next();
                    if (token.type == TokenType.ID && token.s.equalsIgnoreCase("ALL")) {
                        outList.add(token);
                        break;
                    }
                    iter.previous();
                    break;
                }
                case RPAREN: {
                    iter.previous();
                    return;
                }
                default: {
                    iter.previous();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void consumeSelect(ListIterator<Token> iter, List<Token> outList) {
        boolean isQuery = false;
        int start = outList.size();
        ArrayList<Token> subqueryList = new ArrayList<Token>();
        block6: while (iter.hasNext()) {
            Token token = iter.next();
            subqueryList.add(token);
            switch (token.type) {
                case LPAREN: {
                    this.consumeQuery(iter, subqueryList);
                    break;
                }
                case RPAREN: {
                    if (!isQuery) break block6;
                    subqueryList.remove(subqueryList.size() - 1);
                    break block6;
                }
                case SELECT: {
                    isQuery = true;
                    break;
                }
                case UNION: 
                case INTERSECT: 
                case EXCEPT: {
                    subqueryList.remove(subqueryList.size() - 1);
                    iter.previous();
                    break block6;
                }
            }
        }
        if (isQuery) {
            outList.subList(start, outList.size()).clear();
            outList.add(new Query(subqueryList));
            if (outList.size() < 2) return;
            if (outList.get(outList.size() - 2).type != TokenType.LPAREN) return;
            outList.add(new Token(TokenType.RPAREN));
            return;
        }
        outList.addAll(subqueryList);
    }

    public static class IdToken
    extends Token {
        public IdToken(TokenType type, String s) {
            super(type, s);
            assert (type == TokenType.DQID || type == TokenType.ID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Query
    extends Token {
        private final List<Token> tokenList;

        public Query(List<Token> tokenList) {
            super(TokenType.QUERY);
            this.tokenList = new ArrayList<Token>(tokenList);
        }

        @Override
        public void unparse(StringBuilder buf) {
            int k = -1;
            for (Token token : this.tokenList) {
                if (++k > 0) {
                    buf.append(' ');
                }
                token.unparse(buf);
            }
        }

        public static void simplifyList(List<Token> list, String hintToken) {
            for (Token token : list) {
                Query query;
                if (!(token instanceof Query) || !(query = (Query)token).contains(hintToken)) continue;
                list.clear();
                list.add(query.simplify(hintToken));
                break;
            }
        }

        public Query simplify(String hintToken) {
            TokenType clause = TokenType.SELECT;
            TokenType foundInClause = null;
            Query foundInSubquery = null;
            TokenType majorClause = null;
            if (hintToken != null) {
                for (Token token : this.tokenList) {
                    switch (token.type) {
                        case ID: {
                            if (!token.s.equals(hintToken)) break;
                            foundInClause = clause;
                            break;
                        }
                        case SELECT: 
                        case FROM: 
                        case WHERE: 
                        case GROUP: 
                        case HAVING: 
                        case ORDER: {
                            majorClause = token.type;
                        }
                        case JOIN: 
                        case ON: 
                        case USING: {
                            clause = token.type;
                            break;
                        }
                        case COMMA: {
                            if (majorClause != TokenType.FROM) break;
                            clause = TokenType.FROM;
                            break;
                        }
                        case QUERY: {
                            if (!((Query)token).contains(hintToken)) break;
                            foundInClause = clause;
                            foundInSubquery = (Query)token;
                        }
                    }
                }
            } else {
                foundInClause = TokenType.QUERY;
            }
            if (foundInClause != null) {
                switch (foundInClause) {
                    case SELECT: {
                        this.purgeSelectListExcept(hintToken);
                        this.purgeWhere();
                        this.purgeOrderBy();
                        break;
                    }
                    case FROM: 
                    case JOIN: {
                        this.purgeSelect();
                        this.purgeFromExcept(hintToken);
                        this.purgeWhere();
                        this.purgeGroupByHaving();
                        this.purgeOrderBy();
                        break;
                    }
                    case ON: 
                    case USING: {
                        this.purgeSelect();
                        this.purgeWhere();
                        this.purgeOrderBy();
                        break;
                    }
                    case WHERE: {
                        this.purgeSelect();
                        this.purgeGroupByHaving();
                        this.purgeOrderBy();
                        break;
                    }
                    case GROUP: 
                    case HAVING: {
                        this.purgeSelect();
                        this.purgeWhere();
                        this.purgeOrderBy();
                        break;
                    }
                    case ORDER: {
                        this.purgeWhere();
                        break;
                    }
                    case QUERY: {
                        this.purgeSelectExprsKeepAliases();
                        this.purgeWhere();
                        this.purgeGroupByHaving();
                    }
                }
            }
            for (Token token : this.tokenList) {
                switch (token.type) {
                    case QUERY: {
                        Query query = (Query)token;
                        query.simplify(query == foundInSubquery ? hintToken : null);
                    }
                }
            }
            return this;
        }

        private void purgeSelectListExcept(String hintToken) {
            List<Token> sublist = this.findClause(TokenType.SELECT);
            int parenCount = 0;
            int itemStart = 1;
            int itemEnd = -1;
            boolean found = false;
            int i = 0;
            while (i < sublist.size()) {
                Token token = sublist.get(i);
                switch (token.type) {
                    case LPAREN: {
                        ++parenCount;
                        break;
                    }
                    case RPAREN: {
                        --parenCount;
                        break;
                    }
                    case COMMA: {
                        if (parenCount != 0) break;
                        if (found) {
                            itemEnd = i;
                            break;
                        }
                        itemStart = i + 1;
                        break;
                    }
                    case ID: {
                        if (!token.s.equals(hintToken)) break;
                        found = true;
                    }
                }
                ++i;
            }
            if (found) {
                if (itemEnd < 0) {
                    itemEnd = sublist.size();
                }
                ArrayList<Token> selectItem = new ArrayList<Token>(sublist.subList(itemStart, itemEnd));
                Token select = sublist.get(0);
                sublist.clear();
                sublist.add(select);
                sublist.addAll(selectItem);
            }
        }

        private void purgeSelect() {
            List<Token> sublist = this.findClause(TokenType.SELECT);
            Token select = sublist.get(0);
            sublist.clear();
            sublist.add(select);
            sublist.add(new Token(TokenType.ID, "*"));
        }

        private void purgeSelectExprsKeepAliases() {
            List<Token> sublist = this.findClause(TokenType.SELECT);
            ArrayList<Token> newSelectClause = new ArrayList<Token>();
            newSelectClause.add(sublist.get(0));
            int itemStart = 1;
            int i = 1;
            while (i < sublist.size()) {
                Token token = sublist.get(i);
                if (i + 1 == sublist.size() || sublist.get(i + 1).type == TokenType.COMMA) {
                    if (token.type == TokenType.ID) {
                        newSelectClause.add(new Token(TokenType.ID, "0"));
                        newSelectClause.add(new Token(TokenType.ID, "AS"));
                        newSelectClause.add(token);
                    } else {
                        newSelectClause.addAll(sublist.subList(itemStart, i + 1));
                    }
                    itemStart = i + 2;
                    if (i + 1 < sublist.size()) {
                        newSelectClause.add(new Token(TokenType.COMMA));
                    }
                }
                ++i;
            }
            sublist.clear();
            sublist.addAll(newSelectClause);
        }

        private void purgeFromExcept(String hintToken) {
            List<Token> sublist = this.findClause(TokenType.FROM);
            int itemStart = -1;
            int itemEnd = -1;
            int joinCount = 0;
            boolean found = false;
            int i = 0;
            while (i < sublist.size()) {
                Token token = sublist.get(i);
                switch (token.type) {
                    case JOIN: {
                        ++joinCount;
                    }
                    case FROM: 
                    case ON: 
                    case COMMA: {
                        if (found) {
                            itemEnd = i;
                            break;
                        }
                        itemStart = i + 1;
                        break;
                    }
                    case ID: {
                        if (!token.s.equals(hintToken)) break;
                        found = true;
                    }
                }
                ++i;
            }
            if (found && joinCount == 0) {
                if (itemEnd == -1) {
                    itemEnd = sublist.size();
                }
                ArrayList<Token> fromItem = new ArrayList<Token>(sublist.subList(itemStart, itemEnd));
                Token from = sublist.get(0);
                sublist.clear();
                sublist.add(from);
                sublist.addAll(fromItem);
            }
            if (sublist.get(sublist.size() - 1).type == TokenType.ON) {
                sublist.add(new Token(TokenType.ID, "TRUE"));
            }
        }

        private void purgeWhere() {
            List<Token> sublist = this.findClause(TokenType.WHERE);
            if (sublist != null) {
                sublist.clear();
            }
        }

        private void purgeGroupByHaving() {
            List<Token> sublist = this.findClause(TokenType.GROUP);
            if (sublist != null) {
                sublist.clear();
            }
            if ((sublist = this.findClause(TokenType.HAVING)) != null) {
                sublist.clear();
            }
        }

        private void purgeOrderBy() {
            List<Token> sublist = this.findClause(TokenType.ORDER);
            if (sublist != null) {
                sublist.clear();
            }
        }

        private List<Token> findClause(TokenType keyword) {
            int start = -1;
            int k = -1;
            EnumSet<TokenType[]> clauses = EnumSet.of(TokenType.SELECT, new TokenType[]{TokenType.FROM, TokenType.WHERE, TokenType.GROUP, TokenType.HAVING, TokenType.ORDER});
            for (Token token : this.tokenList) {
                ++k;
                if (token.type == keyword) {
                    start = k;
                    continue;
                }
                if (start < 0 || !clauses.contains((Object)token.type)) continue;
                return this.tokenList.subList(start, k);
            }
            if (start >= 0) {
                return this.tokenList.subList(start, k + 1);
            }
            return null;
        }

        private boolean contains(String hintToken) {
            for (Token token : this.tokenList) {
                switch (token.type) {
                    case ID: {
                        if (!token.s.equals(hintToken)) break;
                        return true;
                    }
                    case QUERY: {
                        if (!((Query)token).contains(hintToken)) break;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class Token {
        private final TokenType type;
        private final String s;

        Token(TokenType tokenType) {
            this(tokenType, null);
        }

        Token(TokenType type, String s) {
            this.type = type;
            this.s = s;
        }

        public String toString() {
            return this.s == null ? this.type.toString() : (Object)((Object)this.type) + "(" + this.s + ")";
        }

        public void unparse(StringBuilder buf) {
            if (this.s == null) {
                buf.append(this.type.sql());
            } else {
                buf.append(this.s);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TokenType {
        SELECT,
        FROM,
        JOIN,
        ON,
        USING,
        WHERE,
        GROUP,
        HAVING,
        ORDER,
        BY,
        UNION,
        INTERSECT,
        EXCEPT,
        LPAREN{

            public String sql() {
                return "(";
            }
        }
        ,
        RPAREN{

            public String sql() {
                return ")";
            }
        }
        ,
        ID,
        DQID,
        SQID,
        COMMENT,
        COMMA{

            public String sql() {
                return ",";
            }
        }
        ,
        QUERY;


        public String sql() {
            return this.name();
        }
    }

    public static class Tokenizer {
        private static final Map<String, TokenType> map = new HashMap<String, TokenType>();
        final String sql;
        private final String hintToken;
        private int pos;
        int start = 0;

        static {
            TokenType[] tokenTypeArray = TokenType.values();
            int n = tokenTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TokenType type = tokenTypeArray[n2];
                map.put(type.name(), type);
                ++n2;
            }
        }

        public Tokenizer(String sql, String hintToken) {
            this.sql = sql;
            this.hintToken = hintToken;
            this.pos = 0;
        }

        public Token nextToken() {
            while (this.pos < this.sql.length()) {
                char c = this.sql.charAt(this.pos);
                switch (c) {
                    case ',': {
                        ++this.pos;
                        return new Token(TokenType.COMMA);
                    }
                    case '(': {
                        ++this.pos;
                        return new Token(TokenType.LPAREN);
                    }
                    case ')': {
                        ++this.pos;
                        return new Token(TokenType.RPAREN);
                    }
                    case '\"': {
                        String match;
                        char c1;
                        this.start = this.pos++;
                        while (this.pos < this.sql.length()) {
                            c = this.sql.charAt(this.pos);
                            ++this.pos;
                            if (c != '\"') continue;
                            if (this.pos >= this.sql.length() || (c1 = this.sql.charAt(this.pos)) != '\"') break;
                            ++this.pos;
                        }
                        if ((match = this.sql.substring(this.start, this.pos)).startsWith("\" " + this.hintToken + " ")) {
                            return new Token(TokenType.ID, this.hintToken);
                        }
                        return new Token(TokenType.DQID, match);
                    }
                    case '\'': {
                        char c1;
                        this.start = this.pos++;
                        while (this.pos < this.sql.length()) {
                            c = this.sql.charAt(this.pos);
                            ++this.pos;
                            if (c != '\'') continue;
                            if (this.pos >= this.sql.length() || (c1 = this.sql.charAt(this.pos)) != '\'') break;
                            ++this.pos;
                        }
                        String match = this.sql.substring(this.start, this.pos);
                        return new Token(TokenType.SQID, match);
                    }
                    case '/': {
                        if (this.pos >= this.sql.length()) break;
                        char c1 = this.sql.charAt(this.pos + 1);
                        if (c1 == '*') {
                            int end = this.sql.indexOf("*/", this.pos + 2);
                            end = end < 0 ? this.sql.length() : (end += "*/".length());
                            this.pos = end;
                            return new Token(TokenType.COMMENT);
                        }
                        if (c1 != '/') break;
                        this.pos = this.indexOfLineEnd(this.sql, this.pos + 2);
                        return new Token(TokenType.COMMENT);
                    }
                }
                if (Character.isWhitespace(c)) {
                    ++this.pos;
                    continue;
                }
                int start = this.pos++;
                block14: while (this.pos < this.sql.length()) {
                    c = this.sql.charAt(this.pos);
                    switch (c) {
                        case '(': 
                        case ')': 
                        case ',': 
                        case '/': {
                            break block14;
                        }
                        default: {
                            if (Character.isWhitespace(c)) break block14;
                            ++this.pos;
                        }
                    }
                }
                String name = this.sql.substring(start, this.pos);
                TokenType tokenType = map.get(name.toUpperCase());
                if (tokenType == null) {
                    return new IdToken(TokenType.ID, name);
                }
                return new Token(tokenType);
            }
            return null;
        }

        private int indexOfLineEnd(String sql, int i) {
            int length = sql.length();
            while (i < length) {
                char c = sql.charAt(i);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        return i;
                    }
                }
                ++i;
            }
            return i;
        }
    }
}

