/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.math.BigDecimal;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Util;

public class SqlNumericLiteral
extends SqlLiteral {
    private Integer prec;
    private Integer scale;
    private boolean isExact;

    protected SqlNumericLiteral(BigDecimal value, Integer prec, Integer scale, boolean isExact, SqlParserPos pos) {
        super(value, isExact ? SqlTypeName.DECIMAL : SqlTypeName.DOUBLE, pos);
        this.prec = prec;
        this.scale = scale;
        this.isExact = isExact;
    }

    public Integer getPrec() {
        return this.prec;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean isExact() {
        return this.isExact;
    }

    public SqlNode clone(SqlParserPos pos) {
        return new SqlNumericLiteral((BigDecimal)this.value, this.getPrec(), this.getScale(), this.isExact, pos);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.literal(this.toValue());
    }

    public String toValue() {
        BigDecimal bd = (BigDecimal)this.value;
        if (this.isExact) {
            return this.value.toString();
        }
        return Util.toScientificNotation(bd);
    }

    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        if (this.isExact) {
            int scaleValue = this.scale;
            if (scaleValue == 0) {
                BigDecimal bd = (BigDecimal)this.value;
                long l = bd.longValue();
                SqlTypeName result = l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? SqlTypeName.INTEGER : SqlTypeName.BIGINT;
                return typeFactory.createSqlType(result);
            }
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, this.prec, scaleValue);
        }
        return typeFactory.createSqlType(SqlTypeName.DOUBLE);
    }

    public boolean isInteger() {
        return this.scale == 0;
    }
}

