/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.HashMap;
import java.util.Map;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.fun.SqlTrimFunction;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

public class SqlJdbcFunctionCall
extends SqlFunction {
    private static final String NUMERIC_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE");
    private static final String STRING_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("ASCII", "CHAR", "CONCAT", "DIFFERENCE", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTRING", "UCASE");
    private static final String TIME_DATE_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("CURDATE", "CURTIME", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "TIMESTAMPADD", "TIMESTAMPDIFF", "WEEK", "YEAR");
    private static final String SYSTEM_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("DATABASE", "IFNULL", "USER");
    private final String jdbcName;
    private final MakeCall lookupMakeCallObj;
    private SqlCall lookupCall;
    private SqlNode[] thisOperands;

    public SqlJdbcFunctionCall(String name) {
        super("{fn " + name + "}", SqlKind.JDBC_FN, null, null, OperandTypes.VARIADIC, null);
        this.jdbcName = name;
        this.lookupMakeCallObj = JdbcToInternalLookupTable.INSTANCE.lookup(name);
        this.lookupCall = null;
    }

    private static String constructFuncList(String ... functionNames) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        String[] stringArray = functionNames;
        int n2 = functionNames.length;
        int n3 = 0;
        while (n3 < n2) {
            String funcName = stringArray[n3];
            if (JdbcToInternalLookupTable.INSTANCE.lookup(funcName) != null) {
                if (n++ > 0) {
                    sb.append(",");
                }
                sb.append(funcName);
            }
            ++n3;
        }
        return sb.toString();
    }

    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        this.thisOperands = operands;
        return super.createCall(functionQualifier, pos, operands);
    }

    public SqlCall getLookupCall() {
        if (this.lookupCall == null) {
            this.lookupCall = this.lookupMakeCallObj.createCall(this.thisOperands, SqlParserPos.ZERO);
        }
        return this.lookupCall;
    }

    public String getAllowedSignatures(String name) {
        return this.lookupMakeCallObj.operator.getAllowedSignatures(name);
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            validator.setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope, call);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        SqlCallBinding callBinding = (SqlCallBinding)opBinding;
        if (this.lookupMakeCallObj == null) {
            throw callBinding.newValidationError(Static.RESOURCE.functionUndefined(this.getName()));
        }
        if (!this.lookupMakeCallObj.checkNumberOfArg(opBinding.getOperandCount())) {
            throw callBinding.newValidationError(Static.RESOURCE.wrongNumberOfParam(this.getName(), this.thisOperands.length, this.getArgCountMismatchMsg()));
        }
        if (!this.lookupMakeCallObj.operator.checkOperandTypes(new SqlCallBinding(callBinding.getValidator(), callBinding.getScope(), this.getLookupCall()), false)) {
            throw callBinding.newValidationSignatureError();
        }
        return this.lookupMakeCallObj.operator.validateOperands(callBinding.getValidator(), callBinding.getScope(), this.getLookupCall());
    }

    private String getArgCountMismatchMsg() {
        StringBuilder ret = new StringBuilder();
        int[] possible = this.lookupMakeCallObj.getPossibleArgCounts();
        int i = 0;
        while (i < possible.length) {
            if (i > 0) {
                ret.append(" or ");
            }
            ret.append(possible[i]);
            ++i;
        }
        ret.append(" parameter(s)");
        return ret.toString();
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.print("{fn ");
        writer.print(this.jdbcName);
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
        writer.print("}");
    }

    public static String getNumericFunctions() {
        return NUMERIC_FUNCTIONS;
    }

    public static String getStringFunctions() {
        return STRING_FUNCTIONS;
    }

    public static String getTimeDateFunctions() {
        return TIME_DATE_FUNCTIONS;
    }

    public static String getSystemFunctions() {
        return SYSTEM_FUNCTIONS;
    }

    private static class JdbcToInternalLookupTable {
        static final JdbcToInternalLookupTable INSTANCE = new JdbcToInternalLookupTable();
        private final Map<String, MakeCall> map = new HashMap<String, MakeCall>();

        private JdbcToInternalLookupTable() {
            this.map.put("ABS", new MakeCall((SqlOperator)SqlStdOperatorTable.ABS, 1));
            this.map.put("EXP", new MakeCall((SqlOperator)SqlStdOperatorTable.EXP, 1));
            this.map.put("LOG", new MakeCall((SqlOperator)SqlStdOperatorTable.LN, 1));
            this.map.put("LOG10", new MakeCall((SqlOperator)SqlStdOperatorTable.LOG10, 1));
            this.map.put("MOD", new MakeCall((SqlOperator)SqlStdOperatorTable.MOD, 2));
            this.map.put("POWER", new MakeCall((SqlOperator)SqlStdOperatorTable.POWER, 2));
            this.map.put("CONCAT", new MakeCall((SqlOperator)SqlStdOperatorTable.CONCAT, 2));
            int[] nArray = new int[4];
            nArray[1] = 2;
            nArray[2] = 3;
            nArray[3] = 1;
            this.map.put("INSERT", new MakeCall((SqlOperator)SqlStdOperatorTable.OVERLAY, 4, nArray));
            this.map.put("LCASE", new MakeCall((SqlOperator)SqlStdOperatorTable.LOWER, 1));
            this.map.put("LENGTH", new MakeCall((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, 1));
            this.map.put("LOCATE", new MakeCall((SqlOperator)SqlStdOperatorTable.POSITION, 2));
            this.map.put("LTRIM", new MakeCall(SqlStdOperatorTable.TRIM, 1){

                SqlCall createCall(SqlNode[] operands, SqlParserPos pos) {
                    if (!$assertionsDisabled && 1 != operands.length) {
                        throw new AssertionError();
                    }
                    return super.createCall(new SqlNode[]{SqlTrimFunction.Flag.LEADING.symbol(SqlParserPos.ZERO), SqlLiteral.createCharString(" ", null), operands[0]}, pos);
                }
            });
            this.map.put("RTRIM", new MakeCall(SqlStdOperatorTable.TRIM, 1){

                SqlCall createCall(SqlNode[] operands, SqlParserPos pos) {
                    if (!$assertionsDisabled && 1 != operands.length) {
                        throw new AssertionError();
                    }
                    return super.createCall(new SqlNode[]{SqlTrimFunction.Flag.TRAILING.symbol(SqlParserPos.ZERO), SqlLiteral.createCharString(" ", null), operands[0]}, pos);
                }
            });
            this.map.put("SUBSTRING", new MakeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, 3));
            this.map.put("UCASE", new MakeCall((SqlOperator)SqlStdOperatorTable.UPPER, 1));
            this.map.put("CURDATE", new MakeCall((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, 0));
            this.map.put("CURTIME", new MakeCall((SqlOperator)SqlStdOperatorTable.LOCALTIME, 0));
            this.map.put("NOW", new MakeCall((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, 0));
        }

        public MakeCall lookup(String name) {
            return this.map.get(name);
        }
    }

    private static class MakeCall {
        final SqlOperator operator;
        final int[] order;
        final int[] argCounts;

        private MakeCall(SqlOperator operator, int argCount) {
            this.operator = operator;
            this.order = null;
            this.argCounts = new int[]{argCount};
        }

        MakeCall(SqlOperator operator, int argCount, int[] order) {
            assert (order != null && order.length > 0);
            Util.pre(argCount == order.length, "argCounts==order.length");
            this.operator = operator;
            this.order = order;
            this.argCounts = new int[]{order.length};
            int[] nArray = order;
            int n = order.length;
            int n2 = 0;
            while (n2 < n) {
                int anOrder = nArray[n2];
                assert (anOrder < order.length);
                ++n2;
            }
        }

        final int[] getPossibleArgCounts() {
            return this.argCounts;
        }

        protected SqlNode[] reorder(SqlNode[] operands) {
            assert (operands.length == this.order.length);
            SqlNode[] newOrder = new SqlNode[operands.length];
            int i = 0;
            while (i < operands.length) {
                assert (operands[i] != null);
                int joyDivision = this.order[i];
                assert (newOrder[joyDivision] == null) : "mapping is not 1:1";
                newOrder[joyDivision] = operands[i];
                ++i;
            }
            return newOrder;
        }

        SqlCall createCall(SqlNode[] operands, SqlParserPos pos) {
            if (this.order == null) {
                return this.operator.createCall(pos, operands);
            }
            return this.operator.createCall(pos, this.reorder(operands));
        }

        boolean checkNumberOfArg(int length) {
            int[] nArray = this.argCounts;
            int n = this.argCounts.length;
            int n2 = 0;
            while (n2 < n) {
                int argCount = nArray[n2];
                if (argCount == length) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        /* synthetic */ MakeCall(SqlOperator sqlOperator, int n, MakeCall makeCall, MakeCall makeCall2) {
            this(sqlOperator, n);
        }
    }
}

