/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sarg;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.hydromatic.avatica.ByteString;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sarg.SargBoundType;
import org.eigenbase.sarg.SargFactory;
import org.eigenbase.sarg.SargStrictness;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SargEndpoint
implements Comparable<SargEndpoint> {
    protected final SargFactory factory;
    protected final RelDataType dataType;
    protected RexNode coordinate;
    protected SargBoundType boundType;
    protected SargStrictness strictness;

    SargEndpoint(SargFactory factory, RelDataType dataType) {
        this.factory = factory;
        this.dataType = dataType;
        this.boundType = SargBoundType.LOWER;
        this.strictness = SargStrictness.OPEN;
    }

    void copyFrom(SargEndpoint other) {
        assert (this.getDataType() == other.getDataType());
        if (other.isFinite()) {
            this.setFinite(other.getBoundType(), other.getStrictness(), other.getCoordinate());
        } else {
            this.setInfinity(other.getInfinitude());
        }
    }

    void setInfinity(int infinitude) {
        assert (infinitude == -1 || infinitude == 1);
        this.boundType = infinitude == -1 ? SargBoundType.LOWER : SargBoundType.UPPER;
        this.strictness = SargStrictness.OPEN;
        this.coordinate = null;
    }

    void setFinite(SargBoundType boundType, SargStrictness strictness, RexNode coordinate) {
        assert (coordinate != null);
        if (!(coordinate instanceof RexDynamicParam) && !(coordinate instanceof RexInputRef)) {
            assert (coordinate instanceof RexLiteral);
            RexLiteral literal = (RexLiteral)coordinate;
            if (!RexLiteral.isNullLiteral(literal)) assert (SqlTypeUtil.canAssignFrom(this.dataType, literal.getType()));
        }
        this.boundType = boundType;
        this.coordinate = coordinate;
        this.strictness = strictness;
        this.convertToTargetType();
    }

    private void convertToTargetType() {
        int roundingCompensation;
        if (!(this.coordinate instanceof RexLiteral)) {
            return;
        }
        RexLiteral literal = (RexLiteral)this.coordinate;
        if (RexLiteral.isNullLiteral(literal)) {
            return;
        }
        Comparable value = literal.getValue();
        if (value instanceof BigDecimal) {
            roundingCompensation = this.convertNumber((BigDecimal)value);
        } else if (value instanceof NlsString) {
            roundingCompensation = this.convertString((NlsString)value);
        } else if (value instanceof ByteString) {
            roundingCompensation = this.convertBytes((ByteString)value);
        } else {
            return;
        }
        if (roundingCompensation == 0) {
            return;
        }
        if (this.boundType == SargBoundType.LOWER) {
            this.strictness = roundingCompensation < 0 ? SargStrictness.CLOSED : SargStrictness.OPEN;
        } else if (this.boundType == SargBoundType.UPPER) {
            this.strictness = roundingCompensation > 0 ? SargStrictness.CLOSED : SargStrictness.OPEN;
        }
    }

    private int convertString(NlsString value) {
        boolean fixed = this.dataType.getSqlTypeName() == SqlTypeName.CHAR;
        String s = value.getValue();
        String trimmed = Util.rtrim(s);
        s = fixed ? Util.rpad(s, this.dataType.getPrecision()) : trimmed;
        if (s.length() > this.dataType.getPrecision()) {
            s = s.substring(0, this.dataType.getPrecision());
            if (!fixed) {
                s = Util.rtrim(s);
            }
        }
        this.coordinate = this.factory.getRexBuilder().makeCharLiteral(new NlsString(s, value.getCharsetName(), value.getCollation()));
        if (trimmed.length() > this.dataType.getPrecision()) {
            return 1;
        }
        return 0;
    }

    private int convertBytes(ByteString value) {
        if (value.length() <= this.dataType.getPrecision()) {
            return 0;
        }
        ByteString truncated = value.substring(0, this.dataType.getPrecision());
        this.coordinate = this.factory.getRexBuilder().makeBinaryLiteral(truncated);
        return 1;
    }

    private int convertNumber(BigDecimal value) {
        if (SqlTypeUtil.isApproximateNumeric(this.dataType)) {
            return 0;
        }
        BigDecimal roundedValue = value.setScale(this.dataType.getScale(), RoundingMode.HALF_UP);
        if (roundedValue.precision() > this.dataType.getPrecision()) {
            this.setInfinity(roundedValue.signum());
            return 0;
        }
        this.coordinate = this.factory.getRexBuilder().makeExactLiteral(roundedValue, this.dataType);
        return value.compareTo(roundedValue);
    }

    public boolean isClosed() {
        return this.strictness == SargStrictness.CLOSED;
    }

    public boolean isOpen() {
        return this.strictness == SargStrictness.OPEN;
    }

    public boolean isFinite() {
        return this.coordinate != null;
    }

    public int getInfinitude() {
        if (!this.isFinite()) {
            if (this.boundType == SargBoundType.LOWER) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public RexNode getCoordinate() {
        return this.coordinate;
    }

    public boolean isNull() {
        if (!this.isFinite()) {
            return false;
        }
        return RexLiteral.isNullLiteral(this.coordinate);
    }

    public RelDataType getDataType() {
        return this.dataType;
    }

    public SargBoundType getBoundType() {
        return this.boundType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTouching(SargEndpoint other) {
        assert (this.getDataType() == other.getDataType());
        if (!this.isFinite() || !other.isFinite()) {
            return false;
        }
        if (this.coordinate instanceof RexDynamicParam || other.coordinate instanceof RexDynamicParam) {
            if (!(this.coordinate instanceof RexDynamicParam) || !(other.coordinate instanceof RexDynamicParam)) return false;
            RexDynamicParam p1 = (RexDynamicParam)this.coordinate;
            RexDynamicParam p2 = (RexDynamicParam)other.coordinate;
            if (p1.getIndex() == p2.getIndex()) return this.isClosed() || other.isClosed();
            return false;
        }
        if (this.coordinate instanceof RexInputRef || other.coordinate instanceof RexInputRef) {
            if (!(this.coordinate instanceof RexInputRef) || !(other.coordinate instanceof RexInputRef)) return false;
            RexInputRef r1 = (RexInputRef)this.coordinate;
            RexInputRef r2 = (RexInputRef)other.coordinate;
            if (r1.getIndex() == r2.getIndex()) return this.isClosed() || other.isClosed();
            return false;
        }
        if (SargEndpoint.compareCoordinates(this.coordinate, other.coordinate) == 0) return this.isClosed() || other.isClosed();
        return false;
    }

    static int compareCoordinates(RexNode coord1, RexNode coord2) {
        assert (coord1 instanceof RexLiteral);
        assert (coord2 instanceof RexLiteral);
        boolean isNull1 = RexLiteral.isNullLiteral(coord1);
        boolean isNull2 = RexLiteral.isNullLiteral(coord2);
        if (isNull1 && isNull2) {
            return 0;
        }
        if (isNull1) {
            return -1;
        }
        if (isNull2) {
            return 1;
        }
        RexLiteral lit1 = (RexLiteral)coord1;
        RexLiteral lit2 = (RexLiteral)coord2;
        return lit1.getValue().compareTo(lit2.getValue());
    }

    public String toString() {
        if (!this.isFinite()) {
            if (this.boundType == SargBoundType.LOWER) {
                return "-infinity";
            }
            return "+infinity";
        }
        StringBuilder sb = new StringBuilder();
        if (this.boundType == SargBoundType.LOWER) {
            if (this.isClosed()) {
                sb.append(">=");
            } else {
                sb.append(">");
            }
        } else if (this.isClosed()) {
            sb.append("<=");
        } else {
            sb.append("<");
        }
        sb.append(" ");
        sb.append(this.coordinate);
        return sb.toString();
    }

    @Override
    public int compareTo(SargEndpoint other) {
        if (this.getInfinitude() != other.getInfinitude()) {
            return this.getInfinitude() - other.getInfinitude();
        }
        if (!this.isFinite()) {
            return 0;
        }
        int c = SargEndpoint.compareCoordinates(this.getCoordinate(), other.getCoordinate());
        if (c != 0) {
            return c;
        }
        return this.getStrictnessSign() - other.getStrictnessSign();
    }

    public SargStrictness getStrictness() {
        return this.strictness;
    }

    public SargStrictness getStrictnessComplement() {
        return this.strictness == SargStrictness.OPEN ? SargStrictness.CLOSED : SargStrictness.OPEN;
    }

    public int getStrictnessSign() {
        if (this.strictness == SargStrictness.CLOSED) {
            return 0;
        }
        if (this.boundType == SargBoundType.LOWER) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SargEndpoint)) {
            return false;
        }
        return this.compareTo((SargEndpoint)other) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

