/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.eigenbase.rex.RexFieldCollation;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexWindow {
    public final ImmutableList<RexNode> partitionKeys;
    public final ImmutableList<RexFieldCollation> orderKeys;
    private final SqlNode lowerBound;
    private final SqlNode upperBound;
    private final boolean isRows;
    private final String digest;

    RexWindow(List<RexNode> partitionKeys, List<RexFieldCollation> orderKeys, SqlNode lowerBound, SqlNode upperBound, boolean isRows) {
        assert (partitionKeys != null);
        assert (orderKeys != null);
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.orderKeys = ImmutableList.copyOf(orderKeys);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.isRows = isRows;
        this.digest = this.computeDigest();
        if (!isRows) assert (orderKeys.size() > 0) : "logical window requires sort key";
    }

    public String toString() {
        return this.digest;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof RexWindow) {
            RexWindow window = (RexWindow)that;
            return this.digest.equals(window.digest);
        }
        return false;
    }

    private String computeDigest() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int clauseCount = 0;
        if (this.partitionKeys.size() > 0) {
            if (clauseCount++ > 0) {
                pw.print(' ');
            }
            pw.print("PARTITION BY ");
            i = 0;
            while (i < this.partitionKeys.size()) {
                if (i > 0) {
                    pw.print(", ");
                }
                RexNode partitionKey = (RexNode)this.partitionKeys.get(i);
                pw.print(partitionKey.toString());
                ++i;
            }
        }
        if (this.orderKeys.size() > 0) {
            if (clauseCount++ > 0) {
                pw.print(' ');
            }
            pw.print("ORDER BY ");
            i = 0;
            while (i < this.orderKeys.size()) {
                if (i > 0) {
                    pw.print(", ");
                }
                RexFieldCollation orderKey = (RexFieldCollation)this.orderKeys.get(i);
                pw.print(orderKey.toString());
                ++i;
            }
        }
        if (this.lowerBound != null) {
            if (this.upperBound == null) {
                if (clauseCount++ > 0) {
                    pw.print(' ');
                }
                if (this.isRows) {
                    pw.print("ROWS ");
                } else {
                    pw.print("RANGE ");
                }
                pw.print(this.lowerBound.toString());
            } else {
                if (clauseCount++ > 0) {
                    pw.print(' ');
                }
                if (this.isRows) {
                    pw.print("ROWS BETWEEN ");
                } else {
                    pw.print("RANGE BETWEEN ");
                }
                pw.print(this.lowerBound.toString());
                pw.print(" AND ");
                pw.print(this.upperBound.toString());
            }
        }
        return sw.toString();
    }

    public SqlNode getLowerBound() {
        return this.lowerBound;
    }

    public SqlNode getUpperBound() {
        return this.upperBound;
    }

    public boolean isRows() {
        return this.isRows;
    }
}

