/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.volcano;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.optiq.runtime.Spaces;
import net.hydromatic.optiq.tools.FrameworkContext;
import net.hydromatic.optiq.util.graph.DefaultDirectedGraph;
import net.hydromatic.optiq.util.graph.DefaultEdge;
import net.hydromatic.optiq.util.graph.Graphs;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.convert.ConverterRel;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.MergeProjectRule;
import org.eigenbase.rel.rules.PushFilterPastProjectRule;
import org.eigenbase.rel.rules.RemoveDistinctRule;
import org.eigenbase.rel.rules.RemoveSortRule;
import org.eigenbase.rel.rules.RemoveTrivialCalcRule;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.rel.rules.SwapJoinRule;
import org.eigenbase.rel.rules.UnionToDistinctRule;
import org.eigenbase.relopt.AbstractRelOptPlanner;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptCostFactory;
import org.eigenbase.relopt.RelOptListener;
import org.eigenbase.relopt.RelOptMaterialization;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.SubstitutionVisitor;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepProgramBuilder;
import org.eigenbase.relopt.volcano.AbstractConverter;
import org.eigenbase.relopt.volcano.RelSet;
import org.eigenbase.relopt.volcano.RelSubset;
import org.eigenbase.relopt.volcano.RuleQueue;
import org.eigenbase.relopt.volcano.VolcanoCost;
import org.eigenbase.relopt.volcano.VolcanoPlannerPhase;
import org.eigenbase.relopt.volcano.VolcanoPlannerPhaseRuleMappingInitializer;
import org.eigenbase.relopt.volcano.VolcanoRelMetadataProvider;
import org.eigenbase.relopt.volcano.VolcanoRuleCall;
import org.eigenbase.relopt.volcano.VolcanoRuleMatch;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.util.Pair;
import org.eigenbase.util.SaffronProperties;
import org.eigenbase.util.Stacks;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolcanoPlanner
extends AbstractRelOptPlanner {
    protected static final double COST_IMPROVEMENT = 0.5;
    protected RelSubset root;
    protected boolean ambitious = true;
    protected boolean impatient = false;
    private final List<RelOptRuleOperand> allOperands = new ArrayList<RelOptRuleOperand>();
    final List<RelSet> allSets = new ArrayList<RelSet>();
    private final Map<Pair<String, RelDataType>, RelNode> mapDigestToRel = new HashMap<Pair<String, RelDataType>, RelNode>();
    private final IdentityHashMap<RelNode, RelSubset> mapRel2Subset = new IdentityHashMap();
    final Map<RelNode, Double> relImportances = new HashMap<RelNode, Double>();
    private final Set<RelOptSchema> registeredSchemas = new HashSet<RelOptSchema>();
    final RuleQueue ruleQueue = new RuleQueue(this);
    private final List<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
    protected final Set<RelOptRule> ruleSet = new HashSet<RelOptRule>();
    private int nextSetId = 0;
    private int registerCount;
    RelOptListener listener;
    private String originalRootString;
    private RelNode originalRoot;
    private boolean locked;
    private final List<RelOptMaterialization> materializations = new ArrayList<RelOptMaterialization>();
    final Map<RelNode, Provenance> provenanceMap = new HashMap<RelNode, Provenance>();
    private final List<VolcanoRuleCall> ruleCallStack = new ArrayList<VolcanoRuleCall>();
    private final RelOptCost zeroCost = this.costFactory.makeZeroCost();

    public VolcanoPlanner() {
        this(null, null);
    }

    public VolcanoPlanner(FrameworkContext frameworkContext) {
        this(null, frameworkContext);
    }

    public VolcanoPlanner(RelOptCostFactory costFactory, FrameworkContext frameworkContext) {
        super(costFactory == null ? VolcanoCost.FACTORY : costFactory, frameworkContext);
    }

    protected VolcanoPlannerPhaseRuleMappingInitializer getPhaseRuleMappingInitializer() {
        return new VolcanoPlannerPhaseRuleMappingInitializer(){

            @Override
            public void initialize(Map<VolcanoPlannerPhase, Set<String>> phaseRuleMap) {
                Set<String> preProcessMdrPhaseRules = phaseRuleMap.get((Object)VolcanoPlannerPhase.PRE_PROCESS_MDR);
                preProcessMdrPhaseRules.add("MedMdrJoinRule");
                preProcessMdrPhaseRules.add("IterCalcRule");
                preProcessMdrPhaseRules.add("ProjectToCalcRule");
                preProcessMdrPhaseRules.add("FilterToCalcRule");
                preProcessMdrPhaseRules.add("MergeCalcRule");
                Set<String> cleanupPhaseRules = phaseRuleMap.get((Object)VolcanoPlannerPhase.CLEANUP);
                cleanupPhaseRules.add("RemoveTrivialProjectRule");
                cleanupPhaseRules.add("MergeCalcRule");
                cleanupPhaseRules.add("FennelCalcRule");
                cleanupPhaseRules.add("IterCalcRule");
            }
        };
    }

    @Override
    public boolean isRegistered(RelNode rel) {
        return this.mapRel2Subset.get(rel) != null;
    }

    @Override
    public void setRoot(RelNode rel) {
        this.root = this.registerImpl(rel, null);
        if (this.originalRoot == null) {
            this.originalRoot = rel;
        }
        this.originalRootString = RelOptUtil.toString(this.root, SqlExplainLevel.ALL_ATTRIBUTES);
        this.ruleQueue.recompute(this.root);
    }

    @Override
    public RelNode getRoot() {
        return this.root;
    }

    @Override
    public void addMaterialization(RelOptMaterialization materialization) {
        this.materializations.add(materialization);
    }

    private void useMaterialization(RelOptMaterialization materialization) {
        RelNode sub = this.substitute(this.originalRoot, materialization);
        if (sub != null) {
            this.registerImpl(sub, this.root.set);
            return;
        }
        RelSubset subset = this.registerImpl(materialization.queryRel, null);
        RelNode tableRel2 = RelOptUtil.createCastRel(materialization.tableRel, materialization.queryRel.getRowType(), true);
        this.registerImpl(tableRel2, subset.set);
    }

    private RelNode substitute(RelNode root, RelOptMaterialization materialization) {
        if (materialization.starTable != null) {
            root = RelOptMaterialization.tryUseStar(root, materialization.starRelOptTable);
        }
        RelNode target = materialization.queryRel;
        HepProgram program = new HepProgramBuilder().addRuleInstance(PushFilterPastProjectRule.INSTANCE).addRuleInstance(MergeProjectRule.INSTANCE).build();
        HepPlanner hepPlanner = new HepPlanner(program, this.getFrameworkContext());
        hepPlanner.setRoot(target);
        target = hepPlanner.findBestExp();
        hepPlanner.setRoot(root);
        root = hepPlanner.findBestExp();
        return new SubstitutionVisitor(target, root).go(materialization.tableRel);
    }

    private void useApplicableMaterializations() {
        DefaultDirectedGraph<List<String>, DefaultEdge> usesGraph = DefaultDirectedGraph.create();
        for (RelOptMaterialization materialization : this.materializations) {
            if (materialization.table == null) continue;
            for (RelOptTable usedTable : VolcanoPlanner.findTables(materialization.queryRel)) {
                usesGraph.addVertex(materialization.table.getQualifiedName());
                usesGraph.addVertex(usedTable.getQualifiedName());
                usesGraph.addEdge(materialization.table.getQualifiedName(), usedTable.getQualifiedName());
            }
        }
        Graphs.FrozenGraph<List<String>, DefaultEdge> frozenGraph = Graphs.makeImmutable(usesGraph);
        Set<RelOptTable> queryTables = VolcanoPlanner.findTables(this.originalRoot);
        for (RelOptMaterialization materialization : this.materializations) {
            if (materialization.table == null || !this.usesTable(materialization.table, queryTables, frozenGraph)) continue;
            this.useMaterialization(materialization);
        }
    }

    private boolean usesTable(RelOptTable table, Set<RelOptTable> usedTables, Graphs.FrozenGraph<List<String>, DefaultEdge> usesGraph) {
        for (RelOptTable queryTable : usedTables) {
            if (usesGraph.getShortestPath(table.getQualifiedName(), queryTable.getQualifiedName()) == null) continue;
            return true;
        }
        return false;
    }

    private static Set<RelOptTable> findTables(RelNode rel) {
        final LinkedHashSet<RelOptTable> usedTables = new LinkedHashSet<RelOptTable>();
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof TableAccessRelBase) {
                    usedTables.add(node.getTable());
                }
                super.visit(node, ordinal, parent);
            }
        }.go(rel);
        return usedTables;
    }

    public RelSet getSet(RelNode rel) {
        assert (rel != null) : "pre: rel != null";
        RelSubset subset = this.getSubset(rel);
        if (subset != null) {
            assert (subset.set != null);
            return subset.set;
        }
        return null;
    }

    @Override
    public boolean addRelTraitDef(RelTraitDef relTraitDef) {
        return !this.traitDefs.contains(relTraitDef) && this.traitDefs.add(relTraitDef);
    }

    @Override
    public void clearRelTraitDefs() {
        this.traitDefs.clear();
    }

    @Override
    public List<RelTraitDef> getRelTraitDefs() {
        return this.traitDefs;
    }

    @Override
    public RelTraitSet emptyTraitSet() {
        RelTraitSet traitSet = super.emptyTraitSet();
        for (RelTraitDef traitDef : this.traitDefs) {
            traitDef.multiple();
            traitSet = traitSet.plus((RelTrait)traitDef.getDefault());
        }
        return traitSet;
    }

    @Override
    public void clear() {
        super.clear();
        for (RelOptRule rule : ImmutableList.copyOf(this.ruleSet)) {
            this.removeRule(rule);
        }
        this.allOperands.clear();
        this.allSets.clear();
        this.mapDigestToRel.clear();
        this.mapRel2Subset.clear();
        this.relImportances.clear();
        this.ruleQueue.clear();
    }

    @Override
    public boolean addRule(RelOptRule rule) {
        ConverterRule converterRule;
        RelTrait ruleTrait;
        RelTraitDef ruleTraitDef;
        if (this.locked) {
            return false;
        }
        if (this.ruleSet.contains(rule)) {
            return false;
        }
        boolean added = this.ruleSet.add(rule);
        assert (added);
        this.mapRuleDescription(rule);
        this.allOperands.addAll(rule.getOperands());
        if (rule instanceof ConverterRule && this.traitDefs.contains(ruleTraitDef = (ruleTrait = (converterRule = (ConverterRule)rule).getInTrait()).getTraitDef())) {
            ruleTraitDef.registerConverterRule(this, converterRule);
        }
        return true;
    }

    @Override
    public boolean removeRule(RelOptRule rule) {
        ConverterRule converterRule;
        RelTrait ruleTrait;
        RelTraitDef ruleTraitDef;
        if (!this.ruleSet.remove(rule)) {
            return false;
        }
        this.unmapRuleDescription(rule);
        Iterator<RelOptRuleOperand> operandIter = this.allOperands.iterator();
        while (operandIter.hasNext()) {
            RelOptRuleOperand operand = operandIter.next();
            if (!operand.getRule().equals((Object)rule)) continue;
            operandIter.remove();
        }
        if (rule instanceof ConverterRule && this.traitDefs.contains(ruleTraitDef = (ruleTrait = (converterRule = (ConverterRule)rule).getInTrait()).getTraitDef())) {
            ruleTraitDef.deregisterConverterRule(this, converterRule);
        }
        return true;
    }

    public boolean canConvert(RelTraitSet fromTraits, RelTraitSet toTraits) {
        assert (fromTraits.size() >= toTraits.size());
        boolean canConvert = true;
        int i = 0;
        while (i < toTraits.size() && canConvert) {
            RelTrait fromTrait = fromTraits.getTrait(i);
            RelTrait toTrait = toTraits.getTrait(i);
            assert (fromTrait.getTraitDef() == toTrait.getTraitDef());
            assert (this.traitDefs.contains(fromTrait.getTraitDef()));
            assert (this.traitDefs.contains(toTrait.getTraitDef()));
            canConvert = fromTrait.getTraitDef().canConvert(this, fromTrait, toTrait);
            ++i;
        }
        return canConvert;
    }

    @Override
    public RelNode changeTraits(RelNode rel, RelTraitSet toTraits) {
        assert (!rel.getTraitSet().equals(toTraits)) : "pre: !rel.getTraits().equals(toTraits)";
        RelSubset rel2 = this.ensureRegistered(rel, null);
        if (rel2.getTraitSet().equals(toTraits)) {
            return rel2;
        }
        return rel2.set.getOrCreateSubset(rel.getCluster(), toTraits);
    }

    @Override
    public RelOptPlanner chooseDelegate() {
        return this;
    }

    @Override
    public RelNode findBestExp() {
        this.useApplicableMaterializations();
        int cumulativeTicks = 0;
        VolcanoPlannerPhase[] volcanoPlannerPhaseArray = VolcanoPlannerPhase.values();
        int n = volcanoPlannerPhaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            VolcanoPlannerPhase phase = volcanoPlannerPhaseArray[n2];
            this.setInitialImportance();
            RelOptCost targetCost = this.costFactory.makeHugeCost();
            int tick = 0;
            int firstFiniteTick = -1;
            int splitCount = 0;
            int giveUpTick = Integer.MAX_VALUE;
            while (true) {
                VolcanoRuleMatch match;
                ++tick;
                ++cumulativeTicks;
                if (this.root.bestCost.isLe(targetCost)) {
                    if (firstFiniteTick < 0) {
                        firstFiniteTick = cumulativeTicks;
                        this.clearImportanceBoost();
                    }
                    if (!this.ambitious) break;
                    targetCost = this.root.bestCost.multiplyBy(0.9);
                    ++splitCount;
                    if (this.impatient) {
                        giveUpTick = firstFiniteTick < 10 ? cumulativeTicks + 25 : cumulativeTicks + Math.max(firstFiniteTick / 10, 25);
                    }
                } else {
                    if (cumulativeTicks > giveUpTick) break;
                    if (this.root.bestCost.isInfinite() && tick % 10 == 0) {
                        this.injectImportanceBoost();
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("PLANNER = " + this + "; TICK = " + cumulativeTicks + "/" + tick + "; PHASE = " + phase.toString() + "; COST = " + this.root.bestCost);
                }
                if ((match = this.ruleQueue.popMatch(phase)) == null) break;
                assert (match.getRule().matches(match));
                match.onMatch();
                this.root = this.canonize(this.root);
            }
            this.ruleQueue.phaseCompleted(phase);
            ++n2;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.dump(pw);
            pw.flush();
            LOGGER.finer(sw.toString());
        }
        RelNode cheapest = this.root.buildCheapestPlan(this);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cheapest plan:\n" + RelOptUtil.toString(cheapest, SqlExplainLevel.ALL_ATTRIBUTES));
            LOGGER.fine("Provenance:\n" + this.provenance(cheapest));
        }
        return cheapest;
    }

    private String provenance(RelNode root) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        final ArrayList nodes = new ArrayList();
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                nodes.add(node);
                super.visit(node, ordinal, parent);
            }
        }.go(root);
        HashSet<RelNode> visited = new HashSet<RelNode>();
        for (RelNode node : nodes) {
            this.provenanceRecurse(pw, node, 0, visited);
        }
        pw.flush();
        return sw.toString();
    }

    private void provenanceRecurse(PrintWriter pw, RelNode node, int i, Set<RelNode> visited) {
        Spaces.append(pw, i * 2);
        if (!visited.add(node)) {
            pw.println("rel#" + node.getId() + " (see above)");
            return;
        }
        pw.println(node);
        Provenance o = this.provenanceMap.get(node);
        Spaces.append(pw, i * 2 + 2);
        if (o == Provenance.EMPTY) {
            pw.println("no parent");
        } else if (o instanceof DirectProvenance) {
            RelNode rel = ((DirectProvenance)o).source;
            pw.println("direct");
            this.provenanceRecurse(pw, rel, i + 2, visited);
        } else if (o instanceof RuleProvenance) {
            RuleProvenance rule = (RuleProvenance)o;
            pw.println("call#" + rule.callId + " rule [" + rule.rule + "]");
            for (RelNode rel : rule.rels) {
                this.provenanceRecurse(pw, rel, i + 2, visited);
            }
        } else {
            throw new AssertionError((Object)("bad type " + o));
        }
    }

    private void setInitialImportance() {
        RelVisitor visitor = new RelVisitor(){
            int depth = 0;
            HashSet<RelSubset> visitedSubsets = new HashSet();

            public void visit(RelNode p, int ordinal, RelNode parent) {
                if (p instanceof RelSubset) {
                    RelSubset subset = (RelSubset)p;
                    if (this.visitedSubsets.contains(subset)) {
                        return;
                    }
                    if (subset != VolcanoPlanner.this.root) {
                        Double importance = Math.pow(0.9, this.depth);
                        VolcanoPlanner.this.ruleQueue.updateImportance(subset, importance);
                    }
                    this.visitedSubsets.add(subset);
                    ++this.depth;
                    for (RelNode rel : subset.getRels()) {
                        this.visit(rel, -1, subset);
                    }
                    --this.depth;
                } else {
                    super.visit(p, ordinal, parent);
                }
            }
        };
        visitor.go(this.root);
    }

    private void injectImportanceBoost() {
        HashSet<RelSubset> requireBoost = new HashSet<RelSubset>();
        block0: for (RelSubset subset : this.ruleQueue.subsetImportances.keySet()) {
            for (RelNode rel : subset.getRels()) {
                if (rel.getConvention() != Convention.NONE) continue block0;
            }
            requireBoost.add(subset);
        }
        this.ruleQueue.boostImportance(requireBoost, 1.25);
    }

    private void clearImportanceBoost() {
        Set<RelSubset> empty = Collections.emptySet();
        this.ruleQueue.boostImportance(empty, 1.0);
    }

    @Override
    public RelSubset register(RelNode rel, RelNode equivRel) {
        RelSet set;
        assert (!this.isRegistered(rel)) : "pre: isRegistered(rel)";
        if (equivRel == null) {
            set = null;
        } else {
            assert (RelOptUtil.equal("rel rowtype", rel.getRowType(), "equivRel rowtype", equivRel.getRowType(), true));
            set = this.getSet(equivRel);
        }
        RelSubset subset = this.registerImpl(rel, set);
        if (LOGGER.isLoggable(Level.FINE)) {
            this.validate();
        }
        return subset;
    }

    @Override
    public RelSubset ensureRegistered(RelNode rel, RelNode equivRel) {
        RelSubset subset = this.mapRel2Subset.get(rel);
        if (subset != null) {
            RelSubset equivSubset;
            if (equivRel != null && (equivSubset = this.getSubset(equivRel)) != subset) {
                assert (subset.set != equivSubset.set) : "Same set, different subsets means rel and equivRel have different traits, and that's an error";
                this.merge(subset.set, equivSubset.set);
            }
            return subset;
        }
        return this.register(rel, equivRel);
    }

    protected void validate() {
        for (RelSet set : this.allSets) {
            if (set.equivalentSet != null) {
                throw new AssertionError((Object)("set [" + set + "] has been merged: it should not be in the list"));
            }
            for (RelSubset subset : set.subsets) {
                if (subset.set != set) {
                    throw new AssertionError((Object)("subset [" + subset.getDescription() + "] is in wrong set [" + set + "]"));
                }
                for (RelNode rel : subset.getRels()) {
                    RelOptCost relCost = this.getCost(rel);
                    if (relCost.isLt(subset.bestCost)) {
                        throw new AssertionError((Object)("rel [" + rel.getDescription() + "] has lower cost " + relCost + " than best cost " + subset.bestCost + " of subset [" + subset.getDescription() + "]"));
                    }
                }
            }
        }
    }

    public void registerAbstractRelationalRules() {
        this.addRule(AbstractConverter.ExpandConversionRule.INSTANCE);
        this.addRule(SwapJoinRule.INSTANCE);
        this.addRule(RemoveDistinctRule.INSTANCE);
        this.addRule(UnionToDistinctRule.INSTANCE);
        this.addRule(RemoveTrivialProjectRule.INSTANCE);
        this.addRule(RemoveTrivialCalcRule.INSTANCE);
        this.addRule(RemoveSortRule.INSTANCE);
    }

    @Override
    public void registerSchema(RelOptSchema schema) {
        if (this.registeredSchemas.add(schema)) {
            try {
                schema.registerRules(this);
            }
            catch (Exception e) {
                throw Util.newInternal(e, "Error while registering schema " + schema);
            }
        }
    }

    @Override
    public RelOptCost getCost(RelNode rel) {
        assert (rel != null) : "pre-condition: rel != null";
        if (rel instanceof RelSubset) {
            return ((RelSubset)rel).bestCost;
        }
        if (rel.getTraitSet().getTrait(0) == Convention.NONE) {
            return this.costFactory.makeInfiniteCost();
        }
        RelOptCost cost = RelMetadataQuery.getNonCumulativeCost(rel);
        if (!this.zeroCost.isLt(cost)) {
            cost = this.costFactory.makeTinyCost();
        }
        for (RelNode input : rel.getInputs()) {
            cost = cost.plus(this.getCost(input));
        }
        return cost;
    }

    public RelSubset getSubset(RelNode rel) {
        assert (rel != null) : "pre: rel != null";
        if (rel instanceof RelSubset) {
            return (RelSubset)rel;
        }
        return this.mapRel2Subset.get(rel);
    }

    public RelSubset getSubset(RelNode rel, RelTraitSet traits) {
        return this.getSubset(rel, traits, false);
    }

    public RelSubset getSubset(RelNode rel, RelTraitSet traits, boolean createIfMissing) {
        if (rel instanceof RelSubset && rel.getTraitSet().equals(traits)) {
            return (RelSubset)rel;
        }
        RelSet set = this.getSet(rel);
        if (set == null) {
            return null;
        }
        if (createIfMissing) {
            return set.getOrCreateSubset(rel.getCluster(), traits);
        }
        return set.getSubset(traits);
    }

    private RelNode changeTraitsUsingConverters(RelNode rel, RelTraitSet toTraits, boolean allowAbstractConverters) {
        RelTraitSet fromTraits = rel.getTraitSet();
        assert (fromTraits.size() >= toTraits.size());
        boolean allowInfiniteCostConverters = SaffronProperties.instance().allowInfiniteCostConverters.get();
        RelNode converted = rel;
        int i = 0;
        while (converted != null && i < toTraits.size()) {
            RelTrait fromTrait = converted.getTraitSet().getTrait(i);
            RelTraitDef traitDef = fromTrait.getTraitDef();
            RelTrait toTrait = toTraits.getTrait(i);
            if (toTrait != null) {
                assert (traitDef == toTrait.getTraitDef());
                if (!fromTrait.equals(toTrait)) {
                    rel = traitDef.convert(this, converted, toTrait, allowInfiniteCostConverters);
                    if (rel != null) {
                        assert (rel.getTraitSet().getTrait(traitDef).subsumes(toTrait));
                        if ((rel = this.completeConversion(rel, allowInfiniteCostConverters, toTraits, (Expressions.FluentList<RelTraitDef>)Expressions.list((Object[])new RelTraitDef[]{traitDef}))) != null) {
                            this.register(rel, converted);
                        }
                    }
                    if (rel == null && allowAbstractConverters) {
                        RelTraitSet stepTraits = converted.getTraitSet().replace(toTrait);
                        rel = this.getSubset(converted, stepTraits);
                    }
                    converted = rel;
                }
            }
            ++i;
        }
        if (converted != null) assert (converted.getTraitSet().subsumes(toTraits));
        return converted;
    }

    private RelNode completeConversion(RelNode rel, boolean allowInfiniteCostConverters, RelTraitSet toTraits, Expressions.FluentList<RelTraitDef> usedTraits) {
        return rel;
    }

    RelNode changeTraitsUsingConverters(RelNode rel, RelTraitSet toTraits) {
        return this.changeTraitsUsingConverters(rel, toTraits, false);
    }

    void checkForSatisfiedConverters(RelSet set, RelNode rel) {
        int i = 0;
        while (i < set.abstractConverters.size()) {
            AbstractConverter converter = set.abstractConverters.get(i);
            RelNode converted = this.changeTraitsUsingConverters(rel, converter.getTraitSet());
            if (converted == null) {
                ++i;
                continue;
            }
            if (!this.isRegistered(converted)) {
                this.registerImpl(converted, set);
            }
            set.abstractConverters.remove(converter);
        }
    }

    @Override
    public void setImportance(RelNode rel, double importance) {
        assert (rel != null);
        if (importance == 0.0) {
            this.relImportances.put(rel, importance);
        }
    }

    public void dump(PrintWriter pw) {
        pw.println("Root: " + this.root.getDescription());
        pw.println("Original rel:");
        pw.println(this.originalRootString);
        pw.println("Sets:");
        RelSet[] sets = this.allSets.toArray(new RelSet[this.allSets.size()]);
        Arrays.sort(sets, new Comparator<RelSet>(){

            @Override
            public int compare(RelSet o1, RelSet o2) {
                return o1.id - o2.id;
            }
        });
        RelSet[] relSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            RelSet set = relSetArray[n2];
            pw.println("Set#" + set.id + ", type: " + set.subsets.get(0).getRowType());
            int j = -1;
            for (RelSubset subset : set.subsets) {
                ++j;
                pw.println("\t" + subset.getDescription() + ", best=" + (subset.best == null ? "null" : "rel#" + subset.best.getId()) + ", importance=" + this.ruleQueue.getImportance(subset));
                assert (subset.set == set);
                int k = 0;
                while (k < j) {
                    assert (!set.subsets.get(k).getTraitSet().equals(subset.getTraitSet()));
                    ++k;
                }
                for (RelNode rel : subset.getRels()) {
                    pw.print("\t\t" + rel.getDescription());
                    for (RelNode input : rel.getInputs()) {
                        Iterator<RelNode> rels;
                        RelSubset inputSubset = this.getSubset(input, input.getTraitSet());
                        RelSet inputSet = inputSubset.set;
                        if (!(input instanceof RelSubset) || !(rels = inputSubset.getRels().iterator()).hasNext()) continue;
                        input = rels.next();
                        assert (input.getTraitSet().subsumes(inputSubset.getTraitSet()));
                        assert (inputSet.rels.contains(input));
                        assert (inputSet.subsets.contains(inputSubset));
                    }
                    Double importance = this.relImportances.get(rel);
                    if (importance != null) {
                        pw.print(", importance=" + importance);
                    }
                    pw.print(", rowcount=" + RelMetadataQuery.getRowCount(rel));
                    pw.println(", cumulative cost=" + this.getCost(rel));
                }
            }
            ++n2;
        }
        pw.println();
    }

    void rename(RelNode rel) {
        String oldDigest = rel.getDigest();
        if (this.fixUpInputs(rel)) {
            Pair<String, RelDataType> oldKey = Pair.of(oldDigest, rel.getRowType());
            RelNode removed = this.mapDigestToRel.remove(oldKey);
            assert (removed == rel);
            String newDigest = rel.recomputeDigest();
            LOGGER.finer("Rename #" + rel.getId() + " from '" + oldDigest + "' to '" + newDigest + "'");
            Pair<String, RelDataType> key = Pair.of(newDigest, rel.getRowType());
            RelNode equivRel = this.mapDigestToRel.put(key, rel);
            if (equivRel != null) {
                assert (equivRel != rel);
                LOGGER.finer("After renaming rel#" + rel.getId() + ", it is now equivalent to rel#" + equivRel.getId());
                this.mapDigestToRel.put(key, equivRel);
                RelSubset equivRelSubset = this.getSubset(equivRel);
                this.ruleQueue.recompute(equivRelSubset, true);
                for (RelNode input : rel.getInputs()) {
                    ((RelSubset)input).set.parents.remove(rel);
                }
                RelSubset subset = this.mapRel2Subset.put(rel, equivRelSubset);
                assert (subset != null);
                boolean existed = subset.set.rels.remove(rel);
                assert (existed) : "rel was not known to its set";
                RelSubset equivSubset = this.getSubset(equivRel);
                if (equivSubset != subset) {
                    assert (equivSubset.getTraitSet().equals(subset.getTraitSet()));
                    assert (equivSubset.set != subset.set);
                    this.merge(equivSubset.set, subset.set);
                }
            }
        }
    }

    void reregister(RelSet set, RelNode rel) {
        RelNode equivRel = this.mapDigestToRel.get(rel.getDigest());
        if (equivRel != null && equivRel != rel) {
            assert (equivRel.getClass() == rel.getClass());
            assert (equivRel.getTraitSet().equals(rel.getTraitSet()));
            RelSubset equivRelSubset = this.getSubset(equivRel);
            this.ruleQueue.recompute(equivRelSubset, true);
            return;
        }
        RelSubset subset2 = this.asd(rel, set);
    }

    private RelSubset canonize(RelSubset subset) {
        if (subset.set.equivalentSet == null) {
            return subset;
        }
        RelSet set = subset.set;
        do {
            set = set.equivalentSet;
        } while (set.equivalentSet != null);
        return set.getOrCreateSubset(subset.getCluster(), subset.getTraitSet());
    }

    void fireRules(RelNode rel, boolean deferred) {
        for (RelOptRuleOperand operand : this.allOperands) {
            if (!operand.matches(rel)) continue;
            VolcanoRuleCall ruleCall = deferred ? new DeferringRuleCall(this, operand) : new VolcanoRuleCall(this, operand);
            ruleCall.match(rel);
        }
    }

    private boolean fixUpInputs(RelNode rel) {
        List<RelNode> inputs = rel.getInputs();
        int i = -1;
        int changeCount = 0;
        for (RelNode input : inputs) {
            RelSubset subset;
            RelSubset newSubset;
            ++i;
            if (!(input instanceof RelSubset) || (newSubset = this.canonize(subset = (RelSubset)input)) == subset) continue;
            rel.replaceInput(i, newSubset);
            if (subset.set != newSubset.set) {
                subset.set.parents.remove(rel);
                newSubset.set.parents.add(rel);
            }
            ++changeCount;
        }
        return changeCount > 0;
    }

    private void merge(RelSet set, RelSet set2) {
        assert (set != set2) : "pre: set != set2";
        assert (set.equivalentSet == null);
        if (set2.equivalentSet != null) {
            HashSet<RelSet> seen = new HashSet<RelSet>();
            while (true) {
                if (!seen.add(set2)) {
                    throw Util.newInternal("cycle in equivalence tree");
                }
                if (set2.equivalentSet == null) break;
                set2 = set2.equivalentSet;
            }
            if (set2 == set) {
                return;
            }
        }
        if (set.id > set2.id) {
            RelSet t = set;
            set = set2;
            set2 = t;
        }
        set.mergeWith(this, set2);
        if (set2 == this.getSet(this.root)) {
            this.root = set.getOrCreateSubset(this.root.getCluster(), this.root.getTraitSet());
        }
    }

    private RelSubset registerImpl(RelNode rel, RelSet set) {
        VolcanoRuleCall ruleCall;
        assert (rel instanceof RelSubset || !this.isRegistered(rel)) : "pre: rel instanceof RelSubset || !isRegistered(rel) : {rel=" + rel + "}";
        if (rel instanceof RelSubset) {
            return this.registerSubset(set, (RelSubset)rel);
        }
        if (rel.getCluster().getPlanner() != this) {
            throw Util.newInternal("Relational expression " + rel + " belongs to a different planner than is currently being" + " used.");
        }
        RelTraitSet traits = rel.getTraitSet();
        Convention convention = (Convention)traits.getTrait(0);
        if (!convention.getInterface().isInstance(rel) && !(rel instanceof ConverterRel)) {
            throw Util.newInternal("Relational expression " + rel + " has calling-convention " + convention + " but does not implement the required interface '" + convention.getInterface() + "' of that convention");
        }
        if (traits.size() != this.traitDefs.size()) {
            throw Util.newInternal("Relational expression " + rel + " does not have the correct number of traits " + traits.size() + " != " + this.traitDefs.size());
        }
        rel = rel.onRegister(this);
        if (this.ruleCallStack.isEmpty()) {
            ruleCall = null;
            this.provenanceMap.put(rel, Provenance.EMPTY);
        } else {
            ruleCall = Stacks.peek(this.ruleCallStack);
            this.provenanceMap.put(rel, new RuleProvenance(ruleCall.rule, (ImmutableList<RelNode>)ImmutableList.copyOf((Object[])ruleCall.rels), ruleCall.id));
        }
        Pair<String, RelDataType> key = Pair.of(rel.getDigest(), rel.getRowType());
        RelNode equivExp = this.mapDigestToRel.get(key);
        if (equivExp != null) {
            if (equivExp == rel) {
                return this.getSubset(rel);
            }
            assert (equivExp.getTraitSet().equals(traits) && equivExp.getClass() == rel.getClass());
            assert (RelOptUtil.equal("left", equivExp.getRowType(), "right", rel.getRowType(), true));
            RelSet equivSet = this.getSet(equivExp);
            if (equivSet != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Register: rel#" + rel.getId() + " is equivalent to " + equivExp.getDescription());
                }
                return this.registerSubset(set, this.getSubset(equivExp));
            }
        }
        if (rel instanceof ConverterRel) {
            RelNode input = ((ConverterRel)rel).getChild();
            RelSet childSet = this.getSet(input);
            if (set != null && set != childSet && set.equivalentSet == null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Register #" + rel.getId() + " " + rel.getDigest() + " (and merge sets, because it is a conversion)");
                }
                this.merge(set, childSet);
                ++this.registerCount;
                if (this.fixUpInputs(rel)) {
                    rel.recomputeDigest();
                    key = Pair.of(rel.getDigest(), rel.getRowType());
                    RelNode equivRel = this.mapDigestToRel.get(key);
                    if (equivRel != rel && equivRel != null) {
                        set.obliterateRelNode(rel);
                        return this.getSubset(equivRel);
                    }
                }
            } else {
                set = childSet;
            }
        }
        if (set == null) {
            set = new RelSet(this.nextSetId++, Util.minus(RelOptUtil.getVariablesSet(rel), rel.getVariablesStopped()), RelOptUtil.getVariablesUsed(rel));
            this.allSets.add(set);
        }
        while (set.equivalentSet != null) {
            set = set.equivalentSet;
        }
        ++this.registerCount;
        RelSubset subset = this.asd(rel, set);
        RelNode xx = this.mapDigestToRel.put(key, rel);
        assert (xx == null || xx == rel) : rel.getDigest();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Register " + rel.getDescription() + " in " + subset.getDescription());
        }
        if (xx != null) {
            return subset;
        }
        if (rel == this.root) {
            this.ruleQueue.subsetImportances.put(subset, 1.0);
        }
        for (RelNode input : rel.getInputs()) {
            RelSubset childSubset = (RelSubset)input;
            childSubset.set.parents.add(rel);
            this.ruleQueue.recompute(childSubset);
        }
        if (rel == this.root) {
            this.ruleQueue.subsetImportances.remove(subset);
        }
        if (rel instanceof AbstractConverter) {
            set.abstractConverters.add((AbstractConverter)rel);
        }
        this.checkForSatisfiedConverters(set, rel);
        this.ruleQueue.recompute(subset, true);
        this.fireRules(rel, true);
        return subset;
    }

    private RelSubset asd(RelNode rel, RelSet set) {
        RelSubset subset = set.add(rel);
        this.mapRel2Subset.put(rel, subset);
        subset.propagateCostImprovements(this, rel, new HashSet<RelSubset>());
        return subset;
    }

    private RelSubset registerSubset(RelSet set, RelSubset subset) {
        if (set != subset.set && set != null && set.equivalentSet == null && subset.set.equivalentSet == null) {
            LOGGER.finer("Register #" + subset.getId() + " " + subset + ", and merge sets");
            this.merge(set, subset.set);
            ++this.registerCount;
        }
        return subset;
    }

    @Override
    public void addListener(RelOptListener newListener) {
        if (this.listener != null) {
            throw Util.needToImplement("multiple VolcanoPlanner listeners");
        }
        this.listener = newListener;
    }

    @Override
    public void registerMetadataProviders(List<RelMetadataProvider> list) {
        list.add(0, new VolcanoRelMetadataProvider());
    }

    @Override
    public long getRelMetadataTimestamp(RelNode rel) {
        RelSubset subset = this.getSubset(rel);
        if (subset == null) {
            return 0L;
        }
        return subset.timestamp;
    }

    public static String normalizePlan(String plan) {
        if (plan == null) {
            return null;
        }
        Pattern poundDigits = Pattern.compile("Subset#[0-9]+\\.");
        int i = 0;
        Matcher matcher;
        while ((matcher = poundDigits.matcher(plan)).find()) {
            String token = matcher.group();
            plan = plan.replace(token, "Subset#{" + i++ + "}.");
        }
        return plan;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void ensureRegistered(RelNode rel, RelNode equivRel, VolcanoRuleCall ruleCall) {
        Stacks.push(this.ruleCallStack, ruleCall);
        this.ensureRegistered(rel, equivRel);
        Stacks.pop(this.ruleCallStack, ruleCall);
    }

    private static class DeferringRuleCall
    extends VolcanoRuleCall {
        DeferringRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand) {
            super(planner, operand);
        }

        protected void onMatch() {
            VolcanoRuleMatch match = new VolcanoRuleMatch(this.volcanoPlanner, this.getOperand0(), this.rels);
            this.volcanoPlanner.ruleQueue.addMatch(match);
        }
    }

    static class DirectProvenance
    extends Provenance {
        final RelNode source;

        DirectProvenance(RelNode source) {
            this.source = source;
        }
    }

    private static abstract class Provenance {
        public static final Provenance EMPTY = new UnknownProvenance();

        private Provenance() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RuleProvenance
    extends Provenance {
        final RelOptRule rule;
        final ImmutableList<RelNode> rels;
        final int callId;

        RuleProvenance(RelOptRule rule, ImmutableList<RelNode> rels, int callId) {
            this.rule = rule;
            this.rels = rels;
            this.callId = callId;
        }
    }

    private static class UnknownProvenance
    extends Provenance {
        private UnknownProvenance() {
        }
    }
}

