/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptQuery;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

public class NestedLoopsJoinRule
extends RelOptRule {
    public static final NestedLoopsJoinRule INSTANCE = new NestedLoopsJoinRule();

    private NestedLoopsJoinRule() {
        super(NestedLoopsJoinRule.operand(JoinRel.class, NestedLoopsJoinRule.any()));
    }

    public boolean matches(RelOptRuleCall call) {
        JoinRel join = (JoinRel)call.rel(0);
        switch (join.getJoinType()) {
            case INNER: 
            case LEFT: {
                return true;
            }
            case RIGHT: 
            case FULL: {
                return false;
            }
        }
        throw Util.unexpected(join.getJoinType());
    }

    public void onMatch(RelOptRuleCall call) {
        assert (this.matches(call));
        JoinRel join = (JoinRel)call.rel(0);
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RelNode right = join.getRight();
        RelNode left = join.getLeft();
        RexNode remainingCondition = RelOptUtil.splitJoinCondition(left, right, join.getCondition(), leftKeys, rightKeys);
        assert (leftKeys.size() == rightKeys.size());
        ArrayList<CorrelatorRel.Correlation> correlationList = new ArrayList<CorrelatorRel.Correlation>();
        if (leftKeys.size() > 0) {
            RelOptCluster cluster = join.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RexNode condition = null;
            for (Pair<Integer, Integer> p : Pair.zip(leftKeys, rightKeys)) {
                String dynInIdStr = cluster.getQuery().createCorrel();
                int dynInId = RelOptQuery.getCorrelOrdinal(dynInIdStr);
                correlationList.add(new CorrelatorRel.Correlation(dynInId, (Integer)p.left));
                condition = RelOptUtil.andJoinFilters(rexBuilder, condition, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, rexBuilder.makeInputRef(right, (int)((Integer)p.right)), rexBuilder.makeCorrel(left.getRowType().getFieldList().get((Integer)p.left).getType(), dynInIdStr)));
            }
            right = CalcRel.createFilter(right, condition);
        }
        CorrelatorRel newRel = new CorrelatorRel(join.getCluster(), left, right, remainingCondition, correlationList, join.getJoinType());
        call.transformTo(newRel);
    }
}

