/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiJoinRel
extends AbstractRelNode {
    private ImmutableList<RelNode> inputs;
    private RexNode joinFilter;
    private RelDataType rowType;
    private boolean isFullOuterJoin;
    private ImmutableList<RexNode> outerJoinConditions;
    private ImmutableList<JoinRelType> joinTypes;
    private ImmutableList<BitSet> projFields;
    private ImmutableMap<Integer, int[]> joinFieldRefCountsMap;
    private RexNode postJoinFilter;

    public MultiJoinRel(RelOptCluster cluster, List<RelNode> inputs, RexNode joinFilter, RelDataType rowType, boolean isFullOuterJoin, List<RexNode> outerJoinConditions, List<JoinRelType> joinTypes, List<BitSet> projFields, Map<Integer, int[]> joinFieldRefCountsMap, RexNode postJoinFilter) {
        super(cluster, cluster.traitSetOf(Convention.NONE));
        this.inputs = ImmutableList.copyOf(inputs);
        this.joinFilter = joinFilter;
        this.rowType = rowType;
        this.isFullOuterJoin = isFullOuterJoin;
        this.outerJoinConditions = ImmutableList.copyOf(outerJoinConditions);
        this.joinTypes = ImmutableList.copyOf(joinTypes);
        this.projFields = ImmutableList.copyOf(projFields);
        this.joinFieldRefCountsMap = ImmutableMap.copyOf(joinFieldRefCountsMap);
        this.postJoinFilter = postJoinFilter;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.comprises(Convention.NONE));
        return new MultiJoinRel(this.getCluster(), inputs, this.joinFilter, this.rowType, this.isFullOuterJoin, (List<RexNode>)this.outerJoinConditions, (List<JoinRelType>)this.joinTypes, (List<BitSet>)this.projFields, this.cloneJoinFieldRefCountsMap(), this.postJoinFilter);
    }

    private Map<Integer, int[]> cloneJoinFieldRefCountsMap() {
        HashMap<Integer, int[]> clonedMap = new HashMap<Integer, int[]>();
        int i = 0;
        while (i < this.inputs.size()) {
            clonedMap.put(i, (int[])((int[])this.joinFieldRefCountsMap.get((Object)i)).clone());
            ++i;
        }
        return clonedMap;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        ArrayList<String> joinTypeNames = new ArrayList<String>();
        ArrayList<String> outerJoinConds = new ArrayList<String>();
        ArrayList<String> projFieldObjects = new ArrayList<String>();
        int i = 0;
        while (i < this.inputs.size()) {
            joinTypeNames.add(((JoinRelType)((Object)this.joinTypes.get(i))).name());
            if (this.outerJoinConditions.get(i) == null) {
                outerJoinConds.add("NULL");
            } else {
                outerJoinConds.add(((RexNode)this.outerJoinConditions.get(i)).toString());
            }
            if (this.projFields.get(i) == null) {
                projFieldObjects.add("ALL");
            } else {
                projFieldObjects.add(((BitSet)this.projFields.get(i)).toString());
            }
            ++i;
        }
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("joinFilter", this.joinFilter).item("isFullOuterJoin", this.isFullOuterJoin).item("joinTypes", joinTypeNames).item("outerJoinConditions", outerJoinConds).item("projFields", projFieldObjects).itemIf("postJoinFilter", this.postJoinFilter, this.postJoinFilter != null);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of((Object)this.joinFilter);
    }

    public RexNode getJoinFilter() {
        return this.joinFilter;
    }

    public boolean isFullOuterJoin() {
        return this.isFullOuterJoin;
    }

    public List<RexNode> getOuterJoinConditions() {
        return this.outerJoinConditions;
    }

    public List<JoinRelType> getJoinTypes() {
        return this.joinTypes;
    }

    public List<BitSet> getProjFields() {
        return this.projFields;
    }

    public Map<Integer, int[]> getJoinFieldRefCountsMap() {
        return this.joinFieldRefCountsMap;
    }

    public Map<Integer, int[]> getCopyJoinFieldRefCountsMap() {
        return this.cloneJoinFieldRefCountsMap();
    }

    public RexNode getPostJoinFilter() {
        return this.postJoinFilter;
    }
}

